/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf2;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import oracle.bali.ewt.olaf2.LabelGeometry;
import oracle.bali.ewt.olaf2.LineInfo;
import oracle.bali.ewt.olaf2.WordWrapper;
import oracle.bali.share.nls.LocaleUtils;

class MultiLineLabel2
extends JComponent
implements Accessible {
    private static final int NOT_SET = -1;
    private static final int ALIGNMENT_DEFAULT = 0;
    private static final int ALIGNMENT_LEFT = 1;
    private static final int ALIGNMENT_RIGHT = 2;
    private static final int ALIGNMENT_CENTER = 3;
    private static final float ASPECTRATIO_NONE = 0.0f;
    private float _preferredAspectRatio;
    private LabelGeometry _geometry;
    private int _preferredRows = -1;
    private int _preferredColumns = -1;
    private int _maximumColumns = -1;
    private int _maximumRows = -1;
    private int _minimumColumns = -1;
    private int _minimumRows = -1;
    private Dimension _originalPreferredSize;
    private Dimension _currentPreferredSize;
    private static final String _ELLIPSIS = "...";

    public MultiLineLabel2(String text) {
        if (text == null) {
            text = "";
        }
        WordWrapper wrapper = WordWrapper.getTextWrapper();
        this._geometry = new LabelGeometry(this, wrapper, text);
        this._preferredAspectRatio = 4.0f;
        this.setOpaque(false);
        this.updateUI();
    }

    public String getText() {
        return this._geometry._getText();
    }

    public WordWrapper getTextWrapper() {
        return this._geometry._getTextWrapper();
    }

    public void setMaximumColumns(int columns) {
        if (columns != this._maximumColumns) {
            this._maximumColumns = columns;
            this.invalidateCanvas();
        }
    }

    public void setPreferredColumns(int columns) {
        if (columns == this._preferredColumns) {
            return;
        }
        this._preferredColumns = columns;
        this._originalPreferredSize = null;
        this.invalidateMultiLineLabelCanvas();
    }

    public int getPreferredColumns() {
        return this._preferredColumns;
    }

    public void setPreferredAspectRatio(float preferredAspectRation) {
        if (this._preferredAspectRatio != preferredAspectRation) {
            this._preferredAspectRatio = preferredAspectRation;
            this._originalPreferredSize = null;
            this.invalidateMultiLineLabelCanvas();
        }
    }

    public float getPreferredAspectRatio() {
        return this._preferredAspectRatio;
    }

    @Override
    public void setFont(Font newFont) {
        super.setFont(newFont);
        this._originalPreferredSize = null;
        this._geometry._setFontMetrics(this.getFontMetrics(this.getFont()));
    }

    @Override
    public void setLocale(Locale newLocale) {
        if (newLocale != LocaleUtils.getDefaultableLocale((Component)this)) {
            super.setLocale(newLocale);
            this.invalidate();
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        LookAndFeel.installColorsAndFont(this, "Label.background", "Label.foreground", "Label.font");
    }

    @Override
    public void setMaximumSize(Dimension maximumSize) {
        if (maximumSize != null) {
            this._maximumRows = -1;
            this._maximumColumns = -1;
        }
        super.setMaximumSize(maximumSize);
    }

    @Override
    public Dimension getMaximumSize() {
        return this._computeSize(super.getMaximumSize(), this._maximumRows, this._maximumColumns);
    }

    @Override
    public void setMinimumSize(Dimension minimumSize) {
        if (minimumSize != null) {
            this._minimumRows = -1;
            this._minimumColumns = -1;
        }
        super.setMinimumSize(minimumSize);
    }

    @Override
    public Dimension getMinimumSize() {
        if (!this.isMinimumSizeSet() && this._minimumRows == -1 && this._minimumColumns == -1) {
            return this.getPreferredSize();
        }
        return this._computeSize(super.getMinimumSize(), this._minimumRows, this._minimumColumns);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = this.layoutCanvas();
        Insets insets = this.getBorderInsets();
        d.width += insets.left + insets.right;
        d.height += insets.top + insets.bottom;
        return d;
    }

    @Override
    public void doLayout() {
        this._geometry._validate();
        super.doLayout();
    }

    @Override
    public final void layout() {
        super.layout();
        this.layoutCanvas();
    }

    protected Dimension layoutCanvas() {
        return new Dimension(this._getPreferredInnerSize());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._originalPreferredSize = null;
        this._geometry._setFontMetrics(this.getFontMetrics(this.getFont()));
    }

    @Override
    protected void paintComponent(Graphics g) {
        this._setWrapWidthOnGeometry();
        if (!this.isEnabled()) {
            UIDefaults defaults = UIManager.getDefaults();
            g.setColor(defaults.getColor("controlLtHighlight"));
            g.translate(1, 1);
            this._paintCanvasInterior(g);
            g.setColor(defaults.getColor("controlInactiveText"));
            g.translate(-1, -1);
        }
        this._paintCanvasInterior(g);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleMultiLineLabel();
        }
        return this.accessibleContext;
    }

    Insets getBorderInsets() {
        return new Insets(0, 0, 0, 0);
    }

    void invalidateMultiLineLabelCanvas() {
        this._currentPreferredSize = null;
        this.invalidateCanvas();
    }

    public final void invalidateCanvas() {
        boolean isValid = this.isValid();
        if (!isValid && !this.isShowing()) {
            return;
        }
        this.revalidate();
        this.repaint();
    }

    private Dimension _computeSize(Dimension base, int rows, int columns) {
        if (rows != -1 || columns != -1) {
            base = new Dimension(base);
            Insets insets = this.getBorderInsets();
            FontMetrics metrics = this._geometry.getFontMetrics();
            if (metrics != null) {
                if (rows != -1) {
                    base.height = metrics.getHeight() * rows + (insets.top + insets.bottom);
                }
                if (columns != -1) {
                    base.width = MultiLineLabel2.getAverageWidth(this.getFont()) * columns + (insets.left + insets.right);
                }
            }
        }
        return base;
    }

    private Dimension _getOriginalPreferredSize() {
        if (this._originalPreferredSize == null) {
            FontMetrics metrics;
            Dimension preferredSize = new Dimension(0, 0);
            Font f = this.getFont();
            FontMetrics fontMetrics = metrics = f == null ? null : this.getFontMetrics(f);
            if (metrics != null) {
                int lineCount;
                int stringWidth = metrics.stringWidth(this.getText());
                int lineHeight = metrics.getHeight();
                int width = 0;
                int avgWidth = MultiLineLabel2.getAverageWidth(f);
                int preferredColumns = this._preferredColumns;
                if (preferredColumns == -1 && this._preferredRows == -1) {
                    float aspectRatio = this.getPreferredAspectRatio();
                    int innerWidth = this.getWidth();
                    if (aspectRatio == 0.0f && innerWidth == 0) {
                        aspectRatio = 4.0f;
                    }
                    width = aspectRatio != 0.0f ? (int)Math.sqrt((float)stringWidth * (float)lineHeight * aspectRatio) + 1 : innerWidth;
                } else {
                    if (preferredColumns != -1) {
                        width = avgWidth * preferredColumns;
                    }
                    if (this._preferredRows != -1) {
                        preferredSize.height = this._preferredRows * lineHeight;
                        if (preferredColumns == -1) {
                            int newLineCount = 0;
                            int i = 0;
                            while ((i = this.getText().indexOf(10, i) + 1) > 0) {
                                ++newLineCount;
                            }
                            if (newLineCount + 1 >= this._preferredRows) {
                                preferredColumns = width = Integer.MAX_VALUE;
                            } else {
                                width = stringWidth / this._preferredRows * 21 / 20;
                            }
                        }
                    }
                }
                boolean wasBig = false;
                do {
                    LabelGeometry preferredGeometry = new LabelGeometry(this, this.getTextWrapper(), this.getText(), metrics, width, true);
                    preferredSize.width = preferredGeometry.getMaxPixelWidth();
                    lineCount = preferredGeometry.getLineCount();
                    if (preferredColumns != -1 || this._preferredRows == -1) break;
                    if (this._preferredRows < lineCount) {
                        width += avgWidth;
                        wasBig = true;
                        continue;
                    }
                    if (this._preferredRows <= lineCount || wasBig) break;
                    width -= avgWidth;
                } while (width > 0);
                preferredSize.height = Math.max(preferredSize.height, lineCount * lineHeight);
            }
            this._originalPreferredSize = preferredSize;
        }
        return this._originalPreferredSize;
    }

    private Dimension _getPreferredInnerSize() {
        if (this._currentPreferredSize == null) {
            boolean canUseCurrentWidth;
            FontMetrics metrics;
            Dimension prefSize = new Dimension(0, 0);
            boolean useOriginalSize = this._originalPreferredSize == null;
            Dimension d = this._getOriginalPreferredSize();
            int innerWidth = this.getWidth();
            Font f = this.getFont();
            FontMetrics fontMetrics = metrics = f == null ? null : this.getFontMetrics(f);
            boolean bl = useOriginalSize ? false : (canUseCurrentWidth = this._preferredRows == -1 && this.getPreferredColumns() == -1 && this.getPreferredAspectRatio() == 0.0f || innerWidth > d.width);
            if (canUseCurrentWidth && metrics != null && innerWidth != 0) {
                LabelGeometry prefGeometry = new LabelGeometry(this, this.getTextWrapper(), this.getText(), metrics, innerWidth, true);
                prefSize.width = prefGeometry.getMaxPixelWidth();
                prefSize.height = prefGeometry.getLineCount() * metrics.getHeight();
            } else {
                prefSize.width = d.width;
                prefSize.height = d.height;
            }
            this._currentPreferredSize = prefSize;
        }
        return this._currentPreferredSize;
    }

    private void _paintCanvasInterior(Graphics g) {
        LabelGeometry geometry = this._geometry;
        FontMetrics metrics = geometry.getFontMetrics();
        int lineHt = metrics.getHeight();
        Rectangle drawRect = g.getClipBounds();
        if (drawRect.width == 0 || drawRect.height == 0) {
            return;
        }
        int currLine = drawRect.y / lineHt;
        if (currLine < 0) {
            currLine = 0;
        }
        int y = currLine * lineHt + metrics.getAscent() + metrics.getLeading();
        int lineCount = geometry.getLineCount();
        int wrapWidth = geometry.getWrapWidth();
        int bottom = drawRect.y + drawRect.height;
        int alignment = this.getActualAlignment();
        LineInfo currLineInfo = new LineInfo();
        int descent = metrics.getDescent();
        Insets insets = this.getBorderInsets();
        int height = this.getHeight();
        height = Math.max(0, height - (insets.top + insets.bottom));
        int width = this.getWidth();
        width = Math.max(0, width - (insets.left + insets.right));
        while (currLine < lineCount && (y + descent <= height || currLine == 0)) {
            if ((currLineInfo = geometry.getLineInfo(currLine, currLineInfo)) == null) {
                return;
            }
            Object currString = currLineInfo.text;
            if (y + descent + lineHt > height && currLine != lineCount - 1 || currLineInfo.pixelWidth > width) {
                int diff;
                if (currString == null) {
                    currString = "";
                }
                if ((diff = currLineInfo.pixelWidth + metrics.stringWidth(_ELLIPSIS) - wrapWidth) > 0) {
                    if (currLineInfo.pixelWidth > diff) {
                        int index;
                        for (index = ((String)currString).length() - 1; index >= 0 && diff > 0; diff -= metrics.charWidth(((String)currString).charAt(index)), --index) {
                        }
                        currString = ((String)currString).substring(0, index + 1) + _ELLIPSIS;
                    } else {
                        currString = _ELLIPSIS;
                    }
                } else {
                    currString = (String)currString + _ELLIPSIS;
                }
                currLineInfo.text = currString;
                currLineInfo.pixelWidth = metrics.stringWidth((String)currString);
            }
            if (currString != null) {
                int deltaX = 0;
                if (alignment != 1) {
                    deltaX = wrapWidth - currLineInfo.pixelWidth;
                    if (alignment == 3) {
                        deltaX >>= 1;
                    }
                }
                g.drawString((String)currString, deltaX, y);
            }
            if (y > bottom) break;
            y += lineHt;
            ++currLine;
        }
    }

    int getActualAlignment() {
        return LocaleUtils.getReadingDirectionForLocale((Locale)this.getLocale());
    }

    private void _setWrapWidthOnGeometry() {
        boolean useCurrWidth = this._preferredRows == -1 && this.getPreferredColumns() == -1 && this.getPreferredAspectRatio() == 0.0f ? true : true;
        int newWrapWidth = useCurrWidth ? this.getWidth() : Math.min(this.getWidth(), this._getOriginalPreferredSize().width);
        this._geometry._setWrapWidth(newWrapWidth);
    }

    private static int getAverageWidth(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font).charWidth('e');
    }

    private class AccessibleMultiLineLabel
    extends JComponent.AccessibleJComponent {
        private AccessibleMultiLineLabel() {
            super(MultiLineLabel2.this);
        }

        @Override
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (MultiLineLabel2.this.getText() == null) {
                return super.getAccessibleName();
            }
            return MultiLineLabel2.this.getText();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }
    }
}

