/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.bookmarks;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.bookmarks.Bookmark;
import oracle.ide.bookmarks.BookmarkConstants;
import oracle.ide.bookmarks.BookmarkEvent;
import oracle.ide.bookmarks.BookmarkIcons;
import oracle.ide.bookmarks.BookmarkListener;
import oracle.ide.bookmarks.BookmarkManager;
import oracle.ide.bookmarks.Bookmarks;
import oracle.ide.bookmarks.LineBookmark;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.ContextMenuListenersHook;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.peek.CodePeek;
import oracle.ide.peek.Peek;
import oracle.ide.peek.PeekHelper;
import oracle.ide.peek.Peekable;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.infotip.InfoTipHover;

final class BookmarkPanel
extends JPanel
implements ContextMenuListener {
    private JList<Bookmark> bookmarkList;
    private DefaultListModel<Bookmark> bookmarkListModel;
    private JButton removeButton;
    private ContextMenu contextMenu = new ContextMenu();
    private AssignNumberListener assignNumberListener;
    private static final String ASSIGN_KEY = "ASSIGN_KEY";
    private JMenuItem sourceItem;
    private JMenuItem removeItem;
    private JMenuItem removeAllItem;
    private int mouseOverIndex;
    private boolean isOverClose;
    private final Location location;
    private InfoTipHover hover;
    private Toolbar toolbar;

    public BookmarkPanel(final Location location) {
        ContextMenuListenersHook hook = (ContextMenuListenersHook)ExtensionRegistry.getExtensionRegistry().getHook(ContextMenuListenersHook.ELEMENT);
        this.contextMenu.addContextMenuListener(hook.getListener("bookmarkDockable"));
        this.assignNumberListener = new AssignNumberListener();
        this.mouseOverIndex = -1;
        this.isOverClose = false;
        this.toolbar = new Toolbar();
        this.location = location;
        this.bookmarkListModel = new DefaultListModel();
        this.bookmarkList = location == Location.DOCKABLE ? new PeekableList(this.bookmarkListModel) : new JList<Bookmark>(this.bookmarkListModel);
        this.bookmarkList.setCellRenderer(new Renderer());
        if (location == Location.DOCKABLE) {
            this.toolbar.setPrimaryViewToolbar(true);
        } else {
            this.setOpaque(false);
        }
        this._createPopupMenuItems();
        BookmarkManager.getBookmarkManager().addBookmarkListener(new BookmarkListener(){

            @Override
            public void bookmarksChanged(BookmarkEvent evt) {
                switch (evt.getType()) {
                    case ADDITION: 
                    case REMOVAL: {
                        boolean isFirst = BookmarkPanel.this.bookmarkListModel.getSize() == 0;
                        BookmarkPanel.this.rebuildList();
                        if (isFirst && BookmarkPanel.this.bookmarkListModel.getSize() > 0) {
                            BookmarkPanel.this.bookmarkList.setSelectedIndex(0);
                        }
                        BookmarkPanel.this.repaint();
                        break;
                    }
                    case UPDATE: {
                        BookmarkPanel.this.repaint();
                    }
                }
            }
        });
        this.bookmarkList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                int mouseWasOver = BookmarkPanel.this.mouseOverIndex;
                BookmarkPanel.this.mouseOverIndex = -1;
                BookmarkPanel.this.isOverClose = false;
                if (mouseWasOver > -1 && mouseWasOver < BookmarkPanel.this.bookmarkListModel.size()) {
                    BookmarkPanel.this.bookmarkList.repaint(BookmarkPanel.this.bookmarkList.getCellBounds(mouseWasOver, mouseWasOver));
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (location == Location.DOCKABLE) {
                    this.maybePopup(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                int clicks;
                if (location == Location.DOCKABLE ? this.maybePopup(e) : this.checkForClose(e)) {
                    return;
                }
                int index = BookmarkPanel.this.bookmarkList.locationToIndex(e.getPoint());
                if (index == -1 || !BookmarkPanel.this.bookmarkList.getCellBounds(index, index).contains(e.getPoint())) {
                    return;
                }
                int n = clicks = location == Location.DOCKABLE ? 2 : 1;
                if (e.getClickCount() == clicks && index > -1) {
                    BookmarkPanel.this._jumpToSource(index);
                } else if (location == Location.DOCKABLE) {
                    this.maybePopup(e);
                }
            }

            private boolean maybePopup(MouseEvent e) {
                int index = BookmarkPanel.this.bookmarkList.locationToIndex(e.getPoint());
                if (index == -1 || !BookmarkPanel.this.bookmarkList.getCellBounds(index, index).contains(e.getPoint())) {
                    return false;
                }
                if (e.isPopupTrigger() && index > -1) {
                    BookmarkPanel.this.bookmarkList.setSelectedIndex(index);
                    BookmarkPanel.this._showMenu(e);
                    return true;
                }
                return false;
            }

            private boolean checkForClose(MouseEvent e) {
                if (BookmarkPanel.this.isOverClose(e)) {
                    Bookmark bookmark = BookmarkPanel.this.bookmarkList.getSelectedValue();
                    BookmarkManager.getBookmarkManager().removeBookmark(bookmark);
                    e.consume();
                    BookmarkPanel.this.rebuildList();
                    if (BookmarkPanel.this.hover != null) {
                        BookmarkPanel.this.bookmarkList.setVisibleRowCount(BookmarkPanel.this.bookmarkListModel.getSize());
                        BookmarkPanel.this.hover.getInfoTip().pack();
                    }
                    return true;
                }
                return false;
            }
        });
        if (location == Location.TOOLBAR_HOVER) {
            this.bookmarkList.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    BookmarkPanel.this.mouseOverIndex = BookmarkPanel.this.bookmarkList.locationToIndex(e.getPoint());
                    BookmarkPanel.this.bookmarkList.setSelectedIndex(BookmarkPanel.this.mouseOverIndex);
                    boolean newOverClose = BookmarkPanel.this.isOverClose(e);
                    if (BookmarkPanel.this.isOverClose != newOverClose) {
                        BookmarkPanel.this.isOverClose = newOverClose;
                        BookmarkPanel.this.bookmarkList.repaint(BookmarkPanel.this.bookmarkList.getCellBounds(BookmarkPanel.this.mouseOverIndex, BookmarkPanel.this.mouseOverIndex));
                    }
                }
            });
        }
        this.bookmarkList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ke) {
                int index;
                if ((ke.getKeyCode() == 32 || ke.getKeyCode() == 10) && (index = BookmarkPanel.this.bookmarkList.getSelectedIndex()) != -1) {
                    BookmarkPanel.this._jumpToSource(index);
                }
                if (ke.getKeyCode() == 127) {
                    BookmarkPanel.this.deleteSelected();
                }
            }
        });
        this.bookmarkList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int i = BookmarkPanel.this.bookmarkList.getSelectedIndex();
                BookmarkPanel.this.removeButton.setEnabled(i > -1);
            }
        });
        JScrollPane sp = new JScrollPane(this.bookmarkList);
        sp.setBorder(null);
        this.removeButton = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this.removeButton.setToolTipText(StringUtils.stripMnemonic((String)Bookmarks.get("PANEL_BUTTON_REMOVE")));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BookmarkPanel.this.deleteSelected();
            }
        });
        this.removeButton.setEnabled(this.bookmarkList.getSelectedIndex() > -1);
        this.toolbar.add((Component)this.removeButton);
        JButton prefsButton = new JButton(OracleIcons.getIcon((String)"settings.png"));
        prefsButton.setToolTipText(StringUtils.stripMnemonic((String)Bookmarks.get("PANEL_PREFERENCES")));
        prefsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), new String[]{Bookmarks.get("PANEL_SETTINGS_PREFERENCES_PATH_CODE_EDITOR"), Bookmarks.get("PANEL_SETTINGS_PREFERENCES_PATH_BOOKMARKS")});
            }
        });
        this.toolbar.add(Box.createHorizontalGlue());
        this.toolbar.add((Component)prefsButton);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new BorderLayout());
        if (location == Location.DOCKABLE) {
            this.add((Component)this.toolbar, "North");
        }
        this.add((Component)sp, "Center");
        if (location == Location.TOOLBAR_HOVER) {
            this.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                    BookmarkPanel.this.bookmarkList.setVisibleRowCount(Math.min(BookmarkManager.getBookmarkManager().getAllBookmarks().size(), 20));
                    BookmarkPanel.this.bookmarkList.clearSelection();
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                    BookmarkPanel.this.bookmarkList.clearSelection();
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }
            });
        }
        this.rebuildList();
    }

    private boolean isOverClose(MouseEvent e) {
        if (this.location == Location.TOOLBAR_HOVER && e.getX() > this.bookmarkList.getWidth() - 10 && e.getX() < this.bookmarkList.getWidth() - 1) {
            int i = this.bookmarkList.locationToIndex(e.getPoint());
            Rectangle bounds = this.bookmarkList.getCellBounds(i, i);
            if (e.getY() - bounds.y > 2 && e.getY() - bounds.y < 2 + bounds.height) {
                return true;
            }
        }
        return false;
    }

    public synchronized ContextMenu getContextMenu() {
        return this.contextMenu;
    }

    Toolbar getToolbar() {
        return this.toolbar;
    }

    private void _createPopupMenuItems() {
        String labelText = StringUtils.stripMnemonic((String)Bookmarks.get("PANEL_ACTION_GO"));
        this.sourceItem = new JMenuItem(labelText);
        this.sourceItem.setMnemonic(StringUtils.getMnemonicKeyCode((String)Bookmarks.get("PANEL_ACTION_GO")));
        labelText = StringUtils.stripMnemonic((String)Bookmarks.get("PANEL_BUTTON_REMOVE"));
        this.removeItem = new JMenuItem(labelText);
        this.removeItem.setMnemonic(StringUtils.getMnemonicKeyCode((String)Bookmarks.get("PANEL_BUTTON_REMOVE")));
        labelText = StringUtils.stripMnemonic((String)Bookmarks.get("PANEL_BUTTON_REMOVEALL"));
        this.removeAllItem = new JMenuItem(labelText);
        this.removeAllItem.setMnemonic(StringUtils.getMnemonicKeyCode((String)Bookmarks.get("PANEL_BUTTON_REMOVEALL")));
        this.sourceItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = BookmarkPanel.this.bookmarkList.getSelectedIndex();
                if (index > -1) {
                    BookmarkPanel.this._jumpToSource(index);
                }
            }
        });
        this.removeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BookmarkPanel.this.deleteSelected();
            }
        });
        this.removeAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BookmarkManager.getBookmarkManager().removeAllBookmarks();
                BookmarkPanel.this.requestFocus();
            }
        });
    }

    private void deleteSelected() {
        int i = this.bookmarkList.getSelectedIndex();
        for (Bookmark b : this.bookmarkList.getSelectedValuesList()) {
            BookmarkManager.getBookmarkManager().removeBookmark(b);
        }
        this.bookmarkList.setSelectedIndex(Math.min(i, this.bookmarkList.getModel().getSize() - 1));
    }

    void setActive(boolean active) {
        Color c = active ? Colors.GRADIENT_SELECTION_DARK : Colors.TAB_PANE_BACKGROUND;
        this.setBackground(c);
    }

    private void _jumpToSource(int index) {
        Bookmark b = this.bookmarkListModel.getElementAt(index);
        b.gotoBookmark();
    }

    private void _showMenu(MouseEvent event) {
        Context context = new Context();
        context.setEvent((EventObject)event);
        this.contextMenu.show(context);
    }

    void setHover(InfoTipHover infoTipHover) {
        this.hover = infoTipHover;
    }

    void rebuildList() {
        this.bookmarkListModel.clear();
        for (Bookmark b : BookmarkManager.getBookmarkManager().getAllBookmarks()) {
            this.bookmarkListModel.addElement(b);
        }
        for (Bookmark selB : this.bookmarkList.getSelectedValuesList()) {
            int i = ((DefaultListModel)this.bookmarkList.getModel()).indexOf(selB);
            if (i == -1) continue;
            this.bookmarkList.addSelectionInterval(i, i);
        }
    }

    public void menuWillShow(ContextMenu popup) {
        this.contextMenu.add((Component)this.sourceItem, 1.0f);
        this.contextMenu.add((Component)this.removeItem, 2.0f);
        this.contextMenu.add((Component)this.removeAllItem, 2.0f);
        String subMenuTitle = Bookmarks.get("PANEL_ASSIGN_BOOKMARK_ACCELERATOR_SUB_MENU");
        JMenu accMenu = this.contextMenu.createSubMenu(StringUtils.stripMnemonic((String)subMenuTitle), Integer.valueOf(StringUtils.getMnemonicKeyCode((String)subMenuTitle)), 0.0f, 3.0f);
        this.contextMenu.add((Component)accMenu);
        List<Integer> gotoNumberList = this.getQuickGotoCmdIdList();
        for (int i = 0; i < 10; ++i) {
            String acc = KeyUtil.getAcceleratorTooltip((int)gotoNumberList.get(i));
            JMenuItem accItem = new JMenuItem(Bookmarks.format("PANEL_ASSIGN_BOOKMARK_ACCELERATOR_ASSIGN", acc), BookmarkIcons.getIcon(i));
            accItem.putClientProperty(ASSIGN_KEY, i);
            accItem.setMnemonic(("" + i).charAt(0));
            accItem.addActionListener(this.assignNumberListener);
            accMenu.add(accItem);
        }
        String noAccString = Bookmarks.get("PANEL_ASSIGN_BOOKMARK_ACCELERATOR_NO_ASSIGN");
        JMenuItem accItem = new JMenuItem(StringUtils.stripMnemonic((String)noAccString), OracleIcons.getIcon((String)"bookmark.png"));
        accItem.putClientProperty(ASSIGN_KEY, -1);
        accItem.setMnemonic(StringUtils.getMnemonicKeyCode((String)noAccString));
        accItem.addActionListener(this.assignNumberListener);
        accMenu.add(accItem);
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private List<Integer> getQuickGotoCmdIdList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < 10; ++i) {
            list.add(IdeAction.find((int)BookmarkConstants.getGoToNumberedBookmarkCmdId(i)).getCommandId());
        }
        return list;
    }

    private class AssignNumberListener
    implements ActionListener {
        private AssignNumberListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = (Integer)((JMenuItem)e.getSource()).getClientProperty(BookmarkPanel.ASSIGN_KEY);
            int index = BookmarkPanel.this.bookmarkList.getSelectedIndex();
            Bookmark bookmark = BookmarkPanel.this.bookmarkListModel.getElementAt(index);
            BookmarkManager.getBookmarkManager().setBookmarkNumber(bookmark, i);
            BookmarkPanel.this.bookmarkList.repaint();
        }
    }

    static enum Location {
        DOCKABLE,
        TOOLBAR_HOVER;

    }

    private class PeekableList
    extends JList<Bookmark>
    implements Peekable {
        public PeekableList(ListModel<Bookmark> model) {
            super(model);
        }

        public Peek peek(Point p) {
            Bookmark o;
            SwingUtilities.convertPointFromScreen(p, this);
            int i = this.locationToIndex(p);
            Rectangle rect = this.getCellBounds(i, i);
            if (rect.contains(p) && (o = BookmarkPanel.this.bookmarkListModel.get(i)) instanceof LineBookmark) {
                LineBookmark b = (LineBookmark)o;
                CodePeek peek = PeekHelper.createCodePeek((JComponent)this, (String)b.getURL().getFile(), (String)PeekHelper.getPeekText((URL)b.getURL(), (int)b.getLine(), (int)5), (String)URLFileSystem.getFileName((URL)b.getURL()), (Rectangle)rect);
                PeekHelper.addHighlight((CodePeek)peek, (int)(Math.min(5, b.getLine()) - 1), (String)"caret-line-highlight");
                peek.showPeek();
                return peek;
            }
            return null;
        }
    }

    private final class Renderer
    extends DefaultListCellRenderer {
        private static final int BUTTON_SIZE = 10;
        private boolean paintClose = false;

        private Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String textToDisplay = "";
            this.paintClose = index == BookmarkPanel.this.mouseOverIndex && index != -1 && isSelected;
            Bookmark bookmark = (Bookmark)value;
            if (bookmark != null) {
                textToDisplay = bookmark.getDescription();
            }
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, textToDisplay, index, isSelected, cellHasFocus);
            if (BookmarkPanel.this.location == Location.TOOLBAR_HOVER) {
                label.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 12));
            }
            int number = BookmarkManager.getBookmarkManager().getBookmarkNumber(bookmark);
            label.setIcon(BookmarkIcons.getIcon(number));
            return label;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.paintClose) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setStroke(new BasicStroke(1.0f));
                int indent = 3;
                int x1 = this.getWidth() - 10 + indent;
                int x2 = this.getWidth() - indent;
                int y1 = this.getHeight() / 2 - 5 + indent;
                int y2 = this.getHeight() / 2 + 5 - indent;
                if (BookmarkPanel.this.isOverClose) {
                    g.setColor(Color.LIGHT_GRAY);
                    g.fillRoundRect(x1 - 2, y1 - 2, x2 - x1 + 5, y2 - y1 + 5, 6, 6);
                }
                g.setColor(this.getForeground());
                g.drawLine(x1, y1, x2, y2);
                g.drawLine(x1, y2, x2, y1);
            }
        }
    }
}

