/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdbc.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.jdbc.util.RestJdbcNotImplementedException;
import oracle.dbtools.jdbc.util.RestJdbcUnsupportedException;

public class LogUtil {
    private static final Logger logger = Logger.getLogger(LogUtil.class.getName());
    private static final String myName = LogUtil.class.getName();
    private static final String SUBSEP = "\\Q?\\E";
    private static final String SUBEQ = "\\Q=\\E";
    private static final String LOGORBOTH = "logorboth";
    private static final String LOGORBOTHDEFAULT = "log";
    private static final String[] LOGORBOTHOPTS = new String[]{"log", "both"};
    private static final Level LOGORBOTHDEFAULTLOGLEVEL = Level.FINE;

    public static void log() {
        LogUtil.log(3, null, null);
    }

    public static void log(Integer up, String message, Exception e) {
        if (up == null) {
            up = 2;
        }
        Integer n = up;
        Integer n2 = up = Integer.valueOf(up + 1);
        LogUtil.log(up, Level.FINE, message, e);
    }

    public static void log(Integer up, Level inLevel, String message, Exception e) {
        StackTraceElement el;
        StackTraceElement[] stackTraceElements;
        Object called = null;
        Object realMessage = "No Message";
        Integer doUp = up;
        if (up == null) {
            doUp = 2;
        }
        if (message != null) {
            realMessage = ":" + message;
        }
        if ((stackTraceElements = Thread.currentThread().getStackTrace()) != null && stackTraceElements.length > doUp && (el = stackTraceElements[doUp]) != null) {
            realMessage = el.getClassName() + ":" + el.getMethodName() + ":" + el.getLineNumber() + ":" + (String)realMessage;
        }
        if (e != null) {
            logger.log(inLevel, (String)realMessage, e);
        } else {
            logger.log(inLevel, (String)realMessage);
        }
    }

    public static void setOn() {
        LogUtil.log(3, "ORest driver loaded", null);
    }

    public static String getUrlProperties(String url, Properties info) throws SQLException {
        String[] afterSplit = url.split(SUBSEP);
        for (int i = 1; i < afterSplit.length; ++i) {
            String setting;
            String[] subsplit = afterSplit[i].split(SUBEQ);
            if (subsplit == null || subsplit.length != 2) {
                throw new SQLException("URL format error");
            }
            info.put(subsplit[0], subsplit[1]);
            if (!subsplit[0].equals(LOGORBOTH) || (setting = subsplit[1]) != null && (setting.equals(LOGORBOTHOPTS[0]) || setting.equals(LOGORBOTHOPTS[1]))) continue;
            throw new SQLException("URL format error");
        }
        return afterSplit[0];
    }

    public static void logOrException(Connection conn, Level level, String message, Exception e) throws SQLException {
        if (level == null) {
            level = LOGORBOTHDEFAULTLOGLEVEL;
        }
        String setting = null;
        if (conn == null || conn.getClientInfo() == null) {
            setting = LOGORBOTHDEFAULT;
        } else {
            setting = conn.getClientInfo().getProperty(LOGORBOTH);
            if (setting == null) {
                setting = LOGORBOTHDEFAULT;
            }
        }
        boolean both = true;
        if (setting.equals(LOGORBOTHOPTS[0])) {
            both = false;
        }
        LogUtil.log(3, level, message, null);
        if (both) {
            if (message == null) {
                message = "Logged - unsupported Exception";
            }
            if (e instanceof RestJdbcNotImplementedException) {
                throw (RestJdbcNotImplementedException)e;
            }
            if (e instanceof RestJdbcUnsupportedException) {
                throw (RestJdbcUnsupportedException)e;
            }
            if (e instanceof SQLFeatureNotSupportedException) {
                throw (SQLFeatureNotSupportedException)e;
            }
            if (e != null) {
                throw new UnsupportedOperationException(e);
            }
            throw new UnsupportedOperationException(message);
        }
    }
}

