/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.apex.core;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extension.apex.command.ApexOptions;
import oracle.dbtools.extension.apex.command.MutableCommand;
import oracle.dbtools.extension.apex.exceptions.InvalidApexExportException;
import oracle.dbtools.extension.apex.exceptions.OutputBufferNotInitialized;
import oracle.dbtools.extension.apex.help.ApexMessages;
import oracle.dbtools.extension.apex.utility.ApexUtil;
import oracle.dbtools.extension.apex.utility.QueryUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.jdbc.OracleCallableStatement;

public class APEXExport {
    private static OutputStream _out;
    private final LinkedHashMap<String, RowDetails> _clobData = new LinkedHashMap();
    private final MutableCommand _command;
    private final boolean _noFileStoreClob;
    private final boolean _tsOutput = false;
    ScriptRunnerContext _ctx;
    private Connection _gConn;

    public APEXExport(MutableCommand command) {
        this._noFileStoreClob = false;
        this._command = command;
    }

    public APEXExport(MutableCommand command, boolean noFileStoreClob) {
        this._noFileStoreClob = noFileStoreClob;
        this._command = command;
    }

    private static void write(Object o) throws IOException, OutputBufferNotInitialized {
        if (null == _out || null == o) {
            throw new OutputBufferNotInitialized("Unable to write");
        }
        _out.write(o.toString().getBytes(StandardCharsets.UTF_8));
        _out.write("\n".getBytes(StandardCharsets.UTF_8));
        _out.flush();
    }

    public void doCapture() throws SQLException, IOException, InvalidApexExportException, OutputBufferNotInitialized {
        if (this.getBool(ApexOptions.Symbol.EXPWORKSPACE)) {
            if (null != this.getDec(ApexOptions.Symbol.WORKSPACEID)) {
                this.ExportWorkspace();
            } else {
                this.ExportAllWorkspaces();
            }
        } else if (this.getBool(ApexOptions.Symbol.EXPFEEDBACK)) {
            this.ExportFeedback();
        } else if (this.getBool(ApexOptions.Symbol.EXPFILES)) {
            this.ExportStaticFiles();
        } else if (this.getBool(ApexOptions.Symbol.INSTANCE)) {
            this.ExportInstance();
        } else if (null != this.getDec(ApexOptions.Symbol.WORKSPACEID)) {
            this.ExportAllApplications();
        } else {
            this.ExportApplication(false);
        }
    }

    public void ExportAllApplications() throws SQLException, IOException, InvalidApexExportException, OutputBufferNotInitialized {
        if (null == this.getString(ApexOptions.Symbol.EXPORT_TYPE) || "".equals(this.getString(ApexOptions.Symbol.EXPORT_TYPE))) {
            this._command.setOptionValue(ApexOptions.Symbol.EXPORT_TYPE, ApexOptions.Symbol.EXPORT_ALL_APPLICATIONS.toString());
        }
        if (null == this.getDec(ApexOptions.Symbol.WORKSPACEID)) {
            throw new InvalidApexExportException(ApexMessages.getString("NO_WORKSPACE"));
        }
        PreparedStatement stmt = this._gConn.prepareStatement(QueryUtils.getXMLQueries().getQuery("gStmt2", this._gConn).getSql());
        stmt.setBigDecimal(1, this.getDec(ApexOptions.Symbol.WORKSPACEID));
        ResultSet result = stmt.executeQuery();
        while (result.next()) {
            this._command.setOptionValue(ApexOptions.Symbol.APPLICATIONID, result.getBigDecimal(1));
            this.ExportApplication(true);
        }
        result.close();
        stmt.close();
    }

    public void ExportAllWorkspaces() throws SQLException, IOException, OutputBufferNotInitialized {
        if (null == this.getString(ApexOptions.Symbol.EXPORT_TYPE) || "".equals(this.getString(ApexOptions.Symbol.EXPORT_TYPE))) {
            this._command.setOptionValue(ApexOptions.Symbol.EXPORT_TYPE, ApexOptions.Symbol.EXPORT_ALL_WORKSPACES.toString());
        }
        PreparedStatement stmt = this._gConn.prepareStatement(QueryUtils.getXMLQueries().getQuery("gStmtWorkspaces", this._gConn).getSql());
        ResultSet result = stmt.executeQuery();
        while (result.next()) {
            BigDecimal wkspID = result.getBigDecimal(1);
            String wkspName = result.getString(2);
            this._command.setOptionValue(ApexOptions.Symbol.WORKSPACEID, wkspID);
            this._command.setOptionValue(ApexOptions.Symbol.WORKSPACENAME, wkspName);
            this.ExportWorkspace();
        }
        result.close();
        stmt.close();
    }

    public void ExportComponents() throws SQLException, IOException, InvalidApexExportException, OutputBufferNotInitialized {
        if (null == this.getString(ApexOptions.Symbol.EXPORT_TYPE) || "".equals(this.getString(ApexOptions.Symbol.EXPORT_TYPE))) {
            this._command.setOptionValue(ApexOptions.Symbol.EXPORT_TYPE, ApexOptions.Symbol.EXPORT_COMPONENTS.toString());
        }
        this.ExportApplication(false);
    }

    private String getString(Id id) {
        return (String)this._command.getOptionValue(id);
    }

    public void ExportApplication(boolean expPkgAppMapping) throws SQLException, IOException, InvalidApexExportException, OutputBufferNotInitialized {
        if (null == this.getDec(ApexOptions.Symbol.APPLICATIONID)) {
            throw new InvalidApexExportException(ApexMessages.getString("NO_APPLICATION_ID"));
        }
        QueryUtils.loadAppDetail(this._gConn, this._command, this.getDec(ApexOptions.Symbol.APPLICATIONID));
        APEXExport.write("Exporting Workspace " + this.getString(ApexOptions.Symbol.WORKSPACENAME) + " - application " + this.getDec(ApexOptions.Symbol.APPLICATIONID) + ":" + this.getString(ApexOptions.Symbol.APPLICATIONNAME));
        String p_stmt = QueryUtils.getXMLQueries().getQuery("apex.export.v" + this.getApiVersion(this._gConn), this._gConn).getSql();
        OracleCallableStatement l_stmt = this.getExportStmt(p_stmt);
        l_stmt.setBigDecimal(2, this.getDec(ApexOptions.Symbol.APPLICATIONID));
        this.bind_yn(l_stmt, 3, this.getBool(ApexOptions.Symbol.SPLIT));
        this.bind_yn(l_stmt, 4, !this.getBool(ApexOptions.Symbol.SKIPEXPORTDATE));
        this.bind_yn(l_stmt, 5, this.getBool(ApexOptions.Symbol.EXPPUBREPORTS));
        this.bind_yn(l_stmt, 6, this.getBool(ApexOptions.Symbol.EXPSAVEDREPORTS));
        this.bind_yn(l_stmt, 7, this.getBool(ApexOptions.Symbol.EXPIRNOTIF));
        this.bind_yn(l_stmt, 8, this.getBool(ApexOptions.Symbol.EXPTRANSLATIONS));
        this.bind_yn(l_stmt, 9, expPkgAppMapping);
        this.bind_yn(l_stmt, 10, this.getBool(ApexOptions.Symbol.EXPORIGINALIDS));
        this.bind_yn(l_stmt, 11, this.getBool(ApexOptions.Symbol.EXPNOSUBSCRIPTIONS));
        this.bind_yn(l_stmt, 12, this.getBool(ApexOptions.Symbol.EXPCOMMENTS));
        l_stmt.setString(13, this.getString(ApexOptions.Symbol.EXPSUPPORTINGOBJECTS));
        this.bind_yn(l_stmt, 14, this.getBool(ApexOptions.Symbol.EXPACLASSIGNMENTS));
        if (1 < this.getApiVersion(this._gConn)) {
            if (null != this.getString(ApexOptions.Symbol.EXPCOMPONENTS)) {
                String cleaned = this.getString(ApexOptions.Symbol.EXPCOMPONENTS).replaceAll("^\"|\"$", "");
                l_stmt.setString(15, cleaned);
            } else {
                l_stmt.setString(15, "");
            }
        }
        if (2 < this.getApiVersion(this._gConn)) {
            l_stmt.setString(16, this.getListAsString(ApexOptions.Symbol.EXPTYPE));
        }
        if (3 < this.getApiVersion(this._gConn)) {
            String auditTypeVal = this.getString(ApexOptions.Symbol.AUDITTYPE);
            if (auditTypeVal != null && auditTypeVal.equalsIgnoreCase("NULL")) {
                l_stmt.setNull(17, 0);
            } else {
                l_stmt.setString(17, auditTypeVal);
            }
        }
        this.handle_write_or_save(l_stmt);
    }

    private BigDecimal getDec(Id id) {
        return (BigDecimal)this._command.getOptionValue(id);
    }

    private int getApiVersion(Connection conn) {
        String version = DBUtil.getInstance((Connection)conn).executeReturnOneCol(QueryUtils.getXMLQueries().getQuery("apex.version", conn).getSql());
        String cleanversion = version.replaceAll("-", "");
        Version source = new Version(cleanversion);
        int A192 = source.compareTo(new Version("19.2"));
        int A201 = source.compareTo(new Version("20.1"));
        int A241 = source.compareTo(new Version("24.1"));
        if (A241 >= 0) {
            return 4;
        }
        if (A201 >= 0) {
            return 3;
        }
        if (A192 >= 0) {
            return 2;
        }
        return 1;
    }

    private OracleCallableStatement getExportStmt(String p_stmt) throws SQLException {
        if (this.getBool(ApexOptions.Symbol.DEBUG)) {
            try {
                APEXExport.write("  " + p_stmt.replace("\n", "\n  "));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        OracleCallableStatement l_stmt = (OracleCallableStatement)this._gConn.prepareCall(p_stmt);
        l_stmt.registerOutParameter(1, 2003, "PUBLIC.APEX_T_EXPORT_FILES");
        return l_stmt;
    }

    private void bind_yn(OracleCallableStatement p_stmt, int p_pos, boolean p_val) throws SQLException {
        p_stmt.setString(p_pos, p_val ? "Y" : "N");
    }

    private boolean getBool(Id id) {
        return this._command.isFlagSet(id);
    }

    private String getListAsString(Id id) {
        Object val = this._command.getOptionValue(id);
        if (val instanceof List) {
            int s = ((Collection)val).size();
            if (1 == s) {
                return (String)((List)val).get(0);
            }
            if (1 < s) {
                return String.join((CharSequence)",", (Iterable)val);
            }
            return null;
        }
        if ("[APPLICATION_SOURCE]".equals(val.toString())) {
            return "APPLICATION_SOURCE";
        }
        return null;
    }

    private void handle_write_or_save(OracleCallableStatement p_stmt) throws SQLException, IOException, OutputBufferNotInitialized {
        if (this._noFileStoreClob) {
            this.exec_and_save_files(p_stmt);
        } else {
            this.exec_and_write_files(p_stmt);
        }
    }

    private void exec_and_save_files(OracleCallableStatement p_stmt) throws IOException, OutputBufferNotInitialized {
        try {
            Object[] l_result;
            java.util.Date now;
            if (this.getBool(ApexOptions.Symbol.DEBUG)) {
                now = new java.util.Date();
                APEXExport.write("  Start " + now);
            }
            p_stmt.execute();
            for (Object l_tmp : l_result = (Object[])((Array)p_stmt.getObject(1)).getArray()) {
                Struct l_rec = (Struct)l_tmp;
                if (this.getBool(ApexOptions.Symbol.DEBUG)) {
                    APEXExport.write("  SQLTypeName: " + l_rec.getSQLTypeName());
                    APEXExport.write("  Attr0: " + l_rec.getAttributes()[0].toString());
                }
                Object l_name = (String)l_rec.getAttributes()[0];
                if (null != this.getString(ApexOptions.Symbol.DIR) && !"".equals(this.getString(ApexOptions.Symbol.DIR))) {
                    l_name = this.getString(ApexOptions.Symbol.DIR).replaceAll("/$", "") + "/" + (String)l_name;
                }
                Clob l_contents = (Clob)l_rec.getAttributes()[1];
                this._clobData.put((String)l_name, new RowDetails((String)l_name, l_contents.getSubString(1L, (int)l_contents.length()), ((Serializable)((Object)Objects.requireNonNullElse(this.getDec(ApexOptions.Symbol.APPLICATIONID), ""))).toString(), ((Serializable)((Object)Objects.requireNonNullElse(this.getDec(ApexOptions.Symbol.WORKSPACEID), ""))).toString(), this.getString(ApexOptions.Symbol.APPLICATIONNAME), this.getString(ApexOptions.Symbol.WORKSPACENAME), this.getString(ApexOptions.Symbol.OVERRIDE_APP_SCHEMA), this.getString(ApexOptions.Symbol.OVERRIDE_APP_ALIAS), this.getString(ApexOptions.Symbol.OVERRIDE_APP_ID), this.getString(ApexOptions.Symbol.OVERRIDE_APP_WORKSPACE)));
            }
            p_stmt.close();
            if (this.getBool(ApexOptions.Symbol.DEBUG)) {
                now = new java.util.Date();
                APEXExport.write("  Completed at " + now);
            }
        }
        catch (Exception e) {
            APEXExport.write("No Data Found please verify your information. ");
        }
    }

    private void exec_and_write_ts(OracleCallableStatement p_stmt) throws SQLException, IOException, OutputBufferNotInitialized {
        java.util.Date now;
        Object l_name = null;
        File exportFile = null;
        if (this.getBool(ApexOptions.Symbol.DEBUG)) {
            now = new java.util.Date();
            APEXExport.write("  Start " + now);
        }
        p_stmt.execute();
        Object[] l_result = (Object[])((Array)p_stmt.getObject(1)).getArray();
        boolean overWrite = this.getBool(ApexOptions.Symbol.OVERWRITE_FILES);
        for (Object l_tmp : l_result) {
            Struct l_rec = (Struct)l_tmp;
            if (this.getBool(ApexOptions.Symbol.DEBUG)) {
                APEXExport.write("  SQLTypeName: " + l_rec.getSQLTypeName());
                APEXExport.write("  Attr0: " + l_rec.getAttributes()[0].toString());
            }
            l_name = (String)l_rec.getAttributes()[0];
            if (null != this.getString(ApexOptions.Symbol.DIR) && !"".equals(this.getString(ApexOptions.Symbol.DIR))) {
                l_name = this.getString(ApexOptions.Symbol.DIR).replaceAll("/$", "") + "/" + (String)l_name;
            }
            Clob l_contents = (Clob)l_rec.getAttributes()[1];
            String data = l_contents.getSubString(1L, (int)l_contents.length());
            data = data.replaceAll("(?s)^.*?begin.*?\\.(\\w+\\s\\(.*?\\);)", "$1");
            data = data.replaceAll("(?s)\\w+\\.(\\w+\\(.*?\\);)", "$1");
            data = data.replaceAll(",?\\s*\\w+=>(.*)", "$1,");
            data = data.replaceAll("(?s)wwv_flow_imp\\.component_end.*", "component_end();");
            exportFile = ApexUtil.getFile(this._ctx, (String)l_name, true, overWrite);
            ApexUtil.writeToFile(this._ctx, exportFile, l_contents.getSubString(1L, (int)l_contents.length()));
        }
        p_stmt.close();
        if (l_name != null && exportFile != null) {
            l_name = ((String)l_name).replace("/.*\\.*$", "/" + exportFile.getName());
        }
        APEXExport.write("File " + l_name + " created");
        if (this.getBool(ApexOptions.Symbol.DEBUG)) {
            now = new java.util.Date();
            APEXExport.write("  Completed at " + now);
        }
    }

    private void exec_and_write_files(OracleCallableStatement p_stmt) throws SQLException, IOException, OutputBufferNotInitialized {
        java.util.Date now;
        Object l_name = null;
        File exportFile = null;
        if (this.getBool(ApexOptions.Symbol.DEBUG)) {
            now = new java.util.Date();
            APEXExport.write("  Start " + now);
        }
        p_stmt.execute();
        Object[] l_result = (Object[])((Array)p_stmt.getObject(1)).getArray();
        boolean overWrite = this.getBool(ApexOptions.Symbol.OVERWRITE_FILES);
        for (Object l_tmp : l_result) {
            Struct l_rec = (Struct)l_tmp;
            if (this.getBool(ApexOptions.Symbol.DEBUG)) {
                APEXExport.write("  SQLTypeName: " + l_rec.getSQLTypeName());
                APEXExport.write("  Attr0: " + l_rec.getAttributes()[0].toString());
            }
            l_name = (String)l_rec.getAttributes()[0];
            if (null != this.getString(ApexOptions.Symbol.DIR) && !"".equals(this.getString(ApexOptions.Symbol.DIR))) {
                l_name = this.getString(ApexOptions.Symbol.DIR).replaceAll("/$", "") + "/" + (String)l_name;
            }
            Clob l_contents = (Clob)l_rec.getAttributes()[1];
            exportFile = ApexUtil.getFile(this._ctx, (String)l_name, true, overWrite);
            ApexUtil.writeToFile(this._ctx, exportFile, l_contents.getSubString(1L, (int)l_contents.length()));
        }
        p_stmt.close();
        if (l_name != null && exportFile != null) {
            l_name = ((String)l_name).replace("/.*\\.*$", "/" + exportFile.getName());
        }
        APEXExport.write("File " + l_name + " created");
        if (this.getBool(ApexOptions.Symbol.DEBUG)) {
            now = new java.util.Date();
            APEXExport.write("  Completed at " + now);
        }
    }

    public void ExportFeedback() throws SQLException, IOException, OutputBufferNotInitialized {
        if (null == this.getString(ApexOptions.Symbol.EXPORT_TYPE) || "".equals(this.getString(ApexOptions.Symbol.EXPORT_TYPE))) {
            this._command.setOptionValue(ApexOptions.Symbol.EXPORT_TYPE, ApexOptions.Symbol.EXPORT_FEEDBACK.toString());
        }
        OracleCallableStatement l_stmt = this.getExportStmt("begin\n    ? := apex_export.get_feedback (\n             p_workspace_id      => ?,\n             p_with_date         => ?='Y',\n             p_since             => ?,\n             p_deployment_system => ? );\nend;");
        boolean hasRows = false;
        if (null != this.getDec(ApexOptions.Symbol.WORKSPACEID) && 0L != this.getDec(ApexOptions.Symbol.WORKSPACEID).longValue()) {
            String sql = QueryUtils.getXMLQueries().getQuery("gStmtWorkspaceFeedback", this._gConn).getSql();
            PreparedStatement stmt = this._gConn.prepareStatement(sql);
            stmt.setBigDecimal(1, this.getDec(ApexOptions.Symbol.WORKSPACEID));
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                hasRows = true;
                String wkspName = result.getString(1);
                APEXExport.write("Exporting Feedback for Workspace " + this.getDec(ApexOptions.Symbol.WORKSPACEID) + ":'" + wkspName + "' ");
                l_stmt.setBigDecimal(2, this.getDec(ApexOptions.Symbol.WORKSPACEID));
                this.bind_yn(l_stmt, 3, !this.getBool(ApexOptions.Symbol.SKIPEXPORTDATE));
                l_stmt.setDate(4, this.getDate(ApexOptions.Symbol.EXPFEEDBACKSINCE));
                l_stmt.setString(5, this.getString(ApexOptions.Symbol.DEPLOYMENTSYSTEM));
                this.handle_write_or_save(l_stmt);
            }
            if (!hasRows) {
                APEXExport.write("No data found meeting your query");
            }
            result.close();
            stmt.close();
        } else {
            String sql = QueryUtils.getXMLQueries().getQuery("gStmtWorkspacesFeedbacks", this._gConn).getSql();
            PreparedStatement stmt = this._gConn.prepareStatement(sql);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                hasRows = true;
                BigDecimal wkspID = result.getBigDecimal(1);
                String wkspName = result.getString(2);
                APEXExport.write("Exporting Feedback for Workspace " + wkspID + ":'" + wkspName + "' ");
                l_stmt.setBigDecimal(2, this.getDec(ApexOptions.Symbol.WORKSPACEID));
                this.bind_yn(l_stmt, 3, !this.getBool(ApexOptions.Symbol.SKIPEXPORTDATE));
                l_stmt.setDate(4, this.getDate(ApexOptions.Symbol.EXPFEEDBACKSINCE));
                l_stmt.setString(5, this.getString(ApexOptions.Symbol.DEPLOYMENTSYSTEM));
                this.handle_write_or_save(l_stmt);
            }
            if (!hasRows) {
                APEXExport.write("No data found meeting your query");
            }
            result.close();
            stmt.close();
        }
    }

    public void ExportInstance() throws SQLException, IOException, InvalidApexExportException, OutputBufferNotInitialized {
        if (null == this.getString(ApexOptions.Symbol.EXPORT_TYPE) || "".equals(this.getString(ApexOptions.Symbol.EXPORT_TYPE))) {
            this._command.setOptionValue(ApexOptions.Symbol.EXPORT_TYPE, ApexOptions.Symbol.EXPORT_INSTANCE.toString());
        }
        String sql = QueryUtils.getXMLQueries().getQuery("gStmtInstance", this._gConn).getSql();
        PreparedStatement stmt = this._gConn.prepareStatement(sql);
        ResultSet result = stmt.executeQuery();
        while (result.next()) {
            this._command.setOptionValue(ApexOptions.Symbol.WORKSPACEID, result.getBigDecimal(1));
            this._command.setOptionValue(ApexOptions.Symbol.APPLICATIONID, result.getBigDecimal(2));
            this._command.setOptionValue(ApexOptions.Symbol.WORKSPACENAME, result.getString(3));
            this._command.setOptionValue(ApexOptions.Symbol.APPLICATIONNAME, result.getString(4));
            this.ExportApplication(true);
        }
    }

    public void ExportStaticFiles() throws SQLException, IOException, InvalidApexExportException, OutputBufferNotInitialized {
        if (null == this.getString(ApexOptions.Symbol.EXPORT_TYPE) || "".equals(this.getString(ApexOptions.Symbol.EXPORT_TYPE))) {
            this._command.setOptionValue(ApexOptions.Symbol.EXPORT_TYPE, ApexOptions.Symbol.EXPORT_STATIC_FILES.toString());
        }
        if (null == this.getDec(ApexOptions.Symbol.WORKSPACEID)) {
            throw new InvalidApexExportException(ApexMessages.getString("NO_WORKSPACE"));
        }
        OracleCallableStatement l_stmt = this.getExportStmt("begin\n    ? := apex_export.get_workspace_files (\n             p_workspace_id          => ?,\n             p_with_date             => ?='Y' );\nend;");
        l_stmt.setBigDecimal(2, this.getDec(ApexOptions.Symbol.WORKSPACEID));
        this.bind_yn(l_stmt, 3, !this.getBool(ApexOptions.Symbol.SKIPEXPORTDATE));
        this.handle_write_or_save(l_stmt);
    }

    public void ExportWorkspace() throws SQLException, IOException, OutputBufferNotInitialized {
        if (null == this.getString(ApexOptions.Symbol.EXPORT_TYPE) || "".equals(this.getString(ApexOptions.Symbol.EXPORT_TYPE))) {
            this._command.setOptionValue(ApexOptions.Symbol.EXPORT_TYPE, ApexOptions.Symbol.EXPORT_WORKSPACE.toString());
        }
        HashMap<String, String> binds = new HashMap<String, String>();
        DBUtil dbUtil = DBUtil.getInstance((Connection)this._gConn);
        binds.put("ID", this.getDec(ApexOptions.Symbol.WORKSPACEID).toString());
        String sql = QueryUtils.getXMLQueries().getQuery("gStmtWorkspace", this._gConn).getSql();
        String wName = dbUtil.executeOracleReturnOneCol(sql, binds);
        APEXExport.write("Exporting Workspace " + this.getDec(ApexOptions.Symbol.WORKSPACEID) + ":'" + wName + "' ");
        OracleCallableStatement l_stmt = this.getExportStmt("begin\n    ? := apex_export.get_workspace (\n             p_workspace_id          => ?,\n             p_with_team_development => ?='Y',\n             p_with_misc             => ?='Y',\n             p_with_date             => ?='Y' );\nend;");
        l_stmt.setBigDecimal(2, this.getDec(ApexOptions.Symbol.WORKSPACEID));
        this.bind_yn(l_stmt, 3, this.getBool(ApexOptions.Symbol.EXPTEAMDEVDATA));
        this.bind_yn(l_stmt, 4, !this.getBool(ApexOptions.Symbol.EXPMINIMAL));
        this.bind_yn(l_stmt, 5, !this.getBool(ApexOptions.Symbol.SKIPEXPORTDATE));
        this.handle_write_or_save(l_stmt);
    }

    public LinkedHashMap<String, RowDetails> getResults() {
        return this._clobData;
    }

    public void List() throws SQLException, IOException, OutputBufferNotInitialized {
        String report;
        HashMap<String, Object> binds = new HashMap<String, Object>();
        if (null == this.getDec(ApexOptions.Symbol.WORKSPACEID) && null == this.getDec(ApexOptions.Symbol.APPLICATIONID)) {
            report = "apex.list";
        } else if (null != this.getDec(ApexOptions.Symbol.WORKSPACEID) && null == this.getDec(ApexOptions.Symbol.APPLICATIONID)) {
            report = "gStmtListAppChanges";
            binds.put("b_workspace_id", this.getDec(ApexOptions.Symbol.WORKSPACEID));
        } else {
            report = "gStmtListCompChanges";
            binds.put("b_application_id", this.getDec(ApexOptions.Symbol.APPLICATIONID));
        }
        binds.put("b_updated_on", this.getDate(ApexOptions.Symbol.CHANGESSINCE));
        binds.put("b_updated_by", this.getString(ApexOptions.Symbol.CHANGESBY));
        ApexUtil.printList(this._gConn, this._ctx, report, binds);
    }

    public void setConnection(Connection conn) {
        this._gConn = conn;
    }

    public void setCtx(ScriptRunnerContext ctx) {
        this._ctx = ctx;
    }

    public void setCWD(String cwd) {
    }

    public void setOutStream(OutputStream out) {
        _out = out;
    }

    private Date getDate(Id id) {
        try {
            java.util.Date date = (java.util.Date)this._command.getOptionValue(id);
            return new Date(date.getTime());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static class RowDetails {
        String fileName;
        String contents;
        String appId;
        String workId;
        String appName;
        String workName;
        String override_schema;
        String override_alias;
        String override_appid;
        String override_workspace;

        public RowDetails(String fName, String contents, String appId, String workId, String appName, String workName, String override_schema, String override_alias, String override_appid, String override_workspace) {
            this.fileName = fName;
            this.contents = contents;
            this.appId = appId;
            this.workId = workId;
            this.appName = appName;
            this.workName = workName;
            this.override_schema = override_schema;
            this.override_alias = override_alias;
            this.override_appid = override_appid;
            this.override_workspace = override_workspace;
        }

        public String getAppId() {
            return this.appId;
        }

        public String getAppName() {
            return this.appName;
        }

        public String getContents() {
            return this.contents;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String name) {
            this.fileName = name;
        }

        public String getWorkId() {
            return this.workId;
        }

        public String getWorkName() {
            return this.workName;
        }

        public String getOverrideSchema() {
            return this.override_schema;
        }

        public String getOverrideAlias() {
            return this.override_alias;
        }

        public String getOverrideAppId() {
            return this.override_appid;
        }

        public String getOverrideWorkspace() {
            return this.override_workspace;
        }

        public void setContent(String content) {
            this.contents = content;
        }
    }
}

