/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.webbrowser;

import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.ideimpl.webbrowser.BrowserArb;
import oracle.javatools.util.PlatformUtils;

public final class HttpPing {
    private static final int DEFAULT_TIMEOUT = 5000;
    private final ProxyOptions _proxyOptions;
    private final URL _url;
    private final int _timeout;
    private static final String _forceReadTimeout = System.getProperty("oracle.ide.webbrowser.forceReadTimeout", "false");

    public HttpPing(ProxyOptions options, URL url) {
        this(options, url, 5000);
    }

    public HttpPing(ProxyOptions options, URL url, int timeout) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        if (url == null) {
            throw new IllegalArgumentException("url is null");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout must be >= 0: " + timeout);
        }
        this._proxyOptions = options;
        this._url = url;
        this._timeout = timeout;
    }

    public void ping() throws PingFailedException {
        PingRunnable runnable = new PingRunnable();
        this._proxyOptions.doTask(runnable);
        if (runnable.getThrown() != null) {
            throw runnable.getThrown();
        }
    }

    private PingFailedException convertToPingFailedException(Exception e, int httpResponseCode, String httpResponseMessage) {
        if (e instanceof SocketTimeoutException || httpResponseCode == 408 || httpResponseCode == 504) {
            if ("download.oracle.com".equals(this._url.getHost()) && this._proxyOptions.getProxyExceptions() != null && (this._proxyOptions.getProxyExceptions().toLowerCase().contains("*.oracle.com") || this._proxyOptions.getProxyExceptions().toLowerCase().contains("download.oracle.com"))) {
                return new PingFailedException(BrowserArb.getString(53), BrowserArb.format(54, this._url.getHost()), e, httpResponseCode, httpResponseMessage);
            }
            return new PingFailedException(BrowserArb.getString(45), BrowserArb.format(46, this._url.getHost()), e, httpResponseCode, httpResponseMessage);
        }
        if (httpResponseCode == 407) {
            if (this._proxyOptions.getProxyUserName() != null && this._proxyOptions.getProxyUserName().length() > 0 && this._proxyOptions.getUseProxyAuthentication().booleanValue()) {
                return new PingFailedException(BrowserArb.getString(49), BrowserArb.format(50, this._url.getHost()), e, httpResponseCode, httpResponseMessage);
            }
            return new PingFailedException(BrowserArb.getString(51), BrowserArb.format(52, this._url.getHost()), e, httpResponseCode, httpResponseMessage);
        }
        return new PingFailedException(BrowserArb.getString(47), BrowserArb.format(48, this._url.getHost()), e, httpResponseCode, httpResponseMessage);
    }

    private class PingRunnable
    implements Runnable {
        private PingFailedException _thrown;

        private PingRunnable() {
        }

        public PingFailedException getThrown() {
            return this._thrown;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            URLConnection conn = null;
            int responseCode = -1;
            String responseMessage = null;
            try {
                conn = HttpPing.this._url.openConnection();
                conn.setConnectTimeout(HttpPing.this._timeout);
                if (!PlatformUtils.isMac() || Boolean.parseBoolean(_forceReadTimeout)) {
                    conn.setReadTimeout(HttpPing.this._timeout);
                }
                if (conn instanceof HttpURLConnection) {
                    HttpURLConnection httpConn = (HttpURLConnection)conn;
                    httpConn.setRequestMethod("HEAD");
                    httpConn.setInstanceFollowRedirects(true);
                }
                conn.connect();
                if (conn instanceof HttpURLConnection) {
                    responseCode = ((HttpURLConnection)conn).getResponseCode();
                    responseMessage = ((HttpURLConnection)conn).getResponseMessage();
                    if (responseCode >= 400) {
                        this._thrown = HttpPing.this.convertToPingFailedException(null, responseCode, responseMessage);
                    }
                }
            }
            catch (Exception e) {
                this._thrown = HttpPing.this.convertToPingFailedException(e, responseCode, responseMessage);
            }
            finally {
                if (conn != null && conn instanceof HttpURLConnection) {
                    ((HttpURLConnection)conn).disconnect();
                }
            }
        }
    }

    public static final class PingFailedException
    extends Exception {
        private final String _details;
        private final int _responseCode;
        private final String _responseMessage;

        private PingFailedException(String summary, String details, Throwable cause, int responseCode, String responseMessage) {
            super(summary, cause);
            this._details = details;
            this._responseCode = responseCode;
            this._responseMessage = responseMessage;
        }

        public String getDetails() {
            return this._details;
        }

        public int getHttpResponseCode() {
            return this._responseCode;
        }

        public String getHttpResponseMessage() {
            return this._responseMessage;
        }
    }
}

