/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.jndi;

import java.util.Hashtable;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import oracle.javatools.jndi.LocalInitialContextFactory;
import oracle.javatools.mt.annotation.CodeSharingSafe;

public class LocalInitialContextFactoryBuilder
implements InitialContextFactoryBuilder {
    private static final Logger LOG = Logger.getLogger("oracle.javatools.jndi");
    @CodeSharingSafe(value="StaticField")
    private static final ThreadLocal<Hashtable> OVERRIDE_ENV = new ThreadLocal<Hashtable>(){

        @Override
        protected Hashtable initialValue() {
            return new Hashtable();
        }
    };
    public static final String INITIAL_CONTEXT_FACTORY_LOADER = "oracle.javatools.jndi.factorybuilder.loader";
    LocalInitialContextFactory ic = new LocalInitialContextFactory();

    public static <T, E extends Exception> T callWithModifiedEnvironment(Object key, Object value, Block<T, E> block) throws E {
        Hashtable<Object, Object> modifiedProperties = new Hashtable<Object, Object>();
        modifiedProperties.put(key, value);
        return LocalInitialContextFactoryBuilder.callWithModifiedEnvironment(modifiedProperties, block);
    }

    public static Context createInitialContext(final Hashtable<?, ?> env, ClassLoader classloader) throws NamingException {
        return LocalInitialContextFactoryBuilder.callWithModifiedEnvironment(INITIAL_CONTEXT_FACTORY_LOADER, classloader, new Block<Context, NamingException>(){

            @Override
            public InitialContext call() throws NamingException {
                return new InitialContext(env);
            }
        });
    }

    public static <T, E extends Exception> T callWithModifiedEnvironment(Hashtable modifiedProperties, Block<T, E> block) throws E {
        try {
            OVERRIDE_ENV.get().putAll(modifiedProperties);
            T t = block.call();
            return t;
        }
        finally {
            OVERRIDE_ENV.get().clear();
        }
    }

    @Override
    public InitialContextFactory createInitialContextFactory(Hashtable<?, ?> originalEnv) throws NamingException {
        String className;
        Hashtable env = new Hashtable(originalEnv);
        env.putAll(OVERRIDE_ENV.get());
        Object initialContextFactory = env.get("java.naming.factory.initial");
        if (LocalInitialContextFactory.class.getName().equals(initialContextFactory)) {
            return this.ic;
        }
        String string = className = env != null ? (String)env.get("java.naming.factory.initial") : null;
        if (className == null) {
            NoInitialContextException ne = new NoInitialContextException("Need to specify class name in environment or system property, or as an applet parameter, or in an application resource file:  java.naming.factory.initial");
            throw ne;
        }
        try {
            ClassLoader cl = (ClassLoader)env.get(INITIAL_CONTEXT_FACTORY_LOADER);
            if (cl != null) {
                return this.createInitialFactoryWithLoader(className, cl);
            }
            return this.createInitialFactoryWithDefaults(className, env);
        }
        catch (Throwable e) {
            this.throwNoInitialContextException(className, e);
            return null;
        }
    }

    private InitialContextFactory createInitialFactoryWithDefaults(String className, Hashtable<?, ?> env) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        ClassLoader cl = this.getClass().getClassLoader();
        try {
            InitialContextFactory icf = this.createInitialFactoryWithLoader(className, cl);
            LOG.warning(icf + " initial context factory loaded by buddy policy with classloader " + icf.getClass().getClassLoader() + ". This is avoidable by calling " + this.getClass().getName() + ".createInitialContext(Hashtable, ClassLoader) instead of new InitialContext(Hashtable) directly.");
            return icf;
        }
        catch (ClassNotFoundException cnf) {
            ClassLoader myCL = Thread.currentThread().getContextClassLoader();
            if (cl.equals(myCL)) {
                throw cnf;
            }
            InitialContextFactory instance = this.createInitialFactoryWithLoader(className, myCL);
            return instance;
        }
    }

    private InitialContextFactory createInitialFactoryWithLoader(String className, ClassLoader cl) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        LOG.fine("Attempting to load " + className + " with " + cl);
        return (InitialContextFactory)cl.loadClass(className).newInstance();
    }

    private final void throwNoInitialContextException(String className, Throwable e) throws NoInitialContextException {
        NoInitialContextException ne = new NoInitialContextException("Cannot instantiate class: " + className);
        if (e != null) {
            ne.setRootCause(e);
        }
        throw ne;
    }

    public static interface Block<T, E extends Exception> {
        public T call() throws E;
    }
}

