/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.util.List;
import oracle.olapi.metadata.mdm.MdmBaseMeasure;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.syntax.BaseMetadataObjectReference;
import oracle.olapi.syntax.DataType;
import oracle.olapi.syntax.MetadataObjectReference;
import oracle.olapi.syntax.SQLDataType;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.ValidationContext;
import oracle.olapi.syntax.parser.ExpParser;

public final class OLAPDMLExpression
extends TypedExpression {
    private TypedExpression m_OlapDML;
    private BaseMetadataObjectReference[] m_Dimensions = null;
    private BaseMetadataObjectReference[] m_DenseDimensions = null;
    private BaseMetadataObjectReference[] m_LoopByMeasures = null;
    private SQLDataType m_SQLDataType;

    private BaseMetadataObjectReference[] getDimensionsInternal() {
        return this.m_Dimensions;
    }

    private BaseMetadataObjectReference[] getDenseDimensionsInternal() {
        return this.m_DenseDimensions;
    }

    private BaseMetadataObjectReference[] getLoopByMeasuresInternal() {
        return this.m_LoopByMeasures;
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        int n;
        syntaxPrintingContext.append("OLAP_DML_EXPRESSION(");
        syntaxPrintingContext.print(this.getOlapDML());
        syntaxPrintingContext.append(", ");
        syntaxPrintingContext.append(this.getSQLDataType().getSQLText());
        if (null != this.getDimensionsInternal()) {
            block0: for (n = 0; n < this.getDimensionsInternal().length; ++n) {
                syntaxPrintingContext.newLineAndIndent();
                if (0 == n) {
                    syntaxPrintingContext.append("DIMENSION BY ");
                } else {
                    syntaxPrintingContext.append(", ");
                }
                this.getDimensionsInternal()[n].toSyntax(syntaxPrintingContext);
                if (null == this.getDenseDimensionsInternal() || !syntaxPrintingContext.isMetadataXMLVersionSameOrLaterThan("2.1")) continue;
                for (int i = 0; i < this.getDenseDimensionsInternal().length; ++i) {
                    if (this.getDimensionsInternal()[n].getBaseMetadataObject() != this.getDenseDimensionsInternal()[i].getBaseMetadataObject()) continue;
                    syntaxPrintingContext.append(" DENSE");
                    continue block0;
                }
            }
        }
        if (null != this.getLoopByMeasuresInternal() && syntaxPrintingContext.isMetadataXMLVersionSameOrLaterThan("2.1")) {
            for (n = 0; n < this.getLoopByMeasuresInternal().length; ++n) {
                syntaxPrintingContext.newLineAndIndent();
                if (0 == n) {
                    syntaxPrintingContext.append("LOOP BY ");
                } else {
                    syntaxPrintingContext.append(", ");
                }
                this.getLoopByMeasuresInternal()[n].toSyntax(syntaxPrintingContext);
            }
        }
        syntaxPrintingContext.append(")");
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        int n;
        validationContext.push(this);
        super.validate(validationContext);
        validationContext.pop();
        if (null != this.getDimensionsInternal()) {
            for (n = 0; n < this.getDimensionsInternal().length; ++n) {
                this.getDimensionsInternal()[n] = (BaseMetadataObjectReference)validationContext.validate(this.getDimensionsInternal()[n]);
            }
        }
        if (null != this.getDenseDimensionsInternal()) {
            for (n = 0; n < this.getDenseDimensionsInternal().length; ++n) {
                this.getDenseDimensionsInternal()[n] = (BaseMetadataObjectReference)validationContext.validate(this.getDenseDimensionsInternal()[n]);
            }
        }
        if (null != this.getLoopByMeasuresInternal()) {
            for (n = 0; n < this.getLoopByMeasuresInternal().length; ++n) {
                this.getLoopByMeasuresInternal()[n] = (BaseMetadataObjectReference)validationContext.validate(this.getLoopByMeasuresInternal()[n]);
            }
        }
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        int n;
        if (null != this.getDimensionsInternal()) {
            for (n = 0; n < this.getDimensionsInternal().length; ++n) {
                if (this.getDimensionsInternal()[n].isDefinitionComplete()) continue;
                return false;
            }
        }
        if (null != this.getDenseDimensionsInternal()) {
            for (n = 0; n < this.getDenseDimensionsInternal().length; ++n) {
                if (this.getDenseDimensionsInternal()[n].isDefinitionComplete()) continue;
                return false;
            }
        }
        if (null != this.getLoopByMeasuresInternal()) {
            for (n = 0; n < this.getLoopByMeasuresInternal().length; ++n) {
                if (this.getLoopByMeasuresInternal()[n].isDefinitionComplete()) continue;
                return false;
            }
        }
        return super.checkIfDefinitionIsComplete();
    }

    public OLAPDMLExpression(TypedExpression typedExpression, DataType dataType, MdmPrimaryDimension[] mdmPrimaryDimensionArray) {
        OLAPDMLExpression.validateValue(typedExpression);
        OLAPDMLExpression.validateValue(dataType);
        OLAPDMLExpression.validateValues(mdmPrimaryDimensionArray, 0);
        this.m_OlapDML = typedExpression;
        this.m_SQLDataType = new SQLDataType(dataType);
        this.setDataType(dataType);
        this.m_Dimensions = new BaseMetadataObjectReference[mdmPrimaryDimensionArray.length];
        for (int i = 0; i < mdmPrimaryDimensionArray.length; ++i) {
            this.m_Dimensions[i] = new MetadataObjectReference(mdmPrimaryDimensionArray[i], MdmPrimaryDimension.class);
        }
        this.initialize();
    }

    public OLAPDMLExpression(TypedExpression typedExpression, DataType dataType, List<MdmPrimaryDimension> list) {
        OLAPDMLExpression.validateValue(typedExpression);
        OLAPDMLExpression.validateValue(dataType);
        OLAPDMLExpression.validateValues(list, 0);
        this.m_OlapDML = typedExpression;
        this.m_SQLDataType = new SQLDataType(dataType);
        this.setDataType(dataType);
        this.m_Dimensions = new BaseMetadataObjectReference[list.size()];
        int n = 0;
        for (MdmPrimaryDimension mdmPrimaryDimension : list) {
            this.m_Dimensions[n++] = new MetadataObjectReference(mdmPrimaryDimension, MdmPrimaryDimension.class);
        }
        this.initialize();
    }

    public OLAPDMLExpression(TypedExpression typedExpression, SQLDataType sQLDataType, MdmPrimaryDimension[] mdmPrimaryDimensionArray) {
        OLAPDMLExpression.validateValue(typedExpression);
        OLAPDMLExpression.validateValue(sQLDataType);
        OLAPDMLExpression.validateValues(mdmPrimaryDimensionArray, 0);
        this.m_OlapDML = typedExpression;
        this.m_SQLDataType = sQLDataType;
        this.setDataType(sQLDataType.getDataType());
        this.m_Dimensions = new BaseMetadataObjectReference[mdmPrimaryDimensionArray.length];
        for (int i = 0; i < mdmPrimaryDimensionArray.length; ++i) {
            this.m_Dimensions[i] = new MetadataObjectReference(mdmPrimaryDimensionArray[i], MdmPrimaryDimension.class);
        }
        this.initialize();
    }

    public OLAPDMLExpression(TypedExpression typedExpression, SQLDataType sQLDataType, List<MdmPrimaryDimension> list) {
        OLAPDMLExpression.validateValue(typedExpression);
        OLAPDMLExpression.validateValue(sQLDataType);
        OLAPDMLExpression.validateValues(list, 0);
        this.m_OlapDML = typedExpression;
        this.m_SQLDataType = sQLDataType;
        this.setDataType(sQLDataType.getDataType());
        this.m_Dimensions = new BaseMetadataObjectReference[list.size()];
        int n = 0;
        for (MdmPrimaryDimension mdmPrimaryDimension : list) {
            this.m_Dimensions[n++] = new MetadataObjectReference(mdmPrimaryDimension, MdmPrimaryDimension.class);
        }
        this.initialize();
    }

    public OLAPDMLExpression(ExpParser expParser, TypedExpression typedExpression, SQLDataType sQLDataType, List<BaseMetadataObjectReference> list, List<BaseMetadataObjectReference> list2, List<BaseMetadataObjectReference> list3) {
        BaseMetadataObjectReference[] baseMetadataObjectReferenceArray;
        OLAPDMLExpression.validateValue(typedExpression);
        OLAPDMLExpression.validateValue(sQLDataType);
        if (null != list) {
            OLAPDMLExpression.validateValues(list, 0);
        }
        if (null != list2) {
            OLAPDMLExpression.validateValues(list2, 0);
        }
        if (null != list3) {
            OLAPDMLExpression.validateValues(list3, 0);
        }
        this.m_OlapDML = typedExpression;
        this.m_SQLDataType = sQLDataType;
        this.setDataType(sQLDataType.getDataType());
        if (null == list) {
            this.m_Dimensions = null;
        } else {
            baseMetadataObjectReferenceArray = new BaseMetadataObjectReference[list.size()];
            list.toArray(baseMetadataObjectReferenceArray);
            this.m_Dimensions = baseMetadataObjectReferenceArray;
        }
        if (null == list2) {
            this.m_DenseDimensions = null;
        } else {
            baseMetadataObjectReferenceArray = new BaseMetadataObjectReference[list2.size()];
            list2.toArray(baseMetadataObjectReferenceArray);
            this.m_DenseDimensions = baseMetadataObjectReferenceArray;
        }
        if (null == list3) {
            this.m_LoopByMeasures = null;
        } else {
            baseMetadataObjectReferenceArray = new BaseMetadataObjectReference[list3.size()];
            list3.toArray(baseMetadataObjectReferenceArray);
            this.m_LoopByMeasures = baseMetadataObjectReferenceArray;
        }
        this.initialize();
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitOLAPDMLExpression(this, object);
    }

    public TypedExpression getOlapDML() {
        return this.m_OlapDML;
    }

    public MdmPrimaryDimension[] getDimensions() {
        if (null != this.getDimensionsInternal()) {
            MdmPrimaryDimension[] mdmPrimaryDimensionArray = new MdmPrimaryDimension[this.getDimensionsInternal().length];
            for (int i = 0; i < this.getDimensionsInternal().length; ++i) {
                mdmPrimaryDimensionArray[i] = (MdmPrimaryDimension)this.getDimensionsInternal()[i].getBaseMetadataObject();
            }
            return mdmPrimaryDimensionArray;
        }
        return null;
    }

    public MdmPrimaryDimension[] getDenseDimensions() {
        if (null != this.getDenseDimensionsInternal()) {
            MdmPrimaryDimension[] mdmPrimaryDimensionArray = new MdmPrimaryDimension[this.getDenseDimensionsInternal().length];
            for (int i = 0; i < this.getDenseDimensionsInternal().length; ++i) {
                mdmPrimaryDimensionArray[i] = (MdmPrimaryDimension)this.getDenseDimensionsInternal()[i].getBaseMetadataObject();
            }
            return mdmPrimaryDimensionArray;
        }
        return null;
    }

    public MdmBaseMeasure[] getLoopByMeasures() {
        if (null != this.getLoopByMeasuresInternal()) {
            MdmBaseMeasure[] mdmBaseMeasureArray = new MdmBaseMeasure[this.getLoopByMeasuresInternal().length];
            for (int i = 0; i < this.getLoopByMeasuresInternal().length; ++i) {
                mdmBaseMeasureArray[i] = (MdmBaseMeasure)this.getLoopByMeasuresInternal()[i].getBaseMetadataObject();
            }
            return mdmBaseMeasureArray;
        }
        return null;
    }

    public SQLDataType getSQLDataType() {
        return this.m_SQLDataType;
    }
}

