/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mtm;

import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.mtm.MtmDataType;
import oracle.olapi.metadata.mtm.MtmExpression;
import oracle.olapi.metadata.mtm.MtmXMLTags;

public abstract class MtmValueExpression
extends MtmExpression {
    MtmValueExpression(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
    }

    protected String getColumnDataType() {
        return this.getPropertyStringValue(MtmXMLTags.COLUMN_DATA_TYPE);
    }

    protected int getColumnDataLength() {
        return this.getPropertyIntegerValue(MtmXMLTags.COLUMN_DATA_LENGTH, 0);
    }

    protected int getColumnDataPrecision() {
        return this.getPropertyIntegerValue(MtmXMLTags.COLUMN_DATA_PRECISION, 0);
    }

    protected boolean getColumnIsNullable() {
        return this.getPropertyBooleanValue(MtmXMLTags.COLUMN_IS_NULLABLE);
    }

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        if (MtmXMLTags.COLUMN_DATA_TYPE.matches(string, string2)) {
            return MtmXMLTags.COLUMN_DATA_TYPE;
        }
        if (MtmXMLTags.COLUMN_DATA_LENGTH.matches(string, string2)) {
            return MtmXMLTags.COLUMN_DATA_LENGTH;
        }
        if (MtmXMLTags.COLUMN_DATA_PRECISION.matches(string, string2)) {
            return MtmXMLTags.COLUMN_DATA_PRECISION;
        }
        if (MtmXMLTags.COLUMN_IS_NULLABLE.matches(string, string2)) {
            return MtmXMLTags.COLUMN_IS_NULLABLE;
        }
        return super.getPropertyXMLTag(string, string2);
    }

    private void setColumnDataType(String string) {
        this.setPropertyStringValue(MtmXMLTags.COLUMN_DATA_TYPE, string);
    }

    private void setColumnDataLength(int n) {
        this.setPropertyIntegerValue(MtmXMLTags.COLUMN_DATA_LENGTH, n);
    }

    private void setColumnDataPrecision(int n) {
        this.setPropertyIntegerValue(MtmXMLTags.COLUMN_DATA_PRECISION, n);
    }

    private void setColumnIsNullable(boolean bl) {
        this.setPropertyBooleanValue(MtmXMLTags.COLUMN_IS_NULLABLE, bl);
    }

    public MtmDataType getDataType() {
        return new MtmDataType(this.getColumnDataType(), this.getColumnDataLength(), this.getColumnDataPrecision(), this.getColumnIsNullable());
    }

    public void setDataType(MtmDataType mtmDataType) {
        this.setColumnDataType(mtmDataType.getSqlDataType());
        this.setColumnDataLength(mtmDataType.getSqlDataTypeLength());
        this.setColumnDataPrecision(mtmDataType.getSqlDataTypePrecision());
        this.setColumnIsNullable(mtmDataType.isNullable());
    }
}

