/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mapping;

import java.util.List;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.DuplicateMetadataIDException;
import oracle.olapi.metadata.InvalidMetadataException;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.mapping.CubeDimensionalityMap;
import oracle.olapi.metadata.mapping.MappingXMLTags;
import oracle.olapi.metadata.mapping.MeasureMap;
import oracle.olapi.metadata.mapping.ObjectMap;
import oracle.olapi.metadata.mdm.MdmBaseMeasure;
import oracle.olapi.metadata.mdm.MdmCube;
import oracle.olapi.metadata.mdm.MdmDimensionality;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.syntax.Condition;
import oracle.olapi.syntax.FromClause;
import oracle.olapi.syntax.Query;

public final class CubeMap
extends ObjectMap {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{MappingXMLTags.QUERY, MappingXMLTags.MEASURE_MAPS, MappingXMLTags.CUBE_DIMENSIONALITY_MAPS, MappingXMLTags.IS_SOLVED, MappingXMLTags.AGGREGATION_METHOD, MappingXMLTags.NAME, MappingXMLTags.WHERE_CLAUSE, MappingXMLTags.FROM_CLAUSE};

    CubeMap(MdmMetadataProvider mdmMetadataProvider) {
        super(mdmMetadataProvider);
    }

    public CubeMap(String string, short s, MdmCube mdmCube) {
        this(CubeMap.generateID((BaseMetadataObject)mdmCube, string), string, s, (BaseMetadataObject)mdmCube);
    }

    public CubeMap(String string, String string2, short s, BaseMetadataObject baseMetadataObject) {
        super(baseMetadataObject.getBaseMetadataProvider(), string, s, baseMetadataObject);
        this.setName(string2);
        MdmCube mdmCube = (MdmCube)baseMetadataObject;
        List list = mdmCube.getDimensionality();
        for (MdmDimensionality mdmDimensionality : list) {
            this.findOrCreateCubeDimensionalityMap(mdmDimensionality);
        }
    }

    @Override
    protected XMLTag getXMLTag() {
        return MappingXMLTags.CUBE_MAP_TAG;
    }

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    public void setWhereClause(Condition condition) {
        this.setPropertyObjectValue(MappingXMLTags.WHERE_CLAUSE, condition);
    }

    public Condition getWhereClause() {
        return (Condition)this.getPropertyObjectValue(MappingXMLTags.WHERE_CLAUSE);
    }

    public void setFromClause(FromClause fromClause) {
        this.setPropertyObjectValue(MappingXMLTags.FROM_CLAUSE, fromClause);
    }

    public FromClause getFromClause() {
        return (FromClause)this.getPropertyObjectValue(MappingXMLTags.FROM_CLAUSE);
    }

    public void setQuery(Query query) {
        this.setPropertyObjectValue(MappingXMLTags.QUERY, query);
    }

    public Query getQuery() {
        return (Query)this.getPropertyObjectValue(MappingXMLTags.QUERY);
    }

    public void addMeasureMap(MeasureMap measureMap) {
        this.addToListProperty(MappingXMLTags.MEASURE_MAPS, measureMap);
    }

    public void removeMeasureMap(MeasureMap measureMap) {
        this.removeFromListProperty(MappingXMLTags.MEASURE_MAPS, measureMap);
    }

    public List getMeasureMaps() {
        return this.getPropertyListValues(MappingXMLTags.MEASURE_MAPS);
    }

    public void addDimensionalityMap(CubeDimensionalityMap cubeDimensionalityMap) {
        this.addToListProperty(MappingXMLTags.CUBE_DIMENSIONALITY_MAPS, cubeDimensionalityMap);
    }

    public void removeDimensionalityMap(CubeDimensionalityMap cubeDimensionalityMap) {
        this.removeFromListProperty(MappingXMLTags.CUBE_DIMENSIONALITY_MAPS, cubeDimensionalityMap);
    }

    public List getDimensionalityMaps() {
        return this.getPropertyListValues(MappingXMLTags.CUBE_DIMENSIONALITY_MAPS);
    }

    public MdmCube getCube() {
        return (MdmCube)this.getContainedByObject();
    }

    public boolean getIsSolved() {
        return this.getPropertyBooleanValue(MappingXMLTags.IS_SOLVED);
    }

    public void setIsSolved(boolean bl) {
        this.setPropertyBooleanValue(MappingXMLTags.IS_SOLVED, bl);
    }

    public String getAggregationMethod() {
        return this.getPropertyStringValue(MappingXMLTags.AGGREGATION_METHOD);
    }

    public void setAggregationMethod(String string) {
        this.setPropertyStringValue(MappingXMLTags.AGGREGATION_METHOD, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MeasureMap findOrCreateMeasureMap(MdmBaseMeasure mdmBaseMeasure) {
        MeasureMap measureMap = null;
        String string = mdmBaseMeasure.getName();
        List list = this.getMeasureMaps();
        for (Object object : list) {
            if (((MeasureMap)object).getMeasure() != mdmBaseMeasure) continue;
            measureMap = object;
            break;
        }
        if (null == measureMap) {
            Object object;
            Object object2 = null;
            object = CubeMap.generateID(new String[]{this.getInternalID(), string});
            MdmMetadataProvider mdmMetadataProvider = this.getCube().getMetadataProvider();
            synchronized (mdmMetadataProvider) {
                object2 = this.getCube().getMetadataProvider().fetchMetadataObject((String)object);
                if (null == object2) {
                    measureMap = new MeasureMap(string, mdmBaseMeasure, 0, this);
                    this.addMeasureMap(measureMap);
                    return measureMap;
                }
            }
            if (object2 instanceof MeasureMap) {
                measureMap = (MeasureMap)object2;
                if (mdmBaseMeasure != measureMap.getMeasure()) {
                    throw new InvalidMetadataException(object2.getID());
                }
                this.addMeasureMap(measureMap);
            } else {
                throw new DuplicateMetadataIDException(object2.getID());
            }
        }
        return measureMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CubeDimensionalityMap findOrCreateCubeDimensionalityMap(MdmDimensionality mdmDimensionality) {
        CubeDimensionalityMap cubeDimensionalityMap = null;
        String string = mdmDimensionality.getName();
        List list = this.getDimensionalityMaps();
        for (Object object : list) {
            if (((CubeDimensionalityMap)object).getDimensionality() != mdmDimensionality) continue;
            cubeDimensionalityMap = object;
            break;
        }
        if (null == cubeDimensionalityMap) {
            Object object;
            Object object2 = null;
            object = CubeMap.generateID(new String[]{this.getInternalID(), string});
            MdmMetadataProvider mdmMetadataProvider = this.getCube().getMetadataProvider();
            synchronized (mdmMetadataProvider) {
                object2 = this.getCube().getMetadataProvider().fetchMetadataObject((String)object);
                if (null == object2) {
                    cubeDimensionalityMap = new CubeDimensionalityMap(string, mdmDimensionality, 0, this);
                    this.addDimensionalityMap(cubeDimensionalityMap);
                    return cubeDimensionalityMap;
                }
            }
            if (object2 instanceof CubeDimensionalityMap) {
                cubeDimensionalityMap = (CubeDimensionalityMap)object2;
                if (mdmDimensionality != cubeDimensionalityMap.getDimensionality()) {
                    throw new InvalidMetadataException(object2.getID());
                }
                this.addDimensionalityMap(cubeDimensionalityMap);
            } else {
                throw new DuplicateMetadataIDException(object2.getID());
            }
        }
        return cubeDimensionalityMap;
    }

    @Override
    public final String getName() {
        return this.getPropertyStringValue(MappingXMLTags.NAME);
    }

    public void setName(String string) {
        this.setPropertyStringValue(MappingXMLTags.NAME, string);
    }
}

