/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import oracle.express.idl.reconciliation.TxsOqCursorValueUnion;
import oracle.express.idl.reconciliation.TxsOqDataUnion;
import oracle.express.olapi.data.CursorBlock;
import oracle.express.olapi.data.CursorBlockManager;
import oracle.express.olapi.data.CursorBlockProvider;
import oracle.express.olapi.data.CursorValidationContext;
import oracle.express.olapi.data.ExpressCursor;
import oracle.express.olapi.data.InvalidCursorBlockException;
import oracle.express.olapi.data.full.CursorInputParameter;
import oracle.olapi.data.cursor.NoDataAvailableException;
import oracle.olapi.data.source.Parameter;
import oracle.sql.NUMBER;

public class CursorTreeManager {
    private ExpressCursor[] _idToCursorTable;
    private CursorBlockProvider _cursorBlockProvider;
    private CursorBlock _currentCursorBlock;
    private boolean _valid;
    private Parameter[] _parameters;
    private Set _invalidBlocks;

    public CursorTreeManager(int n, CursorBlockProvider cursorBlockProvider, Parameter[] parameterArray) {
        this._idToCursorTable = new ExpressCursor[n];
        this._cursorBlockProvider = cursorBlockProvider;
        this._currentCursorBlock = null;
        this._parameters = parameterArray;
        this._invalidBlocks = new HashSet();
        this.setInvalid();
    }

    private Set getInvalidBlocks() {
        return this._invalidBlocks;
    }

    private ExpressCursor[] getCursorTable() {
        return this._idToCursorTable;
    }

    public final Parameter[] getParameters() {
        return this._parameters;
    }

    public final void registerCursor(int n, ExpressCursor expressCursor) {
        this.getCursorTable()[n] = expressCursor;
    }

    public final ExpressCursor getCursor(int n) {
        return this.getCursorTable()[n];
    }

    public final int getNumCursors() {
        return this.getCursorTable().length;
    }

    public final boolean isValid() {
        return this._valid;
    }

    public final void setInvalid() {
        this._valid = false;
    }

    private void setValid() {
        this._valid = true;
    }

    public final CursorBlock getCurrentCursorBlock() {
        return this._currentCursorBlock;
    }

    private void setCurrentCursorBlock(CursorBlock cursorBlock) {
        this._currentCursorBlock = cursorBlock;
    }

    public final CursorBlockProvider getCursorBlockProvider() {
        return this._cursorBlockProvider;
    }

    public final CursorBlockManager getCursorBlockManager() {
        return this.getCursorBlockProvider().getCursorBlockManager();
    }

    public final void revalidate() {
        if (this.isValid()) {
            return;
        }
        Set set = this.getInvalidBlocks();
        set.clear();
        if (this.getCurrentCursorBlock() != null) {
            if (this.validateWithBlock(this.getCurrentCursorBlock(), set)) {
                this.setValid();
                return;
            }
            set.add(this.getCurrentCursorBlock());
        }
        CursorBlock cursorBlock = this.getCursorBlockProvider().getCursorBlock(this, set);
        this.setCurrentCursorBlock(cursorBlock);
        this.setValid();
        this.checkEmpty();
    }

    public final boolean validateWithBlock(CursorBlock cursorBlock, Set set) {
        if (set.contains(cursorBlock)) {
            return false;
        }
        if (!cursorBlock.matchesParameterValues(this, this.getParameters())) {
            return false;
        }
        if (cursorBlock.isEmpty()) {
            return true;
        }
        CursorValidationContext cursorValidationContext = new CursorValidationContext(this, cursorBlock);
        for (int i = 0; i < this.getCursorTable().length; ++i) {
            ExpressCursor expressCursor = this.getCursorTable()[i];
            boolean bl = true;
            try {
                bl = expressCursor.validateWithBlock(cursorValidationContext);
            }
            catch (InvalidCursorBlockException invalidCursorBlockException) {
                bl = false;
            }
            if (bl) continue;
            return false;
        }
        cursorValidationContext.commitState();
        return true;
    }

    public static final Object getParameterValueObject(CursorTreeManager cursorTreeManager, Parameter parameter) {
        Object object = null;
        object = parameter instanceof CursorInputParameter && cursorTreeManager != null ? ((CursorInputParameter)parameter).getValueForCursor(cursorTreeManager) : parameter.getValueObject();
        return object;
    }

    public static final TxsOqCursorValueUnion[] getParameterValues(CursorTreeManager cursorTreeManager, Parameter[] parameterArray) {
        if (parameterArray == null) {
            return new TxsOqCursorValueUnion[0];
        }
        TxsOqCursorValueUnion[] txsOqCursorValueUnionArray = new TxsOqCursorValueUnion[parameterArray.length];
        for (int i = 0; i < parameterArray.length; ++i) {
            Object object = CursorTreeManager.getParameterValueObject(cursorTreeManager, parameterArray[i]);
            TxsOqDataUnion txsOqDataUnion = new TxsOqDataUnion();
            if (object instanceof String) {
                txsOqDataUnion.wstringValue((String)object);
            } else if (object instanceof Boolean) {
                txsOqDataUnion.booleanValue((Boolean)object);
            } else if (object instanceof Short) {
                txsOqDataUnion.shortValue((Short)object);
            } else if (object instanceof Integer) {
                txsOqDataUnion.longValue((Integer)object);
            } else if (object instanceof Float) {
                txsOqDataUnion.floatValue(((Float)object).floatValue());
            } else if (object instanceof Double) {
                txsOqDataUnion.doubleValue((Double)object);
            } else if (object instanceof Date) {
                txsOqDataUnion.dateValue((Date)object);
            } else {
                txsOqDataUnion.numberValue((NUMBER)object);
            }
            TxsOqCursorValueUnion txsOqCursorValueUnion = new TxsOqCursorValueUnion();
            txsOqCursorValueUnion.literal(txsOqDataUnion);
            txsOqCursorValueUnionArray[i] = txsOqCursorValueUnion;
        }
        return txsOqCursorValueUnionArray;
    }

    public boolean checkEmpty() {
        boolean bl = this.getCurrentCursorBlock() == null;
        boolean bl2 = false;
        if (!bl) {
            bl2 = this.getCurrentCursorBlock().matchesParameterValues(this, this.getParameters());
        }
        if (!bl && this.getCurrentCursorBlock().isEmpty() && bl2) {
            throw new NoDataAvailableException();
        }
        if (!bl2) {
            this.setInvalid();
        }
        return bl2;
    }
}

