/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.idl.util;

import oracle.express.idl.util.ByteHelper;
import oracle.express.idl.util.IntegerHelper;
import oracle.express.idl.util.InterfaceStub;
import oracle.express.idl.util.OlapiException;
import oracle.express.idl.util.OlapiStreamable;
import oracle.express.idl.util.OlapiTracer;

public class StringHelper {
    private StringHelper() {
    }

    public static String SQL2Java(InterfaceStub interfaceStub, String string) {
        String string2;
        String string3 = string2 = null == string ? "" : string;
        if (OlapiTracer.isTracingEnabled()) {
            OlapiTracer.log("StringHelper.SQL2Java: sqlstring = " + string + ", jstring = " + string2);
        }
        return string2;
    }

    public static String Java2SQL(InterfaceStub interfaceStub, String string) {
        String string2;
        String string3 = string2 = null != string && !string.equals("") ? string : " ";
        if (OlapiTracer.isTracingEnabled()) {
            OlapiTracer.log("StringHelper.Java2SQL: jstring = " + string + ", sqlstring = " + string2);
        }
        return string2;
    }

    public static String SQL2Java(InterfaceStub interfaceStub, OlapiStreamable olapiStreamable) {
        OlapiTracer.enter("StringHelper.SQL2Java");
        String string = null;
        try {
            if (0 != ByteHelper.SQL2Java(interfaceStub, olapiStreamable)) {
                int n = IntegerHelper.SQL2Java(interfaceStub, olapiStreamable);
                if (0 == n) {
                    string = "";
                } else {
                    byte[] byArray = new byte[n];
                    olapiStreamable.read(byArray);
                    string = new String(byArray, "ISO8859_1");
                }
            }
            if (OlapiTracer.isTracingEnabled()) {
                if (null != string) {
                    OlapiTracer.log("jstring.length = " + string.length());
                }
                OlapiTracer.log("jstring = " + string);
            }
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("StringHelper.SQL2Java");
        return string;
    }

    public static void Java2SQL(InterfaceStub interfaceStub, OlapiStreamable olapiStreamable, String string) {
        OlapiTracer.enter("StringHelper.Java2SQL");
        if (OlapiTracer.isTracingEnabled()) {
            if (null != string) {
                OlapiTracer.log("jstring.length = " + string.length());
            }
            OlapiTracer.log("jstring = " + string);
        }
        try {
            if (null == string) {
                ByteHelper.Java2SQL(interfaceStub, olapiStreamable, (byte)0);
            } else {
                ByteHelper.Java2SQL(interfaceStub, olapiStreamable, (byte)1);
                byte[] byArray = string.getBytes("ISO8859_1");
                IntegerHelper.Java2SQL(interfaceStub, olapiStreamable, byArray.length);
                if (0 != byArray.length) {
                    olapiStreamable.write(byArray);
                }
            }
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("StringHelper.Java2SQL");
    }
}

