/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.dependency;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Context;
import oracle.ide.dependency.Declaration;
import oracle.ide.dependency.DeclarationProvider;
import oracle.ide.dependency.DependencyManager;
import oracle.ide.dependency.ProgressIndicator;
import oracle.ide.dependency.Reference;
import oracle.ide.dependency.ReferenceProvider;
import oracle.ide.dependency.Scope;
import oracle.ide.file.ProjectCache;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.Workspace;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.dependency.extension.DeclarationProviderInfo;
import oracle.ideimpl.dependency.extension.DependencyInfo;
import oracle.ideimpl.dependency.extension.ReferenceProviderInfo;
import oracle.javatools.data.PropertyStorage;

public class DependencyManagerImpl
extends DependencyManager {
    private static final ProgressIndicator NULL_PROGRESS_INDICATOR = new ProgressIndicator(){

        @Override
        public void setProgress(int progress) {
        }

        @Override
        public void setProgressText(String text) {
        }

        @Override
        public boolean isCanceled() {
            return false;
        }
    };
    final CopyOnWriteArrayList<DeclarationProvider> declarationProviders = new CopyOnWriteArrayList();
    final CopyOnWriteArrayList<ReferenceProvider> referenceProviders = new CopyOnWriteArrayList();

    static void checkEventThread() {
        if (EventQueue.isDispatchThread() && !IdeUtil.isHeadless()) {
            throw new IllegalArgumentException("Cannot be called on event thread");
        }
    }

    @Override
    public Logger getLogger() {
        return Logger.getLogger(DependencyManager.class.getName());
    }

    @Override
    public Declaration getDeclaration(final Context context) {
        final Result result = DependencyManagerImpl.createResult();
        this.callProviders(this.getDeclarationProviders(), NULL_PROGRESS_INDICATOR, "oracle.ideimpl.dependency.DependencyManagerImpl.getDeclaration", new ProviderTask<DeclarationProvider>(){

            @Override
            public boolean run(DeclarationProvider provider, ProgressIndicator progress) {
                if (provider.canGetDeclaration(context)) {
                    result.setResult(provider.getDeclaration(context));
                    return !result.isSet();
                }
                return true;
            }
        });
        return (Declaration)result.getResult();
    }

    @Override
    public Reference getReference(final Context context) {
        final Result result = DependencyManagerImpl.createResult();
        Project project = context.getProject();
        if (project != null) {
            String[] technologyKeys = this.getTechnologyScopeKeys(context.getWorkspace(), project);
            this.callProviders(this.getReferenceProviders(technologyKeys), NULL_PROGRESS_INDICATOR, "oracle.ideimpl.dependency.DependencyManagerImpl.getReference", new ProviderTask<ReferenceProvider>(){

                @Override
                public boolean run(ReferenceProvider provider, ProgressIndicator progress) {
                    if (provider.canGetReference(context)) {
                        result.setResult(provider.getReference(context));
                    }
                    return !result.isSet();
                }
            });
        }
        return (Reference)result.getResult();
    }

    @Override
    public Collection<Reference> getReferences(final Context context, final Node node) throws InterruptedException {
        DependencyManagerImpl.checkEventThread();
        final HashSet references = new HashSet();
        Project project = context.getProject();
        if (project != null) {
            String[] technologyKeys = this.getTechnologyScopeKeys(context.getWorkspace(), project);
            this.callProviders(this.getReferenceProviders(technologyKeys), NULL_PROGRESS_INDICATOR, "oracle.ideimpl.dependency.DependencyManagerImpl.getReferences", new InterruptibleProviderTask<ReferenceProvider>(){

                @Override
                public boolean run(ReferenceProvider provider, ProgressIndicator progress) throws InterruptedException {
                    Collection<? extends Reference> results;
                    if (provider.canGetReferences(context, node) && (results = provider.getReferences(context, node)) != null) {
                        references.addAll(results);
                    }
                    return true;
                }
            });
        }
        return Collections.unmodifiableCollection(references);
    }

    @Override
    public Collection<Declaration> getDeclarations(final Context context, final Node node) throws InterruptedException {
        DependencyManagerImpl.checkEventThread();
        final HashSet declarations = new HashSet();
        this.callProviders(this.declarationProviders, NULL_PROGRESS_INDICATOR, "oracle.ideimpl.dependency.DependencyManagerImpl.getReferences", new InterruptibleProviderTask<DeclarationProvider>(){

            @Override
            public boolean run(DeclarationProvider provider, ProgressIndicator progress) throws InterruptedException {
                Collection<? extends Declaration> results;
                if (provider.canGetDeclarations(context, node) && (results = provider.getDeclarations(context, node)) != null) {
                    declarations.addAll(results);
                }
                return true;
            }
        });
        return Collections.unmodifiableCollection(declarations);
    }

    @Override
    public Collection<Declaration> getTopLevelDeclarations(final Context context, final Node node) throws InterruptedException {
        DependencyManagerImpl.checkEventThread();
        final HashSet declarations = new HashSet();
        this.callProviders(this.getDeclarationProviders(), NULL_PROGRESS_INDICATOR, "oracle.ideimpl.dependency.DependencyManagerImpl.getReferences", new InterruptibleProviderTask<DeclarationProvider>(){

            @Override
            public boolean run(DeclarationProvider provider, ProgressIndicator progress) throws InterruptedException {
                Collection<? extends Declaration> results;
                if (provider.canGetDeclarations(context, node) && (results = provider.getTopLevelDeclarations(context, node)) != null) {
                    declarations.addAll(results);
                }
                return true;
            }
        });
        return Collections.unmodifiableCollection(declarations);
    }

    @Override
    public Collection<Reference> findReferences(Context context, Scope scope, Declaration declaration) throws InterruptedException {
        return this.findReferences(context, scope, declaration, NULL_PROGRESS_INDICATOR);
    }

    @Override
    public Collection<Reference> findReferences(final Context context, final Scope scope, final Declaration declaration, ProgressIndicator progress) throws InterruptedException {
        DependencyManagerImpl.checkEventThread();
        String[] technologyKeys = this.getTechnologyScopeKeys(context.getWorkspace(), scope);
        final HashSet references = new HashSet();
        this.callProviders(this.getReferenceProviders(technologyKeys), progress, "oracle.ideimpl.dependency.DependencyManagerImpl.findUrlsReferencing", new InterruptibleProviderTask<ReferenceProvider>(){

            @Override
            public boolean run(ReferenceProvider provider, ProgressIndicator progress) throws InterruptedException {
                Collection<? extends Reference> results;
                if (provider.canFindReferences(context, scope, declaration) && (results = provider.findReferences(context, scope, declaration, progress)) != null) {
                    references.addAll(results);
                }
                return true;
            }
        });
        return Collections.unmodifiableCollection(references);
    }

    @Override
    public void addDeclarationProvider(DeclarationProvider provider) {
        this.declarationProviders.add(provider);
    }

    @Override
    public void addReferenceProvider(ReferenceProvider provider) {
        this.referenceProviders.add(provider);
    }

    @Override
    public Collection<DeclarationProvider> getDeclarationProviders() {
        ArrayList<DeclarationProvider> declarationProviders = new ArrayList<DeclarationProvider>(this.declarationProviders);
        DependencyInfo di = DependencyInfo.getInstance();
        for (DeclarationProviderInfo info : di.getDelcarationProviders()) {
            DeclarationProvider provider = info.getDeclarationProvider();
            if (provider == null) continue;
            declarationProviders.add(provider);
        }
        return Collections.unmodifiableCollection(declarationProviders);
    }

    @Override
    public Collection<ReferenceProvider> getReferenceProviders() {
        ArrayList<ReferenceProvider> referenceProviders = new ArrayList<ReferenceProvider>(this.referenceProviders);
        DependencyInfo di = DependencyInfo.getInstance();
        for (ReferenceProviderInfo info : di.getReferenceProviders()) {
            ReferenceProvider provider = info.getReferenceProvider();
            if (provider == null) continue;
            referenceProviders.add(provider);
        }
        return Collections.unmodifiableCollection(referenceProviders);
    }

    @Override
    public Collection<ReferenceProvider> getReferenceProviders(String[] technologyKeys) {
        ArrayList<ReferenceProvider> referenceProviders = new ArrayList<ReferenceProvider>(this.referenceProviders);
        DependencyInfo di = DependencyInfo.getInstance();
        for (ReferenceProviderInfo info : di.getReferenceProviders()) {
            ReferenceProvider provider;
            String[] keys = info.getTechnologyScopeKeys();
            boolean hasTechnology = false;
            if (keys == null || keys.length == 0) {
                hasTechnology = true;
            } else {
                HashSet<String> keySet = new HashSet<String>(Arrays.asList(technologyKeys));
                for (String key : keys) {
                    if (!keySet.contains(key)) continue;
                    hasTechnology = true;
                    break;
                }
            }
            if (!hasTechnology || (provider = info.getReferenceProvider()) == null) continue;
            referenceProviders.add(provider);
        }
        return Collections.unmodifiableCollection(referenceProviders);
    }

    private <T> void callProviders(Collection<T> providers, ProgressIndicator progress, String name, final ProviderTask<T> task) {
        try {
            this.callProviders(providers, progress, name, new InterruptibleProviderTask<T>(){

                @Override
                public boolean run(T provider, ProgressIndicator progress) {
                    return task.run(provider, progress);
                }
            });
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Non-interruptible task threw InterruptedException", e);
        }
    }

    private <T> void callProviders(Collection<T> providers, ProgressIndicator progress, String name, InterruptibleProviderTask<T> task) throws InterruptedException {
        for (T provider : providers) {
            try {
                long start = System.nanoTime();
                boolean result = task.run(provider, progress);
                PerformanceLogger.get().log(name, provider.getClass().getName(), System.nanoTime() - start);
                if (result) continue;
                break;
            }
            catch (RuntimeException e) {
                this.getLogger().log(Level.SEVERE, "Exception in " + provider.getClass().getName(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getTechnologyScopeKeys(Workspace workspace, Scope scope) {
        HashSet<String> technologyKeys = new HashSet<String>();
        if (workspace == null) {
            for (Project project : scope.getProjects()) {
                String[] keys = TechnologyScopeConfiguration.getInstance((PropertyStorage)project).getTechnologyScope().getTechnologyKeys();
                technologyKeys.addAll(Arrays.asList(keys));
            }
        } else {
            try (ProjectCache projectCache = ProjectCache.getInstance((Workspace)workspace);){
                for (Project project : scope.getProjects()) {
                    String[] keys = projectCache.getTechnologyScopeKeys(project);
                    technologyKeys.addAll(Arrays.asList(keys));
                }
            }
        }
        return technologyKeys.toArray(new String[technologyKeys.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getTechnologyScopeKeys(Workspace workspace, Project project) {
        if (workspace == null) {
            return TechnologyScopeConfiguration.getInstance((PropertyStorage)project).getTechnologyScope().getTechnologyKeys();
        }
        try (ProjectCache projectCache = ProjectCache.getInstance((Workspace)workspace);){
            String[] stringArray = projectCache.getTechnologyScopeKeys(project);
            return stringArray;
        }
    }

    private static <T> Result<T> createResult() {
        return new Result();
    }

    private static final class Result<T> {
        private T result;

        private Result() {
        }

        T getResult() {
            return this.result;
        }

        void setResult(T result) {
            this.result = result;
        }

        boolean isSet() {
            return this.result != null;
        }
    }

    private static interface ProviderTask<T> {
        public boolean run(T var1, ProgressIndicator var2);
    }

    private static interface InterruptibleProviderTask<T> {
        public boolean run(T var1, ProgressIndicator var2) throws InterruptedException;
    }
}

