/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicToolTipUI;
import oracle.adfdtinternal.model.dvt.util.help.HelpContext;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.ewt.painter.NullPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.PainterComponent;
import oracle.bali.ewt.painter.WrappingTextPainter;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.TextWrapper;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphTypeAndSubtype;
import oracle.dss.graph.GraphTypeConverter;
import oracle.dss.graph.Subtype;
import oracle.dss.graph.Type;
import oracle.dss.graph.UIGraphType;
import oracle.dss.graph.gui.BasePanel;
import oracle.dss.graph.gui.GraphTypeConverterAdapter;

public class GraphType
extends BasePanel
implements ListSelectionListener,
HelpContext {
    private ResourceBundle rBundle = null;
    private JLabel m_graphTypeLabel;
    Font m_innerFont;
    protected int m_numLinesInName = 2;
    protected JList m_graphTypeList;
    protected MyPainterButton m_subtypeDescriptionLabel;
    protected JPanel m_subtypeDescriptionLabelPanel;
    protected JPanel m_graphSubtypeListPanel;
    protected JPanel m_graphSubtypePanel;
    protected Subtype m_subtype;
    protected Vector m_type;
    protected Vector m_imageButton;
    protected Vector m_innerSubTypePanel;
    protected ButtonGroup m_group;
    protected int m_currentType;
    protected int m_currentSubtype;
    protected JScrollPane m_graphTypeScrollPane;
    protected JScrollPane m_graphSubtypeScrollPane;
    protected String m_toolTip = null;
    protected boolean m_bHelpEnabled = true;
    protected HelpProvider m_helpProvider;
    protected String m_strHelpContextID;
    protected ComponentAdapter m_componentListener;
    protected ItemListener m_itemListener;
    protected CellRenderer m_cellRenderer = null;
    protected KeyStroke m_keyStroke = null;
    public static final String DOUBLE_CLICK = "DoubleClickHappend";
    public static final String SUBTYPE_CHANGED = "SubtypeChanged";
    public static final String TYPE_CHANGED = "TypeChanged";

    public GraphType(Graph graph) {
        super(graph);
        this.updateResourceBundle(graph.getLocale());
        if (this.m_graph.getGraphTypeConverter() == null) {
            GraphTypeConverterAdapter graphTypeConverterAdapter = new GraphTypeConverterAdapter();
            this.m_graph.setGraphTypeConverter((GraphTypeConverter)graphTypeConverterAdapter);
            graphTypeConverterAdapter.setLocale(graph.getLocale());
        }
        this.setTitleText(this.rBundle.getString("create graph type"));
        this.m_mainPanel.setLayout(new BorderLayout(10, 0));
        this._initialiseGraphTypeList();
        this.m_graphTypeScrollPane = new JScrollPane(this.m_graphTypeList);
        Dimension dim = new Dimension(this.m_graphTypeScrollPane.getPreferredSize().width, -1);
        this.m_graphTypeScrollPane.setPreferredSize(dim);
        this.m_graphTypeScrollPane.setMaximumSize(dim);
        this.m_graphTypeScrollPane.setMinimumSize(dim);
        this._initialiseGraphSubtypeListPanel();
        this.m_graphSubtypeScrollPane = new JScrollPane(this.m_graphSubtypeListPanel);
        this.m_graphSubtypeScrollPane.setVerticalScrollBar(new JScrollBar(){

            @Override
            public boolean isFocusTraversable() {
                return false;
            }
        });
        this.m_graphSubtypeScrollPane.setHorizontalScrollBarPolicy(31);
        this.m_subtypeDescriptionLabel = new MyPainterButton((Painter)new MyWrappingTextPainter(WordWrapper.getTextWrapper(), ""));
        this.m_subtypeDescriptionLabelPanel = new JPanel();
        this.m_subtypeDescriptionLabelPanel.setBorder(new TitledBorder(this.rBundle.getString("Description")));
        this.m_subtypeDescriptionLabelPanel.setMinimumSize(new Dimension(this.m_subtypeDescriptionLabelPanel.getMinimumSize().width, 100));
        this.m_subtypeDescriptionLabelPanel.setMaximumSize(new Dimension(this.m_subtypeDescriptionLabelPanel.getMaximumSize().width, 100));
        this.m_subtypeDescriptionLabelPanel.setPreferredSize(new Dimension(this.m_subtypeDescriptionLabelPanel.getPreferredSize().width, 100));
        this.m_subtypeDescriptionLabelPanel.setLayout(new BoxLayout(this.m_subtypeDescriptionLabelPanel, 0));
        this.m_subtypeDescriptionLabel.setMinimumSize(new Dimension(this.m_subtypeDescriptionLabelPanel.getMinimumSize().width, 80));
        this.m_subtypeDescriptionLabel.setMaximumSize(new Dimension(this.m_subtypeDescriptionLabelPanel.getMaximumSize().width, 80));
        this.m_subtypeDescriptionLabel.setPreferredSize(new Dimension(this.m_subtypeDescriptionLabelPanel.getPreferredSize().width, 80));
        this.m_subtypeDescriptionLabelPanel.add((Component)((Object)this.m_subtypeDescriptionLabel));
        this.m_graphSubtypePanel = new JPanel();
        this.m_graphSubtypePanel.setLayout(new BoxLayout(this.m_graphSubtypePanel, 1));
        this.m_graphSubtypePanel.add(this.m_graphSubtypeScrollPane);
        this.m_graphSubtypePanel.add(this.m_subtypeDescriptionLabelPanel);
        this.m_graphSubtypeScrollPane.setAlignmentX(1.0f);
        this.m_subtypeDescriptionLabelPanel.setAlignmentX(1.0f);
        JPanel graphTypePanel = new JPanel();
        graphTypePanel.setLayout(new BorderLayout());
        graphTypePanel.add((Component)this.m_graphTypeScrollPane, "Center");
        String translatedText = this.rBundle.getString("Graph type");
        this.m_graphTypeLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        this.m_graphTypeLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_graphTypeLabel.setLabelFor(this.m_graphTypeList);
        graphTypePanel.add((Component)this.m_graphTypeLabel, "North");
        JPanel graphSubtypePanel = new JPanel();
        graphSubtypePanel.setLayout(new BorderLayout());
        graphSubtypePanel.add((Component)this.m_graphSubtypePanel, "Center");
        translatedText = this.rBundle.getString("Graph sub type");
        JLabel subTypeLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        subTypeLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        graphSubtypePanel.add((Component)subTypeLabel, "North");
        this.m_mainPanel.add((Component)graphTypePanel, "West");
        this.m_mainPanel.add((Component)graphSubtypePanel, "Center");
        this.m_componentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                GraphType.this._adjustScrollBar();
                GraphType.this.m_graphSubtypeListPanel.invalidate();
                GraphType.this.m_graphSubtypeListPanel.validate();
                GraphType.this.m_graphTypeScrollPane.invalidate();
                GraphType.this.m_graphTypeScrollPane.validate();
            }
        };
        this.m_mainPanel.addComponentListener(this.m_componentListener);
        this.refresh();
        this.refreshCurrentType();
    }

    @Override
    public void setGraph(Graph graph) {
        super.setGraph(graph);
        this.refresh();
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.m_mainPanel.removeComponentListener(this.m_componentListener);
        this.m_componentListener = null;
        this.m_graphTypeLabel.setLabelFor(null);
        this.m_cellRenderer.cleanUp();
        this.m_cellRenderer = null;
        this.m_graphTypeScrollPane.setViewportView(null);
        this.m_graphTypeList.removeListSelectionListener(this);
        this.m_graphTypeList.setCellRenderer(null);
        this.m_graphTypeList = null;
        this.m_graphSubtypeListPanel.unregisterKeyboardAction(this.m_keyStroke);
        while (this.m_innerSubTypePanel.size() > 0) {
            JNoTabToggleButton button = (JNoTabToggleButton)this.m_imageButton.elementAt(0);
            this.m_imageButton.removeElementAt(0);
            this.m_group.remove(button);
            button.cleanUp();
            button = null;
            InnerSubTypePanel panel = (InnerSubTypePanel)this.m_innerSubTypePanel.elementAt(0);
            this.m_graphSubtypeListPanel.remove(panel);
            this.m_innerSubTypePanel.removeElementAt(0);
            panel.cleanUp();
            Object var2_2 = null;
        }
        this.m_subtypeDescriptionLabelPanel.remove((Component)((Object)this.m_subtypeDescriptionLabel));
        this.m_subtypeDescriptionLabel.cleanUp();
        this.m_subtypeDescriptionLabel = null;
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
    }

    private void _setupSubtype() {
        this.m_subtype = (Subtype)((Type)this.m_type.elementAt((int)this.m_currentType)).subtypes.elementAt(this.m_currentSubtype);
        this.m_subtypeDescriptionLabel.setText(this.m_subtype.description);
        this.m_toolTip = this.m_subtype.description;
        this._adjustScrollBar();
    }

    private void _initialiseGraphTypeList() {
        this.m_type = (Vector)this.m_graph.getGraphTypeConverter().getTypes().clone();
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < this.m_type.size(); ++i) {
            v.addElement(((Type)this.m_type.elementAt((int)i)).name);
        }
        this.m_graphTypeList = new JList();
        this.m_graphTypeList.setName("GraphType");
        this.m_graphTypeList.setSelectionMode(0);
        this.m_graphTypeList.setListData(v);
        this.m_graphTypeList.setFixedCellHeight(this._getImageIcon("images/S_BAR_VERT_CLUST.gif").getIconHeight() + 5);
        this.m_cellRenderer = new CellRenderer();
        this.m_graphTypeList.setCellRenderer(this.m_cellRenderer);
    }

    private void _initialiseGraphSubtypeListPanel() {
        int i;
        this.m_graphSubtypeListPanel = new JPanel();
        this.m_keyStroke = KeyStroke.getKeyStroke(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Graph sub type")), 8);
        this.m_graphSubtypeListPanel.registerKeyboardAction(new GraphSubtypeKeyListener(), this.m_keyStroke, 2);
        this.m_graphSubtypeListPanel.setBackground(Color.white);
        this.m_graphSubtypeListPanel.setLayout(new FlowLayout(0));
        this.m_graphSubtypeListPanel.setBorder(new BevelBorder(1));
        int maxPanels = ((Type)this.m_type.elementAt((int)0)).subtypes.size();
        for (i = 1; i < this.m_type.size(); ++i) {
            if (((Type)this.m_type.elementAt((int)i)).subtypes.size() <= maxPanels) continue;
            maxPanels = ((Type)this.m_type.elementAt((int)i)).subtypes.size();
        }
        this.m_imageButton = new Vector();
        this.m_group = new ButtonGroup();
        this.m_innerSubTypePanel = new Vector();
        for (i = 0; i < maxPanels; ++i) {
            this.m_imageButton.addElement(new JNoTabToggleButton());
            this.m_group.add((JNoTabToggleButton)this.m_imageButton.elementAt(i));
            this.m_innerSubTypePanel.addElement(new InnerSubTypePanel((JNoTabToggleButton)this.m_imageButton.elementAt(i)));
        }
        InnerSubTypePanel tempPanel = (InnerSubTypePanel)this.m_innerSubTypePanel.elementAt(0);
        this.m_innerFont = tempPanel.getLabelFont();
    }

    private ImageIcon _getImageIcon(String imageName) {
        return new ImageIcon(ImageUtils.getImageResource(GraphType.class, (String)imageName));
    }

    private void _adjustScrollBar() {
        int noOfSubtypes = ((Type)this.m_type.elementAt((int)this.m_currentType)).subtypes.size();
        int height = (((FlowLayout)this.m_graphSubtypeListPanel.getLayout()).getVgap() + ((InnerSubTypePanel)this.m_innerSubTypePanel.elementAt(0)).getHeight()) * noOfSubtypes;
        int width = this.m_graphSubtypeScrollPane.getViewport().getWidth();
        int widthOfItem = ((InnerSubTypePanel)this.m_innerSubTypePanel.elementAt(0)).getWidth();
        int heightOfItem = ((InnerSubTypePanel)this.m_innerSubTypePanel.elementAt(0)).getHeight();
        int itemsInRow = 1;
        int gapWidth = ((FlowLayout)this.m_graphSubtypeListPanel.getLayout()).getHgap();
        if (widthOfItem != 0) {
            itemsInRow = (int)Math.floor((width - gapWidth + 1) / (widthOfItem + gapWidth));
        }
        if (itemsInRow != 0) {
            height = (((FlowLayout)this.m_graphSubtypeListPanel.getLayout()).getVgap() + ((InnerSubTypePanel)this.m_innerSubTypePanel.elementAt(0)).getHeight()) * (int)Math.ceil((double)noOfSubtypes / (double)itemsInRow);
        }
        this.m_graphSubtypeListPanel.setPreferredSize(new Dimension(width, height));
        this.m_graphSubtypeScrollPane.invalidate();
        this.m_graphSubtypeScrollPane.validate();
        int y = 0;
        y = itemsInRow != 0 ? (((FlowLayout)this.m_graphSubtypeListPanel.getLayout()).getVgap() + ((InnerSubTypePanel)this.m_innerSubTypePanel.elementAt(0)).getHeight()) * (int)Math.floor(this.m_currentSubtype / itemsInRow) : ((FlowLayout)this.m_graphSubtypeListPanel.getLayout()).getVgap();
        if (this.m_graphSubtypeScrollPane.getVerticalScrollBar() != null) {
            this.m_graphSubtypeScrollPane.getVerticalScrollBar().setValue(y);
        }
    }

    public int getCurrentType() {
        return this.m_currentType;
    }

    public int getCurrentSubtype() {
        return this.m_currentSubtype;
    }

    public void refresh() {
        if (this.m_graph.getGraphTypeConverter() == null) {
            GraphTypeConverterAdapter graphTypeConverterAdapter = new GraphTypeConverterAdapter();
            this.m_graph.setGraphTypeConverter((GraphTypeConverter)graphTypeConverterAdapter);
            graphTypeConverterAdapter.setLocale(this.m_graph.getLocale());
        }
        this.m_graphTypeList.removeListSelectionListener(this);
        this.m_graphTypeList.clearSelection();
        this.m_type = (Vector)this.m_graph.getGraphTypeConverter().getTypes().clone();
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < this.m_type.size(); ++i) {
            v.addElement(((Type)this.m_type.elementAt((int)i)).name);
        }
        this.m_graphTypeList.setListData(v);
        this.m_graphTypeList.addListSelectionListener(this);
        this.m_currentType = this.getTypeIndex(this.m_graph.getGraphTypeConverter().getTypeAndSubtype((UIGraphType)this.m_graph).type);
        this.m_currentSubtype = this.getSubtypeIndex(this.m_currentType, this.m_graph.getGraphTypeConverter().getTypeAndSubtype((UIGraphType)this.m_graph).subtype);
        this.m_graphTypeList.setSelectedIndex(this.m_currentType);
        this._setupSubtype();
        this.repaint();
    }

    protected int getTypeIndex(int typeID) {
        int length = this.m_type.size();
        for (int i = 0; i < length; ++i) {
            Type type = (Type)this.m_type.elementAt(i);
            if (typeID != type.id) continue;
            return i;
        }
        return 0;
    }

    protected int getSubtypeIndex(int typeIndex, int subtypeID) {
        Type type = (Type)this.m_type.elementAt(typeIndex);
        int length = type.subtypes.size();
        for (int i = 0; i < length; ++i) {
            Subtype subtype = (Subtype)type.subtypes.elementAt(i);
            if (subtypeID != subtype.id) continue;
            return i;
        }
        return 0;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.m_graphTypeList) {
            this.refreshCurrentType();
        }
    }

    protected void refreshCurrentType() {
        Subtype stype;
        Type type;
        int i;
        boolean toggleIndex = false;
        int oldType = 0;
        this.m_graphSubtypeListPanel.removeAll();
        while (this.m_innerSubTypePanel.size() > 0) {
            JNoTabToggleButton button = (JNoTabToggleButton)this.m_imageButton.elementAt(0);
            this.m_imageButton.removeElementAt(0);
            this.m_group.remove(button);
            InnerSubTypePanel panel = (InnerSubTypePanel)this.m_innerSubTypePanel.elementAt(0);
            this.m_graphSubtypeListPanel.remove(panel);
            this.m_innerSubTypePanel.removeElementAt(0);
        }
        oldType = this.m_currentType;
        int oldSubtype = this.m_currentSubtype;
        this.m_currentType = this.m_graphTypeList.getSelectedIndex();
        if (this.m_currentType == -1) {
            this.m_currentType = oldType;
            this.m_graphTypeList.setSelectedIndex(this.m_currentType);
        } else if (this.m_currentType != oldType) {
            this.m_currentSubtype = 0;
        }
        if (oldType != this.m_currentType) {
            this.firePropertyChange(TYPE_CHANGED, oldType, this.m_currentType);
        }
        if (oldSubtype != this.m_currentSubtype) {
            this.firePropertyChange(SUBTYPE_CHANGED, oldSubtype, this.m_currentSubtype);
        }
        Type currType = (Type)this.m_type.elementAt(this.m_currentType);
        int noOfSubtypes = ((Type)this.m_type.elementAt((int)this.m_currentType)).subtypes.size();
        if (noOfSubtypes > this.m_innerSubTypePanel.size()) {
            for (int i2 = this.m_innerSubTypePanel.size(); i2 < noOfSubtypes; ++i2) {
                this.m_imageButton.addElement(new JNoTabToggleButton());
                this.m_group.add((JNoTabToggleButton)this.m_imageButton.elementAt(i2));
                this.m_innerSubTypePanel.addElement(new InnerSubTypePanel((JNoTabToggleButton)this.m_imageButton.elementAt(i2)));
            }
        }
        this.m_numLinesInName = 0;
        int currentCount = 0;
        for (i = 0; i < noOfSubtypes; ++i) {
            type = (Type)this.m_type.elementAt(this.m_currentType);
            stype = (Subtype)type.subtypes.elementAt(i);
            InnerSubTypePanel innerStp = (InnerSubTypePanel)this.m_innerSubTypePanel.elementAt(i);
            innerStp.updatePanel(stype);
            this.m_graphSubtypeListPanel.add(innerStp);
            ImageIcon icon = this._getImageIcon(stype.non_3D_fileName);
            currentCount = innerStp.getLineCount(icon);
            if (currentCount <= this.m_numLinesInName) continue;
            this.m_numLinesInName = currentCount;
        }
        for (i = 0; i < noOfSubtypes; ++i) {
            type = (Type)this.m_type.elementAt(this.m_currentType);
            stype = (Subtype)type.subtypes.elementAt(i);
            InnerSubTypePanel innerStp = (InnerSubTypePanel)this.m_innerSubTypePanel.elementAt(i);
            innerStp.resizeInnerSubtypePanel(stype);
        }
        this._setupSubtype();
        if (this.m_graphSubtypeScrollPane.getVerticalScrollBar() != null) {
            this.m_graphSubtypeScrollPane.getVerticalScrollBar().setValue(0);
        }
        if (this.m_graphSubtypeScrollPane.getHorizontalScrollBar() != null) {
            this.m_graphSubtypeScrollPane.getHorizontalScrollBar().setValue(0);
        }
        if (!((JNoTabToggleButton)this.m_imageButton.elementAt(this.m_currentSubtype)).isSelected()) {
            ((JNoTabToggleButton)this.m_imageButton.elementAt(this.m_currentSubtype)).doClick();
        }
        this.repaint();
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        this.updateResourceBundle(loc);
    }

    @Override
    public void apply() {
        Type type = (Type)this.m_type.elementAt(this.m_currentType);
        int typeID = type.id;
        int subtypeID = ((Subtype)type.subtypes.elementAt((int)this.m_currentSubtype)).id;
        this.m_graph.getGraphTypeConverter().setTypeAndSubtype((UIGraphType)this.m_graph, new GraphTypeAndSubtype(typeID, subtypeID));
    }

    @Override
    public Dimension getPreferredSize() {
        int width = Integer.parseInt(this.rBundle.getString("GraphTypePanelWidth"));
        int height = Integer.parseInt(this.rBundle.getString("GraphTypePanelHeight"));
        return new Dimension(width, height);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public String getHelpContextID() {
        return this.getClass().getName();
    }

    @Override
    public void setHelpContextID(String strHelpContextID) {
        this.m_strHelpContextID = strHelpContextID;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public void setHelpEnabled(boolean bValue) {
        this.m_bHelpEnabled = bValue;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    class CellRenderer
    extends JLabel
    implements ListCellRenderer {
        protected Color highlightColor = new Color(0, 0, 128);

        public CellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = value.toString();
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            this.setIcon(GraphType.this._getImageIcon(((Type)GraphType.this.m_type.elementAt((int)index)).fileName));
            this.setText(s);
            this.setToolTipText(s + " " + GraphType.this.rBundle.getString("graph"));
            if (isSelected) {
                this.setBackground(this.highlightColor);
                this.setForeground(Color.white);
            } else {
                this.setBackground(Color.white);
                this.setForeground(Color.black);
            }
            return this;
        }

        public void cleanUp() {
            this.setIcon(null);
        }
    }

    class MyPainterButton
    extends PainterComponent {
        Painter _painter;

        public MyPainterButton(Painter painter) {
            super(painter);
            this._painter = painter;
            this.setAlignmentX(0.0f);
            this.setAlignmentY(0.0f);
        }

        public void setText(String str) {
            ((MyWrappingTextPainter)this._painter).setText(str);
            this.setPainter(this._painter);
            this.repaint();
            this.validate();
        }

        public void updateUI() {
        }

        public JToolTip createToolTip() {
            MultiLineToolTip tip = new MultiLineToolTip();
            tip.setComponent((JComponent)((Object)this));
            return tip;
        }

        public void cleanUp() {
            this.setPainter((Painter)new NullPainter());
            this._painter = null;
        }
    }

    class MyWrappingTextPainter
    extends WrappingTextPainter {
        String text;

        public MyWrappingTextPainter(TextWrapper wrapper, String str) {
            super(wrapper);
            this.text = "";
        }

        public void setText(String str) {
            this.text = new String(str);
        }

        protected String getStringData(PaintContext context) {
            return new String(this.text);
        }

        protected int paintText(PaintContext context, Graphics g, FontMetrics metrics, String text, int x, int y, int availableWidth, float alignmentX, int mnemonicIndex) {
            if (text.endsWith("...")) {
                StringBuilder stringBuffer = new StringBuilder(GraphType.this.m_toolTip);
                int length = stringBuffer.length();
                int offset = 20;
                int line = 1;
                while (offset < length) {
                    int tmp;
                    for (tmp = offset + line - 1; tmp < length && stringBuffer.charAt(tmp) != ' '; ++tmp) {
                    }
                    if (tmp < length) {
                        stringBuffer = stringBuffer.insert(tmp, '\n');
                    }
                    ++line;
                    offset = tmp + 20;
                }
                GraphType.this.m_subtypeDescriptionLabel.setToolTipText(stringBuffer.toString());
            } else {
                GraphType.this.m_subtypeDescriptionLabel.setToolTipText(null);
            }
            return super.paintText(context, g, metrics, text, x, y, availableWidth, alignmentX, mnemonicIndex);
        }
    }

    class JNoTabToggleButton
    extends JToggleButton {
        protected boolean m_focusTraversable = false;

        JNoTabToggleButton() {
        }

        @Override
        public boolean isFocusTraversable() {
            return this.m_focusTraversable;
        }

        public void setFocusTraversable(boolean bValue) {
            this.m_focusTraversable = bValue;
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleJNoTabToggleButton();
            }
            return this.accessibleContext;
        }

        public void cleanUp() {
            this.accessibleContext = null;
        }

        protected class AccessibleJNoTabToggleButton
        extends JToggleButton.AccessibleJToggleButton {
            protected AccessibleJNoTabToggleButton() {
                super(JNoTabToggleButton.this);
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.UNKNOWN;
            }
        }
    }

    class InnerSubTypePanel
    extends JPanel
    implements ItemListener {
        protected MultiLineLabel label;
        protected JNoTabToggleButton toggleButton;
        protected JPanel bottomPanel = new JPanel();
        protected JPanel buttonPanel = new JPanel();
        protected Color highlightColor = new Color(0, 0, 128);
        protected Color oldBackgroundColor;
        protected Color oldForegroundColor;
        protected InnerMouseAdapter mouse = null;
        protected InnerKeyAdapter keyAdapter = null;

        public InnerSubTypePanel(JNoTabToggleButton button) {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.setBackground(Color.white);
            this.bottomPanel.setBackground(Color.white);
            this.toggleButton = button;
            this.toggleButton.setBackground(Color.white);
            this.toggleButton.setBorder(UIManager.getBorder("Label.border"));
            this.buttonPanel.setLayout(new BorderLayout());
            this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
            this.buttonPanel.setBackground(Color.white);
            this.buttonPanel.add(this.toggleButton);
            this.label = new NoTabMultiLineLabel();
            this.label.setTextWrapper(WordWrapper.getTextWrapper());
            this.label.setAlignment(3);
            this.oldBackgroundColor = this.getBackground();
            this.oldForegroundColor = this.label.getForeground();
            this.add((Component)this.buttonPanel, "North");
            this.add((Component)this.label, "Center");
            this.add((Component)this.bottomPanel, "South");
            this.toggleButton.addItemListener(this);
            this.mouse = new InnerMouseAdapter();
            this.addMouseListener(this.mouse);
            this.toggleButton.addMouseListener(this.mouse);
            this.keyAdapter = new InnerKeyAdapter();
            this.addKeyListener(this.keyAdapter);
            this.toggleButton.addKeyListener(this.keyAdapter);
        }

        @Override
        public int getHeight() {
            int height = this.toggleButton.getIcon().getIconHeight();
            height += GraphType.this.m_numLinesInName * this.getToolkit().getFontMetrics(this.label.getFont()).getHeight() + 5 + 6;
            return height += 5;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == this.toggleButton) {
                if (e.getStateChange() == 1) {
                    this.setBackground(this.highlightColor);
                    this.buttonPanel.setBackground(this.highlightColor);
                    this.bottomPanel.setBackground(Color.white);
                    this.label.setForeground(Color.white);
                    this.toggleButton.setFocusTraversable(true);
                    for (int i = 0; i < GraphType.this.m_imageButton.size(); ++i) {
                        if (!((JNoTabToggleButton)GraphType.this.m_imageButton.elementAt(i)).isSelected()) continue;
                        int oldSubtype = GraphType.this.m_currentSubtype;
                        GraphType.this.m_currentSubtype = i;
                        Type currType = (Type)GraphType.this.m_type.elementAt(GraphType.this.m_currentType);
                        int subtypeID = ((Subtype)currType.subtypes.elementAt((int)GraphType.this.m_currentSubtype)).id;
                        GraphType.this.firePropertyChange(GraphType.SUBTYPE_CHANGED, oldSubtype, GraphType.this.m_currentSubtype);
                        break;
                    }
                    GraphType.this._setupSubtype();
                } else {
                    this.setBackground(this.oldBackgroundColor);
                    this.buttonPanel.setBackground(this.oldBackgroundColor);
                    this.label.setForeground(this.oldForegroundColor);
                    this.toggleButton.setFocusTraversable(false);
                }
            }
        }

        public void doSelect() {
            this.toggleButton.requestFocus();
            this.toggleButton.setSelected(true);
            this.setBackground(this.highlightColor);
            this.buttonPanel.setBackground(this.highlightColor);
            this.label.setForeground(Color.white);
            this.bottomPanel.setBackground(Color.white);
            this.scrollRectToVisible(new Rectangle(0, 0, this.getSize().width, this.getSize().height));
        }

        public void updatePanel(Subtype subtype) {
            boolean iHeight = false;
            ImageIcon icon = GraphType.this._getImageIcon(subtype.non_3D_fileName);
            Dimension d = new Dimension(icon.getIconWidth() + 5, icon.getIconHeight() + 6);
            this.toggleButton.setIcon(icon);
            this.toggleButton.setMinimumSize(d);
            this.toggleButton.setMaximumSize(d);
            this.toggleButton.setPreferredSize(d);
            this.toggleButton.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)GraphType.this.rBundle.getString("Graph sub type")) + subtype.name + GraphType.this.rBundle.getString("Description") + subtype.description);
            this.label.setText(subtype.name);
            this.setToolTipText(subtype.name + " " + GraphType.this.rBundle.getString("graph"));
            this.getAccessibleContext().setAccessibleName(this.toggleButton.getAccessibleContext().getAccessibleName());
            this.toggleButton.setToolTipText(subtype.name + " " + GraphType.this.rBundle.getString("graph"));
        }

        public int getLineCount(ImageIcon icon) {
            String text = this.label.getText();
            int lineMaxWidth = icon.getIconWidth() + 20;
            int currentIndex = 0;
            int lastIndex = text.length();
            int lineCount = 1;
            Object lineStr = "";
            String currentWord = null;
            while (currentIndex < lastIndex) {
                int wordIndex = text.indexOf(32, currentIndex);
                if (wordIndex == -1 && currentIndex == 0) {
                    lineCount = 1;
                    break;
                }
                if (wordIndex == -1) {
                    currentWord = text.substring(currentIndex - 1, lastIndex);
                    wordIndex = lastIndex;
                } else {
                    currentWord = currentIndex > 0 ? text.substring(currentIndex - 1, wordIndex) : text.substring(currentIndex, wordIndex);
                }
                lineStr = (String)lineStr + currentWord;
                FontMetrics fm = this.getToolkit().getFontMetrics(this.label.getFont());
                int width = fm.stringWidth((String)lineStr);
                if (width > lineMaxWidth) {
                    ++lineCount;
                    lineStr = currentWord.substring(1, currentWord.length());
                }
                currentIndex = wordIndex + 1;
            }
            return lineCount;
        }

        public void resizeInnerSubtypePanel(Subtype subtype) {
            int iHeight = 0;
            ImageIcon icon = GraphType.this._getImageIcon(subtype.non_3D_fileName);
            int iLineCount = this.getLineCount(icon);
            FontMetrics fm = this.getToolkit().getFontMetrics(this.label.getFont());
            int fontHeight = fm.getHeight();
            iHeight = (GraphType.this.m_numLinesInName - iLineCount) * fontHeight;
            Dimension d1 = new Dimension(icon.getIconWidth() + 20, iHeight);
            this.bottomPanel.setMinimumSize(d1);
            this.bottomPanel.setMaximumSize(d1);
            this.bottomPanel.setPreferredSize(d1);
            Dimension d = new Dimension(icon.getIconWidth() + 20, this.getHeight());
            this.setMinimumSize(d);
            this.setMaximumSize(d);
            this.setPreferredSize(d);
        }

        public void cleanUp() {
            this.remove((Component)this.label);
            this.label = null;
            this.toggleButton.setIcon(null);
            this.toggleButton.removeItemListener(this);
            this.removeKeyListener(this.keyAdapter);
            this.toggleButton.removeKeyListener(this.keyAdapter);
            this.keyAdapter = null;
            this.toggleButton.removeMouseListener(this.mouse);
            this.removeMouseListener(this.mouse);
            this.mouse = null;
            this.buttonPanel.remove(this.toggleButton);
            this.toggleButton.cleanUp();
            this.toggleButton = null;
        }

        public Font getLabelFont() {
            return this.label.getFont();
        }

        class InnerMouseAdapter
        extends MouseAdapter {
            InnerMouseAdapter() {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                InnerSubTypePanel.this.doSelect();
                ((InnerSubTypePanel)GraphType.this.m_innerSubTypePanel.elementAt(GraphType.this.m_currentSubtype)).requestFocus();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    GraphType.this.firePropertyChange(GraphType.DOUBLE_CLICK, false, true);
                }
            }
        }

        class InnerKeyAdapter
        extends KeyAdapter {
            InnerKeyAdapter() {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                int noOfSubtypes;
                if (e.getKeyCode() == 37 || e.getKeyCode() == 38) {
                    if (GraphType.this.m_currentSubtype > 0) {
                        --GraphType.this.m_currentSubtype;
                        ((InnerSubTypePanel)GraphType.this.m_innerSubTypePanel.elementAt(GraphType.this.m_currentSubtype)).doSelect();
                        GraphType.this.firePropertyChange(GraphType.SUBTYPE_CHANGED, GraphType.this.m_currentSubtype + 1, GraphType.this.m_currentSubtype);
                        ((InnerSubTypePanel)GraphType.this.m_innerSubTypePanel.elementAt(GraphType.this.m_currentSubtype)).requestFocus();
                    }
                } else if ((e.getKeyCode() == 39 || e.getKeyCode() == 40) && GraphType.this.m_currentSubtype < (noOfSubtypes = ((Type)GraphType.this.m_type.elementAt((int)GraphType.this.m_currentType)).subtypes.size()) - 1) {
                    ++GraphType.this.m_currentSubtype;
                    ((InnerSubTypePanel)GraphType.this.m_innerSubTypePanel.elementAt(GraphType.this.m_currentSubtype)).doSelect();
                    GraphType.this.firePropertyChange(GraphType.SUBTYPE_CHANGED, GraphType.this.m_currentSubtype - 1, GraphType.this.m_currentSubtype);
                    ((InnerSubTypePanel)GraphType.this.m_innerSubTypePanel.elementAt(GraphType.this.m_currentSubtype)).requestFocus();
                }
            }
        }
    }

    class GraphSubtypeKeyListener
    implements ActionListener {
        GraphSubtypeKeyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((InnerSubTypePanel)GraphType.this.m_innerSubTypePanel.elementAt(GraphType.this.m_currentSubtype)).doSelect();
        }
    }

    class MultiLineToolTip
    extends JToolTip {
        MultiLineToolTip() {
            if (!(UIManager.getLookAndFeel() instanceof OracleLookAndFeel)) {
                this.setUI(new MultiLineToolTipUI());
            }
        }
    }

    class MultiLineToolTipUI
    extends BasicToolTipUI {
        private String[] strs;
        private int maxWidth = 0;

        MultiLineToolTipUI() {
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            FontMetrics metrics = GraphType.this.getToolkit().getFontMetrics(g.getFont());
            Dimension size = c.getSize();
            g.setColor(c.getBackground());
            g.fillRect(0, 0, size.width, size.height);
            g.setColor(c.getForeground());
            if (this.strs != null) {
                for (int i = 0; i < this.strs.length; ++i) {
                    g.drawString(this.strs[i], 3, metrics.getHeight() * (i + 1));
                }
            }
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            FontMetrics metrics = GraphType.this.getToolkit().getFontMetrics(c.getFont());
            String tipText = ((JToolTip)c).getTipText();
            if (tipText == null) {
                tipText = "";
            }
            BufferedReader br = new BufferedReader(new StringReader(tipText));
            int maxWidth = 0;
            Vector<String> v = new Vector<String>();
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    int width = SwingUtilities.computeStringWidth(metrics, line);
                    maxWidth = maxWidth < width ? width : maxWidth;
                    v.addElement(line);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            int lines = v.size();
            if (lines < 1) {
                this.strs = null;
                lines = 1;
            } else {
                this.strs = new String[lines];
                int i = 0;
                Enumeration e = v.elements();
                while (e.hasMoreElements()) {
                    this.strs[i] = (String)e.nextElement();
                    ++i;
                }
            }
            int height = metrics.getHeight() * lines;
            this.maxWidth = maxWidth;
            return new Dimension(maxWidth + 6, height + 4);
        }
    }

    class NoTabMultiLineLabel
    extends MultiLineLabel {
        NoTabMultiLineLabel() {
        }

        public boolean isFocusTraversable() {
            return false;
        }
    }
}

