/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.util.gui.layout;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import oracle.adfdtinternal.model.dvt.util.gui.layout.Layout;
import oracle.adfdtinternal.model.dvt.util.gui.layout.LayoutComponent;
import oracle.bali.ewt.dnd.DragGestureEvent;
import oracle.bali.ewt.dnd.DragGestureListener;
import oracle.bali.ewt.dnd.DragGestureRecognizer;
import oracle.bali.ewt.dnd.DragSource;
import oracle.bali.ewt.dnd.DragSourceDragEvent;
import oracle.bali.ewt.dnd.DragSourceDropEvent;
import oracle.bali.ewt.dnd.DragSourceEvent;
import oracle.bali.ewt.dnd.DragSourceListener;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.dnd.DropTargetDropEvent;
import oracle.bali.ewt.dnd.DropTargetEvent;
import oracle.bali.ewt.dnd.DropTargetListener;
import oracle.bali.ewt.elaf.EWTPivotHeaderUI;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderSelectionManager;
import oracle.bali.ewt.model.AbstractTwoDModel;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.NumericOneDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.pivot.PivotEvent;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotListener;
import oracle.bali.ewt.pivot.PivotTransfer;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.share.datatransfer.TransferUtils;
import oracle.bali.share.event.ListenerManager;

public class LayoutSpreadTable
extends SpreadTable
implements LayoutComponent {
    private final int _DROP_FEEDBACK_SIZE = 4;
    private final int _PIVOT_SIZE = 10;
    private final int _ROW_HEADER_WIDTH = 25;
    private ColumnDS _columnHeaderDS = new ColumnDS();
    private EmptyDS _gridDS = new EmptyDS();
    private NumericOneDModel _rowHeaderDS = new NumericOneDModel(0);
    private TableDragDropAdapter _dragDrop;
    private Layout.PopupManager _popupManager;
    private int m_edge;
    int _dragIndex = -1;
    int _dropIndex = -1;
    private ListenerManager _pivotListeners;
    private boolean _ignoreReshape;
    private boolean _swapping;
    private Layout m_layout;
    private ComponentListener _componentListener;

    public LayoutSpreadTable() {
        this.setModels((TwoDModel)this._gridDS, (OneDModel)this._columnHeaderDS, (OneDModel)this._rowHeaderDS);
        this.setRowHeaderWidth(25);
        this._dragDrop = new TableDragDropAdapter(this);
        this.getGrid().setPreferredColumnsOnScreen(5);
        this._componentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                LayoutSpreadTable.this._setSizes();
            }
        };
        this.addComponentListener(this._componentListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setItems(String[] items) {
        this.freezeRepaints();
        this.getColumnHeader().freezeRepaints();
        this.getGrid().freezeRepaints();
        try {
            int oldCount = this._columnHeaderDS.getItemCount();
            this._columnHeaderDS.removeItems(0, oldCount);
            this._columnHeaderDS.addItems(0, items);
            int count = items == null ? 0 : items.length;
            this._gridDS.setColumnCount(count);
            this._setSizes();
        }
        finally {
            this.unfreezeRepaints();
            this.getColumnHeader().unfreezeRepaints();
            this.getGrid().unfreezeRepaints();
        }
        this.invalidate();
        this.getGrid().invalidate();
        this.getColumnHeader().invalidate();
    }

    public String getItem(int index) {
        return this._columnHeaderDS.getElement(index);
    }

    @Override
    public String[] getItems() {
        String[] items = new String[this._columnHeaderDS.getItemCount()];
        for (int i = 0; i < this._columnHeaderDS.getItemCount(); ++i) {
            items[i] = this.getItem(i);
        }
        return items;
    }

    @Override
    public int getEdge() {
        return this.m_edge;
    }

    @Override
    public void setEdge(int edge) {
        this.m_edge = edge;
    }

    public int getSelectedIndex() {
        Header h = this.getColumnHeader();
        return h.getSelection().getSingleItem();
    }

    public void clearSelection() {
        Header h = this.getColumnHeader();
        try {
            h.deselectAll();
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void setPopupManager(Layout.PopupManager popupManager) {
        this._popupManager = popupManager;
    }

    public synchronized void addPivotListener(PivotListener listener) {
        if (this._pivotListeners == null) {
            this._pivotListeners = new ListenerManager();
        }
        this._pivotListeners.addListener((EventListener)listener);
    }

    public synchronized void removePivotListener(PivotListener listener) {
        if (this._pivotListeners != null) {
            this._pivotListeners.removeListener((EventListener)listener);
        }
    }

    public void cleanup() {
        this.removeComponentListener(this._componentListener);
        this.setModels(null, null, null);
        this._dragDrop.cleanup();
        this._columnHeaderDS = null;
        this._gridDS = null;
        this._rowHeaderDS = null;
        this._pivotListeners = null;
        this._dragDrop = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBounds(int x, int y, int width, int height) {
        int oldHeight = this.getHeight();
        super.setBounds(x, y, width, height);
        if (this._ignoreReshape) {
            return;
        }
        height = this.getHeight();
        if (height == oldHeight) {
            return;
        }
        this._ignoreReshape = true;
        try {
            int defaultHeight = this.getDefaultRowHeight();
            int rowCount = defaultHeight == 0 ? 0 : height / defaultHeight;
            this._gridDS.setRowCount(rowCount);
            int oldCount = this._rowHeaderDS.getItemCount();
            if (oldCount != rowCount) {
                this._rowHeaderDS.removeItems(0, oldCount);
                this._rowHeaderDS.addItems(0, rowCount);
            }
        }
        finally {
            this._ignoreReshape = false;
        }
    }

    public Header createRowHeader(OneDModel ds) {
        return new RowHeader(ds);
    }

    public Grid createGrid(TwoDModel ds) {
        return new ExtendedGrid(ds);
    }

    public Header createColumnHeader(OneDModel ds) {
        return new ColumnHeader(ds);
    }

    public void firePivotEvent(Object source, int sourceIndex, Object destination, int destinationIndex) {
        PivotEvent e = new PivotEvent(source, 2001, destination, sourceIndex, destinationIndex);
        this.processEvent((AWTEvent)e);
    }

    public void fireSwapEvent(Object source, int sourceIndex, Object destination, int destinationIndex) {
        PivotEvent e = new PivotEvent(source, 2002, destination, sourceIndex, destinationIndex);
        this.processEvent((AWTEvent)e);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void requestFocus() {
        this.getColumnHeader().requestFocus();
    }

    public Dimension layoutCanvas() {
        if (this.getGrid().getColumnCount() != 0 || this.getParent() == null) {
            return super.layoutCanvas();
        }
        Dimension d = this.getParent().getSize();
        --d.width;
        return d;
    }

    protected void processEventImpl(AWTEvent e) {
        if (e instanceof PivotEvent) {
            this.processPivotEvent((PivotEvent)e);
        } else {
            super.processEventImpl(e);
        }
    }

    protected void processPivotEvent(PivotEvent evt) {
        if (this._pivotListeners == null) {
            return;
        }
        Enumeration e = this._pivotListeners.getListeners();
        if (e == null) {
            return;
        }
        switch (evt.getID()) {
            case 2001: {
                while (e.hasMoreElements()) {
                    ((PivotListener)e.nextElement()).pivot(evt);
                }
                break;
            }
            case 2002: {
                while (e.hasMoreElements()) {
                    ((PivotListener)e.nextElement()).swap(evt);
                }
                break;
            }
        }
    }

    void scrollColumnIntoView(int index) {
        ((ExtendedGrid)this.getGrid()).scrollColumnIntoView(index);
        ((ColumnHeader)this.getColumnHeader()).scrollItemIntoView(index);
    }

    void setDragItem(int item) {
        this._dragIndex = item;
        this.repaint();
    }

    void setDropLocation(int index, boolean isSwap) {
        if (this._dropIndex != index || this._swapping != isSwap) {
            int swapItem = !isSwap ? -1 : (index == -1 ? -1 : (index == this._dragIndex ? -1 : index));
            ((ColumnHeader)this.getColumnHeader()).setSwapItem(swapItem);
            this._swapping = isSwap;
            if (index == -1 || this._dragIndex == -1 || this._swapping && this._dragIndex != index) {
                this._dropIndex = index;
            } else {
                if (this._dragIndex != -1 && (this._dragIndex == index || this._dragIndex == index - 1)) {
                    index = -1;
                }
                this._dropIndex = index;
            }
            this.getColumnHeader().repaint();
            this.getGrid().repaint();
        }
    }

    int getElementCount() {
        return this._columnHeaderDS.getItemCount();
    }

    void paintDropFeedback(Graphics g) {
        if (this._swapping) {
            return;
        }
        Rectangle rect = this.getInnerBounds();
        Dimension bounds = this.getColumnHeader().getCanvasSize();
        boolean l2r = this.getActualReadingDirection() == 1;
        Color oldColor = g.getColor();
        g.setColor(Color.black);
        int count = this.getElementCount();
        int position = this._dropIndex < count ? this.getColumnHeader().getItemPosition(this._dropIndex) : (this._dropIndex == count && count != 0 ? this.getColumnHeader().getItemPosition(this._dropIndex - 1) + this.getColumnHeader().getItemSize(this._dropIndex - 1) : 0);
        int x = position - 2;
        int originX = -this.getCanvasOriginX();
        if (x < rect.x + originX) {
            x = rect.x + originX;
        }
        if (x + 4 > rect.width + originX) {
            x = rect.width + originX - 4;
        }
        if (l2r) {
            g.fillRect(x, 0, 4, rect.height);
        } else {
            g.fillRect(x, 0, 4, rect.height);
        }
        if (oldColor != null) {
            g.setColor(oldColor);
        }
    }

    protected boolean isSwap(Point p) {
        int index = -1;
        Header header = this.getColumnHeader();
        index = header.getItemAt(p.x, p.y);
        if (index == -1) {
            return false;
        }
        if (!this._canPivot(index)) {
            return false;
        }
        int position = header.getItemPosition(index);
        int size = header.getItemSize(index);
        if (p.x < position + 10) {
            return false;
        }
        return p.x <= position + size - 10;
    }

    protected void setLayoutPanel(Layout _layout) {
        this.m_layout = _layout;
    }

    protected Layout getLayoutPanel() {
        return this.m_layout;
    }

    private boolean _canPivot(int index) {
        boolean bPivotSupported = true;
        if (this.m_layout != null && this.m_layout.getCanPivot(this.getEdge(), index) == 0) {
            bPivotSupported = false;
        }
        return bPivotSupported;
    }

    private int _getPrevPivotableIndex(int index) {
        for (int i = index; i >= 0; --i) {
            if (!this._canPivot(i)) continue;
            return i;
        }
        return -1;
    }

    private void _setSizes() {
        Header h = this.getColumnHeader();
        Painter p = h.getDefaultPainter();
        BorderPainter b = h.getHeaderItemBorderPainter();
        ImmInsets insets = b.getInsets(this.getPaintContext());
        ImmInsets aInsets = h.getAppearance().getInsets();
        int extra = insets.left + insets.right + aInsets.left + aInsets.right + 4;
        int count = this._columnHeaderDS.getItemCount();
        for (int i = 0; i < count; ++i) {
            PaintContext context = h.getItemPaintContext(i);
            int width = p.getPreferredSize((PaintContext)context).width;
            this.setColumnWidth(i, width + extra);
        }
    }

    private class ColumnDS
    extends ArrayOneDModel {
        public ColumnDS() {
            super(0);
        }

        public String getElement(int item) {
            return (String)super.getData(item);
        }

        public Object getData(int item) {
            return this.getElement(item);
        }
    }

    private class EmptyDS
    extends AbstractTwoDModel {
        private int _columnCount;
        private int _rowCount;

        private EmptyDS() {
        }

        public void setColumnCount(int count) {
            int oldCount = this._columnCount;
            int diff = count - oldCount;
            this._columnCount = count;
            if (diff > 0) {
                this.fireModelEvent(2001, 0, diff);
            } else if (diff < 0) {
                this.fireModelEvent(2002, 0, -diff);
            }
        }

        public int getColumnCount() {
            return this._columnCount;
        }

        public void setRowCount(int count) {
            int oldCount = this._rowCount;
            int diff = count - oldCount;
            this._rowCount = count;
            if (diff > 0) {
                this.fireModelEvent(2004, 0, diff);
            } else if (diff < 0) {
                this.fireModelEvent(2005, 0, -diff);
            }
        }

        public int getRowCount() {
            return this._rowCount;
        }

        public Object getData(int column, int row) {
            return null;
        }

        public void setData(int column, int row, Object data) {
        }
    }

    private class TableDragDropAdapter
    implements DropTargetListener,
    DragSourceListener,
    DragGestureListener {
        LayoutSpreadTable m_table;
        DropTarget _headerTarget;
        DropTarget _gridTarget;
        DragGestureRecognizer _recognizer;

        public TableDragDropAdapter(LayoutSpreadTable table) {
            this.m_table = table;
            Header header = this.m_table.getColumnHeader();
            this._recognizer = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer((Component)header, 2, (DragGestureListener)this);
            this._headerTarget = new DropTarget((Component)header, (DropTargetListener)this);
            this._gridTarget = new DropTarget((Component)this.m_table.getGrid(), (DropTargetListener)this);
        }

        public void cleanup() {
            this._headerTarget.setActive(false);
            this._headerTarget.setComponent(null);
            this._gridTarget.setActive(false);
            this._gridTarget.setComponent(null);
            this._recognizer.removeDragGestureListener((DragGestureListener)this);
            this._recognizer = null;
            this._headerTarget = null;
            this._gridTarget = null;
            this.m_table = null;
        }

        public void dragEnter(DropTargetDragEvent e) {
        }

        public void dragOver(DropTargetDragEvent e) {
            if (!this._acceptDrag(e)) {
                e.rejectDrag();
                return;
            }
            boolean isSwap = this._isSwap(e.getLocation());
            int index = this._getIndex(e.getLocation(), isSwap);
            this._setDropLocation(index, isSwap);
        }

        public void dragScroll(DropTargetDragEvent e) {
        }

        public void dragExit(DropTargetEvent e) {
            this._setDropLocation(-1, false);
        }

        public void dropActionChanged(DropTargetDragEvent e) {
        }

        public void drop(DropTargetDropEvent e) {
            e.acceptDrop(1);
            this._setDropLocation(-1, false);
            Transferable transfer = e.getTransferable();
            Object data = null;
            try {
                data = transfer.getTransferData(PivotTransfer.DATA_FLAVOR);
            }
            catch (UnsupportedFlavorException ufe) {
                data = null;
            }
            catch (IOException ioe) {
                data = null;
            }
            if (data != null && data instanceof PivotTransfer) {
                boolean isSwap = this._isSwap(e.getLocation());
                int index = this._getIndex(e.getLocation(), isSwap);
                if (index != -1) {
                    PivotTransfer layoutTransfer = (PivotTransfer)data;
                    Object source = layoutTransfer.getSource();
                    int sourceIndex = layoutTransfer.getIndex();
                    LayoutSpreadTable destination = this.m_table;
                    int destinationIndex = index;
                    if (!isSwap && source == destination && destinationIndex > sourceIndex) {
                        --destinationIndex;
                    }
                    if (!isSwap) {
                        this.m_table.firePivotEvent(source, sourceIndex, destination, destinationIndex);
                    } else {
                        this.m_table.fireSwapEvent(source, sourceIndex, destination, destinationIndex);
                    }
                }
            }
            e.dropComplete(data != null);
        }

        public void dragGestureRecognized(DragGestureEvent e) {
            Header header = this.m_table.getColumnHeader();
            if (this.m_table.getElementCount() == 0) {
                return;
            }
            Point origin = e.getDragOrigin();
            int index = header.getItemAt(origin.x, origin.y);
            if (index == -1) {
                return;
            }
            if (!LayoutSpreadTable.this._canPivot(index)) {
                return;
            }
            origin.x = 5;
            origin.y -= header.getItemPosition(index);
            origin.y = -origin.y;
            Image dragImage = null;
            this.m_table.setDragItem(index);
            e.startDrag(null, dragImage, origin, PivotTransfer.createTransferable((Object)this.m_table, (int)index), (DragSourceListener)this);
        }

        public void dragEnter(DragSourceDragEvent e) {
        }

        public void dragOver(DragSourceDragEvent e) {
        }

        public void dropActionChanged(DragSourceDragEvent e) {
        }

        public void dragExit(DragSourceEvent e) {
        }

        public void dragDropEnd(DragSourceDropEvent e) {
            this.m_table.setDragItem(-1);
        }

        private boolean _acceptDrag(DropTargetDragEvent dtde) {
            if (!this.m_table.isEnabled()) {
                return false;
            }
            DataFlavor[] flavors = dtde.getCurrentDataFlavors();
            if (flavors == null) {
                return false;
            }
            for (int i = 0; i < flavors.length; ++i) {
                if (!TransferUtils.supportsDataFlavor((DataFlavor)flavors[i], (DataFlavor)PivotTransfer.DATA_FLAVOR)) continue;
                return true;
            }
            return false;
        }

        void _setDropLocation(int index, boolean isSwap) {
            this.m_table.setDropLocation(index, isSwap);
        }

        boolean _isSwap(Point p) {
            return this.m_table.isSwap(p);
        }

        private int _getIndex(Point p, boolean isSwap) {
            int index = -1;
            Header header = this.m_table.getColumnHeader();
            boolean l2r = this.m_table.getActualReadingDirection() == 1;
            p = header.convertOuterToCanvas(p.x, p.y);
            index = header.getItemAt(p.x, p.y);
            if (!isSwap) {
                if (index == -1) {
                    int count = header.getItemCount();
                    int size = header.getGeometryManager().getTotalSize();
                    index = p.x > size && count != 0 ? LayoutSpreadTable.this._getPrevPivotableIndex(count - 1) + 1 : 0;
                } else if ((index = LayoutSpreadTable.this._getPrevPivotableIndex(index)) == -1) {
                    index = 0;
                } else {
                    int position = header.getItemPosition(index);
                    int size = header.getItemSize(index);
                    if (l2r) {
                        if (p.x > position + size / 2) {
                            ++index;
                        }
                    } else if (p.x < position + size / 2) {
                        ++index;
                    }
                }
            }
            return index;
        }
    }

    private class RowHeader
    extends Header {
        public RowHeader(OneDModel ds) {
            super(ds, 1);
            this.setCanMoveItems(false);
            this.setCanResizeItems(false);
            this.setHeaderSelectionManager(null);
        }

        public Insets getAutoscrollInsets() {
            return new Insets(0, 0, 0, 0);
        }

        protected int getItemPaintState(int baseState, int item) {
            return baseState & 0xFFFFFFFD;
        }
    }

    private class ExtendedGrid
    extends Grid {
        public ExtendedGrid(TwoDModel ds) {
            super(ds);
            this.setGridSelectionManager(null);
        }

        public Dimension layoutCanvas() {
            if (this.getColumnCount() != 0 || this.getParent() == null) {
                return super.layoutCanvas();
            }
            Dimension d = this.getParent().getSize();
            --d.width;
            return d;
        }

        public Insets getAutoscrollInsets() {
            return new Insets(0, 0, 0, 0);
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void requestFocus() {
            LayoutSpreadTable.this.requestFocus();
        }

        public void scrollColumnIntoView(int column) {
            super.scrollColumnIntoView(column);
        }

        public void paintCanvasInterior(Graphics g) {
            super.paintCanvasInterior(g);
            if (LayoutSpreadTable.this._dropIndex != -1) {
                LayoutSpreadTable.this.paintDropFeedback(g);
            }
        }
    }

    private class ColumnHeader
    extends Header
    implements ActionListener {
        private Color _foreColor;
        private Color _selForeColor;
        private Color _backColor;
        private Color _selBackColor;
        private final String COMMAND_LEFT = "LEFT";
        private final String COMMAND_RIGHT = "RIGHT";
        private final String COMMAND_POPUP = "SHOW_POPUP";

        public ColumnHeader(OneDModel ds) {
            super(ds, 0);
            this.COMMAND_LEFT = "LEFT";
            this.COMMAND_RIGHT = "RIGHT";
            this.COMMAND_POPUP = "SHOW_POPUP";
            this.enableEvents(4L);
            this.setDrawSelected(true);
            this.setCanMoveItems(false);
            this.setCanResizeItems(false);
            Appearance a = this.getAppearance();
            a.setHorizontalJustify(3);
            a.setVerticalJustify(1);
            this.setAppearance(a);
            this.setHeaderSelectionManager((HeaderSelectionManager)new GeneralHeaderSelectionManager(1));
            this._foreColor = a.getForeground();
            this._selForeColor = a.getSelectForeground();
            this._backColor = a.getBackground();
            this._selBackColor = a.getSelectBackground();
            this._registerKeyStrokes();
        }

        protected Dimension layoutCanvas() {
            if (this.getItemCount() != 0 || this.getParent() == null) {
                return super.layoutCanvas();
            }
            return new Dimension(this.getParent().getSize().width - 1, this.getPreferredHeaderSize());
        }

        public void paintCanvasInterior(Graphics g) {
            super.paintCanvasInterior(g);
            if (LayoutSpreadTable.this._dropIndex != -1) {
                LayoutSpreadTable.this.paintDropFeedback(g);
            }
        }

        void setSwapItem(int item) {
            for (int i = 0; i < this.getItemCount(); ++i) {
                Appearance app = super.getItemAppearance(i);
                if (i == item) {
                    PivotHeader _pivotHeader = new PivotHeader();
                    EWTPivotHeaderUI ui = _pivotHeader.getPivotHeaderUI();
                    Color color = ui.getSwapForegroundColor((JComponent)_pivotHeader, app);
                    app.setForeground(color);
                    app.setSelectForeground(color);
                    color = ui.getSwapBackgroundColor((JComponent)_pivotHeader, app);
                    app.setBackground(color);
                    app.setSelectBackground(color);
                } else {
                    app.setForeground(this._foreColor);
                    app.setSelectForeground(this._selForeColor);
                    app.setBackground(this._backColor);
                    app.setSelectBackground(this._selBackColor);
                }
                this.setItemAppearance(i, app);
            }
        }

        public boolean isFocusTraversable() {
            return LayoutSpreadTable.this.getElementCount() != 0;
        }

        public Insets getAutoscrollInsets() {
            return new Insets(0, 0, 0, 0);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index;
            int count = LayoutSpreadTable.this.getElementCount();
            if (count == 0) {
                return;
            }
            if ("LEFT".equals(e.getActionCommand())) {
                int index2 = LayoutSpreadTable.this.getSelectedIndex() - 1;
                if (index2 < 0) {
                    index2 = 0;
                }
                this.setSelectedIndex(index2);
                LayoutSpreadTable.this.scrollColumnIntoView(index2);
            } else if ("RIGHT".equals(e.getActionCommand())) {
                int index3 = LayoutSpreadTable.this.getSelectedIndex() + 1;
                if (index3 > count - 1) {
                    index3 = count - 1;
                }
                this.setSelectedIndex(index3);
                LayoutSpreadTable.this.scrollColumnIntoView(index3);
            } else if ("SHOW_POPUP".equals(e.getActionCommand()) && (index = LayoutSpreadTable.this.getSelectedIndex()) > -1 && index < LayoutSpreadTable.this.getElementCount()) {
                String selectedItem = (String)this.getModel().getData(index);
                Point p = new Point();
                p.x = this.getItemPosition(index);
                p.y = this.getPreferredHeaderSize();
                if (LayoutSpreadTable.this._popupManager != null) {
                    LayoutSpreadTable.this._popupManager.createPopup(LayoutSpreadTable.this, selectedItem, (JComponent)((Object)this), p);
                }
            }
        }

        public void scrollItemIntoView(int item) {
            super.scrollItemIntoView(item);
        }

        protected void processFocusEvent(FocusEvent e) {
            super.processFocusEvent(e);
            int id = e.getID();
            int item = -1;
            switch (id) {
                case 1004: {
                    item = LayoutSpreadTable.this.getSelectedIndex();
                    if (item != -1 || LayoutSpreadTable.this.getElementCount() == 0) break;
                    item = 0;
                    break;
                }
                case 1005: {
                    item = e.isTemporary() ? LayoutSpreadTable.this.getSelectedIndex() : -1;
                }
            }
            this.setSelectedIndex(item);
        }

        protected void processMouseEvent(MouseEvent e) {
            if (e.getID() == 501 && LayoutSpreadTable.this.getElementCount() != 0) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    e.consume();
                    String selectedItem = (String)this.getModel().getData(this.getItemAt(e.getX(), e.getY()));
                    Point p = new Point(e.getX(), e.getY());
                    LayoutSpreadTable.this._popupManager.createPopup(LayoutSpreadTable.this, selectedItem, (JComponent)((Object)this), p);
                    return;
                }
                super.requestFocus();
            }
            super.processMouseEvent(e);
        }

        void setSelectedIndex(int index) {
            try {
                if (index == -1) {
                    LayoutSpreadTable.this.getColumnHeader().deselectAll();
                } else {
                    LayoutSpreadTable.this.getColumnHeader().setSelection(new OneDSelection(index));
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        private void _registerKeyStrokes() {
            ColumnHeader listener = this;
            int condition = 0;
            KeyStroke stroke = KeyStroke.getKeyStroke(37, 0);
            this.registerKeyboardAction(listener, "LEFT", stroke, condition);
            stroke = KeyStroke.getKeyStroke(39, 0);
            this.registerKeyboardAction(listener, "RIGHT", stroke, condition);
            stroke = KeyStroke.getKeyStroke(121, 1);
            this.registerKeyboardAction(listener, "SHOW_POPUP", stroke, condition);
        }
    }
}

