/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.util.gui.layout;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Enumeration;
import java.util.EventListener;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import oracle.adfdtinternal.model.dvt.util.gui.layout.ColumnHeader;
import oracle.adfdtinternal.model.dvt.util.gui.layout.CornerPainter;
import oracle.adfdtinternal.model.dvt.util.gui.layout.CrosstabScrollPane;
import oracle.adfdtinternal.model.dvt.util.gui.layout.DataPointGrid;
import oracle.adfdtinternal.model.dvt.util.gui.layout.Layout;
import oracle.adfdtinternal.model.dvt.util.gui.layout.LayoutComponent;
import oracle.adfdtinternal.model.dvt.util.gui.layout.RowHeader;
import oracle.adfdtinternal.model.dvt.util.gui.layout.ScrollPaneDropAdapter;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.border.UIBorderFactory;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.pivot.PivotEvent;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotListener;
import oracle.bali.share.event.ListenerManager;

public class Crosstab
extends JPanel {
    public static final String PROPERTY_SELECTION = "selection";
    static final Object KEY_HORIZONTAL = "crosstablayout.horizontal";
    static final Object KEY_VERTICAL = "crosstablayout.vertical";
    protected static final int ADJUST_EACH_ROW = 5;
    ColumnHeader _columnHeader = new ColumnHeader(this, 0);
    RowHeader _rowHeader;
    DataPointGrid _grid;
    CrosstabScrollPane _scrollPane;
    CrosstabScrollPane _columnScrollPane;
    CrosstabScrollPane _rowScrollPane;
    LWComponent _corner;
    Layout _layout;
    ScrollPaneDropAdapter _mainScrollDrop;
    ScrollPaneDropAdapter _rowScrollDrop;
    ScrollPaneDropAdapter _columnScrollDrop;
    private ListenerManager _pivotListeners;

    public Crosstab() {
        this._columnHeader.setName("CrosstabColumnHeader");
        this._rowHeader = new RowHeader(this, 1);
        this._rowHeader.setName("CrosstabRowHeader");
        this._grid = new DataPointGrid(this, -1);
        this._scrollPane = new CrosstabScrollPane((Component)((Object)this._grid));
        this._columnScrollPane = new CrosstabScrollPane((Component)((Object)this._columnHeader));
        this._rowScrollPane = new CrosstabScrollPane((Component)((Object)this._rowHeader), false);
        this._corner = new Corner();
        this._columnHeader.setBorder(null);
        this._rowHeader.setBorder(null);
        this._scrollPane.setBorder(null);
        this._columnScrollPane.setBorder(null);
        this._rowScrollPane.setBorder(null);
        this._layout = new Layout();
        this.setLayout(this._layout);
        this.setBorder(UIBorderFactory.getLoweredBevelBorder());
        this.add(this._columnScrollPane);
        this.add(this._rowScrollPane);
        this.add(this._scrollPane);
        this.add((Component)this._corner);
    }

    public ColumnHeader getColumnHeader() {
        return this._columnHeader;
    }

    public RowHeader getRowHeader() {
        return this._rowHeader;
    }

    public DataPointGrid getDataPointGrid() {
        return this._grid;
    }

    public boolean isSomethingSelected() {
        int index = this._columnHeader.getSelectedIndex();
        if (index != -1) {
            return true;
        }
        index = this._rowHeader.getSelectedIndex();
        if (index != -1) {
            return true;
        }
        index = this._grid.getSelectedIndex();
        return index != -1;
    }

    public LayoutComponent getSelectedAxis() {
        int index = this._columnHeader.getSelectedIndex();
        if (index != -1) {
            return this._columnHeader;
        }
        index = this._rowHeader.getSelectedIndex();
        if (index != -1) {
            return this._rowHeader;
        }
        index = this._grid.getSelectedIndex();
        if (index != -1) {
            return this._grid;
        }
        return null;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._columnHeader.setBorder(null);
        this._rowHeader.setBorder(null);
        this._scrollPane.setBorder(null);
        this._columnScrollPane.setBorder(null);
        this._rowScrollPane.setBorder(null);
        this._mainScrollDrop = new ScrollPaneDropAdapter(this._scrollPane, this);
        this._columnScrollDrop = new ScrollPaneDropAdapter(this._columnScrollPane, this);
        this._rowScrollDrop = new ScrollPaneDropAdapter(this._rowScrollPane, this);
    }

    public void clearSelection() {
        this._columnHeader.clearSelection();
        this._rowHeader.clearSelection();
        this._grid.clearSelection();
    }

    public synchronized void addPivotListener(PivotListener listener) {
        if (this._pivotListeners == null) {
            this._pivotListeners = new ListenerManager();
        }
        this._pivotListeners.addListener((EventListener)listener);
    }

    public synchronized void removePivotListener(PivotListener listener) {
        if (this._pivotListeners != null) {
            this._pivotListeners.removeListener((EventListener)listener);
        }
    }

    public int getDataPointOrientation() {
        return this._grid.getOrientation();
    }

    public void setDataPointOrientation(int orientation) {
        this._grid.setOrientation(orientation);
        this.invalidate();
    }

    public void setPopupManager(Layout.PopupManager popupManager) {
        if (this._columnHeader != null) {
            this._columnHeader.setPopupManager(popupManager);
            if (popupManager != null) {
                popupManager.setColumnLayoutComponent(this._columnHeader);
            }
        }
        if (this._rowHeader != null) {
            this._rowHeader.setPopupManager(popupManager);
            if (popupManager != null) {
                popupManager.setRowLayoutComponent(this._rowHeader);
            }
        }
    }

    public void setGridPopupManager(Layout.PopupManager popupManager) {
        if (this._grid != null) {
            this._grid.setPopupManager(popupManager);
            if (popupManager != null) {
                popupManager.setMeasureLayoutComponent(this._grid);
            }
        }
    }

    public void cleanup() {
        this._columnHeader.cleanup();
        this._rowHeader.cleanup();
        this._grid.cleanup();
        if (this._mainScrollDrop != null) {
            this._mainScrollDrop.cleanup();
            this._rowScrollDrop.cleanup();
            this._columnScrollDrop.cleanup();
        }
        BorderLayout layout = (BorderLayout)this.getParent().getLayout();
        layout.removeLayoutComponent(this);
        this.removeAll();
        this.setLayout(null);
        this._columnScrollPane.removeAll();
        this._rowScrollPane.removeAll();
        this._scrollPane.removeAll();
        this._layout = null;
        this._columnHeader = null;
        this._columnScrollPane = null;
        this._corner = null;
        this._grid = null;
        this._pivotListeners = null;
        this._rowHeader = null;
        this._rowScrollPane = null;
        this._scrollPane = null;
        this._mainScrollDrop = null;
        this._rowScrollDrop = null;
        this._columnScrollDrop = null;
    }

    public void firePivotEvent(Object source, int sourceIndex, Object destination, int destinationIndex) {
        PivotEvent e = new PivotEvent(source, 2001, destination, sourceIndex, destinationIndex);
        this.processEvent((AWTEvent)e);
    }

    public void fireSwapEvent(Object source, int sourceIndex, Object destination, int destinationIndex) {
        PivotEvent e = new PivotEvent(source, 2002, destination, sourceIndex, destinationIndex);
        this.processEvent((AWTEvent)e);
    }

    @Override
    public boolean isValidateRoot() {
        return true;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (!this.isPreferredSizeSet()) {
            dimension = this.adjustedPreferredSize();
        }
        return dimension;
    }

    protected Dimension adjustedPreferredSize() {
        ColumnHeader columnHeader;
        Grid grid;
        Dimension dimension = super.getPreferredSize();
        int nRowCount = 0;
        RowHeader rowHeader = this.getRowHeader();
        if (rowHeader != null && (grid = rowHeader.getGrid()) != null) {
            nRowCount += grid.getRowCount();
        }
        if ((columnHeader = this.getColumnHeader()) != null && (grid = columnHeader.getGrid()) != null) {
            nRowCount += grid.getRowCount();
        }
        int nHeight = (int)dimension.getHeight() + nRowCount * 5;
        if (this._columnScrollPane != null) {
            nHeight = (int)((double)nHeight + this._columnScrollPane.getSize().getHeight());
        }
        dimension = new Dimension((int)dimension.getWidth(), nHeight);
        return dimension;
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (e instanceof PivotEvent) {
            this.processPivotEvent((PivotEvent)e);
        } else {
            super.processEvent(e);
        }
    }

    protected void processPivotEvent(PivotEvent evt) {
        if (this._pivotListeners == null) {
            return;
        }
        Enumeration e = this._pivotListeners.getListeners();
        if (e == null) {
            return;
        }
        switch (evt.getID()) {
            case 2001: {
                while (e.hasMoreElements()) {
                    ((PivotListener)e.nextElement()).pivot(evt);
                }
                break;
            }
            case 2002: {
                while (e.hasMoreElements()) {
                    ((PivotListener)e.nextElement()).swap(evt);
                }
                break;
            }
        }
    }

    void columnSelectionChanged() {
        this._rowHeader.clearSelection();
        this._grid.clearSelection();
        this.firePropertyChange(PROPERTY_SELECTION, null, null);
    }

    void rowSelectionChanged() {
        this._columnHeader.clearSelection();
        this._grid.clearSelection();
        this.firePropertyChange(PROPERTY_SELECTION, null, null);
    }

    void gridSelectionChanged() {
        this._rowHeader.clearSelection();
        this._columnHeader.clearSelection();
        this.firePropertyChange(PROPERTY_SELECTION, null, null);
    }

    void axisItemToDataPoint(PivotHeader which, int index) {
        this.firePivotEvent(which, index, this._grid, 0);
    }

    void dataPointToAxisItem(int index) {
        int count = this._columnHeader.getItemCount();
        this.firePivotEvent(this._grid, index, this._columnHeader, count);
    }

    private class Corner
    extends LWComponent {
        private Corner() {
        }

        public void paintComponent(Graphics g) {
            Painter p = CornerPainter.getPainter();
            p.paint(this.getPaintContext(), g, 0, 0, this.getWidth(), this.getHeight());
        }

        public Object getPaintData(Object key) {
            if (KEY_HORIZONTAL.equals(key)) {
                return Crosstab.this._rowHeader.getGrid().getColumnCount() != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            if (KEY_VERTICAL.equals(key)) {
                return Crosstab.this._columnHeader.getGrid().getRowCount() != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            return super.getPaintData(key);
        }
    }

    private class Layout
    implements LayoutManager {
        private Layout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension rowSize = Crosstab.this._rowHeader.getPreferredScrollableViewportSize();
            Dimension columnSize = Crosstab.this._columnHeader.getPreferredScrollableViewportSize();
            Dimension gridSize = Crosstab.this._grid.getPreferredScrollableViewportSize();
            if (columnSize.height == 0) {
                columnSize.height = Crosstab.this._columnHeader.getPreferredSize().height;
            }
            if (rowSize.width == 0) {
                rowSize.width = Crosstab.this._rowHeader.getPreferredSize().width;
            }
            int extra = Crosstab.this._columnHeader.getRowHeaderWidth();
            int width = rowSize.width + extra + Math.max(columnSize.width, gridSize.width);
            int height = columnSize.height + extra + Math.max(rowSize.height, gridSize.height);
            return new Dimension(width, height);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension size = parent.getSize();
            int nScrollBarWidth = 0;
            Insets borderInsets = Crosstab.this.getInsets();
            if (borderInsets != null) {
                size.width -= borderInsets.left + borderInsets.right;
                size.height -= borderInsets.top + borderInsets.bottom;
            }
            Dimension rowSize = Crosstab.this._rowHeader.getPreferredScrollableViewportSize();
            Dimension columnSize = Crosstab.this._columnHeader.getPreferredScrollableViewportSize();
            Dimension gridSize = Crosstab.this._grid.getPreferredScrollableViewportSize();
            if (columnSize.height == 0) {
                columnSize.height = Crosstab.this._columnHeader.getPreferredSize().height;
            }
            if (Crosstab.this._grid != null && Crosstab.this._grid.getColumnCount() <= 1) {
                JScrollBar jScrollbar = new JScrollBar();
                nScrollBarWidth = jScrollbar.getPreferredSize().width;
                jScrollbar = null;
            }
            if (rowSize.width == 0) {
                rowSize.width = Crosstab.this._rowHeader.getPreferredSize().width;
            }
            if (columnSize.height + rowSize.height > size.height) {
                int half = size.height / 2;
                if (columnSize.height > half) {
                    columnSize.height = half;
                }
                if (rowSize.height > half) {
                    rowSize.height = half;
                }
            }
            if (columnSize.width + rowSize.width > size.width) {
                int half = size.width / 2;
                if (columnSize.width > half) {
                    columnSize.width = half;
                }
                if (rowSize.width > half) {
                    rowSize.width = half;
                }
            }
            int extra = Crosstab.this._columnHeader.getRowHeaderWidth();
            int x = 0;
            int y = 0;
            if (borderInsets != null) {
                x = borderInsets.left;
                y = borderInsets.top;
            }
            Crosstab.this._corner.setBounds(x, y, rowSize.width, columnSize.height);
            Crosstab.this._rowScrollPane.setBounds(x, y + columnSize.height, rowSize.width, size.height - columnSize.height);
            int width = size.width - rowSize.width;
            if (nScrollBarWidth > 0) {
                width -= nScrollBarWidth;
            }
            Crosstab.this._columnHeader.setColumnWidth(width);
            Crosstab.this._columnScrollPane.setBounds(x + rowSize.width, y, width, columnSize.height);
            Crosstab.this._grid.setColumnWidth(width -= extra);
            if (nScrollBarWidth > 0) {
                width = width + extra + 1;
            }
            Crosstab.this._scrollPane.setBounds(rowSize.width + extra, columnSize.height + extra, width, size.height - columnSize.height - extra + 1);
        }
    }
}

