/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v11;

import java.util.List;
import oracle.security.xmlsec.dsig.XSKeyInfo;
import oracle.security.xmlsec.liberty.v11.LibertyInitializer;
import oracle.security.xmlsec.liberty.v11.LibertyUtils;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.util.XMLElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class ProviderDescriptor
extends XMLElement {
    private static final String[] nsURIs = new String[]{"http://projectliberty.org/schemas/core/2002/12", "http://www.w3.org/2000/09/xmldsig#", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12"};
    private static final String[] localNames = new String[]{"ProviderID", "KeyInfo", "SoapEndpoint", "SingleLogoutServiceURL", "SingleLogoutServiceReturnURL", "FederationTerminationServiceURL", "FederationTerminationServiceReturnURL", "FederationTerminationNotificationProtocolProfile", "SingleLogoutProtocolProfile", "RegisterNameIdentifierProtocolProfile", "RegisterNameIdentifierServiceURL", "RegisterNameIdentifierServiceReturnURL"};

    protected ProviderDescriptor(Element element) throws DOMException {
        super(element);
    }

    protected ProviderDescriptor(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    protected ProviderDescriptor(Document owner, String nsURI, String localName) throws DOMException {
        super(owner, nsURI, localName);
    }

    protected ProviderDescriptor(Document owner, String nsURI, String localName, String providerId) throws DOMException {
        this(owner, nsURI, localName);
        this.setProviderID(providerId);
    }

    public void setProviderID(String providerID) {
        LibertyUtils.insertChildElementWithText(this, "http://projectliberty.org/schemas/core/2002/12", "ProviderID", nsURIs, localNames, providerID, true);
    }

    public String getProviderID() {
        return LibertyUtils.collectTextFromChild(this, "http://projectliberty.org/schemas/core/2002/12", "ProviderID");
    }

    public void setKeyInfo(XSKeyInfo keyInfo) {
        String prefix = keyInfo.getPrefix();
        if (prefix == null || prefix.length() == 0) {
            keyInfo.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
        } else {
            keyInfo.addNSPrefixAttr(prefix, "http://www.w3.org/2000/09/xmldsig#");
        }
        LibertyUtils.setChildElement(this, (XMLElement)keyInfo, nsURIs, localNames);
    }

    public XSKeyInfo getKeyInfo() {
        return (XSKeyInfo)LibertyUtils.getChildElement(this, "http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
    }

    public void setSoapEndpoint(String soapEndpointURI) {
        LibertyUtils.insertChildElementWithText(this, "http://projectliberty.org/schemas/core/2002/12", "SoapEndpoint", nsURIs, localNames, soapEndpointURI, true);
    }

    public String getSoapEndpoint() {
        return LibertyUtils.collectTextFromChild(this, "http://projectliberty.org/schemas/core/2002/12", "SoapEndpoint");
    }

    public void setSingleLogoutServiceURL(String logoutServiceURI) {
        LibertyUtils.insertChildElementWithText(this, "http://projectliberty.org/schemas/core/2002/12", "SingleLogoutServiceURL", nsURIs, localNames, logoutServiceURI, true);
    }

    public String getSingleLogoutServiceURL() {
        return LibertyUtils.collectTextFromChild(this, "http://projectliberty.org/schemas/core/2002/12", "SingleLogoutServiceURL");
    }

    public void setSingleLogoutServiceReturnURL(String logoutReturnURI) {
        LibertyUtils.insertChildElementWithText(this, "http://projectliberty.org/schemas/core/2002/12", "SingleLogoutServiceReturnURL", nsURIs, localNames, logoutReturnURI, true);
    }

    public String getSingleLogoutServiceReturnURL() {
        return LibertyUtils.collectTextFromChild(this, "http://projectliberty.org/schemas/core/2002/12", "SingleLogoutServiceReturnURL");
    }

    public void setFederationTerminationServiceURL(String fedTermServiceURI) {
        LibertyUtils.insertChildElementWithText(this, "http://projectliberty.org/schemas/core/2002/12", "FederationTerminationServiceURL", nsURIs, localNames, fedTermServiceURI, true);
    }

    public String getFederationTerminationServiceURL() {
        return LibertyUtils.collectTextFromChild(this, "http://projectliberty.org/schemas/core/2002/12", "FederationTerminationServiceURL");
    }

    public void setFederationTerminationServiceReturnURL(String fedTermReturnURI) {
        LibertyUtils.insertChildElementWithText(this, "http://projectliberty.org/schemas/core/2002/12", "FederationTerminationServiceReturnURL", nsURIs, localNames, fedTermReturnURI, true);
    }

    public String getFederationTerminationServiceReturnURL() {
        return LibertyUtils.collectTextFromChild(this, "http://projectliberty.org/schemas/core/2002/12", "FederationTerminationServiceReturnURL");
    }

    public void addFederationTerminationNotificationProtocolProfile(String fedTermProfURI) {
        LibertyUtils.insertChildElementWithText(this, "http://projectliberty.org/schemas/core/2002/12", "FederationTerminationNotificationProtocolProfile", nsURIs, localNames, fedTermProfURI, false);
    }

    public List getFederationTerminationNotificationProtocolProfiles() {
        return LibertyUtils.collectTextFromChildren(this, "http://projectliberty.org/schemas/core/2002/12", "FederationTerminationNotificationProtocolProfile");
    }

    public void addSingleLogoutProtocolProfile(String logoutProfURI) {
        LibertyUtils.insertChildElementWithText(this, "http://projectliberty.org/schemas/core/2002/12", "SingleLogoutProtocolProfile", nsURIs, localNames, logoutProfURI, false);
    }

    public List getSingleLogoutProtocolProfiles() {
        return LibertyUtils.collectTextFromChildren(this, "http://projectliberty.org/schemas/core/2002/12", "SingleLogoutProtocolProfile");
    }

    public void addRegisterNameIdentifierProtocolProfile(String regNameProfURI) {
        LibertyUtils.insertChildElementWithText(this, "http://projectliberty.org/schemas/core/2002/12", "RegisterNameIdentifierProtocolProfile", nsURIs, localNames, regNameProfURI, false);
    }

    public List getRegisterNameIdentifierProtocolProfiles() {
        return LibertyUtils.collectTextFromChildren(this, "http://projectliberty.org/schemas/core/2002/12", "RegisterNameIdentifierProtocolProfile");
    }

    public void setRegisterNameIdentifierServiceURL(String regNameServiceURI) {
        LibertyUtils.insertChildElementWithText(this, "http://projectliberty.org/schemas/core/2002/12", "RegisterNameIdentifierServiceURL", nsURIs, localNames, regNameServiceURI, true);
    }

    public String getRegisterNameIdentifierServiceURL() {
        return LibertyUtils.collectTextFromChild(this, "http://projectliberty.org/schemas/core/2002/12", "RegisterNameIdentifierServiceURL");
    }

    public void setRegisterNameIdentifierServiceReturnURL(String regNameReturnURI) {
        LibertyUtils.insertChildElementWithText(this, "http://projectliberty.org/schemas/core/2002/12", "RegisterNameIdentifierServiceReturnURL", nsURIs, localNames, regNameReturnURI, true);
    }

    public String getRegisterNameIdentifierServiceReturnURL() {
        return LibertyUtils.collectTextFromChild(this, "http://projectliberty.org/schemas/core/2002/12", "RegisterNameIdentifierServiceReturnURL");
    }

    static {
        SAMLInitializer.initialize();
        LibertyInitializer.initialize();
    }
}

