/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.mapviewer.model;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import oracle.dbtools.spatial.mapviewer.model.MainCanvasDAO;
import oracle.maps.core.Layer;
import oracle.sdovis.util.JDBCUtil;
import oracle.spatial.edit.model.AbstractDataAccessObject;
import oracle.spatial.edit.model.AbstractDataSource;

public class MainCanvasDataSource
extends AbstractDataSource {
    public static final String PROPERTY_VISIBLE = "true";
    public static final String PROPERTY_QUERY = "query";
    public static final String PROPERTY_GEOM_COLUMN_IDX = "geomcolumnidx";
    public static final String PROPERTY_LAYER_IDX = "layeridx";
    public static final String PROPERTY_LAYER_MBR_XMIN = "layermbr_xmin";
    public static final String PROPERTY_LAYER_MBR_XMAX = "layermbr_xmax";
    public static final String PROPERTY_LAYER_MBR_YMIN = "layermbr_ymin";
    public static final String PROPERTY_LAYER_MBR_YMAX = "layermbr_ymax";
    public static final String PROPERTY_SUBLAYER_TYPE = "sublayer_type";
    protected static final String PROPERTY_GEOMCOLUMN_NAME = "geomcolumnname";
    protected static final String PROPERTY_TABLE_SRID = "tablesrid";
    private Layer dataLayer;
    private Connection mapConnection;
    private double[] layerMBR;
    private List<String> geomKeys;
    private Map geometryMap;
    private HashMap<String, String> columnLabelMappings;

    public MainCanvasDataSource(Layer layer) {
        this.dataLayer = layer;
        this.geometryMap = new HashMap();
        this.geomKeys = new ArrayList<String>();
    }

    public boolean init(Properties properties) {
        int n = 0;
        if (properties == null) {
            return false;
        }
        if (properties.getProperty(PROPERTY_QUERY) == null || properties.getProperty(PROPERTY_QUERY).equals("")) {
            return false;
        }
        if (properties.getProperty(PROPERTY_GEOM_COLUMN_IDX) == null || properties.getProperty(PROPERTY_GEOM_COLUMN_IDX).equals("")) {
            return false;
        }
        n = Integer.parseInt(properties.getProperty(PROPERTY_GEOM_COLUMN_IDX));
        if (properties.getProperty(PROPERTY_LAYER_IDX) == null || properties.getProperty(PROPERTY_LAYER_IDX).equals("")) {
            return false;
        }
        this.connProperties = new Properties(properties);
        return true;
    }

    public AbstractDataAccessObject getDataAccessObject() {
        return new MainCanvasDAO(this);
    }

    public boolean setLayerConnection(Connection connection) {
        if (connection == null) {
            return false;
        }
        this.mapConnection = connection;
        return true;
    }

    public double[] getMBR() {
        return this.layerMBR;
    }

    public boolean isGeodetic() throws Exception {
        String string = this.connProperties.getProperty(PROPERTY_TABLE_SRID);
        return JDBCUtil.isGeodeticSRID((Connection)this.mapConnection, (long)Long.parseLong(string));
    }

    public Connection getConnection() {
        return this.mapConnection;
    }

    public List getKeys() {
        return this.geomKeys;
    }

    public Map getMap() {
        return this.geometryMap;
    }

    public Layer getLayer() {
        return this.dataLayer;
    }

    public HashMap<String, String> getColumnLabels() {
        return this.columnLabelMappings;
    }

    public void setGeomKeys(List<String> list) {
        this.geomKeys = list;
    }

    public void setGeometryMap(Map map) {
        this.geometryMap = map;
    }

    public void setLabelMap(HashMap<String, String> hashMap) {
        this.columnLabelMappings = hashMap;
    }

    public List<String> getGeomKeys() {
        return this.geomKeys;
    }
}

