/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.vcscore.nav;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Iterator;
import javax.accessibility.Accessible;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockingParam;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.SingletonProvider;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.view.View;
import oracle.ideimpl.vcscore.VersioningConnectController;
import oracle.ideimpl.vcscore.VersioningRegistration;
import oracle.ideimpl.vcscore.VersioningRegistrations;
import oracle.ideimpl.vcscore.nav.ConnectionProviderRegistry;
import oracle.ideimpl.vcscore.nav.VersioningNavigatorConstants;
import oracle.ideimpl.vcscore.res.Bundle;
import oracle.ideri.navigator.DefaultNavigatorManager;
import oracle.ideri.navigator.DefaultNavigatorWindow;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.jndi.Names;
import oracle.javatools.util.StringUtil;

public final class VersioningNavigatorManager
extends DefaultNavigatorManager {
    public static final String NAVIGATOR_WINDOW_ID = "VersioningNavigatorWindow";
    private static final String VERSIONING_NAV_NAME = "ide/versioning-navigator";
    private static final String NAVIGATOR_DEFAULT_NAME = "VersioningNavigator";
    private final DefaultContainer _rootFolder = new DefaultContainer(){

        public String getShortLabel() {
            String label = Bundle.get("VERSIONING_NAVIGATOR");
            int mnemonic = StringUtils.getMnemonicKeyCode((String)label);
            label = StringUtils.stripMnemonic((String)label);
            if (mnemonic != 0) {
                label = StringUtil.removeMnemonic((String)label, (char)((char)mnemonic));
            }
            return label;
        }

        public Icon getIcon() {
            return OracleIcons.getIcon((String)"navconnections.png");
        }
    };

    public VersioningNavigatorManager() {
        this.initialize();
    }

    protected NavigatorWindow createNavigatorWindow(Context context, ViewId viewId) {
        return new DefaultNavigatorWindow(context, viewId.getId()){

            public String getTitleName() {
                String title = this.getTabName();
                AccessibleUtils.updateAccessibleName((Accessible)this.getTree(), (String)title, (boolean)false);
                return title;
            }

            protected void showPopupInBlankSpace(ContextMenu contextMenu, MouseEvent e) {
                Context context = new Context();
                context.setView((View)this);
                context.setEvent((EventObject)e);
                contextMenu.show(context);
            }
        };
    }

    protected void initNavigatorWindow(DefaultNavigatorWindow navigator, Context context, ViewId viewId) {
        super.initNavigatorWindow(navigator, context, viewId);
        navigator.getContextMenu().addContextMenuListener(new ContextMenuListener(){
            private VersioningConnectController _controller;

            public void menuWillShow(ContextMenu contextMenu) {
                Node node = contextMenu.getContext().getNode();
                if (VersioningNavigatorManager.this._rootFolder.getChildren().hasNext() && (node == null || !this.isChildOfRoot(node))) {
                    return;
                }
                for (VersioningRegistration registration : VersioningRegistrations.getInstance().getRegistrations()) {
                    if (!registration.isConnectionNodeVisible() || ConnectionProviderRegistry.getInstance().lookupProvider(registration.getExtensionID()) != null) continue;
                    int cmdId = Ide.findOrCreateCmdID((String)(registration.getExtensionID() + ".VersioningNavigator.Connect"));
                    IdeAction connectAction = IdeAction.find((int)cmdId);
                    if (connectAction == null) {
                        connectAction = IdeAction.findOrCreate((int)cmdId, null, (String)Bundle.format("CONNECT_TO_VCS", registration.getVcsName()), (String)registration.getVcsName(), null, null, null, (boolean)true);
                        connectAction.putValue("VCS", (Object)registration.getExtensionID());
                        if (this._controller == null) {
                            this._controller = new VersioningConnectController();
                        }
                        connectAction.addController((Controller)this._controller);
                    }
                    JMenuItem item = Ide.getMenubar().createMenuItem((ToggleAction)connectAction);
                    float weight = registration.getComputedWeight();
                    item.putClientProperty("menu-weight", Float.valueOf(weight));
                    contextMenu.add((Component)item, 100.1f);
                }
            }

            public void menuWillHide(ContextMenu contextMenu) {
            }

            public boolean handleDefaultAction(Context context) {
                return false;
            }

            private final boolean isChildOfRoot(Node node) {
                Iterator itr = VersioningNavigatorManager.this._rootFolder.getChildren();
                while (itr.hasNext()) {
                    if (itr.next() != node) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public static final VersioningNavigatorManager getInstance() {
        VersioningNavigatorManager navMgr = (VersioningNavigatorManager)((Object)Names.lookup((javax.naming.Context)Names.newInitialContext(), (String)VERSIONING_NAV_NAME));
        if (navMgr == null) {
            if (Ide.getIdeArgs().getCreateUI()) {
                navMgr = (VersioningNavigatorManager)((Object)SingletonProvider.find(VersioningNavigatorManager.class));
            }
            if (navMgr != null) {
                VersioningNavigatorManager.setInstance(navMgr);
            }
        }
        return navMgr;
    }

    public static void setInstance(VersioningNavigatorManager navMgr) {
        Names.bind((javax.naming.Context)Names.newInitialContext(), (String)VERSIONING_NAV_NAME, (Object)((Object)navMgr));
    }

    final DefaultContainer getRootFolder() {
        return this._rootFolder;
    }

    public String getViewCategory() {
        return NAVIGATOR_WINDOW_ID;
    }

    protected String getAcceleratorFile() {
        return "oracle/ideimpl/vcscore/nav/accelerators.xml";
    }

    public String getDefaultName() {
        return NAVIGATOR_DEFAULT_NAME;
    }

    protected IdeAction createShowNavigatorAction() {
        return IdeAction.find((int)VersioningNavigatorConstants.SHOW_NAVIGATOR_CMD_ID);
    }

    protected DockingParam createNavigatorDockingParam() {
        DockingParam param = new DockingParam();
        param.setPosition(0);
        return param;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_ideversioningnavigator_html");
    }

    protected NavigatorWindow createNavigatorWindow() {
        return this.createNavigatorWindow((Folder)this._rootFolder, false, 0);
    }

    protected void configureNavigator(NavigatorWindow navigator) {
        navigator.setType(32);
    }
}

