/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.pagingControl;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.JComponent;
import oracle.bali.ewt.pivot.PageItem;
import oracle.bali.ewt.pivot.PagingPivotEvent;
import oracle.bali.ewt.pivot.PagingPivotListener;
import oracle.bali.ewt.pivot.PivotEvent;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.datatransfer.TransferUtils;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.ControllerAdapter;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.dataView.ViewComponent;
import oracle.dss.dataView.ViewKeyListener;
import oracle.dss.dataView.ViewMouseMotionListener;
import oracle.dss.pagingControl.PageItemComponentHandle;
import oracle.dss.pagingControl.PagingComponent;
import oracle.dss.pagingControl.PagingControl;
import oracle.dss.pagingControl.PagingControlComponentHandle;
import oracle.dss.pagingControl.PagingControlController;
import oracle.dss.pagingControl.PagingControlEvent;
import oracle.dss.pagingControl.PagingControlListener;
import oracle.dss.pagingControl.PagingControlModel;
import oracle.dss.pagingControl.PagingControlTransferable;
import oracle.dss.util.DataException;

public class PagingControlControllerAdapter
extends ControllerAdapter
implements FocusListener,
KeyListener,
MouseListener,
MouseMotionListener,
PagingControlController,
PagingPivotListener {
    private static final long serialVersionUID = 1L;
    protected int viewKeyListenerCount = 0;
    protected int viewMouseMotionListenerCount = 0;
    private PagingControl _pagingControl;
    private boolean _embedded;
    private PagingControlModel _pagingControlModel;
    private PagingComponent _pagingComponent;
    private ComponentHandle _selectedObject;
    private PagingControlDragListener _dragListener;
    private DropTargetListener _dropListener;
    private boolean _pagingControlSelected = false;
    private PagingControl _dragComponent;
    private static final String _DRAG_GESTURE_RECOGNIZER = "oracle.dss.pagingControl.PagingControlController.DRAG_GESTURE_RECOGNIZER";

    public PagingControlControllerAdapter(PagingControl pc, boolean embedded) {
        super(pc);
        this._pagingControl = pc;
        this._embedded = embedded;
        this._pagingControlModel = pc.getPagingControlModel();
        this._pagingComponent = pc.getPagingComponent();
        this.addPagingControlListeners();
    }

    private void addPagingControlListeners() {
        if (!this._embedded) {
            this._pagingControl.addFocusListener(this);
            this._pagingControl.addMouseListener(this);
            this._pagingControl.addMouseMotionListener(this);
            this._pagingControl.addKeyListener(this);
            if (this._pagingComponent != null) {
                this._pagingComponent.addPivotListener(this);
            }
            if (this._pagingControl.isDragEnabled()) {
                this.enableDrag();
            }
        }
    }

    private void removePagingControlListeners() {
        if (!this._embedded) {
            this._pagingControl.removeFocusListener(this);
            this._pagingControl.removeMouseListener(this);
            this._pagingControl.removeMouseMotionListener(this);
            this._pagingControl.removeKeyListener(this);
            this._pagingComponent.removePivotListener(this);
            if (this._pagingControl.isDragEnabled()) {
                this.disableDrag();
            }
        }
    }

    @Override
    public void cleanUp() {
        this.removePagingControlListeners();
    }

    protected ComponentHandle getComponentFromPagingControl(Object source) {
        if (source instanceof PageItem) {
            return this.createComponentFromPageItem(source);
        }
        return this.createComponentFromPagingControl((ViewComponent)source);
    }

    @Override
    protected ComponentHandle createComponentFromPageItem(Object source) {
        PageItem pi = (PageItem)source;
        PagingComponent pc = this._pagingControl.getPagingComponent();
        return new PageItemComponentHandle(4, "PageItem", source, pc.getIndex(pi));
    }

    protected ComponentHandle createComponentFromPagingControl(ViewComponent c) {
        return new PagingControlComponentHandle(c.getID(), c.getComponentName(), c);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseEvent = e;
        if (this.viewMouseMotionListenerCount == 0) {
            return;
        }
        ComponentHandle ch = this.getComponentFromPagingControl(e.getSource());
        this.processViewMouseMotionEvent(e, ch);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseEvent = e;
        if (this.viewMouseMotionListenerCount == 0) {
            return;
        }
        ComponentHandle ch = this.getComponentFromPagingControl(e.getSource());
        this.processViewMouseMotionEvent(e, ch);
    }

    @Override
    public void addViewMouseMotionListener(ViewMouseMotionListener l) {
        super.addViewMouseMotionListener(l);
        this.viewMouseMotionListenerCount = this.listenerList.getListenerCount(ViewMouseMotionListener.class);
    }

    @Override
    public void removeViewMouseMotionListener(ViewMouseMotionListener l) {
        super.removeViewMouseMotionListener(l);
        this.viewMouseMotionListenerCount = this.listenerList.getListenerCount(ViewMouseMotionListener.class);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (this.viewKeyListenerCount == 0) {
            return;
        }
        ComponentHandle ch = this.getComponentFromPagingControl(e.getSource());
        this.processViewKeyEvent(e, ch);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.viewKeyListenerCount == 0) {
            return;
        }
        ComponentHandle ch = this.getComponentFromPagingControl(e.getSource());
        this.processViewKeyEvent(e, ch);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.viewKeyListenerCount == 0) {
            return;
        }
        ComponentHandle ch = this.getComponentFromPagingControl(e.getSource());
        this.processViewKeyEvent(e, ch);
    }

    @Override
    public void addViewKeyListener(ViewKeyListener l) {
        super.addViewKeyListener(l);
        this.viewKeyListenerCount = this.listenerList.getListenerCount(ViewKeyListener.class);
    }

    @Override
    public void removeViewKeyListener(ViewKeyListener l) {
        super.removeViewKeyListener(l);
        this.viewKeyListenerCount = this.listenerList.getListenerCount(ViewKeyListener.class);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.mouseEvent = e;
        ComponentHandle ch = this.getComponentFromPagingControl(e.getSource());
        this.processViewMouseEvent(e, ch);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseEvent = e;
        ComponentHandle ch = this.getComponentFromPagingControl(e.getSource());
        this.processViewMouseEvent(e, ch);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseEvent = e;
        ComponentHandle ch = this.getComponentFromPagingControl(e.getSource());
        this.processViewMouseEvent(e, ch);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseEvent = e;
        ComponentHandle ch = this.getComponentFromPagingControl(e.getSource());
        this.processViewMouseEvent(e, ch);
        if (this.fireComponentSelecting(this._pagingControl, ch)) {
            this.setSelectedObject(ch);
        }
        if (e.getSource() instanceof PagingControl && this._pagingControl.isDragEnabled()) {
            this._pagingControlSelected = true;
            this._pagingControl.setBackground(this._pagingComponent.getSelectionColor());
            this._pagingComponent.getItem(0).requestFocus();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mouseEvent = e;
        ComponentHandle ch = this.getComponentFromPagingControl(e.getSource());
        this.processViewMouseEvent(e, ch);
    }

    @Override
    public void focusGained(FocusEvent e) {
        ComponentHandle ch = this.getComponentFromPagingControl(e.getSource());
        this.processViewFocusEvent(e, ch);
    }

    @Override
    public void focusLost(FocusEvent e) {
        ComponentHandle ch = this.getComponentFromPagingControl(e.getSource());
        this.processViewFocusEvent(e, ch);
        if (!e.isTemporary() && this._pagingControlSelected) {
            this._pagingControlSelected = false;
            this._pagingControl.setOpaque(true);
            this._pagingControl.setBackground(null);
        }
    }

    @Override
    public void setSelectedObject(ComponentHandle c) {
        PageItemComponentHandle pic;
        int pi;
        this._selectedObject = c;
        if (c instanceof PageItemComponentHandle && (pi = (pic = (PageItemComponentHandle)c).getPageItem()) >= 0) {
            this._pagingComponent.setSelectedItem(this._pagingComponent.getItem(pi));
        }
        this.fireComponentSelected(this._pagingControl, c);
    }

    @Override
    public ComponentHandle getSelectedObject() {
        return this._selectedObject;
    }

    public void pivot(PagingPivotEvent e) {
        PivotEvent pe = new PivotEvent(e.getSource(), e.getID(), e.getDestination(), e.getSourceIndex(), e.getDestinationIndex());
        this._pivot(pe);
    }

    public void swap(PagingPivotEvent e) {
        PivotEvent pe = new PivotEvent(e.getSource(), e.getID(), e.getDestination(), e.getSourceIndex(), e.getDestinationIndex());
        this._swap(pe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _pivot(PivotEvent e) {
        try {
            int flags = 0;
            int sourceIndex = e.getSourceIndex();
            int destinationIndex = e.getDestinationIndex();
            flags = sourceIndex < destinationIndex ? 3 : 2;
            this.setCursor(WindowUtils.getWindow((Component)this._pagingControl), this.getCursorType(2));
            if (this._pagingControlModel.getControllerActions().canPivot(this._pagingControl, this._getSourceEdge(e), 2, sourceIndex, destinationIndex, flags)) {
                this._pagingControlModel.getControllerActions().pivotGestureHappened(this._pagingControl, this._getSourceEdge(e), 2, sourceIndex, destinationIndex, flags);
            }
        }
        catch (DataException exception) {
            this._pagingControl.getErrorHandler().error((Throwable)exception, this.getClass().getName(), "pivot");
        }
        finally {
            this.setCursor(WindowUtils.getWindow((Component)this._pagingControl), this.getCursorType(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _swap(PivotEvent e) {
        try {
            int sourceIndex = e.getSourceIndex();
            int destinationIndex = e.getDestinationIndex();
            this.setCursor(WindowUtils.getWindow((Component)this._pagingControl), this.getCursorType(2));
            if (this._pagingControlModel.getControllerActions().canPivot(this._pagingControl, this._getSourceEdge(e), 2, sourceIndex, destinationIndex, 1)) {
                this._pagingControlModel.getControllerActions().pivotGestureHappened(this._pagingControl, this._getSourceEdge(e), 2, sourceIndex, destinationIndex, 1);
            }
        }
        catch (DataException exception) {
            this._pagingControl.getErrorHandler().error((Throwable)exception, this.getClass().getName(), "swap");
        }
        finally {
            this.setCursor(WindowUtils.getWindow((Component)this._pagingControl), this.getCursorType(0));
        }
    }

    private int _getSourceEdge(PivotEvent e) {
        if (e.getSource() instanceof PagingComponent) {
            return 2;
        }
        return e.getSourcePivotHeader().getOrientation() == 0 ? 0 : 1;
    }

    @Override
    public void setCursor(Component component, Cursor c) {
        DataviewUtils.setCursor(component, c);
    }

    @Override
    public DropTargetListener getDropTargetListener() {
        return this._dropListener;
    }

    @Override
    public void enableDrag() {
        this._dragListener = new PagingControlDragListener();
        this._dropListener = new PagingControlDropTargetListener();
        DragGestureRecognizer _recognizer = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this._pagingControl, 2, this._dragListener);
        this._pagingControl.putClientProperty(_DRAG_GESTURE_RECOGNIZER, _recognizer);
    }

    @Override
    public void disableDrag() {
        Object o = this._pagingControl.getClientProperty(_DRAG_GESTURE_RECOGNIZER);
        if (o instanceof DragGestureRecognizer) {
            DragGestureRecognizer r = (DragGestureRecognizer)o;
            r.setComponent(null);
            r.removeDragGestureListener(this._dragListener);
        }
        this._pagingControl.putClientProperty(_DRAG_GESTURE_RECOGNIZER, null);
        this._dragListener = null;
        this._dropListener = null;
    }

    @Override
    public void addPagingControlListener(PagingControlListener l) {
        this.listenerList.add(PagingControlListener.class, l);
    }

    @Override
    public void removePagingControlListener(PagingControlListener l) {
        this.listenerList.remove(PagingControlListener.class, l);
    }

    protected void fireDropEvent(Object source, Object destination) {
        PagingControlEvent e = new PagingControlEvent(source, destination);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PagingControlListener.class) continue;
            ((PagingControlListener)listeners[i + 1]).dropEvent(e);
        }
    }

    @Override
    protected boolean fireComponentSelecting(Object source, ComponentHandle id) {
        return super.fireComponentSelecting(source, id);
    }

    @Override
    protected void fireComponentSelected(Object source, ComponentHandle id) {
        super.fireComponentSelected(source, id);
    }

    PagingControl getPagingControl(Component c) {
        if (c == null) {
            return null;
        }
        if (c instanceof PagingControl) {
            return (PagingControl)c;
        }
        return null;
    }

    class PagingControlDragListener
    extends DragSourceAdapter
    implements DragGestureListener {
        private boolean _dragging;
        private int _dragAction = 2;

        PagingControlDragListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent e) {
            Point origin = e.getDragOrigin();
            Component c = e.getComponent();
            PagingControl pc = PagingControlControllerAdapter.this.getPagingControl(c);
            if (pc != null && PagingControlControllerAdapter.this._pagingControlSelected) {
                BufferedImage dragImage = pc.getDragImage();
                PagingControlControllerAdapter.this._dragComponent = pc;
                PagingControlControllerAdapter.this._dragComponent.setDragging(true);
                Transferable t = PagingControlTransferable.createTransferable(PagingControlControllerAdapter.this._dragComponent);
                try {
                    e.startDrag(null, dragImage, new Point(-origin.x, -origin.y), t, PagingControlControllerAdapter.this._dragListener);
                }
                catch (InvalidDnDOperationException idoe) {
                    PagingControlControllerAdapter.this._pagingControl.getErrorHandler().log("invalid DnD operation", this.getClass().getName(), "dragGestureRecognized()");
                }
            }
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            if (!dsde.getDropSuccess()) {
                return;
            }
            if (PagingControlControllerAdapter.this._dragComponent != null && dsde.getDropAction() == 2) {
                PagingControlControllerAdapter.this._dragComponent.setDragging(false);
                PagingControlControllerAdapter.this._dragComponent = null;
            }
        }
    }

    class PagingControlDropTargetListener
    implements DropTargetListener {
        private Rectangle2D _raImage = new Rectangle2D.Float();
        private BufferedImage _image;

        PagingControlDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            if (!this.acceptDrag(e)) {
                e.rejectDrag();
                return;
            }
            e.acceptDrag(e.getDropAction());
        }

        @Override
        public void dragExit(DropTargetEvent e) {
            Component c = e.getDropTargetContext().getComponent();
            JComponent jc = (JComponent)c;
            jc.repaint();
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            if (!this.acceptDrag(e)) {
                e.rejectDrag();
                return;
            }
            e.acceptDrag(e.getDropAction());
            Component c = e.getDropTargetContext().getComponent();
            Point p = e.getLocation();
            JComponent jc = (JComponent)c;
            Graphics2D g2 = (Graphics2D)jc.getGraphics();
            BufferedImage _imgGhost = PagingControlControllerAdapter.this._pagingControl.getDragImage();
            jc.paintImmediately(this._raImage.getBounds());
            this._raImage.setRect(p.x, p.y, _imgGhost.getWidth(), _imgGhost.getHeight());
            g2.drawImage(_imgGhost, AffineTransform.getTranslateInstance(this._raImage.getX(), this._raImage.getY()), null);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
            if (!this.acceptDrag(dtde)) {
                dtde.rejectDrag();
                return;
            }
            dtde.acceptDrag(dtde.getDropAction());
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            if (!this.acceptDrop(e)) {
                e.rejectDrop();
                return;
            }
            e.acceptDrop(e.getDropAction());
            Component c = e.getDropTargetContext().getComponent();
            JComponent jc = (JComponent)c;
            jc.repaint();
            Transferable transfer = e.getTransferable();
            Object data = null;
            try {
                data = transfer.getTransferData(PagingControlTransferable.pagingControlFlavor);
            }
            catch (IOException ioe) {
                data = null;
                e.dropComplete(false);
                return;
            }
            catch (UnsupportedFlavorException ufe) {
                data = null;
                e.dropComplete(false);
                return;
            }
            boolean success = false;
            if (data != null && data instanceof PagingControlTransferable) {
                PagingControlTransferable pct = (PagingControlTransferable)data;
                Object source = pct.getSource();
                PagingControlControllerAdapter.this.fireDropEvent(source, c);
                success = true;
            }
            e.dropComplete(success);
        }

        protected boolean acceptDrag(DropTargetDragEvent e) {
            DataFlavor[] flavors = e.getCurrentDataFlavors();
            if (flavors == null) {
                return false;
            }
            for (int i = 0; i < flavors.length; ++i) {
                if (!TransferUtils.supportsDataFlavor((DataFlavor)flavors[i], (DataFlavor)PagingControlTransferable.pagingControlFlavor)) continue;
                return true;
            }
            return false;
        }

        protected boolean acceptDrop(DropTargetDropEvent e) {
            DataFlavor[] flavors = e.getCurrentDataFlavors();
            if (flavors == null) {
                return false;
            }
            for (int i = 0; i < flavors.length; ++i) {
                if (!TransferUtils.supportsDataFlavor((DataFlavor)flavors[i], (DataFlavor)PagingControlTransferable.pagingControlFlavor)) continue;
                return true;
            }
            return false;
        }
    }
}

