/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.legend.impl;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import oracle.dss.legend.LegendItem;
import oracle.dss.legend.LegendOrientation;
import oracle.dss.legend.LegendScrolling;
import oracle.dss.legend.LegendSection;
import oracle.dss.legend.impl.LegendContext;
import oracle.dss.legend.impl.ListLegend;
import oracle.dss.util.shapes.DrawableObject;
import oracle.dss.util.shapes.Line;

public class LegendArea
extends LegendSection {
    Graphics m_graphics;
    Font m_font;
    protected int m_columnCount = 1;
    protected int m_columnWidth = 0;
    protected int m_initHeight = 0;

    public LegendArea(Rectangle bounds, Graphics g, Font font) {
        this.m_x = bounds.x;
        this.m_y = bounds.y;
        this.m_width = bounds.width;
        this.m_height = bounds.height;
        this.m_graphics = g;
        this.m_font = font;
    }

    public ListLegend createListSection() {
        ListLegend section = new ListLegend();
        section.setLocale(this.getLocale());
        this.addItem(section);
        return section;
    }

    @Override
    public void calc() {
        boolean useInitialAlloc;
        boolean isHoriz;
        LegendContext.setContext(new LegendContext(this.m_graphics, this.m_font));
        int curr_h = 0;
        int curr_w = 0;
        int titleHeight = 0;
        int titleWidth = 0;
        boolean bl = isHoriz = this.m_orientation == LegendOrientation.HORIZONTAL;
        if (this.m_title != null) {
            this.m_title.setWidth(this.m_width);
            this.m_title.calc();
            curr_h = 4 + this.m_title.getHeight();
            titleHeight = this.m_title.getHeight() + 4;
            titleWidth = this.m_title.getWidth() + 8;
            if (!isHoriz) {
                curr_w = titleWidth;
            }
        }
        int allocSpace = !isHoriz ? this.m_height - titleHeight - 8 : this.m_width;
        allocSpace = allocSpace / this.m_items.size() - 8;
        int unusedSpaceSum = 0;
        ArrayList<LegendItem> recalcItems = new ArrayList<LegendItem>();
        ArrayList<Integer> reqSpaceList = new ArrayList<Integer>();
        int diffSpaceSum = 0;
        if (isHoriz) {
            this.m_columnCount = this.m_items.size();
        }
        for (int i = 0; i < this.m_items.size(); ++i) {
            int diffSpace;
            LegendItem item = (LegendItem)this.m_items.get(i);
            if (!isHoriz) {
                item.setWidth(this.m_width - 8);
                item.setHeight(allocSpace);
            } else {
                item.setWidth(allocSpace);
                item.setHeight(this.m_height - 8);
            }
            item.calc();
            int itemHeight = item.getHeight() + 8;
            int itemWidth = item.getWidth() + 8;
            if (!isHoriz) {
                curr_h += itemHeight;
                curr_w = Math.max(curr_w, itemWidth);
                diffSpace = allocSpace - itemHeight;
            } else {
                int newHeight = titleHeight + itemHeight;
                if (newHeight <= this.m_height) {
                    curr_h = Math.max(curr_h, newHeight);
                }
                curr_w += itemWidth;
                diffSpace = this.m_height - titleHeight - itemHeight;
            }
            if (diffSpace < 0) {
                int j;
                int reqSpace = Math.abs(diffSpace);
                for (j = 0; j < reqSpaceList.size() && reqSpace >= (Integer)reqSpaceList.get(j); ++j) {
                }
                recalcItems.add(j, item);
                reqSpaceList.add(j, reqSpace);
                diffSpaceSum += reqSpace;
            } else if (!isHoriz) {
                unusedSpaceSum += diffSpace;
            }
            if (!isHoriz || allocSpace <= item.getWidth()) continue;
            unusedSpaceSum += allocSpace - item.getWidth();
        }
        boolean bl2 = useInitialAlloc = unusedSpaceSum == 0 && diffSpaceSum > 0;
        if (!isHoriz && unusedSpaceSum < diffSpaceSum && this.m_scrolling != LegendScrolling.AUTO || isHoriz && diffSpaceSum > 0) {
            for (int i = 0; i < recalcItems.size(); ++i) {
                LegendItem item = (LegendItem)recalcItems.get(i);
                if (!(item instanceof ListLegend)) continue;
                if (!isHoriz) {
                    int reqSpace = (Integer)reqSpaceList.get(i);
                    if (reqSpace <= unusedSpaceSum) {
                        unusedSpaceSum -= reqSpace;
                        continue;
                    }
                    int finalSpace = useInitialAlloc ? allocSpace : item.getHeight() - reqSpace + unusedSpaceSum;
                    unusedSpaceSum = 0;
                    curr_h -= item.getHeight();
                    item.setHeight(finalSpace);
                    item.setWidth(this.m_width - 8);
                    item.calcFinal();
                    curr_w = Math.max(curr_w, item.getWidth() + 8);
                    curr_h += item.getHeight();
                    if (item.getHeight() >= finalSpace) continue;
                    unusedSpaceSum += finalSpace - item.getHeight();
                    continue;
                }
                curr_w -= item.getWidth();
                item.setWidth(unusedSpaceSum += item.getWidth());
                item.setHeight(this.m_height - titleHeight - 8);
                item.calcFinal();
                curr_w += item.getWidth();
                int newHeight = titleHeight + item.getHeight() + 8;
                if (newHeight <= this.m_height) {
                    curr_h = Math.max(curr_h, newHeight);
                }
                unusedSpaceSum -= item.getWidth();
            }
        }
        curr_w = Math.max(titleWidth, curr_w);
        this.m_columnWidth = this.m_width = Math.min(this.m_width, curr_w);
        this.m_height = !isHoriz && this.m_scrolling == LegendScrolling.AUTO ? curr_h : Math.min(this.m_height, curr_h);
        this.m_initHeight = this.m_height;
        LegendContext.release();
    }

    @Override
    public void calcFinal() {
        int allocWidth = this.m_columnWidth;
        int maxColumns = this.m_width / allocWidth;
        boolean maxColHeight = false;
        while (this.m_columnCount < maxColumns) {
            ++this.m_columnCount;
            if (this.m_columnCount * this.m_height <= this.m_initHeight) continue;
        }
        this.m_width = this.m_columnCount * this.m_columnWidth;
    }

    @Override
    public List<DrawableObject> render() {
        ArrayList<DrawableObject> section = new ArrayList<DrawableObject>();
        oracle.dss.util.shapes.Rectangle box = new oracle.dss.util.shapes.Rectangle(this.m_x, this.m_y, this.m_width, this.m_height);
        box.setProperty("L_ID", this.m_id);
        section.add(box);
        int curr_x = this.m_x;
        int curr_y = this.m_y;
        int titleHeight = 0;
        curr_x += 4;
        curr_y += 4;
        if (this.m_title != null) {
            titleHeight = this.m_title.getHeight() + 4;
            int titleX = curr_x;
            int titleWidth = this.m_title.getWidth();
            if (titleWidth + 8 <= this.m_width) {
                titleX = curr_x + this.m_width / 2 - titleWidth / 2;
            }
            this.m_title.setPosition(titleX, curr_y);
            section.addAll(this.m_title.render());
            curr_y += titleHeight;
        }
        if (this.m_columnCount == 1) {
            for (int i = 0; i < this.m_items.size(); ++i) {
                if (i > 0) {
                    Line line = new Line(this.m_x + 1, curr_y, this.m_x + this.m_width, curr_y);
                    line.setProperty("L_ID", this.m_id);
                    section.add(line);
                    curr_y += 4;
                }
                LegendItem item = (LegendItem)this.m_items.get(i);
                int itemX = curr_x;
                if (this.isBiDiLocale()) {
                    int offset = curr_x - this.m_x;
                    itemX = this.m_x + this.m_width - offset - item.getWidth();
                }
                item.setPosition(itemX, curr_y);
                section.addAll(item.render());
                curr_y += item.getHeight() + 4;
            }
        } else {
            int curr_col = 1;
            int init_x = curr_x;
            int init_y = curr_y;
            for (int i = 0; i < this.m_items.size(); ++i) {
                LegendItem item = (LegendItem)this.m_items.get(i);
                item.setPosition(curr_x, curr_y);
                section.addAll(item.render());
                if (++curr_col % this.m_columnCount == 1) {
                    curr_y += item.getHeight() + 4;
                    curr_x = init_x;
                    continue;
                }
                curr_y = init_y;
                Line line = new Line(curr_x += item.getWidth() + 4, init_y - 4 + 1, curr_x, init_y - 4 + this.m_height - titleHeight);
                line.setProperty("L_ID", this.m_id);
                section.add(line);
                curr_x += 4;
            }
        }
        return section;
    }
}

