/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.model3d;

import java.awt.Point;
import java.awt.Polygon;
import oracle.dss.graph.pfj.JChart_3D;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.model3d.Model3DRectSolid;
import oracle.dss.graph.pfj.model3d.Point3d;

public class Model3DCubeWall
extends Model3DRectSolid {
    private static final long serialVersionUID = 1L;
    public static final int FLOOR = 0;
    public static final int LWALL = 1;
    public static final int RWALL = 2;
    public static final int DRAW_NEVER = 0;
    public static final int DRAW_BEFORE = 1;
    public static final int DRAW_AFTER = 2;
    protected int m_nDisplayWhen;
    protected Polygon m_projectedVertices = null;

    public Model3DCubeWall(JChart_3D chart, IdentObj id, BlackBoxIF bb, Point3d origin, Point3d size, boolean[][] bGridStatus, boolean bAutoshading) {
        super(chart, id, bb, origin, size, bGridStatus, bAutoshading, false);
    }

    public void calcDisplayWhen(boolean bDisplay, int faceBehindRisers) {
        this.m_nDisplayWhen = 0;
        if (bDisplay) {
            this.m_nDisplayWhen = this.visibility(faceBehindRisers) > 0.0 ? 1 : 2;
        }
    }

    public void postDisplay() {
        if (this.m_nDisplayWhen == 2) {
            this.display();
        }
    }

    public void preDisplay() {
        if (this.m_nDisplayWhen == 1) {
            this.display();
        }
    }

    @Override
    public void display() {
        super.display();
        this.saveProjectedPoints();
    }

    public void saveProjectedPoints() {
        this.transformVertices();
        this.m_projectedVertices = new Polygon();
        for (int i = 0; i < this.m_nVertices; ++i) {
            Point pt = this.m_chart.projectPoint3d(this.m_xVertices[i]);
            this.m_projectedVertices.addPoint(pt.x, pt.y);
        }
    }

    public Polygon getProjectedVertices() {
        if (this.m_projectedVertices == null) {
            this.saveProjectedPoints();
        }
        return this.m_projectedVertices;
    }
}

