/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.math;

import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.math.CurveFitIF;

public class FitPolynomial
implements CurveFitIF {
    private static final int MAX_ORDER = 10;
    private int m_nOrder;

    public FitPolynomial(int nOrder) throws AssertionException {
        PfjAssert.pfjAssert(nOrder >= 1 && nOrder <= 10);
        this.m_nOrder = nOrder;
    }

    @Override
    public double compute(double x, double[] a) throws AssertionException {
        PfjAssert.pfjAssert(a.length >= this.m_nOrder + 1 + 1);
        double y = a[1];
        for (int i = 1; i <= this.m_nOrder; ++i) {
            y += a[i + 1] * Math.pow(x, i);
        }
        return y;
    }

    @Override
    public void eval(double x, double[] a) throws AssertionException {
        PfjAssert.pfjAssert(a.length >= this.m_nOrder + 1 + 1);
        double product = 1.0;
        for (int i = 1; i <= this.m_nOrder + 1; ++i) {
            a[i] = product;
            product *= x;
        }
    }

    @Override
    public int numCoeffs() {
        return this.m_nOrder + 1;
    }

    @Override
    public double transformY(double y) {
        return y;
    }

    @Override
    public double invTransformCoeff(int ia, double a) {
        return a;
    }

    @Override
    public String createEquation(String[] strCoeffs, boolean bHighOrderFirst) throws AssertionException {
        String strEquation;
        PfjAssert.pfjAssert(strCoeffs.length >= this.m_nOrder + 1 + 1);
        if (bHighOrderFirst) {
            strEquation = strCoeffs[2] + " * x + " + strCoeffs[1];
            for (int i = 3; i <= this.m_nOrder + 1; ++i) {
                strEquation = strCoeffs[i] + " * x^" + (i - 1) + " + " + strEquation;
            }
        } else {
            strEquation = strCoeffs[1] + " + " + strCoeffs[2] + " * x";
            for (int i = 3; i <= this.m_nOrder + 1; ++i) {
                strEquation = strEquation + " + " + strCoeffs[i] + " * x^" + (i - 1);
            }
        }
        return strEquation;
    }
}

