/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.math;

import oracle.javatools.mt.annotation.CodeSharingSafe;

public final class FP {
    @CodeSharingSafe(value="StaticField")
    public static final double TOLERANCE = Math.exp(-24.0);

    public static boolean equal(double a, double b) {
        return Math.abs(a - b) <= TOLERANCE;
    }

    public static boolean nonzero(double a) {
        return !FP.equal(a, 0.0);
    }

    public static boolean greaterThan(double a, double b) {
        return a - b > TOLERANCE;
    }

    public static boolean lessThan(double a, double b) {
        return a - b < -TOLERANCE;
    }

    public static boolean between(double a, double min, double max) {
        return FP.greaterThan(a, min) && FP.lessThan(a, max);
    }

    public static double pythag(double a, double b) {
        double result;
        double bt;
        double at = Math.abs(a);
        if (at > (bt = Math.abs(b))) {
            double ct = bt / at;
            result = at * Math.sqrt(1.0 + ct * ct);
        } else if (bt != 0.0) {
            double ct = at / bt;
            result = bt * Math.sqrt(1.0 + ct * ct);
        } else {
            result = 0.0;
        }
        return result;
    }

    public static int round(double a) {
        return (int)Math.floor(a + 0.5);
    }

    public static double sigDigits(double dVal, int significantDigits) {
        int excessDigitValue;
        boolean Neg;
        String theValueString = Double.toString(dVal);
        if (significantDigits < 0) {
            significantDigits = 0;
        }
        int excessDigit = significantDigits;
        boolean Decimal = theValueString.indexOf(".") != -1;
        boolean bl = Neg = dVal < 0.0;
        if (Decimal) {
            ++excessDigit;
        }
        if (Neg) {
            ++excessDigit;
        }
        if (theValueString.length() < excessDigit) {
            return dVal;
        }
        Object excessFractionString = theValueString.substring(excessDigit, theValueString.length());
        excessFractionString = "0." + (String)excessFractionString;
        double excessFractionValue = Double.parseDouble((String)excessFractionString);
        Object significanceAdder = "0.";
        for (int i = 1; i < significantDigits; ++i) {
            significanceAdder = (String)significanceAdder + "0";
        }
        significanceAdder = (String)significanceAdder + "5";
        double returnValue = dVal;
        if (excessFractionValue > 0.5) {
            returnValue = Neg ? dVal - Double.parseDouble((String)significanceAdder) : dVal + Double.parseDouble((String)significanceAdder);
        } else if (FP.equal(excessFractionValue, 0.5) && (excessDigitValue = Integer.parseInt(theValueString.substring(excessDigit - 1, excessDigit))) % 2 != 0) {
            returnValue = Neg ? dVal - Double.parseDouble((String)significanceAdder) : dVal + Double.parseDouble((String)significanceAdder);
        }
        return returnValue;
    }
}

