/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import oracle.dss.graph.GraphStyleManager;
import oracle.dss.graph.managers.GraphStyle;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BorderObj;
import oracle.dss.graph.pfj.draw.FillGradientObj;
import oracle.dss.graph.pfj.draw.FillObj;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;

public class SimpleBlackBoxObj
implements BlackBoxIF,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Perspective m_Perspective;
    private IdentObj m_id;
    private boolean m_bTransparentBorderColor;
    private boolean m_bTransparentFillColor;
    private Color m_borderColor;
    private Color m_fillColor;
    private boolean m_bHidden;

    public SimpleBlackBoxObj(Perspective p, IdentObj id, boolean bWantRiserBorder) {
        this.m_Perspective = p;
        this.m_id = id;
        this.m_bTransparentBorderColor = !bWantRiserBorder || this.m_Perspective.getTransparentBorderColor(id);
        this.m_bTransparentFillColor = this.m_Perspective.getTransparentFillColor(id);
        this.m_borderColor = this.m_bTransparentBorderColor ? null : this.m_Perspective.getBorderColor(id);
        this.m_fillColor = this.m_bTransparentFillColor ? null : this.m_Perspective.getFillColor(id);
        this.m_bHidden = false;
    }

    public SimpleBlackBoxObj(Perspective p) {
        this.m_Perspective = p;
        this.m_bTransparentBorderColor = true;
        this.m_bTransparentFillColor = true;
        this.m_borderColor = null;
        this.m_fillColor = null;
        this.m_bHidden = false;
    }

    public SimpleBlackBoxObj(SimpleBlackBoxObj bb) {
        this.copy(bb);
    }

    @Override
    public BlackBoxIF runRules(int seriesID, int groupID) {
        GraphStyle style = this.getGraphStyle(seriesID, groupID);
        if (style != null) {
            Color c = this.getFillColor();
            Color newColor = style.getFillColor();
            if (newColor != null && !c.equals(newColor)) {
                SimpleBlackBoxObj blackBox = new SimpleBlackBoxObj(this.m_Perspective);
                blackBox.copy(this);
                blackBox.setFillColor(newColor);
                return blackBox;
            }
        }
        return this;
    }

    @Override
    public GraphStyle getGraphStyle(int seriesID, int groupID) {
        GraphStyleManager styleManager;
        GraphStyle style = null;
        if (this.m_Perspective != null && this.m_id != null && (styleManager = this.m_Perspective.getStyleManager()) != null && styleManager.getBundles() != null) {
            style = styleManager.getGraphComponentStyle(this.m_Perspective.getCommonGraph(), seriesID, groupID);
        }
        return style;
    }

    public void copy(SimpleBlackBoxObj bb) {
        this.m_Perspective = bb.m_Perspective;
        this.m_id = bb.m_id;
        this.m_bTransparentBorderColor = bb.m_bTransparentBorderColor;
        this.m_bTransparentFillColor = bb.m_bTransparentFillColor;
        this.m_borderColor = bb.m_borderColor;
        this.m_fillColor = bb.m_fillColor;
        this.m_bHidden = bb.m_bHidden;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleBlackBoxObj)) {
            return false;
        }
        SimpleBlackBoxObj bb2 = (SimpleBlackBoxObj)obj;
        boolean bEqual = this.m_bTransparentBorderColor == bb2.m_bTransparentBorderColor && this.m_bTransparentFillColor == bb2.m_bTransparentFillColor && this.m_borderColor.equals(bb2.m_borderColor) && this.m_fillColor.equals(bb2.m_fillColor);
        this.m_borderColor.equals(bb2.m_borderColor);
        return bEqual;
    }

    @Override
    public Color getBorderColor() {
        return this.m_borderColor;
    }

    @Override
    public Color getFillColor() {
        return this.m_fillColor;
    }

    @Override
    public int getFillType() {
        return 1;
    }

    @Override
    public void setFillType(int type) {
    }

    @Override
    public FillObj getFillObj() {
        return null;
    }

    @Override
    public BorderObj getBorderObj() {
        return null;
    }

    @Override
    public void setFillGradientObj(FillGradientObj fillGradientObj) {
    }

    @Override
    public void setBorderGradientObj(FillGradientObj fillGradientObj) {
    }

    @Override
    public boolean getTransparentBorderColor() {
        return this.m_bTransparentBorderColor;
    }

    @Override
    public boolean getTransparentFillColor() {
        return this.m_bTransparentFillColor;
    }

    @Override
    public void setTransparentFillColor(boolean bTransparent) {
        this.m_bTransparentFillColor = bTransparent;
    }

    @Override
    public void setTransparentBorderColor(boolean bTransparent) {
        this.m_bTransparentBorderColor = bTransparent;
    }

    @Override
    public boolean isHidden() {
        return this.m_bHidden;
    }

    @Override
    public void setHidden(boolean hidden) {
        this.m_bHidden = hidden;
    }

    @Override
    public void paint(Graphics g, Point a, Point b) {
        if (!this.m_bTransparentBorderColor) {
            g.setColor(this.m_borderColor);
            g.drawLine(a.x, a.y, b.x, b.y);
        }
    }

    @Override
    public void paint(Graphics g, Rectangle rect, int type) {
    }

    @Override
    public void paint(Graphics g, Point a, Point b, int nThick) {
        if (!this.m_bTransparentBorderColor || !this.m_bTransparentFillColor) {
            double dx = b.x - a.x;
            double dy = b.y - a.y;
            double fNinetyRadians = 1.57;
            double fAngle = Math.atan2(dy, dx);
            double fTwoSeventyRadians = 4.71;
            double x = (double)nThick * Math.cos(fAngle + fNinetyRadians);
            double y = (double)nThick * Math.sin(fAngle + fNinetyRadians);
            double y2 = (double)(nThick / 2) * Math.sin(fAngle + fTwoSeventyRadians);
            double x2 = (double)(nThick / 2) * Math.cos(fAngle + fTwoSeventyRadians);
            Polygon pg = new Polygon();
            pg.addPoint(b.x + (int)Math.round(x2), b.y + (int)Math.round(y2));
            pg.addPoint(b.x + (int)Math.round(x) + (int)Math.round(x2), b.y + (int)Math.round(y) + (int)Math.round(y2));
            pg.addPoint(a.x + (int)Math.round(x) + (int)Math.round(x2), a.y + (int)Math.round(y) + (int)Math.round(y2));
            pg.addPoint(a.x + (int)Math.round(x2), a.y + (int)Math.round(y2));
            pg.addPoint(b.x + (int)Math.round(x2), b.y + (int)Math.round(y2));
            g.setColor(this.m_borderColor);
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(new BasicStroke(1.0f, 1, 1));
            g2.drawPolygon(pg.xpoints, pg.ypoints, pg.npoints);
            g.setColor(this.m_fillColor);
            g.fillPolygon(pg);
            g.fillOval(b.x - nThick / 2, b.y - nThick / 2, nThick, nThick);
        }
    }

    @Override
    public void paint(Graphics g, Point[] points, int nThick, int style, boolean isMarker, boolean is3D) {
        Stroke oldStroke = ((Graphics2D)g).getStroke();
        BasicStroke dashed = new BasicStroke(nThick, 0, 0);
        float dashLen = 10.0f;
        if (style != 0) {
            if (style == 1) {
                if (isMarker) {
                    dash1 = new float[]{4.0f, 2.0f, 4.0f};
                    dashLen = 2.0f;
                    nThick = 2;
                } else {
                    dash1 = new float[]{dashLen, dashLen / 2.0f};
                }
                dashed = new BasicStroke(nThick, 0, 0, dashLen, dash1, 0.0f);
            } else if (style == 2) {
                if (isMarker || nThick <= 1) {
                    nThick = 2;
                }
                dash1 = new float[]{nThick};
                dashed = new BasicStroke(nThick, 0, 0, 1.0f, dash1, 0.0f);
            } else if (style == 3) {
                if (isMarker) {
                    dash1 = new float[]{3.0f, 1.0f, 2.0f, 1.0f, 3.0f};
                    nThick = 2;
                } else {
                    dash1 = new float[]{dashLen, dashLen / 2.0f, nThick, dashLen / 2.0f};
                }
                dashed = new BasicStroke(nThick, 0, 0, 1.0f, dash1, 0.0f);
            }
        }
        int np = points.length;
        int[] x = new int[np];
        int[] y = new int[np];
        for (int i = 0; i < np; ++i) {
            x[i] = points[i].x;
            y[i] = points[i].y;
        }
        if (!this.m_bTransparentFillColor) {
            if (!is3D) {
                ((Graphics2D)g).setStroke(dashed);
                g.setColor(this.getFillColor());
                g.drawPolyline(x, y, np);
            } else {
                int i;
                nThick = nThick % 2 == 0 ? nThick++ : nThick;
                int shadowX = nThick <= 2 ? 1 : 2;
                shadowX = nThick == 1 ? 0 : shadowX;
                int shadowY = nThick / 2 + 1;
                dashed = new BasicStroke(nThick, 2, 1);
                for (i = 0; i < np; ++i) {
                    x[i] = points[i].x + shadowX;
                    y[i] = points[i].y - shadowY;
                }
                ((Graphics2D)g).setStroke(dashed);
                g.setColor(this._getBrighter(this.getFillColor()));
                g.drawPolyline(x, y, np);
                dashed = new BasicStroke(nThick, 2, 1);
                for (i = 0; i < np; ++i) {
                    x[i] = points[i].x;
                    y[i] = points[i].y;
                }
                ((Graphics2D)g).setStroke(dashed);
                g.setColor(this.getFillColor());
                g.drawPolyline(x, y, np);
            }
        }
        ((Graphics2D)g).setStroke(oldStroke);
    }

    @Override
    public void paint(Graphics g, Point a, Point b, int nThick, int style, boolean isMarker) {
        if (g instanceof Graphics2D) {
            Stroke oldStroke = ((Graphics2D)g).getStroke();
            BasicStroke dashed = new BasicStroke(nThick, 0, 0);
            float dashLen = 10.0f;
            if (style != 0) {
                if (style == 1) {
                    float[] dash1;
                    if (isMarker) {
                        dash1 = new float[]{4.0f, 2.0f, 4.0f};
                        dashLen = 2.0f;
                        nThick = 2;
                    } else {
                        dash1 = new float[]{dashLen, dashLen / 2.0f};
                    }
                    dashed = new BasicStroke(nThick, 0, 0, dashLen, dash1, 0.0f);
                } else if (style == 2) {
                    if (isMarker || nThick <= 1) {
                        nThick = 2;
                    }
                    float[] dash1 = new float[]{nThick};
                    dashed = new BasicStroke(nThick, 0, 0, 1.0f, dash1, 0.0f);
                } else if (style == 3) {
                    float[] dash1;
                    if (isMarker) {
                        dash1 = new float[]{3.0f, 1.0f, 2.0f, 1.0f, 3.0f};
                        nThick = 2;
                    } else {
                        dash1 = new float[]{dashLen, dashLen / 2.0f, nThick, dashLen / 2.0f};
                    }
                    dashed = new BasicStroke(nThick, 0, 0, 1.0f, dash1, 0.0f);
                }
            }
            ((Graphics2D)g).setStroke(dashed);
            g.setColor(this.getFillColor());
            g.drawLine(a.x, a.y, b.x, b.y);
            ((Graphics2D)g).setStroke(oldStroke);
        } else {
            this.paint(g, a, b, nThick);
        }
    }

    @Override
    public void paint(Graphics g, Polygon p) {
        VC vc = this.m_Perspective.getVC();
        if (!this.m_bTransparentFillColor) {
            g.setColor(this.m_fillColor);
            g.fillPolygon(p);
        }
        if (!this.m_bTransparentBorderColor) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(new BasicStroke(1.0f, 1, 1));
            g2.setColor(this.m_borderColor);
            g2.drawPolygon(p);
        }
    }

    @Override
    public void paint(Graphics g, Area area) {
        Graphics2D g2 = (Graphics2D)g;
        if (!this.m_bTransparentFillColor) {
            g2.setColor(this.m_fillColor);
            g2.fill(area);
        }
        if (!this.m_bTransparentBorderColor) {
            g2.setColor(this.m_borderColor);
            g2.draw(area);
        }
    }

    @Override
    public void paint(Graphics g, RectangularShape shape) {
        Graphics2D g2 = (Graphics2D)g;
        if (!this.m_bTransparentFillColor) {
            g2.setColor(this.m_fillColor);
            g2.fill(shape);
        }
        if (!this.m_bTransparentBorderColor) {
            g2.setColor(this.m_borderColor);
            g2.draw(shape);
        }
    }

    @Override
    public void paint(Graphics g, GeneralPath path, Rectangle r) {
        Graphics2D g2 = (Graphics2D)g;
        if (!this.m_bTransparentFillColor) {
            g2.setColor(this.m_fillColor);
            g2.fill(path);
        }
        if (!this.m_bTransparentBorderColor) {
            g2.setColor(this.m_borderColor);
            g2.draw(path);
        }
    }

    @Override
    public void paint(Graphics g, Point2D a, Point2D b) {
    }

    @Override
    public void paint(Graphics g, Point2D a, Point2D b, int nThick, int Style2, boolean isMarker) {
    }

    @Override
    public void paint(Graphics g, Rectangle r) {
        if (!this.m_bTransparentFillColor) {
            g.setColor(this.m_fillColor);
            g.fillRect(r.x, r.y, r.width, r.height);
        }
        if (!this.m_bTransparentBorderColor) {
            g.setColor(this.m_borderColor);
            g.drawRect(r.x, r.y, r.width, r.height);
        }
    }

    @Override
    public void paint(Graphics g, Rectangle r, boolean bOval, boolean bNoFill, boolean bDotted) {
        this.paint(g, r, bOval, bNoFill);
    }

    @Override
    public void paint(Graphics g, Rectangle r, boolean bOval, boolean bNoFill) {
        if (bOval) {
            if (!this.m_bTransparentFillColor && !bNoFill) {
                g.setColor(this.m_fillColor);
                g.fillOval(r.x, r.y, r.width, r.height);
            }
            if (!this.m_bTransparentBorderColor) {
                g.setColor(this.m_borderColor);
                g.drawOval(r.x, r.y, r.width, r.height);
            }
        } else {
            if (!this.m_bTransparentFillColor && !bNoFill) {
                g.setColor(this.m_fillColor);
                g.fillRect(r.x, r.y, r.width, r.height);
            }
            if (!this.m_bTransparentBorderColor) {
                g.setColor(this.m_borderColor);
                g.drawRect(r.x, r.y, r.width, r.height);
            }
        }
    }

    @Override
    public void paint(Graphics g, String szText, Rectangle rBounds, Rectangle rInnerBounds, TextStyleObj textStyle, VC vc) {
        if (!this.m_bTransparentFillColor) {
            g.setColor(this.m_fillColor);
            textStyle.draw(g, null, szText, rInnerBounds, null, null, vc);
        }
    }

    @Override
    public void releaseReferences() {
        this.m_Perspective = null;
    }

    @Override
    public void setBorderColor(Color color) {
        this.m_borderColor = color;
    }

    @Override
    public void setFillColor(int r, int g, int b, int a) {
        this.m_fillColor = new Color(r, g, b, a);
    }

    @Override
    public void setFillColor(Color color) {
        this.m_fillColor = color;
    }

    @Override
    public void paint(Graphics g, Rectangle r, boolean bOval, boolean bNoFill, int nLineWidth) {
    }

    @Override
    public IdentObj getIdentObj() {
        return this.m_id;
    }

    @Override
    public Dimension getDropShadowOffset() {
        return null;
    }

    @Override
    public Color getDropShadowColor() {
        return null;
    }

    private Color _getBrighter(Color c) {
        double COLOR_FACTOR = 1.25;
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int i = (int)(0.25 / COLOR_FACTOR);
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        r = (int)((double)r * COLOR_FACTOR);
        g = (int)((double)g * COLOR_FACTOR);
        b = (int)((double)b * COLOR_FACTOR);
        if (r >= 255 && g >= 255 && b >= 255) {
            return c;
        }
        return new Color(Math.min(r, 255), Math.min(g, 255), Math.min(b, 255), c.getAlpha());
    }

    public Object clone() {
        return new SimpleBlackBoxObj(this);
    }

    @Override
    public BlackBoxIF copy() {
        return (BlackBoxIF)this.clone();
    }
}

