/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.GraphExportXMLWriter;
import oracle.dss.graph.pfj.GraphSVGWriter;
import oracle.dss.graph.pfj.JChart_2D;
import oracle.dss.graph.pfj.JChart_Base;
import oracle.dss.graph.pfj.ObjClassID;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.DetLabel;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.Detectiv;
import oracle.dss.graph.pfj.draw.IdentObj;

public class DetOval
extends DetObj {
    private static final long serialVersionUID = 1L;
    Rectangle m_rBounds;
    boolean m_bNoFill;
    boolean m_bDrawCircular;
    int m_nReferenceLineWidth = 0;
    int m_nUnitWidth = 0;
    Rectangle m_clipRect;
    DetLabel m_detLabel = null;

    public DetOval(Detectiv m_Detectiv, IdentObj id, int x, int y, int width, int height, BlackBoxIF blackBox) {
        this(m_Detectiv, id, x, y, width, height, blackBox, false, true, false, false);
    }

    public DetOval(Detectiv m_Detectiv, IdentObj id, int x, int y, int width, int height, BlackBoxIF blackBox, boolean bMoveable, boolean bDetectable) {
        this(m_Detectiv, id, x, y, width, height, blackBox, bMoveable, bDetectable, false, false);
    }

    public DetOval(Detectiv m_Detectiv, IdentObj id, int x, int y, int width, int height, BlackBoxIF blackBox, boolean bMoveable, boolean bDetectable, boolean bNoFill) {
        this(m_Detectiv, id, x, y, width, height, blackBox, bMoveable, bDetectable, bNoFill, true);
    }

    public DetOval(Detectiv m_Detectiv, IdentObj id, int x, int y, int width, int height, BlackBoxIF blackBox, boolean bMoveable, boolean bDetectable, boolean bNoFill, int nLineWidth, int nUnit) {
        this(m_Detectiv, id, x, y, width, height, blackBox, bMoveable, bDetectable, bNoFill, true, nLineWidth, nUnit);
    }

    private DetOval(Detectiv m_Detectiv, IdentObj id, int x, int y, int width, int height, BlackBoxIF blackBox, boolean bMoveable, boolean bDetectable, boolean bNoFill, boolean bDrawCircular, int nWidth, int nUnit) {
        super(m_Detectiv, id, blackBox, bMoveable, bDetectable);
        this.m_rBounds = new Rectangle(x, y, width, height);
        this.m_bNoFill = bNoFill;
        this.m_bDrawCircular = bDrawCircular;
        this.m_nReferenceLineWidth = nWidth;
        this.m_nUnitWidth = nUnit;
    }

    private DetOval(Detectiv m_Detectiv, IdentObj id, int x, int y, int width, int height, BlackBoxIF blackBox, boolean bMoveable, boolean bDetectable, boolean bNoFill, boolean bDrawCircular) {
        super(m_Detectiv, id, blackBox, bMoveable, bDetectable);
        this.m_rBounds = new Rectangle(x, y, width, height);
        this.m_bNoFill = bNoFill;
        this.m_bDrawCircular = bDrawCircular;
    }

    public DetOval(Detectiv m_Detectiv, IdentObj id, int x, int y, int width, int height, BlackBoxIF blackBox, boolean bDrawCircular) {
        this(m_Detectiv, id, x, y, width, height, blackBox, true, true, false, bDrawCircular);
    }

    public DetOval(Detectiv m_Detectiv, IdentObj id, int width, int height, BlackBoxIF blackBox) {
        this(m_Detectiv, id, 0, 0, width, height, blackBox, false, true, false, false);
    }

    public DetOval(Detectiv m_Detectiv, IdentObj id, Rectangle r, BlackBoxIF blackBox) {
        this(m_Detectiv, id, r.x, r.y, r.width, r.height, blackBox, false, true, false, false);
    }

    public static DetOval newMarkerInstance(Detectiv detectiv, IdentObj id, Rectangle virtRect, BlackBoxIF blackBox, Rectangle clipRect) {
        DetOval detOval = new DetOval(detectiv, id, virtRect, blackBox);
        detOval.m_clipRect = clipRect;
        return detOval;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DetOval)) {
            return false;
        }
        DetOval detOval = (DetOval)obj;
        return this.m_id.equals(detOval.m_id);
    }

    @Override
    public Rectangle getBounds() {
        if (this.m_clipRect != null && this.m_rBounds != null) {
            return this.m_rBounds.intersection(this.m_clipRect);
        }
        return this.m_rBounds;
    }

    public Rectangle getBounds(VC vc) {
        return this.getBounds(vc, true);
    }

    public Rectangle getBounds(VC vc, boolean useClip) {
        Rectangle ret = null;
        if (this.m_bDrawCircular) {
            Rectangle rDest = vc.virtToDest(new Rectangle(this.m_rBounds.x, this.m_rBounds.y, this.m_rBounds.width, this.m_rBounds.height));
            int diameter = Math.min(rDest.width, rDest.height);
            rDest.x += (rDest.width - diameter) / 2;
            rDest.y += (rDest.height - diameter) / 2;
            rDest.width = diameter;
            rDest.height = diameter;
            ret = vc.destToVirt(rDest);
        } else {
            ret = this.m_rBounds;
        }
        if (useClip && this.m_clipRect != null && ret != null) {
            ret = ret.intersection(this.m_clipRect);
        }
        return ret;
    }

    @Override
    public void hilite(Graphics g, VC vc) {
        Shape shape = null;
        if (this.m_clipRect != null) {
            Rectangle rClip = vc.virtToDest(this.m_clipRect);
            shape = g.getClip();
            g.setClip(rClip);
        }
        Rectangle dest = vc.virtToDest(this.getBounds(vc));
        g.setXORMode(Color.yellow);
        g.drawOval(dest.x, dest.y, dest.width, dest.height);
        g.setPaintMode();
        if (this.m_clipRect != null) {
            g.setClip(shape);
        }
    }

    @Override
    public boolean isPointInObj(int x, int y, VC vc) {
        int slopHeight = vc.destToVirtHeight(5);
        int slopWidth = vc.destToVirtWidth(5);
        Rectangle rBounds = this.getBounds(vc);
        if (this.m_bNoFill) {
            rBounds.grow(slopWidth / 2, slopHeight / 2);
            if (!this.isPointInOval(x, y, rBounds)) {
                return false;
            }
            rBounds.grow(-slopWidth, -slopHeight);
            return !this.isPointInOval(x, y, rBounds);
        }
        return this.isPointInOval(x, y, rBounds);
    }

    private boolean isPointInOval(int x, int y, Rectangle bounds) {
        double b;
        double yCenter;
        double dy;
        double a;
        double xCenter;
        double dx;
        if (!this.m_bDetectable) {
            return false;
        }
        if (this.m_clipRect != null && !this.m_clipRect.contains(x, y)) {
            return false;
        }
        boolean bInside = !bounds.contains(x, y) ? false : (dx = (double)x - (xCenter = (double)bounds.x + (double)bounds.width / 2.0)) * dx / ((a = (double)bounds.width / 2.0) * a) + (dy = (double)y - (yCenter = (double)bounds.y + (double)bounds.height / 2.0)) * dy / ((b = (double)bounds.height / 2.0) * b) <= 1.0;
        return bInside;
    }

    @Override
    public void paintIt(Graphics g, VC vc) {
        Shape shape = null;
        if (this.m_clipRect != null) {
            Rectangle rClip = vc.virtToDest(this.m_clipRect);
            shape = g.getClip();
            if (shape == null) {
                g.setClip(rClip);
            }
        }
        if (this.getReferenceObject()) {
            this.m_blackBox.paint(g, vc.virtToDest(this.getBounds(vc, false)), true, this.m_bNoFill, this.m_nReferenceLineWidth);
        } else {
            this.m_blackBox.paint(g, vc.virtToDest(this.getBounds(vc, false)), true, this.m_bNoFill);
        }
        if (this.m_clipRect != null) {
            g.setClip(shape);
        }
    }

    @Override
    public void renderItToSVG(Map context) throws IOException, Exception {
        Rectangle frameRect;
        boolean bOnMouseOverOutPresent;
        boolean bOnClickPresent;
        GraphSVGWriter writer = (GraphSVGWriter)context.get("svgWriter");
        VC vc = (VC)context.get("svgVC");
        int mode = (Integer)context.get("svgMode");
        boolean bTooltips = (mode & 2) != 0;
        String[] tooltipsArray = null;
        if (bTooltips) {
            tooltipsArray = this.m_Detectiv.getPerspective().getUserTooltipStrings(this);
        }
        boolean bShapeAttributes = (mode & 0x10) != 0;
        String clickEventJS = null;
        boolean bl = bOnClickPresent = bShapeAttributes && writer.isOnClickPresent();
        if (bShapeAttributes && !bOnClickPresent) {
            clickEventJS = writer.getClickEventJS();
        }
        boolean bl2 = bOnMouseOverOutPresent = bShapeAttributes && writer.isOnMouseOverOutPresent();
        if (bOnMouseOverOutPresent) {
            bTooltips = false;
        }
        String saAlt = null;
        String saTitle = null;
        String saHRef = null;
        String saTarget = null;
        if (bShapeAttributes) {
            saAlt = writer.getShapeAttributesAlt();
            saTitle = writer.getShapeAttributesTitle();
            if (!bOnClickPresent) {
                saHRef = writer.getShapeAttributesHRef();
            }
            saTarget = writer.getShapeAttributesTarget();
        }
        boolean bDrilling = (mode & 4) != 0;
        bDrilling = bDrilling && !bOnClickPresent && clickEventJS == null;
        String drillJS = null;
        String link = null;
        boolean bLink = this.m_Detectiv.getPerspective().isDataLinkEnabled();
        if (bLink && ((link = writer.getLink(this)) == null || link.length() < 1)) {
            bLink = false;
        }
        if (bDrilling && ((drillJS = writer.getDrillJS(this)) == null || drillJS.length() < 1)) {
            bDrilling = false;
        }
        if (bTooltips) {
            if (saAlt != null) {
                tooltipsArray = new String[]{saAlt};
            } else if (saTitle != null) {
                tooltipsArray = new String[]{saTitle};
            }
        }
        if (bDrilling && bTooltips && tooltipsArray == null) {
            tooltipsArray = new String[]{writer.getDrillTooltip(this)};
        }
        bTooltips = bTooltips && tooltipsArray != null && tooltipsArray.length > 0;
        boolean bBubbleGraph = (Boolean)context.get("svgIsBubble");
        String sPlotAreaClip = null;
        if (bBubbleGraph && ObjClassID.stripExceptionalOffset(this.getObjectID()) == 259 && (sPlotAreaClip = (String)context.get("svgPlotAreaClip")) == null && (frameRect = (Rectangle)context.get("svgPlotAreaRect")) != null) {
            writer.startElement("clipPath");
            String clipID = writer.getFilteredBeanName() + "_plotAreaClip";
            writer.writeAttribute("id", clipID);
            StringBuilder sb = new StringBuilder("url(#");
            sb.append(clipID);
            sb.append(")");
            sPlotAreaClip = sb.toString();
            context.put("svgPlotAreaClip", sPlotAreaClip);
            if (writer.startRectElement(frameRect)) {
                writer.endElement();
            }
            writer.endElement();
        }
        boolean bStartA = bDrilling || bOnClickPresent || clickEventJS != null || saHRef != null || bLink;
        boolean bAnchorGroup = false;
        if (bStartA) {
            writer.startElement("a");
            String href = "";
            if (clickEventJS == null && !bDrilling && saHRef != null) {
                href = saHRef;
            } else if (clickEventJS == null && !bDrilling && bLink) {
                href = link;
            }
            writer.writeAttribute("xlink:href", href);
            if (saTarget != null) {
                writer.writeAttribute("target", saTarget);
            }
            String strOnclick = null;
            if (clickEventJS != null) {
                strOnclick = clickEventJS;
            } else if (bDrilling) {
                strOnclick = drillJS;
            }
            if (strOnclick != null) {
                bAnchorGroup = true;
                writer.startElement("g");
                writer.writeAttribute("onclick", strOnclick);
            }
        }
        boolean bElementStarted = false;
        bElementStarted = this.getReferenceObject() ? writer.startElement(this.m_id, this.m_blackBox, vc.virtToDest(this.getBounds(vc, false)), true, this.m_bNoFill, this.m_nReferenceLineWidth) : writer.startElement(this.m_id, this.m_blackBox, vc.virtToDest(this.getBounds(vc, false)), true, this.m_bNoFill);
        if (bElementStarted) {
            if (bShapeAttributes) {
                writer.writeShapeAttributes();
            }
            if (sPlotAreaClip != null) {
                writer.writeAttribute("clip-path", sPlotAreaClip);
            }
            if (bTooltips) {
                int rbMode;
                List l;
                onMouseOverJS = null;
                String onMouseOutJS = null;
                int graphID = this.m_Detectiv.getPerspective().getReferenceObjectGraphID(this.m_id.getObjectID());
                if (graphID != -1 && this.m_Detectiv.getPerspective().getReferenceObjectDisplay(graphID) == 2 && (l = writer.getReferenceObjects(this.m_id)) != null) {
                    context.put("svgHasReferenceObj", Boolean.TRUE);
                    StringBuilder strBuf = new StringBuilder("evt,");
                    for (int i = 0; i < l.size() - 1; ++i) {
                        strBuf.append("'" + (String)l.get(i) + "',");
                    }
                    strBuf.append("'" + (String)l.get(l.size() - 1) + "'");
                    onMouseOverJS = "bi_refObj_show_mOver(" + strBuf.toString() + ");";
                    onMouseOutJS = "bi_refObj_hide_mOut(" + strBuf.toString() + ");";
                }
                if ((rbMode = this.m_Detectiv.getPerspective().getIntegerProp(Attr.SeriesRolloverBehavior)) != 0) {
                    String shfOver = "bi_rollover(evt, true, '" + writer.getSimpleBeanName() + "');";
                    String shfOut = "bi_rollover(evt, false, '" + writer.getSimpleBeanName() + "');";
                    onMouseOverJS = onMouseOverJS != null ? (String)onMouseOverJS + shfOver : shfOver;
                    onMouseOutJS = onMouseOutJS != null ? onMouseOutJS + shfOut : shfOut;
                }
                writer.writeTooltip(tooltipsArray, onMouseOverJS, onMouseOutJS);
            } else {
                List l;
                int graphID;
                onMouseOverJS = null;
                String onMouseOutJS = null;
                int rbMode = this.m_Detectiv.getPerspective().getIntegerProp(Attr.SeriesRolloverBehavior);
                if (rbMode != 0 && this.m_id.isSeriesRelated()) {
                    String shfOver = "bi_rollover(evt, true, '" + writer.getSimpleBeanName() + "');";
                    String shfOut = "bi_rollover(evt, false, '" + writer.getSimpleBeanName() + "');";
                    onMouseOverJS = onMouseOverJS != null ? onMouseOverJS + shfOver : shfOver;
                    onMouseOutJS = onMouseOutJS != null ? onMouseOutJS + shfOut : shfOut;
                }
                if ((graphID = this.m_Detectiv.getPerspective().getReferenceObjectGraphID(this.m_id.getObjectID())) != -1 && this.m_Detectiv.getPerspective().getReferenceObjectDisplay(graphID) == 2 && (l = writer.getReferenceObjects(this.m_id)) != null) {
                    context.put("svgHasReferenceObj", Boolean.TRUE);
                    StringBuilder strBuf = new StringBuilder("evt,");
                    for (int i = 0; i < l.size() - 1; ++i) {
                        strBuf.append("'" + (String)l.get(i) + "',");
                    }
                    strBuf.append("'" + (String)l.get(l.size() - 1) + "'");
                    onMouseOverJS = onMouseOverJS == null ? "bi_refObj_show_mOver(" + strBuf.toString() + ");" : onMouseOverJS + "bi_refObj_show_mOver(" + strBuf.toString() + ");";
                    onMouseOutJS = onMouseOutJS == null ? "bi_refObj_hide_mOut(" + strBuf.toString() + ");" : "bi_refObj_hide_mOut(" + strBuf.toString() + ");";
                }
                if (onMouseOverJS != null) {
                    writer.writeAttribute("onmouseover", onMouseOverJS);
                }
                if (onMouseOutJS != null) {
                    writer.writeAttribute("onmouseout", onMouseOutJS);
                }
                if (saTitle != null) {
                    writer.writeTitleElement(saTitle);
                }
            }
            writer.endElement();
        }
        if (bStartA) {
            if (bAnchorGroup) {
                writer.endElement();
            }
            writer.endElement();
        }
    }

    @Override
    public void renderItToXML(Map context) throws IOException, Exception {
        String drillJS;
        GraphExportXMLWriter writer = (GraphExportXMLWriter)context.get("xmlWriter");
        VC contextVC = (VC)context.get("xmlVC");
        VC vc = this.m_Detectiv.getPerspective().getVC();
        String link = null;
        boolean bLink = this.m_Detectiv.getPerspective().isDataLinkEnabled();
        if (bLink && ((link = this.m_Detectiv.getPerspective().getLink(this)) == null || link.length() < 1)) {
            bLink = false;
        }
        boolean bDrilling = (drillJS = writer.getDrillJS(this)) != null && drillJS.length() > 0;
        boolean bLiveScroll = this.m_Detectiv.getPerspective().getZoomAndScroll() == 0;
        boolean bZoomed = (this.m_Detectiv.getPerspective().getHorzRangeSlider() != null || this.m_Detectiv.getPerspective().getY1RangeSlider() != null || this.m_Detectiv.getPerspective().getY2RangeSlider() != null) && contextVC != vc;
        boolean bBubbleGraph = this.m_Detectiv.getPerspective().getJGraphType().isBubble();
        String sPlotAreaClip = null;
        if (!(!bBubbleGraph || bLiveScroll && bZoomed || ObjClassID.stripExceptionalOffset(this.getObjectID()) != 259 || (sPlotAreaClip = (String)context.get("xmlPlotAreaClip")) != null)) {
            Rectangle frameRect = null;
            JChart_Base chart = this.m_Detectiv.getPerspective().getGraphObject();
            frameRect = chart instanceof JChart_2D ? vc.virtToDest(((JChart_2D)chart).getFrameObj().calcAdjustedFrameRect()) : vc.virtToDest(this.m_Detectiv.getPerspective().getFrameRect(false));
            if (frameRect != null) {
                writer.startElement("clipPath");
                String clipID = "plotAreaClip";
                writer.writeAttribute("id", clipID);
                StringBuilder sb = new StringBuilder("(#");
                sb.append(clipID);
                sb.append(")");
                sPlotAreaClip = sb.toString();
                context.put("xmlPlotAreaClip", sPlotAreaClip);
                if (writer.startRectElement(frameRect)) {
                    writer.endElement();
                }
                writer.endElement();
            }
        }
        boolean bElementStarted = false;
        Rectangle boundsRect = null;
        boundsRect = bBubbleGraph && bLiveScroll && bZoomed ? vc.virtToDest(this.getBounds(vc, false)) : contextVC.virtToDest(this.getBounds(contextVC, false));
        bElementStarted = this.getReferenceObject() ? writer.startElement(this.m_id, this.m_blackBox, boundsRect, true, this.m_bNoFill, this.m_nReferenceLineWidth) : writer.startElement(this.m_id, this.m_blackBox, boundsRect, true, this.m_bNoFill);
        if (bElementStarted) {
            writer.writeDataZoomAndScrollEventJsAttributes(this);
            if (sPlotAreaClip != null) {
                writer.writeAttribute("clip", sPlotAreaClip);
            }
            if (bDrilling) {
                writer.writeAttribute("drillJs", drillJS);
            }
            if (bLink) {
                writer.writeAttribute("link", link);
            }
            if (!writer.hasAlt()) {
                String[] tooltipsArray = null;
                boolean bTooltipTemplate = writer.useTooltipTemplate(this.m_id);
                if (!bTooltipTemplate) {
                    tooltipsArray = this.m_Detectiv.getPerspective().getUserTooltipStrings(this);
                }
                if (bDrilling && !bTooltipTemplate && tooltipsArray == null) {
                    tooltipsArray = new String[]{writer.getDrillTooltip(this)};
                }
                if (tooltipsArray != null && tooltipsArray.length > 0) {
                    writer.writeTooltipAttribute(tooltipsArray);
                } else if (!bTooltipTemplate) {
                    writer.writeCachedAttribute("tt", "f", null);
                }
            }
            writer.writeVisualEffectsAttributes(this.m_visualEffectsMap);
            writer.writeCustomPropertyAttribute();
            writer.writeShapeAttributesElement();
            writer.writeFillChildren(this.m_id, this.m_blackBox, boundsRect);
            writer.writeBorderChildren(this.m_id, this.m_blackBox, boundsRect);
            int graphID = this.m_Detectiv.getPerspective().getReferenceObjectGraphID(this.m_id.getObjectID());
            if (graphID != -1 && this.m_Detectiv.getPerspective().getReferenceObjectDisplay(graphID) == 2) {
                writer.writeReferenceObjectsElement(this.m_id);
            }
            if (this.m_detLabel != null) {
                this.m_detLabel.renderXML(context);
            }
            writer.endElement();
        }
    }

    @Override
    public void setBounds(Rectangle rBounds) {
        this.m_rBounds = rBounds;
    }

    public void setMarkerLabel(DetLabel detLabel) {
        this.m_detLabel = detLabel;
    }

    @Override
    public Polygon getShape(VC vc) {
        Polygon ret = null;
        ret = this.m_clipRect != null ? this.rectToPoly(this.m_clipRect.intersection(this.m_rBounds)) : this.rectToPoly(this.m_rBounds);
        return ret;
    }

    private Arc2D getArc(Rectangle boundingRect) {
        int width = boundingRect.width;
        int height = boundingRect.height;
        int x = boundingRect.x;
        int y = boundingRect.y;
        Arc2D.Double arc = new Arc2D.Double(x, y, width, height, -90.0, 360.0, 0);
        return arc;
    }
}

