/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dss.graph.DataStyleType;
import oracle.dss.graph.GraphXMLWriterCallback;
import oracle.dss.graph.pfj.CustomMarkerTemplate;
import oracle.dss.graph.pfj.GraphExportXMLWriter;
import oracle.dss.graph.pfj.JChart_2D;
import oracle.dss.graph.pfj.JChart_Base;
import oracle.dss.graph.pfj.MarkerTemplate;
import oracle.dss.graph.pfj.MarkerTemplateArray;
import oracle.dss.graph.pfj.ObjClassID;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.DetLabel;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.Detectiv;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.presutil.PresUtils;
import oracle.dss.util.containers.Marker;
import oracle.dss.util.renderers.MDOXMLRenderer;

public class DetMarker
extends DetObj {
    private static final long serialVersionUID = 1L;
    private List<Point> m_destCoords;
    private List<IdentObj> m_identObjs;
    private List<Integer> m_destSizes = new ArrayList<Integer>();
    private int m_markerShape;
    private List<DetLabel> m_detLabels;
    private List<String> m_analyticLayerColor;
    private List<String> m_analyticLayerShape;
    private CustomMarkerTemplate m_ctm;
    private boolean shouldOutputMarkerDef;
    private static final Rectangle MARKER_GRADIENT_RECT = new Rectangle(0, 0, 0, 0);
    public static final String MARKER_TYPE_OVAL = "c";
    public static final String MARKER_TYPE_RECT = "s";
    public static final String MARKER_TYPE_DIAMOND = "d";
    public static final String MARKER_TYPE_PLUS = "p";
    public static final String MARKER_TYPE_TRIANGLE_DN = "td";
    public static final String MARKER_TYPE_TRIANGLE_UP = "t";
    public static final String MARKER_TYPE_HUMAN = "h";

    public DetMarker(Detectiv detectiv, IdentObj id, int markerShape, int destX, int destY, int destSize, BlackBoxIF blackBox) {
        super(detectiv, id, blackBox, false, true);
        this.m_markerShape = markerShape;
        this.m_destCoords = new ArrayList<Point>();
        this.add(destX, destY, destSize, id);
    }

    public static DetMarker addMarker(Detectiv detectiv, IdentObj id, int markerShape, int destX, int destY, int destSize, BlackBoxIF blackBox, DetMarker marker) {
        int nextGroup;
        if (!(marker == null || marker.m_blackBox != blackBox || marker.m_markerShape != markerShape || !detectiv.getPerspective().isChartBubble() && marker.m_destSizes.get(0) != destSize || marker.getSeriesID() != id.getSeriesID() || marker.getObjectID() != id.getObjectID() || marker.getMiscID() != id.getMiscID() || marker.getStackID() != id.getStackID() || detectiv.getPerspective().getToolTipCallBack() != null && detectiv.getPerspective().getToolTipCallBack().getCustomToolTipCallback() != null || (nextGroup = marker.getGroupID() + marker.m_destCoords.size()) != id.getGroupID())) {
            marker.add(destX, destY, destSize, id);
            return marker;
        }
        return new DetMarker(detectiv, id, markerShape, destX, destY, destSize, blackBox);
    }

    public void addMarkerAttributes(String key, Object val) {
        String attribVal = " ";
        if (key.equals(DataStyleType.UNDERLAY_COLOR.toString())) {
            if (this.m_analyticLayerColor == null) {
                this.m_analyticLayerColor = new ArrayList<String>();
            }
            if (val instanceof Color) {
                attribVal = PresUtils.toHexStringWithAlpha(((Color)val).getRGB());
            }
            this.m_analyticLayerColor.add(attribVal);
        } else if (key.equals(DataStyleType.UNDERLAY_SHAPE.toString())) {
            if (this.m_analyticLayerShape == null) {
                this.m_analyticLayerShape = new ArrayList<String>();
            }
            if (val instanceof DataStyleType.Shape) {
                attribVal = DetMarker.convertDataStyleShapeToString((DataStyleType.Shape)((Object)val));
            }
            this.m_analyticLayerShape.add(attribVal);
        }
    }

    public void addMarkerLabel(DetLabel detLabel) {
        if (this.m_detLabels == null) {
            this.m_detLabels = new ArrayList<DetLabel>();
        }
        this.m_detLabels.add(detLabel);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DetMarker)) {
            return false;
        }
        DetMarker DetMarker2 = (DetMarker)obj;
        return this.m_id.equals(DetMarker2.m_id);
    }

    @Override
    public Rectangle getBounds() {
        Rectangle bounds = null;
        for (int i = 0; i < this.m_destCoords.size(); ++i) {
            Point p = this.m_destCoords.get(i);
            int destSize = this.m_destSizes.get(i);
            if (bounds == null) {
                bounds = new Rectangle(p.x, p.y, destSize, destSize);
                continue;
            }
            bounds.add(new Rectangle(p.x, p.y, destSize, destSize));
        }
        return this.m_Detectiv.getPerspective().getVC().destToVirt(bounds);
    }

    @Override
    public void hilite(Graphics g, VC vc) {
    }

    @Override
    public boolean isPointInObj(int x, int y, VC vc) {
        return this.m_bDetectable && this.getBounds().contains(x, y);
    }

    @Override
    public boolean isPointInObj(Point pt, VC vc) {
        return this.isPointInObj(pt.x, pt.y, vc);
    }

    @Override
    public void paintIt(Graphics g, VC vc) {
    }

    @Override
    public void renderItToSVG(Map context) throws IOException, Exception {
    }

    @Override
    public void renderItToXML(Map context) throws IOException, Exception {
        String drillJS;
        GraphExportXMLWriter writer = (GraphExportXMLWriter)context.get("xmlWriter");
        if (this.shouldOutputMarkerDef) {
            Marker marker = this.m_ctm.getMarker();
            MDOXMLRenderer mdox = new MDOXMLRenderer(writer);
            mdox.drawShape(marker);
        }
        String link = null;
        boolean bLink = this.m_Detectiv.getPerspective().isDataLinkEnabled();
        if (bLink && ((link = this.m_Detectiv.getPerspective().getLink(this)) == null || link.length() < 1)) {
            bLink = false;
        }
        boolean bDrilling = (drillJS = writer.getDrillJS(this)) != null && drillJS.length() > 0;
        boolean bLiveScroll = this.m_Detectiv.getPerspective().getZoomAndScroll() == 0;
        boolean bZoomed = (this.m_Detectiv.getPerspective().getHorzRangeSlider() != null || this.m_Detectiv.getPerspective().getY1RangeSlider() != null || this.m_Detectiv.getPerspective().getY2RangeSlider() != null) && context.get("xmlVC") != this.m_Detectiv.getPerspective().getVC();
        boolean bBubbleGraph = this.m_Detectiv.getPerspective().getJGraphType().isBubble();
        String sPlotAreaClip = null;
        if (!(!bBubbleGraph || bLiveScroll && bZoomed || ObjClassID.stripExceptionalOffset(this.getObjectID()) != 259)) {
            sPlotAreaClip = DetMarker.writeBubbleClipRect(this.m_Detectiv, writer, context);
        }
        boolean bElementStarted = false;
        String shape = DetMarker.convertMarkerShapeToString(this.m_markerShape);
        if (this.m_ctm != null) {
            shape = this.m_ctm.getMarker().getID();
        }
        String customProperty = null;
        GraphXMLWriterCallback xmlCallback = this.m_Detectiv.getPerspective().getCommonGraph().getXMLWriterCallback();
        if (xmlCallback != null) {
            StringBuilder sb = new StringBuilder();
            Iterator<IdentObj> iterator = this.m_identObjs.iterator();
            while (iterator.hasNext()) {
                IdentObj id;
                this.m_id = id = iterator.next();
                writer.init(this);
                String value = xmlCallback.getCustomProperty();
                if (value != null) {
                    sb.append(value);
                }
                sb.append("~;");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 2);
            }
            customProperty = sb.toString();
            this.m_id = this.m_identObjs.get(0);
            writer.init(this);
        }
        if (bElementStarted = writer.startMarkerElement(this.m_id, this.m_blackBox, shape, this.m_destCoords, this.m_destSizes)) {
            StringBuilder attrib;
            boolean bTooltipTemplate;
            if (bDrilling) {
                writer.writeAttribute("drillJs", drillJS);
            }
            if (bLink) {
                writer.writeAttribute("link", link);
            }
            if (sPlotAreaClip != null) {
                writer.writeAttribute("clip", sPlotAreaClip);
            }
            if (!(bTooltipTemplate = writer.useTooltipTemplate(this.m_id))) {
                this.writeTooltipAttribute(writer, bDrilling);
            }
            writer.writeVisualEffectsAttributes(this.m_visualEffectsMap);
            if (this.m_analyticLayerColor != null) {
                attrib = new StringBuilder();
                for (int i = 0; i < this.m_analyticLayerColor.size(); ++i) {
                    attrib.append(this.m_analyticLayerColor.get(i) + ",");
                }
                attrib.deleteCharAt(attrib.length() - 1);
                writer.writeAttribute("umc", attrib.toString());
            }
            if (this.m_analyticLayerShape != null) {
                attrib = new StringBuilder();
                for (int i = 0; i < this.m_analyticLayerShape.size(); ++i) {
                    attrib.append(this.m_analyticLayerShape.get(i) + ",");
                }
                attrib.deleteCharAt(attrib.length() - 1);
                writer.writeAttribute("ums", attrib.toString());
            }
            if (customProperty != null) {
                writer.writeAttribute("Z", customProperty);
            }
            writer.writeFillChildren(this.m_id, this.m_blackBox, MARKER_GRADIENT_RECT);
            writer.writeBorderChildren(this.m_id, this.m_blackBox, MARKER_GRADIENT_RECT);
            int graphID = this.m_Detectiv.getPerspective().getReferenceObjectGraphID(this.m_id.getObjectID());
            if (graphID != -1 && this.m_Detectiv.getPerspective().getReferenceObjectDisplay(graphID) == 2) {
                writer.writeReferenceObjectsElement(this.m_id);
            }
            if (this.m_detLabels != null) {
                for (int i = 0; i < this.m_detLabels.size(); ++i) {
                    this.m_detLabels.get(i).renderXML(context);
                }
            }
            Iterator<IdentObj> iterator = this.m_identObjs.iterator();
            while (iterator.hasNext()) {
                IdentObj id;
                this.m_id = id = iterator.next();
                writer.init(this);
                writer.writeShapeAttributesElement();
            }
            this.m_id = this.m_identObjs.get(0);
            writer.endElement();
        }
    }

    private void writeTooltipAttribute(GraphExportXMLWriter writer, boolean bDrilling) throws IOException, Exception {
        if (writer.hasAlt()) {
            return;
        }
        if (this.m_identObjs.size() <= 1) {
            boolean bTooltips;
            String[] tooltipsArray = null;
            tooltipsArray = this.m_Detectiv.getPerspective().getUserTooltipStrings(this);
            if (bDrilling && tooltipsArray == null) {
                tooltipsArray = new String[]{writer.getDrillTooltip(this)};
            }
            boolean bl = bTooltips = tooltipsArray != null && tooltipsArray.length > 0;
            if (bTooltips) {
                writer.writeTooltipAttribute(tooltipsArray);
            } else {
                writer.writeCachedAttribute("tt", "f", null);
            }
        } else {
            StringBuilder sb = new StringBuilder();
            String LINE_SEP = System.getProperty("line.separator");
            Iterator<IdentObj> iterator = this.m_identObjs.iterator();
            while (iterator.hasNext()) {
                IdentObj id;
                this.m_id = id = iterator.next();
                String[] tooltipsArray = null;
                tooltipsArray = this.m_Detectiv.getPerspective().getUserTooltipStrings(this);
                if (bDrilling && tooltipsArray == null) {
                    sb.append(writer.getDrillTooltip(this));
                } else if (tooltipsArray != null) {
                    for (int i = 0; i < tooltipsArray.length; ++i) {
                        if (tooltipsArray[i] == null || tooltipsArray[i].length() <= 0) continue;
                        if (sb.length() > 0 && i > 0) {
                            sb.append(LINE_SEP);
                        }
                        sb.append(tooltipsArray[i]);
                    }
                }
                sb.append("~;");
            }
            if (sb != null && sb.length() > 0) {
                sb.setLength(sb.length() - 2);
                writer.writeAttribute(MARKER_TYPE_TRIANGLE_UP, sb.toString());
            }
            writer.writeCachedAttribute("tt", "f", null);
            this.m_id = this.m_identObjs.get(0);
        }
    }

    protected static String writeBubbleClipRect(Detectiv detectiv, GraphExportXMLWriter writer, Map context) throws IOException, Exception {
        String sPlotAreaClip = (String)context.get("xmlPlotAreaClip");
        if (sPlotAreaClip == null) {
            Rectangle frameRect = null;
            JChart_Base chart = detectiv.getPerspective().getGraphObject();
            frameRect = chart instanceof JChart_2D ? detectiv.getPerspective().getVC().virtToDest(((JChart_2D)chart).getFrameObj().calcAdjustedFrameRect()) : detectiv.getPerspective().getVC().virtToDest(detectiv.getPerspective().getFrameRect(false));
            if (frameRect != null) {
                writer.startElement("clipPath");
                String clipID = "plotAreaClip";
                writer.writeAttribute("id", clipID);
                StringBuilder sb = new StringBuilder("(#");
                sb.append(clipID);
                sb.append(")");
                sPlotAreaClip = sb.toString();
                context.put("xmlPlotAreaClip", sPlotAreaClip);
                if (writer.startRectElement(frameRect)) {
                    writer.endElement();
                }
                writer.endElement();
            }
        }
        return sPlotAreaClip;
    }

    @Override
    public void setBounds(Rectangle rBounds) {
    }

    @Override
    public Polygon getShape(VC vc) {
        return null;
    }

    @Override
    public boolean isMoveable() {
        return super.isMoveable();
    }

    public void setCustomMarkerTemplate(CustomMarkerTemplate ctm) {
        this.m_ctm = ctm;
    }

    public void shouldOutputMarkerDef(boolean should) {
        this.shouldOutputMarkerDef = should;
    }

    public void add(int destX, int destY, int size, IdentObj id) {
        this.m_destCoords.add(new Point(destX, destY));
        this.m_destSizes.add(size);
        if (this.m_identObjs == null) {
            this.m_identObjs = new ArrayList<IdentObj>();
        }
        this.m_identObjs.add(id);
    }

    public static String convertMarkerShapeToString(int type) {
        switch (type) {
            case 2: 
            case 9: {
                return MARKER_TYPE_OVAL;
            }
            case 1: {
                return MARKER_TYPE_RECT;
            }
            case 3: {
                return MARKER_TYPE_DIAMOND;
            }
            case 5: {
                return MARKER_TYPE_PLUS;
            }
            case 6: {
                return MARKER_TYPE_TRIANGLE_DN;
            }
            case 7: {
                return MARKER_TYPE_TRIANGLE_UP;
            }
            case 11: {
                return MARKER_TYPE_HUMAN;
            }
        }
        return null;
    }

    public static String convertDataStyleShapeToString(DataStyleType.Shape shape) {
        if (shape.equals((Object)DataStyleType.Shape.CIRCLE)) {
            return MARKER_TYPE_OVAL;
        }
        if (shape.equals((Object)DataStyleType.Shape.SQUARE)) {
            return MARKER_TYPE_RECT;
        }
        if (shape.equals((Object)DataStyleType.Shape.DIAMOND)) {
            return MARKER_TYPE_DIAMOND;
        }
        if (shape.equals((Object)DataStyleType.Shape.PLUS)) {
            return MARKER_TYPE_PLUS;
        }
        if (shape.equals((Object)DataStyleType.Shape.TRIANGLE_DN)) {
            return MARKER_TYPE_TRIANGLE_DN;
        }
        if (shape.equals((Object)DataStyleType.Shape.TRIANGLE_UP)) {
            return MARKER_TYPE_TRIANGLE_UP;
        }
        if (shape.equals((Object)DataStyleType.Shape.HUMAN)) {
            return MARKER_TYPE_HUMAN;
        }
        return null;
    }

    public static MarkerTemplate convertStringToMarkerShape(String type) {
        if (type.equals(MARKER_TYPE_OVAL)) {
            return MarkerTemplateArray.PRESET_CIRCLE;
        }
        if (type.equals(MARKER_TYPE_RECT)) {
            return MarkerTemplateArray.PRESET_SQUARE;
        }
        if (type.equals(MARKER_TYPE_DIAMOND)) {
            return MarkerTemplateArray.PRESET_DIAMOND;
        }
        if (type.equals(MARKER_TYPE_TRIANGLE_DN)) {
            return MarkerTemplateArray.PRESET_TRIANGLE_DN;
        }
        if (type.equals(MARKER_TYPE_TRIANGLE_UP)) {
            return MarkerTemplateArray.PRESET_TRIANGLE_UP;
        }
        return null;
    }

    public static MarkerTemplate getMarkerTemplate(DataStyleType.Shape shape) {
        MarkerTemplate val = null;
        if (shape.equals((Object)DataStyleType.Shape.SQUARE)) {
            val = MarkerTemplateArray.PRESET_SQUARE;
        } else if (shape.equals((Object)DataStyleType.Shape.CIRCLE)) {
            val = MarkerTemplateArray.PRESET_CIRCLE;
        } else if (shape.equals((Object)DataStyleType.Shape.DIAMOND)) {
            val = MarkerTemplateArray.PRESET_DIAMOND;
        } else if (shape.equals((Object)DataStyleType.Shape.TRIANGLE_DN)) {
            val = MarkerTemplateArray.PRESET_TRIANGLE_DN;
        } else if (shape.equals((Object)DataStyleType.Shape.TRIANGLE_UP)) {
            val = MarkerTemplateArray.PRESET_TRIANGLE_UP;
        } else if (shape.equals((Object)DataStyleType.Shape.PLUS)) {
            val = MarkerTemplateArray.PRESET_PLUS;
        } else if (shape.equals((Object)DataStyleType.Shape.HUMAN)) {
            val = MarkerTemplateArray.PRESET_HUMAN;
        }
        return val;
    }
}

