/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;

public class ReversePathIterator
implements PathIterator {
    private final int windingRule;
    private final double[] coordinates;
    private final int[] segmentTypes;
    private int coordIndex = 0;
    private int segmentIndex = 0;

    public static PathIterator getReversePathIterator(Shape shape) {
        return new ReversePathIterator(shape.getPathIterator(null));
    }

    public static PathIterator getReversePathIterator(Shape shape, double flatness) {
        return new ReversePathIterator(shape.getPathIterator(null, flatness));
    }

    public static PathIterator getReversePathIterator(Shape shape, AffineTransform at) {
        return new ReversePathIterator(shape.getPathIterator(at));
    }

    public static PathIterator getReversePathIterator(Shape shape, AffineTransform at, double flatness) {
        return new ReversePathIterator(shape.getPathIterator(at, flatness));
    }

    public static PathIterator getReversePathIterator(Shape shape, int windingRule) {
        return new ReversePathIterator(shape.getPathIterator(null), windingRule);
    }

    public static PathIterator getReversePathIterator(Shape shape, double flatness, int windingRule) {
        return new ReversePathIterator(shape.getPathIterator(null, flatness), windingRule);
    }

    public static PathIterator getReversePathIterator(Shape shape, AffineTransform at, int windingRule) {
        return new ReversePathIterator(shape.getPathIterator(at), windingRule);
    }

    public static PathIterator getReversePathIterator(Shape shape, AffineTransform at, double flatness, int windingRule) {
        return new ReversePathIterator(shape.getPathIterator(at, flatness), windingRule);
    }

    public ReversePathIterator(PathIterator original) {
        this(original, original.getWindingRule());
    }

    public ReversePathIterator(PathIterator original, int windingRule) {
        this.windingRule = windingRule;
        double[] coords = new double[16];
        int coordPos = 0;
        int[] segTypes = new int[8];
        int segPos = 0;
        boolean first = true;
        double[] temp = new double[6];
        while (!original.isDone()) {
            if (segPos == segTypes.length) {
                int[] dummy = new int[2 * segPos];
                System.arraycopy(segTypes, 0, dummy, 0, segPos);
                segTypes = dummy;
            }
            int n = segPos++;
            int n2 = original.currentSegment(temp);
            segTypes[n] = n2;
            int segType = n2;
            if (first) {
                if (segType != 0) {
                    throw new IllegalPathStateException("missing initial moveto in path definition");
                }
                first = false;
            }
            int copy = switch (segType) {
                case 0, 1 -> 2;
                case 2 -> 4;
                case 3 -> 6;
                default -> 0;
            };
            if (copy > 0) {
                if (coordPos + copy > coords.length) {
                    double[] dummy = new double[coords.length * 2];
                    System.arraycopy(coords, 0, dummy, 0, coords.length);
                    coords = dummy;
                }
                for (int c = 0; c < copy; ++c) {
                    coords[coordPos++] = temp[c];
                }
            }
            original.next();
        }
        this.coordinates = new double[coordPos];
        for (int p = coordPos / 2 - 1; p >= 0; --p) {
            this.coordinates[2 * p] = coords[coordPos - 2 * p - 2];
            this.coordinates[2 * p + 1] = coords[coordPos - 2 * p - 1];
        }
        this.segmentTypes = new int[segPos];
        if (segPos > 0) {
            boolean pendingClose = false;
            int sr = 0;
            this.segmentTypes[sr++] = 0;
            block12: for (int s = segPos - 1; s > 0; --s) {
                switch (segTypes[s]) {
                    case 0: {
                        if (pendingClose) {
                            pendingClose = false;
                            this.segmentTypes[sr++] = 4;
                        }
                        this.segmentTypes[sr++] = 0;
                        continue block12;
                    }
                    case 4: {
                        pendingClose = true;
                        continue block12;
                    }
                    default: {
                        this.segmentTypes[sr++] = segTypes[s];
                    }
                }
            }
            if (pendingClose) {
                this.segmentTypes[sr] = 4;
            }
        }
    }

    @Override
    public int getWindingRule() {
        return this.windingRule;
    }

    private static final int coordinatesForSegmentType(int segtype) {
        switch (segtype) {
            case 0: 
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 6;
            }
        }
        return 0;
    }

    @Override
    public void next() {
        this.coordIndex += ReversePathIterator.coordinatesForSegmentType(this.segmentTypes[this.segmentIndex++]);
    }

    @Override
    public boolean isDone() {
        return this.segmentIndex >= this.segmentTypes.length;
    }

    @Override
    public int currentSegment(double[] coords) {
        int segmentType = this.segmentTypes[this.segmentIndex];
        int copy = ReversePathIterator.coordinatesForSegmentType(segmentType);
        if (copy > 0) {
            System.arraycopy(this.coordinates, this.coordIndex, coords, 0, copy);
        }
        return segmentType;
    }

    @Override
    public int currentSegment(float[] coords) {
        int segmentType = this.segmentTypes[this.segmentIndex];
        int copy = ReversePathIterator.coordinatesForSegmentType(segmentType);
        if (copy > 0) {
            for (int c = 0; c < copy; ++c) {
                coords[c] = (float)this.coordinates[this.coordIndex + c];
            }
        }
        return segmentType;
    }
}

