/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Polygon;
import java.util.Vector;
import oracle.dss.graph.pfj.Access;
import oracle.dss.graph.pfj.DataItem;
import oracle.dss.graph.pfj.DataStorage;
import oracle.dss.graph.pfj.DatumObj;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_Base;
import oracle.dss.graph.pfj.NatCubic;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.SeriesEnumerator;

public class MissingData {
    public static final int MISSINGDATA_SKIP = 0;
    public static final int MISSINGDATA_ZERO = 1;
    public static final int MISSINGDATA_INTERPOLATE = 2;
    Perspective m_Perspective;
    Access m_Access;
    JChart_Base m_Chart;
    DataStorage m_DataStorage;

    public MissingData(JChart_Base chart, Perspective perspective, Access access, DataStorage dataStorage) {
        this.m_Perspective = perspective;
        this.m_Access = access;
        this.m_Chart = chart;
        this.m_DataStorage = dataStorage;
    }

    public void calcMissingData(SeriesEnumerator sEnum, boolean bFirstTime) {
        int nFillMissingData = this.m_Perspective.getFillMissingData();
        switch (nFillMissingData) {
            case 0: {
                break;
            }
            case 1: {
                this.calcMissingDataZero(sEnum, bFirstTime);
                break;
            }
            case 2: {
                this.calcMissingDataInterpolated(sEnum, bFirstTime);
            }
        }
    }

    private void calcMissingDataZero(SeriesEnumerator sEnum, boolean bFirstTime) {
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        sEnum.reset();
        while (sEnum.hasMoreElements()) {
            int nSeries = sEnum.nextSeries();
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                int nGroup = gEnum.nextGroup();
                boolean bFillMissingDataIn = this.shouldFillInMissingData(bFirstTime, nSeries, nGroup);
                if (!bFillMissingDataIn) continue;
                this.m_Chart.setDataAsDouble(nSeries, nGroup, DataItem.DI_GENERAL, 0.0);
                this.m_DataStorage.setFillMissingData(nSeries, nGroup, true);
            }
        }
    }

    private void calcMissingDataInterpolated(SeriesEnumerator sEnum, boolean bFirstTime) {
        Polygon polyValidData = null;
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        sEnum.reset();
        while (sEnum.hasMoreElements()) {
            int nSeries = sEnum.nextSeries();
            Vector vectMissingGroupIndices = this.getMissingDataGroupIndices(bFirstTime, nSeries, polyValidData = new Polygon());
            if (vectMissingGroupIndices.size() < 1) continue;
            Polygon polyInter = NatCubic.interpolate(polyValidData);
            this.setMissingDataForSeries(nSeries, vectMissingGroupIndices, polyInter);
        }
    }

    Vector getMissingDataGroupIndices(boolean bFirstTime, int nSeries, Polygon polyValidData) {
        Vector<Integer> vectMissingGroupIndices = new Vector<Integer>();
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        gEnum.reset();
        while (gEnum.hasMoreElements()) {
            int nGroup = gEnum.nextGroup();
            boolean bFillMissingDataIn = this.shouldFillInMissingData(bFirstTime, nSeries, nGroup);
            if (bFillMissingDataIn) {
                Integer intGrp = nGroup;
                vectMissingGroupIndices.addElement(intGrp);
                continue;
            }
            DatumObj dObj = this.m_Chart.getDataValue(nSeries, nGroup, DataItem.DI_GENERAL);
            double fValue = dObj.m_fValue;
            polyValidData.addPoint(nGroup, (int)fValue);
        }
        return vectMissingGroupIndices;
    }

    private boolean shouldFillInMissingData(boolean bFirstTime, int nSeries, int nGroup) {
        boolean bFillMissingData = false;
        DatumObj dObj = this.m_Chart.getDataValue(nSeries, nGroup, DataItem.DI_GENERAL);
        double fValue = dObj.m_fValue;
        if (bFirstTime) {
            if (!dObj.m_bOK) {
                bFillMissingData = true;
            }
        } else {
            boolean bPrevFilledInMissingData = this.m_DataStorage.isMissingDataFilledIn(nSeries, nGroup);
            if (bPrevFilledInMissingData) {
                bFillMissingData = true;
            }
        }
        return bFillMissingData;
    }

    private void setMissingDataForSeries(int nSeries, Vector vectMissingGroupIndices, Polygon polyInter) {
        for (int nIdx = 0; nIdx < vectMissingGroupIndices.size(); ++nIdx) {
            Integer intGroup = (Integer)vectMissingGroupIndices.elementAt(nIdx);
            int nGroup = intGroup;
            double fAverageValue = this.getAverageInterpolatedValue(nGroup, polyInter);
            this.m_Chart.setDataAsDouble(nSeries, nGroup, DataItem.DI_GENERAL, fAverageValue);
            this.m_DataStorage.setFillMissingData(nSeries, nGroup, true);
        }
    }

    private double getAverageInterpolatedValue(int nGroup, Polygon polyInter) {
        int nSum = 0;
        int nNumInterpolatedValues = 0;
        double fAverageValue = 0.0;
        for (int nPt = 0; nPt < polyInter.npoints - 1; ++nPt) {
            if (nGroup != polyInter.xpoints[nPt]) continue;
            nSum += polyInter.ypoints[nPt];
            ++nNumInterpolatedValues;
        }
        if (nNumInterpolatedValues != 0) {
            fAverageValue = nSum / nNumInterpolatedValues;
        }
        return fAverageValue;
    }
}

