/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import oracle.adf.share.mt.util.MultiTenantStorage;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.DatumObj;
import oracle.dss.graph.pfj.FunnelFrameObj;
import oracle.dss.graph.pfj.FunnelSliceLabelContainer;
import oracle.dss.graph.pfj.FunnelSliceObj;
import oracle.dss.graph.pfj.FunnelStageLabelContainer;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_2D;
import oracle.dss.graph.pfj.LegendObj;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.ReversePathIterator;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetLabel;
import oracle.dss.graph.pfj.draw.DetLine;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.DetRect;
import oracle.dss.graph.pfj.draw.DetShape;
import oracle.dss.graph.pfj.draw.FillGradientObj;
import oracle.dss.graph.pfj.draw.FillObj;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;
import oracle.dss.presutil.PresUtils;

public class JChart_2D_Funnel
extends JChart_2D {
    private static final long serialVersionUID = 1L;
    private static final int ID_TOPLINE = 300;
    private static final int ID_BOTTOMLINE = 400;
    private static final int LABEL_TOP = 1;
    private static final int LABEL_BG_TOP = 3;
    private static final int LABEL_BG_BOTTOM = 4;
    private static final int MARGIN = 5;
    private static final double FONT_GAP = 0.25;
    private static final int THRESHOLD1 = 40;
    private static final int THRESHOLD2 = 70;
    private static MultiTenantStorage<Double> _prevTopLeftX = new MultiTenantStorage();
    private int m_bFunnelLabelDisplay;
    private int m_nTextFormat;
    private String m_strTextFormatPattern;
    private int m_nFunnelTextDisplay;
    private boolean m_bFunnelTextVisibility;
    private FunnelSliceObj[] m_funnelSlices;
    private int m_nSliceCount;
    private int m_maxLabelWidthDest;
    private int m_maxStageLabelWidthDest;
    private double m_sliceLabelHeightReserved;
    private double m_stageLabelHeightReserved;
    private Vector m_topSliceLabels;
    private Vector m_bottomSliceLabels;
    private Vector m_topTruncatedLabels;
    private Vector m_bottomTruncatedLabels;
    private Dimension m_labelDim;
    private Dimension m_stageLabelDim;
    private Rectangle m_funnelFrame;
    private TextStyleObj m_textStyles;
    private TextStyleObj m_stageTextStyles;
    private boolean m_sliceLabelTruncated;
    private boolean m_stageLabelTruncated;
    private VC m_VC;
    private int m_virtMarginHeight;
    private int m_virtMarginWidth;
    private double m_sliceLabelGap;
    private double m_stageLabelGap;
    private double m_leftRightHeightRatio;
    private double m_rotateAngle;
    private double m_viewAngle;
    private double m_leftSurfaceHeight;
    private double m_leftSurfaceWidth;
    private double m_rightSurfaceHeight;
    private double m_rightSurfaceWidth;
    private double m_funnelLength;
    private double m_leftSurfaceStartX;
    private double m_leftSurfaceStartY;
    private double m_topTanX1;
    private double m_topTanY1;
    private double m_topTanX2;
    private double m_topTanY2;
    private double m_bottomTanX1;
    private double m_bottomTanY1;
    private double m_bottomTanX2;
    private double m_bottomTanY2;
    private double m_topLineGradient;
    private double m_topLineYield;
    private double m_bottomLineGradient;
    private double m_bottomLineYield;
    private double m_availableChartWidth;
    private int m_sliceCount;
    private double m_sliceStep;
    private int[] m_topLabelWidths;
    private int[] m_bottomLabelWidths;
    private double[] m_stagePercents;
    private Ellipse2D m_leftEllipse;
    private int m_skeletonBorderWidth;
    private boolean m_standardFunnel;
    private int m_minWidth = 7;
    private Map<FunnelSliceObj, Rectangle> m_topLabelRects;
    private Map<FunnelSliceObj, Rectangle> m_bottomLabelRects;
    public static final int FUNNEL_LABEL_MARGIN = 15;
    private FunnelSliceLabelContainer funnelSliceLabelContainer;
    private FunnelStageLabelContainer funnelStageLabelContainer;
    private Rectangle m_prevTopLabelRect;
    private Rectangle m_prevBottomLabelRect;

    @Override
    public void calc() {
        super.calc();
        this.m_VC = this.m_Perspective.getVC();
        this.m_sliceLabelTruncated = false;
        this.m_stageLabelTruncated = false;
        this.m_virtMarginHeight = this.m_VC.destToVirtHeight(5);
        this.m_virtMarginWidth = this.m_VC.destToVirtWidth(5);
        this.copyFunnelParams();
        this._calcFunnel();
        if (this.m_funnelLength <= this.m_leftSurfaceWidth / 2.0) {
            String err = "Calculated funnel length too short for the funnel to be rendered. Reverting back to default view angle";
            this.m_Perspective.getErrorHandler().log(err, this.getClass().getName(), "calc()");
            this.m_rotateAngle = this.m_viewAngle = ((Double)Attr.FunnelViewAngle.getDefault()).doubleValue();
            this._calcFunnel();
        }
        this._drawFunnel();
        if (this.m_sliceLabelTruncated) {
            this.m_Perspective.setSliceLabelsTruncated(this.m_sliceLabelTruncated, new IdentObj(622));
        } else {
            this.m_Perspective.setSliceLabelsTruncated(this.m_sliceLabelTruncated, null);
        }
        if (this.m_stageLabelTruncated) {
            this.m_Perspective.setO1LabelsTruncated(this.m_stageLabelTruncated, new IdentObj(270));
        } else {
            this.m_Perspective.setO1LabelsTruncated(this.m_stageLabelTruncated);
        }
        this.fireInapropriateDataEvent();
    }

    @Override
    public void createLegend() {
        if (this.m_nEffColorMode == 4) {
            this.m_Legend = new LegendObj(this.m_Perspective, this.m_Access, this, true);
        }
    }

    private FontMetrics _getSliceLabelFontMetrics() {
        return this.funnelSliceLabelContainer.getFontMetrics();
    }

    private FontMetrics _getStageLabelFontMetrics() {
        return this.funnelStageLabelContainer.getFontMetrics();
    }

    private void _calcFunnel() {
        this._calcSurfaceWidthHeight();
        if (this.m_leftSurfaceHeight <= 0.0) {
            // empty if block
        }
        this._calcFunnelLength();
        this._calcTopLeftXY();
        this._adjustFunnelBounds();
        this.m_topLabelWidths = this.funnelSliceLabelContainer.getLabelWidthArray();
        this.m_bottomLabelWidths = this.funnelStageLabelContainer.getLabelWidthArray();
        _prevTopLeftX.set((Object)this.m_leftSurfaceStartX);
    }

    private void _adjustFunnelBounds() {
        if (this.m_Perspective.getSelectionEnableMove() && this.m_Perspective.getIntegerProp(Attr.AutoLayout) == 0 && this.m_rotateAngle == this.m_viewAngle && this.m_funnelLength < this.m_leftSurfaceWidth / 2.0) {
            this.m_funnelLength = this.m_leftSurfaceWidth / 2.0;
            double newWidth = this.m_leftSurfaceWidth + this.m_rightSurfaceWidth / 2.0;
            int oldWidth = this.m_funnelFrame.width;
            this.m_availableChartWidth = newWidth;
            this.m_funnelFrame.width = (int)this.m_VC.destToVirtWidth(this.m_availableChartWidth);
            if (this.m_leftSurfaceStartX > (Double)_prevTopLeftX.get()) {
                this.m_funnelFrame.x -= this.m_funnelFrame.width - oldWidth;
                this._calcTopLeftXY();
            }
            IdentObj rectId = new IdentObj(this.m_Perspective.getFunnelFrame());
            rectId.setMiscID(627);
            DetObj detObj = this.m_Detectiv.findNodeOf(rectId);
            detObj.setBounds(this.m_funnelFrame);
        }
    }

    private void _calcTopLeftXY() {
        this.m_leftSurfaceStartX = (double)this.m_VC.virtToDestX(this.m_funnelFrame.x) + this.m_sliceLabelGap;
        this.m_leftSurfaceStartY = (double)this.m_VC.virtToDestY(this.m_funnelFrame.y + this.m_funnelFrame.height) + this.m_sliceLabelHeightReserved;
        double extraWidth = (this.m_availableChartWidth - (this.m_leftSurfaceWidth / 2.0 + this.m_funnelLength + this.m_rightSurfaceWidth / 2.0)) / 2.0;
        this.m_leftSurfaceStartX += extraWidth;
    }

    private void _calcSurfaceWidthHeight() {
        double leftSurfaceHeightDest = 0.0;
        int availWidth = this.m_funnelFrame.width;
        int availHeight = this.m_funnelFrame.height;
        if (availHeight < 200 || availWidth < 200) {
            if (availHeight < 200) {
                availHeight = 200;
            }
            if (availWidth < 200) {
                availWidth = 200;
            }
            this.m_funnelFrame.width = availWidth;
            this.m_funnelFrame.height = availHeight;
            IdentObj rectId = new IdentObj(this.m_Perspective.getFunnelFrame());
            rectId.setMiscID(627);
            DetObj detObj = this.m_Detectiv.findNodeOf(rectId);
            detObj.setBounds(this.m_funnelFrame);
        }
        int availHeightDest = this.m_VC.virtToDestHeight(availHeight);
        int textRotationAngle = JChart_2D_Funnel.mappedRotationAngle(this.m_stageTextStyles.getRotationAngle());
        double heightNeeded = ((double)this.m_maxStageLabelWidthDest + 3.0 * this.m_stageLabelGap) * Math.abs(Math.sin(Math.toRadians(textRotationAngle)));
        FontMetrics fm = this._getStageLabelFontMetrics();
        int fontHeight = TextStyleObj.getFontHeight(fm, this.m_Perspective.getFontMetricsResolver());
        double minimumSpaceReserved = 2.0 * this.m_stageLabelGap + (double)fontHeight;
        this.m_stageLabelHeightReserved = Math.max(Math.min((double)availHeightDest * 0.3, heightNeeded), minimumSpaceReserved);
        leftSurfaceHeightDest = (double)availHeightDest - this.m_stageLabelHeightReserved;
        textRotationAngle = JChart_2D_Funnel.mappedRotationAngle(this.m_textStyles.getRotationAngle());
        heightNeeded = ((double)this.m_maxLabelWidthDest + 3.0 * this.m_sliceLabelGap) * Math.abs(Math.sin(Math.toRadians(textRotationAngle)));
        fm = this._getSliceLabelFontMetrics();
        fontHeight = TextStyleObj.getFontHeight(fm, this.m_Perspective.getFontMetricsResolver());
        minimumSpaceReserved = 2.0 * this.m_sliceLabelGap + (double)fontHeight;
        this.m_sliceLabelHeightReserved = Math.max(Math.min((double)availHeightDest * 0.3, heightNeeded), minimumSpaceReserved);
        this._calcFunnelHeightRatio();
        this.m_leftRightHeightRatio = this.m_Perspective.getFunnelHeightRatio();
        this.m_leftSurfaceHeight = leftSurfaceHeightDest -= this.m_sliceLabelHeightReserved;
        this.m_leftSurfaceWidth = this.m_leftSurfaceHeight * (this.m_rotateAngle / 90.0);
        this.m_rightSurfaceHeight = this.m_leftRightHeightRatio * this.m_leftSurfaceHeight;
        this.m_rightSurfaceWidth = this.m_rightSurfaceHeight * (this.m_rotateAngle / 90.0);
    }

    private void _calcFunnelLength() {
        double funnelLengthDest = 0.0;
        int availWidth = this.m_funnelFrame.width;
        int availWidthDest = this.m_VC.virtToDestWidth(availWidth);
        this.m_availableChartWidth = funnelLengthDest = (double)availWidthDest;
        this.m_funnelLength = this.m_availableChartWidth - (this.m_leftSurfaceWidth / 2.0 + this.m_rightSurfaceWidth / 2.0);
        double actualFunnelLength = this.m_funnelLength / (1.0 - this.m_viewAngle / 90.0);
        this.m_funnelLength = actualFunnelLength * (1.0 - this.m_rotateAngle / 90.0);
    }

    private void _calcFunnelHeightRatio() {
        if (this.m_Perspective.isStandardShapeAndWidth()) {
            return;
        }
        double actualVolumeRatio = this.getTargetValue(0) / this.getTargetValue(this.m_sliceCount - 1);
        if (actualVolumeRatio <= 1.0) {
            this.m_Perspective.setFunnelHeightRatio(0.999);
            return;
        }
        double prevError = this._calcVolumeRatioError(0.0, actualVolumeRatio);
        if (prevError <= 0.0) {
            this.m_Perspective.setFunnelHeightRatio(0.001);
            return;
        }
        double x = 0.4;
        prevError = this._calcVolumeRatioError(x, actualVolumeRatio);
        double step = 0.2;
        double prevX = x;
        while (step >= 0.05 && prevX < 1.0) {
            if (prevError > 0.0) {
                x = prevX + step;
            } else {
                if (!(prevError < 0.0)) break;
                x = prevX - step;
            }
            double error = this._calcVolumeRatioError(x, actualVolumeRatio);
            if (Math.abs(error) < Math.abs(prevError)) {
                prevError = error;
                prevX = x;
            }
            if (prevX > 0.4) {
                step /= 1.5;
                continue;
            }
            step /= 2.0;
        }
        this.m_Perspective.setFunnelHeightRatio(prevX);
    }

    private double _calcVolumeRatioError(double heightRatio, double actualVolumeRatio) {
        double r1 = 1.0 - (1.0 - heightRatio) / (double)this.m_sliceCount;
        double R2 = heightRatio + (1.0 - heightRatio) / (double)this.m_sliceCount;
        double volumeRatio = (1.0 + r1 + r1 * r1) / (R2 * R2 + R2 * heightRatio + heightRatio * heightRatio);
        return volumeRatio - actualVolumeRatio;
    }

    private void _drawAllSliceLabels() {
        for (int sRel = 1; sRel < this.m_sliceCount + 1; ++sRel) {
            if (!this.m_bFunnelTextVisibility) continue;
            this._drawSliceLabel(this.m_funnelSlices[sRel]);
        }
    }

    private void _drawSliceLabel(FunnelSliceObj theSlice) {
        BlackBoxObj blackBoxLabel;
        Rectangle rLabelTop = null;
        Rectangle rLabelBottom = null;
        IdentObj id = null;
        BlackBoxObj rBlackBoxLabel = null;
        IdentObj idBackground = null;
        switch (this.m_nFunnelTextDisplay) {
            case 0: {
                return;
            }
            case 3: {
                return;
            }
        }
        switch (this.m_bFunnelLabelDisplay) {
            case 0: 
            case 1: {
                rLabelTop = this._calcTopLabel(theSlice);
                break;
            }
            case 2: {
                rLabelBottom = this._calcBottomLabel(theSlice);
                break;
            }
            default: {
                rLabelTop = this._calcTopLabel(theSlice);
                rLabelBottom = this._calcBottomLabel(theSlice);
            }
        }
        idBackground = new IdentObj(625, -3, theSlice.m_nGroupID);
        if (rLabelTop != null) {
            id = new IdentObj(622, -3, theSlice.m_nGroupID);
            rBlackBoxLabel = new BlackBoxObj(this.m_Perspective, id);
            rBlackBoxLabel.setTransparentFillColor(true);
            rBlackBoxLabel.setTransparentBorderColor(true);
            blackBoxLabel = new BlackBoxObj(this.m_Perspective, id);
            this._drawTopLabel(id, idBackground, rLabelTop, rBlackBoxLabel, blackBoxLabel, theSlice);
        }
        if (rLabelBottom != null) {
            id = this.m_Perspective.getO1Label();
            rBlackBoxLabel = new BlackBoxObj(this.m_Perspective, id);
            rBlackBoxLabel.setTransparentFillColor(true);
            rBlackBoxLabel.setTransparentBorderColor(true);
            blackBoxLabel = new BlackBoxObj(this.m_Perspective, id);
            this._drawBottomLabel(id, idBackground, rLabelBottom, rBlackBoxLabel, blackBoxLabel, theSlice);
        }
    }

    private Rectangle _calcTopLabel(FunnelSliceObj theSlice) {
        Rectangle rLabelTop = this.m_topLabelRects.get(theSlice);
        String label = this._truncateLabelAsNeeded(theSlice, rLabelTop.width, this._getSliceLabelFontMetrics(), true);
        if (!label.isEmpty()) {
            this.m_prevTopLabelRect = rLabelTop;
            return rLabelTop;
        }
        return null;
    }

    private Rectangle _calcBottomLabel(FunnelSliceObj theSlice) {
        Rectangle rLabelBottom = this.m_bottomLabelRects.get(theSlice);
        String label = this._truncateLabelAsNeeded(theSlice, rLabelBottom.width, this._getStageLabelFontMetrics(), false);
        if (!label.isEmpty()) {
            this.m_prevBottomLabelRect = rLabelBottom;
            return rLabelBottom;
        }
        return null;
    }

    private void _drawTopLabel(IdentObj id, IdentObj idBackground, Rectangle rLabelTop, BlackBoxObj rBlackBoxLabel, BlackBoxObj blackBoxLabel, FunnelSliceObj theSlice) {
        IdentObj idBg = new IdentObj(idBackground);
        idBg.setMiscID(3);
        theSlice.setTopLabelBackground(new DetRect(this.m_Detectiv, idBg, rLabelTop.x, rLabelTop.y, rLabelTop.width, rLabelTop.height, rBlackBoxLabel, false, false));
        IdentObj idLabel = new IdentObj(id);
        idLabel.setMiscID(1);
        theSlice.setTopLabel(new DetLabel(this.m_Detectiv, idLabel, (String)this.m_topTruncatedLabels.elementAt(theSlice.m_nSliceIdx - 1), (String)this.m_topSliceLabels.elementAt(theSlice.m_nSliceIdx - 1), rLabelTop, this.m_textStyles, blackBoxLabel, false));
    }

    private void _drawBottomLabel(IdentObj id, IdentObj idBackground, Rectangle rLabelBottom, BlackBoxObj rBlackBoxLabel, BlackBoxObj blackBoxLabel, FunnelSliceObj theSlice) {
        IdentObj idBg = new IdentObj(idBackground);
        idBg.setMiscID(4);
        theSlice.setBottomLabelBackground(new DetRect(this.m_Detectiv, idBg, rLabelBottom.x, rLabelBottom.y, rLabelBottom.width, rLabelBottom.height, rBlackBoxLabel, false, false));
        IdentObj idLabel = new IdentObj(id);
        idLabel.setGroupID(theSlice.m_nGroupID);
        theSlice.setBottomLabel(new DetLabel(this.m_Detectiv, idLabel, (String)this.m_bottomTruncatedLabels.elementAt(theSlice.m_nSliceIdx - 1), (String)this.m_bottomSliceLabels.elementAt(theSlice.m_nSliceIdx - 1), rLabelBottom, this.m_stageTextStyles, blackBoxLabel, false));
    }

    private String _truncateLabelAsNeeded(FunnelSliceObj theSlice, int labelWidth, FontMetrics fm, boolean topBottom) {
        TextStyleObj style = topBottom ? this.m_textStyles : this.m_stageTextStyles;
        if (style.getRotationAngle() == 0 || style.getRotationAngle() == 360) {
            return this._truncateLabelStandardAngle(theSlice, labelWidth, fm, topBottom);
        }
        return this._truncateLabelArbitaryAngle(theSlice, labelWidth, fm, topBottom);
    }

    private String _truncateLabelStandardAngle(FunnelSliceObj theSlice, int labelWidth, FontMetrics fm, boolean topBottom) {
        Vector truncatedLabels;
        Rectangle prevLabelRect;
        Rectangle currentLabelRect;
        int sliceLabelWidth;
        boolean truncated = false;
        String label = "";
        if (topBottom) {
            sliceLabelWidth = this.m_topLabelWidths[theSlice.m_nSliceIdx - 1];
            label = (String)this.m_topSliceLabels.elementAt(theSlice.m_nSliceIdx - 1);
            currentLabelRect = this.m_topLabelRects.get(theSlice);
            prevLabelRect = this.m_prevTopLabelRect;
            truncatedLabels = this.m_topTruncatedLabels;
        } else {
            sliceLabelWidth = this.m_bottomLabelWidths[theSlice.m_nSliceIdx - 1];
            label = (String)this.m_bottomSliceLabels.elementAt(theSlice.m_nSliceIdx - 1);
            currentLabelRect = this.m_bottomLabelRects.get(theSlice);
            prevLabelRect = this.m_prevBottomLabelRect;
            truncatedLabels = this.m_bottomTruncatedLabels;
        }
        if (prevLabelRect != null && prevLabelRect.intersects(currentLabelRect)) {
            truncatedLabels.setElementAt("", theSlice.m_nSliceIdx - 1);
            truncated = true;
            return "";
        }
        if (sliceLabelWidth > this.m_VC.virtToDestWidth(labelWidth)) {
            label = PresUtils.truncateText(label, fm, 0, this.m_VC.virtToDestWidth(labelWidth), this.m_Perspective.getFontMetricsResolver());
            truncatedLabels.setElementAt(label, theSlice.m_nSliceIdx - 1);
            truncated = true;
        }
        if (truncated) {
            if (topBottom) {
                this.m_sliceLabelTruncated = true;
            } else {
                this.m_stageLabelTruncated = true;
            }
        }
        return label;
    }

    private String _truncateLabelArbitaryAngle(FunnelSliceObj theSlice, int labelWidth, FontMetrics fm, boolean topBottom) {
        String label = "";
        label = topBottom ? (String)this.m_topSliceLabels.elementAt(theSlice.m_nSliceIdx - 1) : (String)this.m_bottomSliceLabels.elementAt(theSlice.m_nSliceIdx - 1);
        if (topBottom) {
            int sliceLabelWidth = this.m_topLabelWidths[theSlice.m_nSliceIdx - 1];
            int destLabelWidth = this.m_VC.virtToDestWidth(labelWidth);
            if (sliceLabelWidth > destLabelWidth) {
                label = PresUtils.truncateText(label, fm, 0, destLabelWidth, this.m_Perspective.getFontMetricsResolver());
                this.m_topTruncatedLabels.setElementAt(label, theSlice.m_nSliceIdx - 1);
                this.m_sliceLabelTruncated = true;
            }
            boolean leftNoSpace = false;
            boolean rightNoSpace = false;
            int horizLabelheight = (int)(this.m_stageLabelDim.getHeight() * (double)Math.round(Math.abs(Math.cos(90.0 - (double)this.m_textStyles.getRotationAngle()))));
            Rectangle currentTopLabelRect = this.m_topLabelRects.get(theSlice);
            Rectangle prevTopLabelRect = null;
            Rectangle nextTopLabelRect = null;
            int destCurrRectX = this.m_VC.virtToDestX((int)currentTopLabelRect.getX());
            int destPrevRectX = 0;
            int destNextRectX = 0;
            if (theSlice.m_nSliceIdx + 1 != this.m_funnelSlices.length) {
                prevTopLabelRect = this.m_topLabelRects.get(this.m_funnelSlices[theSlice.m_nSliceIdx - 1]);
                nextTopLabelRect = this.m_topLabelRects.get(this.m_funnelSlices[theSlice.m_nSliceIdx + 1]);
                if (prevTopLabelRect == null) {
                    destNextRectX = this.m_VC.virtToDestX((int)nextTopLabelRect.getX());
                    boolean bl = rightNoSpace = (double)(destCurrRectX + horizLabelheight) + this.m_sliceLabelGap * 2.0 > (double)destNextRectX;
                    if (rightNoSpace) {
                        label = "...";
                        this.m_sliceLabelTruncated = true;
                    }
                } else {
                    destPrevRectX = this.m_VC.virtToDestX((int)prevTopLabelRect.getX());
                    destNextRectX = this.m_VC.virtToDestX((int)nextTopLabelRect.getX());
                    rightNoSpace = (double)(destCurrRectX + horizLabelheight) + this.m_sliceLabelGap * 6.0 > (double)destNextRectX;
                    boolean bl = leftNoSpace = (double)(destPrevRectX + horizLabelheight) + this.m_sliceLabelGap * 6.0 > (double)destCurrRectX;
                    if (rightNoSpace && leftNoSpace && !((String)this.m_topTruncatedLabels.get(this.m_funnelSlices[theSlice.m_nSliceIdx - 1].m_nSliceIdx - 1)).equals("...")) {
                        label = "...";
                        this.m_sliceLabelTruncated = true;
                    }
                }
            } else {
                prevTopLabelRect = this.m_topLabelRects.get(this.m_funnelSlices[theSlice.m_nSliceIdx - 1]);
                destPrevRectX = prevTopLabelRect == null ? 0 : this.m_VC.virtToDestX((int)prevTopLabelRect.getX());
                boolean bl = leftNoSpace = (double)(destPrevRectX + horizLabelheight) + this.m_sliceLabelGap * 2.0 > (double)destCurrRectX;
                if (leftNoSpace) {
                    label = "...";
                    this.m_sliceLabelTruncated = true;
                }
            }
            if (this.m_sliceLabelTruncated) {
                this.m_topTruncatedLabels.setElementAt(label, theSlice.m_nSliceIdx - 1);
            }
        } else {
            int sliceLabelWidth = this.m_bottomLabelWidths[theSlice.m_nSliceIdx - 1];
            int destLabelWidth = this.m_VC.virtToDestWidth(labelWidth);
            if (sliceLabelWidth > destLabelWidth) {
                label = PresUtils.truncateText(label, fm, 0, destLabelWidth, this.m_Perspective.getFontMetricsResolver());
                this.m_bottomTruncatedLabels.setElementAt(label, theSlice.m_nSliceIdx - 1);
                this.m_stageLabelTruncated = true;
            }
            boolean leftNoSpace = false;
            boolean rightNoSpace = false;
            int horizLabelheight = (int)(this.m_stageLabelDim.getHeight() * Math.abs(Math.cos(Math.toRadians((double)this.m_textStyles.getRotationAngle() - 90.0))));
            Rectangle currentBottomLabelRect = this.m_bottomLabelRects.get(theSlice);
            Rectangle prevBottomLabelRect = null;
            Rectangle nextBottomLabelRect = null;
            int destCurrRectX = this.m_VC.virtToDestX((int)currentBottomLabelRect.getX());
            int destPrevRectX = 0;
            int destNextRectX = 0;
            if (theSlice.m_nSliceIdx + 1 != this.m_funnelSlices.length) {
                prevBottomLabelRect = this.m_bottomLabelRects.get(this.m_funnelSlices[theSlice.m_nSliceIdx - 1]);
                nextBottomLabelRect = this.m_bottomLabelRects.get(this.m_funnelSlices[theSlice.m_nSliceIdx + 1]);
                if (prevBottomLabelRect == null) {
                    destNextRectX = this.m_VC.virtToDestX((int)nextBottomLabelRect.getX());
                    boolean bl = rightNoSpace = (double)(destCurrRectX + horizLabelheight) + this.m_sliceLabelGap * 2.0 > (double)destNextRectX;
                    if (rightNoSpace) {
                        label = "...";
                        this.m_stageLabelTruncated = true;
                    }
                } else {
                    destPrevRectX = this.m_VC.virtToDestX((int)prevBottomLabelRect.getX());
                    destNextRectX = this.m_VC.virtToDestX((int)nextBottomLabelRect.getX());
                    rightNoSpace = (double)(destCurrRectX + horizLabelheight) + this.m_sliceLabelGap * 6.0 > (double)destNextRectX;
                    boolean bl = leftNoSpace = (double)(destPrevRectX + horizLabelheight) + this.m_sliceLabelGap * 6.0 > (double)destCurrRectX;
                    if (rightNoSpace && leftNoSpace && !((String)this.m_bottomTruncatedLabels.get(this.m_funnelSlices[theSlice.m_nSliceIdx - 1].m_nSliceIdx - 1)).equals("...")) {
                        label = "...";
                        this.m_stageLabelTruncated = true;
                    }
                }
            } else {
                prevBottomLabelRect = this.m_bottomLabelRects.get(this.m_funnelSlices[theSlice.m_nSliceIdx - 1]);
                destPrevRectX = prevBottomLabelRect == null ? 0 : this.m_VC.virtToDestX((int)prevBottomLabelRect.getX());
                boolean bl = leftNoSpace = (double)(destPrevRectX + horizLabelheight) + this.m_sliceLabelGap * 2.0 > (double)destCurrRectX;
                if (leftNoSpace) {
                    label = "...";
                    this.m_stageLabelTruncated = true;
                }
            }
            if (this.m_stageLabelTruncated) {
                this.m_bottomTruncatedLabels.setElementAt(label, theSlice.m_nSliceIdx - 1);
            }
        }
        return label;
    }

    @Override
    public void createFrame() {
        this.m_Frame = new FunnelFrameObj(this.m_Perspective);
    }

    @Override
    protected void copyParams() {
        super.copyParams();
        this.m_nFunnelTextDisplay = this.m_Perspective.getFunnelTextDisplay();
        this.m_bFunnelTextVisibility = this.m_Perspective.getDisplay(this.m_Perspective.getFunnelSliceLabel());
        this.m_nTextFormat = this.m_Perspective.getFunnelTextFormat();
        this.m_strTextFormatPattern = this.m_Perspective.getFunnelTextFormatPattern();
        this.m_funnelFrame = this.m_Perspective.getRect(new IdentObj(620));
        this.m_bFunnelLabelDisplay = this.m_Perspective.getFunnelLabelDisplay();
        this.m_viewAngle = this.m_Perspective.getFunnelViewAngle();
        this.m_rotateAngle = this.m_Perspective.getFunnelRotateAngle();
        this.m_leftRightHeightRatio = this.m_Perspective.getFunnelHeightRatio();
        this.m_skeletonBorderWidth = this.m_Perspective.getLineWidth(this.m_Perspective.getFunnelFrame());
    }

    private void _drawFunnel() {
        this.m_funnelSlices = new FunnelSliceObj[this.m_nTotalGroups + 1];
        this.m_standardFunnel = this.m_Perspective.isStandardShapeAndWidth();
        if (!this.m_standardFunnel) {
            double volume = this.calcVolume(this.m_leftSurfaceHeight / 2.0, this.m_funnelLength, this.m_rightSurfaceHeight / 2.0);
            this._createSliceObjects(volume, false);
        } else {
            this._createSliceObjects();
        }
        if (this.m_bFunnelTextVisibility) {
            this._calcTopLabelBounds();
            this._calcBottomLabelBounds();
        }
        this._drawFunnelPlotArea();
        this._drawAllFunnelSlices();
        this.m_prevTopLabelRect = null;
        this.m_prevBottomLabelRect = null;
        this._drawAllSliceLabels();
    }

    private void _createSliceObjects() {
        this.m_nSliceCount = 0;
        this.m_sliceStep = this.m_funnelLength / (double)this.m_sliceCount;
        Arc2D leftSurfaceArc = this._calcLeftSurface();
        ++this.m_nSliceCount;
        this._calcBottomLine(leftSurfaceArc);
        this._calcTopLine(leftSurfaceArc);
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        double cx = leftSurfaceArc.getFrame().getCenterX();
        double cy = leftSurfaceArc.getFrame().getCenterY();
        Arc2D leftArc = (Arc2D.Double)this.m_funnelSlices[0].m_rightArc.clone();
        if (this.m_rotateAngle != 0.0) {
            Point2D.Double pt1 = new Point2D.Double(this.m_bottomTanX1, this.m_bottomTanY1);
            Point2D.Double pt2 = new Point2D.Double(this.m_topTanX1, this.m_topTanY1);
            leftArc.setAngles(pt1, pt2);
        }
        double startX = cx;
        double r1 = this.m_leftSurfaceHeight / 2.0;
        double vertex = (cy - this.m_bottomLineYield) / this.m_bottomLineGradient;
        double h1 = vertex - cx;
        while (gEnum.hasMoreElements()) {
            int g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            double fValue = this.m_stagePercents[this.m_nSliceCount];
            Arc2D rightArc = this._createSliceArc(startX += this.m_sliceStep, cx, cy, r1, h1, leftArc);
            Color col = this._getSliceFillColor(fValue);
            Area fillArea = this._calcSliceFillArea(fValue, leftArc, rightArc, this.m_funnelSlices[this.m_nSliceCount]);
            Area sliceArea = null;
            if (this.m_funnelSlices[this.m_nSliceCount].m_renderPercent != 0.0) {
                sliceArea = this._calcSliceArea(leftArc, rightArc);
            }
            this.m_funnelSlices[this.m_nSliceCount].m_fillArea = fillArea;
            this.m_funnelSlices[this.m_nSliceCount].m_sliceArea = sliceArea;
            this.m_funnelSlices[this.m_nSliceCount].m_fillColor = col;
            this.m_funnelSlices[this.m_nSliceCount].m_nSliceIdx = this.m_nSliceCount;
            this.m_funnelSlices[this.m_nSliceCount].m_nGroupID = g;
            this.m_funnelSlices[this.m_nSliceCount].m_fSliceValue = fValue;
            leftArc = rightArc;
            ++this.m_nSliceCount;
        }
    }

    private Arc2D _calcLeftSurface() {
        Arc2D.Double leftSurfaceArc;
        double arcStartAngle = -90.0;
        double angleExtent = 360.0;
        int type = 0;
        this.m_leftEllipse = new Ellipse2D.Double(this.m_leftSurfaceStartX, this.m_leftSurfaceStartY, this.m_leftSurfaceWidth, this.m_leftSurfaceHeight);
        Arc2D.Double rightArc = leftSurfaceArc = new Arc2D.Double(this.m_leftSurfaceStartX, this.m_leftSurfaceStartY, this.m_leftSurfaceWidth, this.m_leftSurfaceHeight, arcStartAngle, angleExtent, type);
        this.m_funnelSlices[this.m_nSliceCount] = new FunnelSliceObj();
        this.m_funnelSlices[this.m_nSliceCount].m_leftArc = null;
        this.m_funnelSlices[this.m_nSliceCount].m_rightArc = rightArc;
        this.m_funnelSlices[this.m_nSliceCount].m_fillArea = new Area(rightArc);
        this.m_funnelSlices[this.m_nSliceCount].m_fillColor = null;
        this.m_funnelSlices[this.m_nSliceCount].m_nSliceIdx = this.m_nSliceCount;
        this.m_funnelSlices[this.m_nSliceCount].m_nGroupID = -1;
        this.m_funnelSlices[this.m_nSliceCount].m_fSliceValue = -1.0;
        return leftSurfaceArc;
    }

    private Arc2D _createSliceArc(double startX, double cx, double cy, double r1, double h1, Arc2D leftArc) {
        double arcStartAngle = -90.0;
        double angleExtent = 360.0;
        int type = 0;
        double h = startX - cx;
        double r2 = r1 * (h1 - h) / h1;
        double w = r2 * (this.m_rotateAngle / 90.0);
        Arc2D.Double rightArc = new Arc2D.Double(startX - w, cy - r2, 2.0 * w, 2.0 * r2, arcStartAngle, angleExtent, type);
        this._setSliceArcExtent(rightArc, startX, r2, w, cy);
        this.m_funnelSlices[this.m_nSliceCount] = new FunnelSliceObj();
        this.m_funnelSlices[this.m_nSliceCount].m_leftArc = leftArc;
        this.m_funnelSlices[this.m_nSliceCount].m_rightArc = rightArc;
        return rightArc;
    }

    private void _setSliceArcExtent(Arc2D rightArc, double startX, double r2, double w, double cy) {
        double lastx0 = startX;
        double lasty0 = this.m_bottomLineGradient * startX + this.m_bottomLineYield;
        double lasth = r2;
        double lastcx = startX;
        double dx = lastx0 - lastcx;
        double a = Math.pow(w, 2.0) * Math.pow(lasty0 - cy, 2.0) + Math.pow(lasth, 2.0) * Math.pow(dx, 2.0);
        double b = -2.0 * Math.pow(w, 2.0) * Math.pow(lasth, 2.0) * dx;
        double c = Math.pow(w, 4.0) * (Math.pow(lasth, 2.0) - Math.pow(lasty0 - cy, 2.0));
        double b24ac = Math.sqrt(Math.pow(b, 2.0) - 4.0 * a * c);
        double tpx = (-b + b24ac) / (2.0 * a);
        double tpy = this.m_topLineGradient * (tpx += lastcx) + this.m_topLineYield;
        Point2D.Double pt1 = new Point2D.Double(tpx, tpy);
        Point2D.Double pt2 = new Point2D.Double(tpx, this.m_bottomLineGradient * tpx + this.m_bottomLineYield);
        rightArc.setAngles(pt2, pt1);
    }

    private Area _calcSliceFillArea(double fValue, Arc2D leftArc, Arc2D rightArc, FunnelSliceObj theSlice) {
        double degree;
        double renderPercent = fValue;
        if (fValue > 100.0) {
            renderPercent = theSlice.m_thresholdId == -1 ? 0.0 : 100.0;
        }
        if (fValue < 0.0) {
            renderPercent = 0.0;
        }
        theSlice.m_renderPercent = renderPercent;
        Arc2D.Double currLeftArc = (Arc2D.Double)leftArc.clone();
        double r = ((RectangularShape)currLeftArc).getHeight() / 2.0;
        double angleExtent = ((Arc2D)currLeftArc).getAngleExtent() / 2.0;
        double h = r * Math.sin(Math.toRadians(angleExtent));
        if (renderPercent >= 50.0) {
            height = h * ((renderPercent - 50.0) / 50.0);
            degree = Math.toDegrees(Math.asin(height / r)) + angleExtent;
        } else {
            height = h * (renderPercent / 50.0);
            degree = angleExtent - Math.toDegrees(Math.asin((h - height) / r));
        }
        ((Arc2D)currLeftArc).setAngleExtent(degree);
        theSlice.m_leftFillArc = (Arc2D.Double)currLeftArc.clone();
        Arc2D.Double currRightArc = (Arc2D.Double)rightArc.clone();
        r = ((RectangularShape)currRightArc).getHeight() / 2.0;
        angleExtent = ((Arc2D)currRightArc).getAngleExtent() / 2.0;
        h = r * Math.sin(Math.toRadians(angleExtent));
        if (renderPercent >= 50.0) {
            height = h * ((renderPercent - 50.0) / 50.0);
            degree = Math.toDegrees(Math.asin(height / r)) + angleExtent;
        } else {
            height = h * (renderPercent / 50.0);
            degree = angleExtent - Math.toDegrees(Math.asin((h - height) / r));
        }
        ((Arc2D)currRightArc).setAngleExtent(degree);
        theSlice.m_rightFillArc = (Arc2D.Double)currRightArc.clone();
        Area fillArea = JChart_2D_Funnel._convertShapeToArea(currLeftArc, currRightArc);
        return fillArea;
    }

    private Area _calcSliceArea(Arc2D leftArc, Arc2D rightArc) {
        double actualExtent = 0.0;
        double renderPercent = 100.0;
        double degree = 1.8 * renderPercent;
        Arc2D.Double currLeftArc = (Arc2D.Double)leftArc.clone();
        if (this.m_rotateAngle != 0.0) {
            actualExtent = ((Arc2D)currLeftArc).getAngleExtent();
            degree = actualExtent / 100.0 * renderPercent;
        }
        ((Arc2D)currLeftArc).setAngleExtent(degree);
        double arcStartX1 = currLeftArc.getStartPoint().getX();
        double arcStartY1 = currLeftArc.getStartPoint().getY();
        double arcEndX1 = currLeftArc.getEndPoint().getX();
        double arcEndY1 = currLeftArc.getEndPoint().getY();
        Arc2D.Double currRightArc = (Arc2D.Double)rightArc.clone();
        if (this.m_rotateAngle != 0.0) {
            actualExtent = ((Arc2D)currRightArc).getAngleExtent();
            degree = actualExtent / 100.0 * renderPercent;
        }
        ((Arc2D)currRightArc).setAngleExtent(degree);
        double arcStartX2 = currRightArc.getStartPoint().getX();
        double arcStartY2 = currRightArc.getStartPoint().getY();
        double arcEndX2 = currRightArc.getEndPoint().getX();
        double arcEndY2 = currRightArc.getEndPoint().getY();
        GeneralPath path = new GeneralPath();
        path.moveTo((float)arcStartX1, (float)arcStartY1);
        path.lineTo((float)arcEndX1, (float)arcEndY1);
        path.lineTo((float)arcEndX2, (float)arcEndY2);
        path.lineTo((float)arcStartX2, (float)arcStartY2);
        path.lineTo((float)arcStartX1, (float)arcStartY1);
        Area fillArea = new Area(path);
        currLeftArc.setArcType(1);
        Area leftArea = new Area(currLeftArc);
        fillArea.subtract(leftArea);
        currRightArc.setArcType(1);
        Area rightArea = new Area(currRightArc);
        leftArea.intersect(rightArea);
        leftArea.exclusiveOr(rightArea);
        fillArea.add(leftArea);
        return fillArea;
    }

    private Color _getSliceFillColor(double fValue) {
        int thresholdCount = this.m_Perspective.getThresholdCount();
        Color col = null;
        double min = 0.0;
        double max = 0.0;
        this.m_funnelSlices[this.m_nSliceCount].m_thresholdId = -1;
        for (int i = 0; i < thresholdCount; ++i) {
            IdentObj idThreshold = this.m_Perspective.getThreshold(i);
            Double val = this.m_Perspective.getThresholdMinValue(idThreshold);
            if (val != null) {
                min = val;
            }
            if ((val = this.m_Perspective.getThresholdMaxValue(idThreshold)) != null) {
                max = val;
            }
            if (i == 0) {
                if (min == Double.NEGATIVE_INFINITY) {
                    if (!(fValue < max)) continue;
                    col = this.m_Perspective.getFillColor(idThreshold);
                    this.m_funnelSlices[this.m_nSliceCount].m_thresholdId = i;
                    break;
                }
                if (!(fValue >= min) || !(fValue < max)) continue;
                col = this.m_Perspective.getFillColor(idThreshold);
                this.m_funnelSlices[this.m_nSliceCount].m_thresholdId = i;
                break;
            }
            if (i == thresholdCount - 1) {
                if (max == Double.POSITIVE_INFINITY) {
                    if (!(fValue > min)) continue;
                    col = this.m_Perspective.getFillColor(idThreshold);
                    this.m_funnelSlices[this.m_nSliceCount].m_thresholdId = i;
                    break;
                }
                if (!(fValue > min) || !(fValue <= max)) continue;
                col = this.m_Perspective.getFillColor(idThreshold);
                this.m_funnelSlices[this.m_nSliceCount].m_thresholdId = i;
                break;
            }
            if (!(fValue >= min) || !(fValue <= max)) continue;
            col = this.m_Perspective.getFillColor(idThreshold);
            this.m_funnelSlices[this.m_nSliceCount].m_thresholdId = i;
            break;
        }
        return col;
    }

    private void _calcBottomLine(Arc2D leftSurfaceArc) {
        double cx = leftSurfaceArc.getFrame().getCenterX();
        double cy = leftSurfaceArc.getFrame().getCenterY();
        double w = this.m_leftSurfaceWidth / 2.0;
        double h = this.m_leftSurfaceHeight / 2.0;
        double x0 = cx + this.m_funnelLength;
        double y0 = cy + this.m_rightSurfaceHeight / 2.0;
        this._calcBottomLeftTangent(x0, y0, cx, cy, w, h);
        this._calcBottomLineEquation(x0, y0);
        this._calcBottomRightTangent(cx);
    }

    private void _calcBottomLeftTangent(double x0, double y0, double cx, double cy, double w, double h) {
        double a = Math.pow(w, 2.0) * Math.pow(y0 - cy, 2.0) + Math.pow(h, 2.0) * Math.pow(x0 - cx, 2.0);
        double b = -2.0 * Math.pow(w, 2.0) * Math.pow(h, 2.0) * (x0 - cx);
        double c = Math.pow(w, 4.0) * (Math.pow(h, 2.0) - Math.pow(y0 - cy, 2.0));
        double b24ac = Math.sqrt(Math.pow(b, 2.0) - 4.0 * a * c);
        double myX1 = (-b - b24ac) / (2.0 * a);
        double myY1 = Math.pow(h, 2.0) / (y0 - cy) * (1.0 - (x0 - cx) * myX1 / Math.pow(w, 2.0));
        this.m_bottomTanX1 = myX1 += cx;
        this.m_bottomTanY1 = myY1 += cy;
    }

    private void _calcBottomLineEquation(double x0, double y0) {
        if (this.m_funnelLength - this.m_leftSurfaceWidth / 2.0 < 0.0 || this.m_rotateAngle == 0.0) {
            this.m_bottomLineGradient = (y0 - (this.m_leftSurfaceStartY + this.m_leftSurfaceHeight)) / (x0 - this.m_leftSurfaceStartX);
            this.m_bottomLineYield = y0 - x0 * this.m_bottomLineGradient;
        } else {
            this.m_bottomLineGradient = (y0 - this.m_bottomTanY1) / (x0 - this.m_bottomTanX1);
            this.m_bottomLineYield = y0 - x0 * this.m_bottomLineGradient;
        }
    }

    private void _calcBottomRightTangent(double cx) {
        double lastcx;
        this.m_bottomTanX2 = lastcx = cx + this.m_funnelLength;
        this.m_bottomTanY2 = this.m_bottomLineGradient * this.m_bottomTanX2 + this.m_bottomLineYield;
    }

    private void _calcTopLine(Arc2D leftSurfaceArc) {
        double cx = leftSurfaceArc.getFrame().getCenterX();
        double cy = leftSurfaceArc.getFrame().getCenterY();
        double x0 = cx + this.m_funnelLength;
        double y0 = cy - this.m_rightSurfaceHeight / 2.0;
        this.m_topTanX1 = this.m_bottomTanX1;
        this.m_topTanY1 = cy - (this.m_bottomTanY1 - cy);
        if (this.m_funnelLength - this.m_leftSurfaceWidth / 2.0 < 0.0 || this.m_rotateAngle == 0.0) {
            this.m_topLineGradient = (y0 - this.m_leftSurfaceStartY) / (x0 - this.m_leftSurfaceStartX);
            this.m_topLineYield = y0 - x0 * this.m_topLineGradient;
        } else {
            this.m_topLineGradient = (y0 - this.m_topTanY1) / (x0 - this.m_topTanX1);
            this.m_topLineYield = y0 - x0 * this.m_topLineGradient;
            this.m_topTanX2 = this.m_bottomTanX2;
            this.m_topTanY2 = this.m_topLineGradient * this.m_topTanX2 + this.m_topLineYield;
        }
    }

    private void _drawAllFunnelSlices() {
        int sRel;
        for (sRel = 1; sRel < this.m_sliceCount + 1; ++sRel) {
            this._drawFunnelSlice(this.m_funnelSlices[sRel]);
        }
        for (sRel = 1; sRel < this.m_sliceCount + 1; ++sRel) {
            this._drawFunnelArc(this.m_funnelSlices[sRel]);
        }
        this._drawLeftSurface();
        IdentObj fid = this.m_Perspective.getFunnelLines();
        BlackBoxObj bb = new BlackBoxObj(this.m_Perspective, this.m_Perspective.getFunnelFrame());
        IdentObj newID = new IdentObj(fid);
        newID.setMiscID(fid.getMiscID() + 300);
        new DetLine(this.m_Detectiv, newID, this.m_VC.destToVirtX(this.m_topTanX1), this.m_VC.destToVirtY(this.m_topTanY1), this.m_VC.destToVirtX(this.m_topTanX2), this.m_VC.destToVirtY(this.m_topTanY2), (BlackBoxIF)bb, null, this.m_skeletonBorderWidth);
        newID = new IdentObj(fid);
        newID.setMiscID(fid.getMiscID() + 400);
        new DetLine(this.m_Detectiv, newID, this.m_VC.destToVirtX(this.m_bottomTanX1), this.m_VC.destToVirtY(this.m_bottomTanY1), this.m_VC.destToVirtX(this.m_bottomTanX2), this.m_VC.destToVirtY(this.m_bottomTanY2), (BlackBoxIF)bb, null, this.m_skeletonBorderWidth);
    }

    private void _drawFunnelSlice(FunnelSliceObj theSlice) {
        int nObjectID = this.getSliceObjectID(621);
        IdentObj id = new IdentObj(nObjectID, 0, theSlice.m_nGroupID);
        if (theSlice.m_renderPercent != 0.0) {
            BlackBoxIF blackBox = this._assignThresholdColor(theSlice);
            FillObj fill = blackBox.getFillObj();
            if (fill instanceof FillGradientObj) {
                FillGradientObj gradient = (FillGradientObj)fill;
                gradient.setBoundingBox(theSlice.m_sliceArea.getBounds2D());
            }
            new DetShape(this.m_Detectiv, id, blackBox, theSlice.m_fillArea);
        }
    }

    private void _drawFunnelArc(FunnelSliceObj theSlice) {
        int nObjectID = this.getSliceObjectID(626);
        IdentObj id = new IdentObj(nObjectID);
        id.setMiscID(theSlice.m_nGroupID);
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, this.m_Perspective.getFunnelFrame());
        blackBox.setTransparentFillColor(true);
        Arc2D.Double arc = (Arc2D.Double)theSlice.m_rightArc.clone();
        arc.setArcType(0);
        new DetShape(this.m_Detectiv, id, (BlackBoxIF)blackBox, arc);
    }

    private void _drawLeftSurface() {
        IdentObj id = this.m_Perspective.getFunnelLeftSurface();
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, id);
        if (!this.m_Perspective.getFunnelGradientEffect()) {
            Color col = blackBox.getFillColor();
            blackBox.setFillColor(this.m_Perspective.getDarker(col, 0.65));
        }
        new DetShape(this.m_Detectiv, id, (BlackBoxIF)blackBox, this.m_leftEllipse);
    }

    private void _drawFunnelPlotArea() {
        IdentObj id = this.m_Perspective.getFunnelFrame();
        Arc2D leftArc = this.m_funnelSlices[1].m_leftArc;
        Arc2D rightArc = this.m_funnelSlices[this.m_sliceCount].m_rightArc;
        Area fillArea = JChart_2D_Funnel._convertShapeToArea(leftArc, rightArc);
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, id);
        if (!this.m_Perspective.getFunnelGradientEffect()) {
            Color col = blackBox.getFillColor();
            blackBox.setFillColor(PresUtils.getPastel(col, 0.3));
        }
        new DetShape(this.m_Detectiv, id, (BlackBoxIF)blackBox, fillArea);
    }

    private BlackBoxIF _assignThresholdColor(FunnelSliceObj theSlice) {
        IdentObj id = this.m_Perspective.getThreshold(theSlice.m_thresholdId);
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, id);
        return blackBox;
    }

    private GeneralPath _getGeneralPathFromSlice(FunnelSliceObj theSlice, Arc2D arc, boolean fill) {
        GeneralPath path;
        Arc2D rightArc;
        Arc2D leftArc;
        if (fill) {
            leftArc = theSlice.m_leftFillArc;
            rightArc = theSlice.m_rightFillArc;
        } else {
            leftArc = theSlice.m_leftArc;
            rightArc = theSlice.m_rightArc;
        }
        if (arc != null) {
            path = new GeneralPath(leftArc);
            path.moveTo((float)leftArc.getEndPoint().getX(), (float)leftArc.getEndPoint().getY());
            path.lineTo((float)rightArc.getEndPoint().getX(), (float)rightArc.getEndPoint().getY());
            path.append(rightArc, false);
            path.moveTo((float)rightArc.getStartPoint().getX(), (float)rightArc.getStartPoint().getY());
            path.lineTo((float)leftArc.getStartPoint().getX(), (float)leftArc.getStartPoint().getY());
        } else {
            path = new GeneralPath(theSlice.m_rightArc);
        }
        return path;
    }

    private GeneralPath _getArcPath(Arc2D arc) {
        double arcWidth = 2.0;
        if ((double)this.m_skeletonBorderWidth > arcWidth) {
            arcWidth = this.m_skeletonBorderWidth;
        }
        if (arcWidth >= this.m_sliceStep) {
            arcWidth = this.m_sliceStep;
        }
        Arc2D leftArc = this._createDummyDetectArc(arc, arcWidth, true);
        Arc2D rightArc = this._createDummyDetectArc(arc, arcWidth, false);
        GeneralPath path = new GeneralPath(leftArc);
        path.moveTo((float)leftArc.getEndPoint().getX(), (float)leftArc.getEndPoint().getY());
        path.lineTo((float)rightArc.getEndPoint().getX(), (float)rightArc.getEndPoint().getY());
        path.append(rightArc, false);
        path.moveTo((float)rightArc.getStartPoint().getX(), (float)rightArc.getStartPoint().getY());
        path.lineTo((float)leftArc.getStartPoint().getX(), (float)leftArc.getStartPoint().getY());
        return path;
    }

    private Arc2D _createDummyDetectArc(Arc2D arc, double arcWidth, boolean left) {
        double arcStartAngle = -90.0;
        double angleExtent = 360.0;
        int type = 0;
        double cx = this.m_leftEllipse.getFrame().getCenterX();
        double cy = this.m_leftEllipse.getFrame().getCenterY();
        double r1 = this.m_leftSurfaceHeight / 2.0;
        double vertex = (cy - this.m_bottomLineYield) / this.m_bottomLineGradient;
        double h1 = vertex - cx;
        double startX = arc.getFrame().getCenterX();
        startX = left ? (startX -= arcWidth / 2.0) : (startX += arcWidth / 2.0);
        double h = startX - cx;
        double r2 = r1 * (h1 - h) / h1;
        double w = r2 * (this.m_rotateAngle / 90.0);
        Arc2D.Double dummyArc = new Arc2D.Double(startX - w, cy - r2, 2.0 * w, 2.0 * r2, arcStartAngle, angleExtent, type);
        this._setSliceArcExtent(dummyArc, startX, r2, w, cy);
        return dummyArc;
    }

    private Area _getLeftSurfaceBorder(Ellipse2D ellipse) {
        double borderWidth = 2.0;
        if ((double)this.m_skeletonBorderWidth > borderWidth) {
            borderWidth = this.m_skeletonBorderWidth;
        }
        Ellipse2D.Double innerEllipse = (Ellipse2D.Double)ellipse.clone();
        Ellipse2D.Double outerEllipse = (Ellipse2D.Double)ellipse.clone();
        ((RectangularShape)innerEllipse).setFrame(ellipse.getX() + borderWidth / 2.0, ellipse.getY() + borderWidth / 2.0, ellipse.getWidth() - borderWidth, ellipse.getHeight() - borderWidth);
        Area innerArea = new Area(innerEllipse);
        ((RectangularShape)outerEllipse).setFrame(ellipse.getX() - borderWidth / 2.0, ellipse.getY() - borderWidth / 2.0, ellipse.getWidth() + borderWidth, ellipse.getHeight() + borderWidth);
        Area outerArea = new Area(outerEllipse);
        outerArea.subtract(innerArea);
        return outerArea;
    }

    public double getActualValue(int g) {
        double actualValue = 0.0;
        if (this.m_Perspective.m_bValidChart) {
            SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
            int s = sEnum.getAbsoluteSeries(0);
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            DatumObj dobj = this.getDataValue(s, g);
            actualValue = dobj.m_fValue;
        }
        return actualValue;
    }

    public double getTargetValue(int g) {
        if (this.m_Perspective.m_bValidChart) {
            return this.funnelSliceLabelContainer.getTargetValue(g);
        }
        return 0.0;
    }

    @Override
    public boolean wantLegend() {
        this.m_nEffColorMode = this.m_Perspective.getEffectiveColorMode();
        return this.m_nEffColorMode == 4;
    }

    public boolean wantThreshold() {
        return true;
    }

    public int getThresholdId(int group) {
        return this.m_funnelSlices[group + 1].m_thresholdId;
    }

    public double getFunnelLength() {
        return this.m_funnelLength;
    }

    public double getLeftSurfaceWidth() {
        return this.m_leftSurfaceWidth;
    }

    public double getLeftSurfaceHeight() {
        return this.m_leftSurfaceHeight;
    }

    public double getRightSurfaceWidth() {
        return this.m_rightSurfaceWidth;
    }

    public double getRightSurfaceHeight() {
        return this.m_rightSurfaceHeight;
    }

    public static int mappedRotationAngle(int angle) {
        if (angle == 90) {
            return 90;
        }
        if (angle == 270) {
            return 270;
        }
        return angle;
    }

    private int getSliceObjectID(int nDefaultID) {
        return nDefaultID;
    }

    private double calcVolume(double r1, double h, double r2) {
        return 1.0471975511965976 * h * (Math.pow(r1, 2.0) + r1 * r2 + Math.pow(r2, 2.0));
    }

    private void _createSliceObjects(double volume, boolean recompute) {
        boolean compute;
        int g;
        double sumOfSliceWidths = 0.0;
        double sumOfSliceVols = 0.0;
        int defaultees = 0;
        this.m_nSliceCount = 0;
        this.m_sliceStep = 0.0;
        Arc2D leftSurfaceArc = this._calcLeftSurface();
        ++this.m_nSliceCount;
        this._calcBottomLine(leftSurfaceArc);
        this._calcTopLine(leftSurfaceArc);
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        double cx = leftSurfaceArc.getFrame().getCenterX();
        double cy = leftSurfaceArc.getFrame().getCenterY();
        Arc2D leftArc = (Arc2D.Double)this.m_funnelSlices[0].m_rightArc.clone();
        if (this.m_rotateAngle != 0.0) {
            Point2D.Double pt1 = new Point2D.Double(this.m_bottomTanX1, this.m_bottomTanY1);
            Point2D.Double pt2 = new Point2D.Double(this.m_topTanX1, this.m_topTanY1);
            leftArc.setAngles(pt1, pt2);
        }
        double startX = cx;
        double r1 = this.m_leftSurfaceHeight / 2.0;
        double vertex = (cy - this.m_bottomLineYield) / this.m_bottomLineGradient;
        double h1 = vertex - cx;
        boolean allZeroOrNull = true;
        double sumOfTargetValue = 0.0;
        if (!recompute) {
            while (gEnum.hasMoreElements()) {
                g = gEnum.nextGroup();
                sumOfTargetValue += this.getTargetValue(g);
                if (this.getTargetValue(g) == 0.0) continue;
                allZeroOrNull = false;
            }
            gEnum = this.getResetGroupsEnumerator();
        }
        double totVol = 1.0471975511965976 * Math.pow(r1, 2.0) * h1;
        int i = 0;
        while (gEnum.hasMoreElements()) {
            g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            double fValue = this.m_stagePercents[this.m_nSliceCount];
            if (!recompute) {
                double propTarVal = this.getTargetValue(g) / sumOfTargetValue;
                double sliceVol = propTarVal * volume;
                this.m_sliceStep = this.getFunnelSliceWidth(sumOfSliceVols += sliceVol, h1, r1, totVol) - sumOfSliceWidths;
                if (allZeroOrNull) {
                    this.m_sliceStep = this.m_funnelLength / (double)this.m_sliceCount;
                }
                if (this.m_sliceStep < (double)this.m_minWidth) {
                    ++defaultees;
                }
                sumOfSliceWidths += this.m_sliceStep;
            } else {
                this.m_sliceStep = this.m_funnelSlices[i + 1].m_width;
            }
            Arc2D rightArc = this._createSliceArc(Math.min(startX += this.m_sliceStep, cx + this.m_funnelLength), cx, cy, r1, h1, leftArc);
            Color col = this._getSliceFillColor(fValue);
            Area fillArea = this._calcSliceFillArea(fValue, leftArc, rightArc, this.m_funnelSlices[this.m_nSliceCount]);
            Area sliceArea = null;
            if (this.m_funnelSlices[this.m_nSliceCount].m_renderPercent != 0.0) {
                sliceArea = this._calcSliceArea(leftArc, rightArc);
            }
            this.m_funnelSlices[this.m_nSliceCount].m_fillArea = fillArea;
            this.m_funnelSlices[this.m_nSliceCount].m_sliceArea = sliceArea;
            this.m_funnelSlices[this.m_nSliceCount].m_fillColor = col;
            this.m_funnelSlices[this.m_nSliceCount].m_nSliceIdx = this.m_nSliceCount;
            this.m_funnelSlices[this.m_nSliceCount].m_nGroupID = g;
            this.m_funnelSlices[this.m_nSliceCount].m_fSliceValue = fValue;
            this.m_funnelSlices[this.m_nSliceCount].m_width = this.m_sliceStep;
            leftArc = rightArc;
            ++this.m_nSliceCount;
            ++i;
        }
        if (defaultees != 0 && (compute = this.adjustSliceWidth(this.m_funnelSlices, defaultees))) {
            this._createSliceObjects(volume, true);
        }
        this._calcBottomLine(leftSurfaceArc);
        this._calcTopLine(leftSurfaceArc);
    }

    private double getFunnelSliceWidth(double sliceVol, double H, double R, double totVol) {
        double r2 = Math.cbrt(3.0 * (totVol - sliceVol) * R / (Math.PI * H));
        double width = H * (R - r2) / R;
        return width;
    }

    private boolean adjustSliceWidth(FunnelSliceObj[] funnelSlices, int defaultees) {
        if (defaultees == funnelSlices.length - 1) {
            return false;
        }
        int numOfGroups = funnelSlices.length - 1 - defaultees;
        defaultees = 0;
        double excess = 0.0;
        for (int i = 1; i < this.m_funnelSlices.length; ++i) {
            if (!(this.m_funnelSlices[i].m_width < (double)this.m_minWidth)) continue;
            excess += (double)this.m_minWidth - this.m_funnelSlices[i].m_width;
        }
        double shareToAdjust = excess / (double)numOfGroups;
        for (int i = 1; i < this.m_funnelSlices.length; ++i) {
            if (this.m_funnelSlices[i].m_width < (double)this.m_minWidth) {
                this.m_funnelSlices[i].m_width = this.m_minWidth;
                continue;
            }
            this.m_funnelSlices[i].m_width -= shareToAdjust;
            if (!(this.m_funnelSlices[i].m_width < (double)this.m_minWidth)) continue;
            ++defaultees;
        }
        if ((double)defaultees >= (double)(this.m_funnelSlices.length - 1) * 0.7) {
            this.adjustSliceWidth(funnelSlices, defaultees);
        }
        return true;
    }

    private void _calcTopLabelBounds() {
        FontMetrics fm = this._getSliceLabelFontMetrics();
        int fontHeight = TextStyleObj.getFontHeight(fm, this.m_Perspective.getFontMetricsResolver());
        this.m_labelDim = new Dimension(this.m_maxLabelWidthDest, fontHeight);
        if (this.m_labelDim == null) {
            return;
        }
        Rectangle rLabelTop = null;
        int sliceLabelWidth = 0;
        int textRotationAngle = JChart_2D_Funnel.mappedRotationAngle(this.m_textStyles.getRotationAngle());
        this.m_topLabelRects = new HashMap<FunnelSliceObj, Rectangle>();
        if (this.m_textStyles.getRotationAngle() == 0 || this.m_textStyles.getRotationAngle() == 360) {
            for (int i = 1; i < this.m_funnelSlices.length; ++i) {
                FunnelSliceObj theSlice = this.m_funnelSlices[i];
                sliceLabelWidth = this.m_topLabelWidths[theSlice.m_nSliceIdx - 1];
                double xDist = theSlice.m_rightArc.getEndPoint().getX() - theSlice.m_leftArc.getEndPoint().getX();
                double yDist = theSlice.m_rightArc.getEndPoint().getY() - theSlice.m_leftArc.getEndPoint().getY();
                double xMax = this.m_funnelSlices[this.m_funnelSlices.length - 1].m_rightArc.getMaxX() + 3.0;
                int x = (int)Math.round(theSlice.m_leftArc.getEndPoint().getX() + xDist / 4.0 + this.m_sliceLabelGap);
                int y = (int)Math.round(theSlice.m_leftArc.getEndPoint().getY() + yDist / 4.0 - 3.0);
                String label = (String)this.m_topSliceLabels.elementAt(i - 1) + "  ";
                int labelWidth = this.m_Perspective.getFontMetricsResolver().stringWidth(label, fm);
                int allowWidth = (int)(xMax - (double)x);
                int width = Math.min(labelWidth, allowWidth);
                rLabelTop = new Rectangle(this.m_VC.destToVirtX(x), this.m_VC.destToVirtY(y), this.m_VC.destToVirtWidth(width), this.m_VC.destToVirtHeight(this.m_labelDim.height));
                this.m_topLabelRects.put(theSlice, rLabelTop);
            }
        } else {
            for (int i = 1; i < this.m_funnelSlices.length; ++i) {
                double x;
                double y;
                FunnelSliceObj theSlice = this.m_funnelSlices[i];
                sliceLabelWidth = this.m_topLabelWidths[theSlice.m_nSliceIdx - 1];
                Rectangle frame = this.m_VC.virtToDest(this.m_funnelFrame);
                double availLabelHeight = this.m_labelDim.height;
                double availLabelWidth = 0.0;
                double pivotY = (theSlice.m_leftArc.getEndPoint().getY() + theSlice.m_rightArc.getEndPoint().getY()) / 2.0 - availLabelHeight / 2.0 - 3.0;
                double pivotX = (theSlice.m_leftArc.getEndPoint().getX() * 3.0 + theSlice.m_rightArc.getEndPoint().getX() * 2.0) / 5.0 + this.m_sliceLabelGap;
                double sinAngle = Math.sin(Math.toRadians(textRotationAngle));
                double cosAngle = Math.cos(Math.toRadians(textRotationAngle));
                if (sinAngle == 0.0) {
                    availLabelWidth = sliceLabelWidth;
                } else {
                    double frameAvailableHeight = pivotY - (double)frame.y;
                    double hypo = frameAvailableHeight / Math.abs(sinAngle);
                    availLabelWidth = Math.min(hypo, (double)sliceLabelWidth);
                }
                if (textRotationAngle <= 180) {
                    y = pivotY - sinAngle * availLabelWidth / 2.0;
                    x = pivotX + availLabelHeight / 2.0 * sinAngle - sinAngle * availLabelWidth / 2.0;
                } else {
                    y = pivotY + sinAngle * availLabelWidth / 2.0;
                    x = pivotX - availLabelHeight / 2.0 * sinAngle + sinAngle * availLabelWidth / 2.0;
                }
                if (textRotationAngle >= 90 && textRotationAngle <= 270) {
                    y += cosAngle * availLabelHeight;
                }
                rLabelTop = new Rectangle(this.m_VC.destToVirtX((int)x), this.m_VC.destToVirtY((int)y), this.m_VC.destToVirtWidth((int)availLabelWidth), this.m_VC.destToVirtHeight((int)availLabelHeight));
                this.m_topLabelRects.put(theSlice, rLabelTop);
            }
        }
    }

    private void _calcBottomLabelBounds() {
        FontMetrics fm = this._getStageLabelFontMetrics();
        int fontHeight = TextStyleObj.getFontHeight(fm, this.m_Perspective.getFontMetricsResolver());
        this.m_stageLabelDim = new Dimension(this.m_maxStageLabelWidthDest, fontHeight);
        if (this.m_stageLabelDim == null) {
            return;
        }
        Rectangle rLabelBottom = null;
        this.m_bottomLabelRects = new HashMap<FunnelSliceObj, Rectangle>();
        int textRotationAngle = JChart_2D_Funnel.mappedRotationAngle(this.m_stageTextStyles.getRotationAngle());
        int stageLabelWidth = 0;
        if (textRotationAngle == 0 || textRotationAngle == 360) {
            for (int i = 1; i < this.m_funnelSlices.length; ++i) {
                FunnelSliceObj theSlice = this.m_funnelSlices[i];
                stageLabelWidth = this.m_bottomLabelWidths[theSlice.m_nSliceIdx - 1];
                double xDist = theSlice.m_rightArc.getStartPoint().getX() - theSlice.m_leftArc.getStartPoint().getX();
                double yDist = theSlice.m_rightArc.getStartPoint().getY() - theSlice.m_leftArc.getStartPoint().getY();
                double xMax = this.m_funnelSlices[this.m_funnelSlices.length - 1].m_rightArc.getMaxX() + 3.0;
                int x = (int)Math.round(theSlice.m_leftArc.getStartPoint().getX() + xDist / 4.0 + this.m_stageLabelGap);
                int y = (int)Math.round(theSlice.m_leftArc.getStartPoint().getY() + yDist / 4.0 + 3.0 + (double)this.m_stageLabelDim.height);
                String label = (String)this.m_bottomSliceLabels.elementAt(i - 1) + "  ";
                int labelWidth = this.m_Perspective.getFontMetricsResolver().stringWidth(label, fm);
                int allowWidth = (int)(xMax - (double)x);
                int width = Math.min(labelWidth, allowWidth);
                rLabelBottom = new Rectangle(this.m_VC.destToVirtX(x), this.m_VC.destToVirtY(y), this.m_VC.destToVirtWidth(width), this.m_VC.destToVirtHeight(this.m_stageLabelDim.height));
                this.m_bottomLabelRects.put(theSlice, rLabelBottom);
            }
        } else {
            for (int i = 1; i < this.m_funnelSlices.length; ++i) {
                double x;
                double y;
                FunnelSliceObj theSlice = this.m_funnelSlices[i];
                stageLabelWidth = this.m_bottomLabelWidths[theSlice.m_nSliceIdx - 1];
                Rectangle frame = this.m_VC.virtToDest(this.m_funnelFrame);
                double availLabelHeight = this.m_stageLabelDim.height;
                double availLabelWidth = 0.0;
                double pivotY = (theSlice.m_leftArc.getStartPoint().getY() + theSlice.m_rightArc.getStartPoint().getY()) / 2.0 + 7.0 + (double)this.m_stageLabelDim.height;
                double pivotX = (theSlice.m_leftArc.getStartPoint().getX() * 3.0 + theSlice.m_rightArc.getStartPoint().getX() * 2.0) / 5.0 + this.m_stageLabelGap;
                double sinAngle = Math.sin(Math.toRadians(textRotationAngle));
                double cosAngle = Math.cos(Math.toRadians(textRotationAngle));
                if (sinAngle == 0.0) {
                    availLabelWidth = stageLabelWidth;
                } else {
                    double frameAvailableHeight = (double)(frame.y + frame.height) - pivotY;
                    double hypo = frameAvailableHeight / Math.abs(sinAngle);
                    availLabelWidth = Math.min(hypo, (double)stageLabelWidth);
                }
                if (textRotationAngle > 180) {
                    y = pivotY - availLabelWidth * sinAngle / 2.0;
                    x = pivotX - availLabelHeight / 2.0 * sinAngle + availLabelWidth * sinAngle / 2.0;
                } else {
                    y = pivotY + availLabelWidth * sinAngle / 2.0;
                    x = pivotX + availLabelHeight / 2.0 * sinAngle - availLabelWidth * sinAngle / 2.0;
                }
                rLabelBottom = new Rectangle(this.m_VC.destToVirtX((int)x), this.m_VC.destToVirtY((int)y), this.m_VC.destToVirtWidth((int)availLabelWidth), this.m_VC.destToVirtHeight((int)availLabelHeight));
                this.m_bottomLabelRects.put(theSlice, rLabelBottom);
            }
        }
    }

    private static Area _convertShapeToArea(Arc2D shape, Arc2D shape2) {
        PathIterator pi2;
        if (shape == null || shape2 == null) {
            return null;
        }
        GeneralPath path = new GeneralPath();
        PathIterator pi = shape.getPathIterator(null);
        if (pi != null) {
            path.append(pi, false);
        }
        if ((pi2 = ReversePathIterator.getReversePathIterator(shape2)) != null) {
            path.append(pi2, true);
        }
        return new Area(path);
    }

    private void copyFunnelParams() {
        this.funnelSliceLabelContainer = this.m_Perspective.getFunnelLabelContainer().getFunnelSliceLabelContainer();
        this.funnelStageLabelContainer = this.m_Perspective.getFunnelLabelContainer().getFunnelStageLabelContainer();
        this.m_textStyles = this.funnelSliceLabelContainer.getTextStyle();
        this.m_stageTextStyles = this.funnelStageLabelContainer.getTextStyle();
        this.m_sliceLabelGap = this.funnelSliceLabelContainer.getSliceLabelGap();
        this.m_stageLabelGap = this.funnelStageLabelContainer.getStageLabelGap();
        this.m_stagePercents = this.funnelSliceLabelContainer.getPercents();
        this.m_topSliceLabels = this.funnelSliceLabelContainer.getLabels();
        this.m_bottomSliceLabels = this.funnelStageLabelContainer.getLabels();
        this.m_topTruncatedLabels = this.funnelSliceLabelContainer.getTruncatedLabels();
        this.m_bottomTruncatedLabels = this.funnelStageLabelContainer.getTruncatedLabels();
        this.m_maxLabelWidthDest = this.funnelSliceLabelContainer.getMaxSliceLabelWidth();
        this.m_maxStageLabelWidthDest = this.funnelStageLabelContainer.getMaxStageLabelWidth();
        this.m_sliceCount = this.funnelSliceLabelContainer.getSliceCount();
    }
}

