/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.DataCallback;
import oracle.dss.graph.DataStyleContext;
import oracle.dss.graph.DataStyleType;
import oracle.dss.util.DataAccess;
import oracle.javatools.annotations.Concealed;

@Concealed
public class DataStyle {
    protected HashMap<DataStyleType, HashMap<Object, Integer>> m_styleMap;
    HashMap<String, Integer> m_edgeLayerIdxMap;
    DataAccess m_dataAccess;
    DataCallback m_dataCallback;
    CommonGraph m_graph;
    ArrayList<DataStyleContext> m_contextList;

    @Concealed
    public DataStyle(CommonGraph graph) {
        this.m_graph = graph;
        this.m_dataAccess = graph.getDataAccess();
        this.m_dataCallback = graph.getPFJ().getDataGridCallback();
        this.m_styleMap = new HashMap();
        this.m_contextList = new ArrayList();
    }

    @Concealed
    public Object getStyleValue(DataStyleType styleType, Object styleKey) {
        DataStyleContext context = this.getContext(styleType, styleKey);
        if (this.m_graph.getPFJ().m_filteredKeys.contains(String.valueOf(this.getStyleId(styleType, styleKey)))) {
            return null;
        }
        if (context != null) {
            return context.getStyle();
        }
        return null;
    }

    @Concealed
    public Set getStyleKeys(DataStyleType styleType) {
        HashMap<Object, Integer> map = this.m_styleMap.get((Object)styleType);
        if (map == null) {
            return null;
        }
        return map.keySet();
    }

    @Concealed
    public DataStyleContext addKeyFromAnalyticLayer(DataStyleType styleType, String aLayerName, int row, int col) {
        return this.addToStyleMap(styleType, this.getKeyFromAnalyticLayer(aLayerName, row, col), aLayerName, this.m_graph.isDataRowShownAsASeries() ? row : col);
    }

    @Concealed
    public DataStyleContext addKeyFromEdgeMetadata(DataStyleType styleType, String edgeLayerName, int edge, int slice) {
        return this.addToStyleMap(styleType, this.getKeyFromEdgeMetadata(edgeLayerName, edge, slice), edgeLayerName, slice);
    }

    @Concealed
    protected Object getKeyFromAnalyticLayer(String aLayerName, int row, int col) {
        try {
            Object styleKey = this.m_dataCallback.getValue(row, col, aLayerName);
            return styleKey;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Concealed
    protected Object getKeyFromEdgeMetadata(String edgeLayerName, int edge, int slice) {
        if (this.m_edgeLayerIdxMap == null) {
            this.m_edgeLayerIdxMap = new HashMap();
        }
        Integer layerIdx = this.m_edgeLayerIdxMap.get(edgeLayerName);
        try {
            if (layerIdx == null) {
                for (int i = 0; i < this.m_dataAccess.getLayerCount(edge); ++i) {
                    if (!edgeLayerName.equals(this.m_dataAccess.getLayerMetadata(edge, i, "layerName"))) continue;
                    layerIdx = i;
                    this.m_edgeLayerIdxMap.put(edgeLayerName, layerIdx);
                    break;
                }
                if (layerIdx == null) {
                    return null;
                }
            }
            Object key = this.m_dataAccess.getMemberMetadata(1, layerIdx.intValue(), slice, "value");
            return key;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private DataStyleContext addToStyleMap(DataStyleType styleType, Object styleKey, String layerName, int series) {
        ArrayList<Integer> sliceList;
        if (styleKey == null) {
            return null;
        }
        HashMap<Object, Integer> map = this.m_styleMap.get((Object)styleType);
        DataStyleContext context = null;
        if (map == null) {
            map = new HashMap();
            this.m_styleMap.put(styleType, map);
        }
        if (!map.containsKey(styleKey)) {
            int styleKeyId = map.size();
            Object styleValue = this.assignValue(styleType, styleKey, styleKeyId);
            int styleId = this.m_contextList.size();
            context = new DataStyleContext(layerName, styleKey, styleValue, styleType, new ArrayList<Integer>(), styleId);
            this.m_contextList.add(context);
            map.put(styleKey, styleId);
        }
        ArrayList<Integer> arrayList = sliceList = context != null ? context.getSeries() : this.m_contextList.get(map.get(styleKey)).getSeries();
        if (!sliceList.contains(series)) {
            sliceList.add(series);
        }
        return context;
    }

    @Concealed
    protected Object assignValue(DataStyleType styleType, Object styleKey, int id) {
        return null;
    }

    public int getStyleId(DataStyleType styleType, Object styleKey) {
        HashMap<Object, Integer> map = this.m_styleMap.get((Object)styleType);
        if (map != null && map.get(styleKey) != null) {
            return map.get(styleKey);
        }
        return -3;
    }

    @Concealed
    public DataStyleContext getContext(DataStyleType styleType, Object styleKey) {
        int styleId = this.getStyleId(styleType, styleKey);
        return this.getContext(styleId);
    }

    @Concealed
    public DataStyleContext getContext(int styleId) {
        if (styleId >= 0 && styleId < this.m_contextList.size()) {
            return this.m_contextList.get(styleId);
        }
        return null;
    }
}

