/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.DataChunk;
import oracle.dss.graph.pfj.DataRange;
import oracle.dss.graph.pfj.PfjAssert;

public class DataStorage
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int USER_PAGE = 0;
    public static final int MISSING_DATA_PAGE = 1;
    private DataRange m_DataExtents;
    private Vector m_chunks = new Vector();
    private Object[][] m_dataGrid = null;

    public DataStorage() {
        this.m_DataExtents = new DataRange();
    }

    public DataStorage(DataStorage dsSrc) {
        if (dsSrc.m_dataGrid != null) {
            this.m_dataGrid = (Object[][])dsSrc.m_dataGrid.clone();
        } else {
            Enumeration e = dsSrc.m_chunks.elements();
            while (e.hasMoreElements()) {
                DataChunk srcChunk = (DataChunk)e.nextElement();
                DataChunk chunk = new DataChunk(srcChunk);
                this.m_chunks.addElement(chunk);
            }
        }
        this.m_DataExtents = new DataRange(dsSrc.m_DataExtents);
    }

    public DataStorage(double[][] theData) {
        this();
        this.setDataMatrix(theData);
    }

    public DataStorage(double[][] theData, int rowStart, int colStart) {
        this();
        this.setDataMatrix(rowStart, colStart, theData);
    }

    public DataStorage(double[] theData, int rowStart) {
        this();
        this.setDataRow(rowStart, theData);
    }

    public DataStorage(double[] theData, int rowStart, int colStart) {
        this();
        this.setDataRow(rowStart, colStart, theData);
    }

    public void dumpPage() {
        this.dumpPage(0);
    }

    public void dumpPage(int page) {
        Enumeration e = this.m_chunks.elements();
        while (e.hasMoreElements()) {
            DataChunk chunk = (DataChunk)e.nextElement();
            if (!chunk.isOnPage(page)) continue;
            chunk.dumpChunk();
        }
    }

    public DataChunk findChunk(int page, int row, int col) {
        int chunkCount = this.m_chunks.size();
        for (int iChunk = 0; iChunk < chunkCount; ++iChunk) {
            DataChunk chunk = (DataChunk)this.m_chunks.elementAt(iChunk);
            if (!chunk.contains(page, row, col)) continue;
            return chunk;
        }
        return null;
    }

    public Object getData(int row, int col) {
        Object obj = null;
        PfjAssert.pfjAssert(row >= 0 && col >= 0);
        if (this.m_dataGrid != null) {
            obj = this.m_dataGrid[row][col];
        } else {
            DataChunk chunk = this.findChunk(0, row, col);
            if (chunk == null) {
                PfjAssert.pfjAssert(chunk, "Cell Not In Chunk for row = " + row + ", col = " + col);
            }
            obj = chunk.getData(row, col);
        }
        return obj;
    }

    public double getDataAsDouble(int row, int col) {
        Object obj = this.getData(row, col);
        if (DataStorage.isObjectNumeric(obj)) {
            Number nObj = (Number)obj;
            return nObj.doubleValue();
        }
        if (DataStorage.isObjectDate(obj)) {
            Long val = ((Date)obj).getTime();
            return val.doubleValue();
        }
        if (obj == null) {
            return Double.NaN;
        }
        throw new AssertionException("Cell at row = " + row + ", col = " + col + " is NOT a Number.");
    }

    public String getDataAsString(int row, int col) {
        String str = null;
        Object obj = this.getData(row, col);
        if (obj != null) {
            str = obj.toString();
        }
        return str;
    }

    public DataRange getDataExtents() {
        return this.m_DataExtents;
    }

    public boolean isCellNumeric(int row, int col) {
        Object obj = this.getData(row, col);
        return DataStorage.isObjectNumeric(obj);
    }

    public static boolean isObjectNumeric(Object obj) {
        if (obj == null) {
            return false;
        }
        boolean bNumeric = false;
        if (obj instanceof Number) {
            bNumeric = true;
        }
        return bNumeric;
    }

    public static boolean isObjectDate(Object obj) {
        if (obj == null) {
            return false;
        }
        boolean bDate = false;
        if (obj instanceof Date) {
            bDate = true;
        }
        return bDate;
    }

    public void setData(int row, int col, double fValue) {
        this.setData(row, col, (Object)fValue);
    }

    public void setData(int row, int col, Object obj) {
        PfjAssert.pfjAssert(row >= 0 && col >= 0);
        if (row < 0 || col < 0) {
            return;
        }
        if (this.m_dataGrid != null) {
            this.m_dataGrid[row][col] = obj;
        } else {
            DataChunk chunk = this.findChunk(0, row, col);
            if (chunk == null) {
                chunk = new DataChunk(0, row, col);
                this.m_chunks.addElement(chunk);
            }
            if (obj instanceof Double && ((Double)obj).isNaN()) {
                obj = null;
            }
            chunk.setData(row, col, obj);
            if (obj != null) {
                this.m_DataExtents.extendTo(row, col);
            }
            this.setFillMissingData(row, col, false);
        }
    }

    public void deleteRow(int row) {
        if (this.m_dataGrid != null) {
            for (int r = row; r < this.m_dataGrid.length; ++r) {
                this.m_dataGrid[r] = this.m_dataGrid[r + 1];
            }
            this.m_dataGrid[this.m_dataGrid.length - 1] = null;
        } else {
            DataChunk chunk;
            int numRows = this.m_DataExtents.getNumRows();
            int numCols = this.m_DataExtents.getNumCols();
            int r = row;
            while (r + 1 < numRows) {
                for (int c = 0; c < numCols; ++c) {
                    DataChunk nextChunk;
                    chunk = this.findChunk(0, r, c);
                    if (chunk == null || (nextChunk = this.findChunk(0, r + 1, c)) == null) continue;
                    chunk.setData(r, c, nextChunk.getData(r + 1, c));
                }
                ++r;
            }
            for (int c = 0; c < numCols; ++c) {
                chunk = this.findChunk(0, numRows - 1, c);
                if (chunk == null) continue;
                chunk.setData(numRows - 1, c, null);
            }
        }
        this.m_DataExtents.shrinkTo(this.m_DataExtents.getRowStart(), this.m_DataExtents.getColStart(), this.m_DataExtents.getRowStop() - 1, this.m_DataExtents.getColStop());
    }

    public void deleteCol(int col) {
        if (this.m_dataGrid != null) {
            for (int r = 0; r < this.m_dataGrid.length; ++r) {
                if (this.m_dataGrid[r] == null) continue;
                for (int c = col; c < this.m_dataGrid[r].length; ++c) {
                    this.m_dataGrid[r][c] = this.m_dataGrid[r][c + 1];
                }
                this.m_dataGrid[r][this.m_dataGrid[r].length - 1] = null;
            }
        } else {
            DataChunk chunk;
            int numRows = this.m_DataExtents.getNumRows();
            int numCols = this.m_DataExtents.getNumCols();
            int c = col;
            while (c + 1 < numCols) {
                for (int r = 0; r < numRows; ++r) {
                    DataChunk nextChunk;
                    chunk = this.findChunk(0, r, c);
                    if (chunk == null || (nextChunk = this.findChunk(0, r, c + 1)) == null) continue;
                    chunk.setData(r, c, nextChunk.getData(r, c + 1));
                }
                ++c;
            }
            for (int r = 0; r < numRows; ++r) {
                chunk = this.findChunk(0, r, numCols - 1);
                if (chunk == null) continue;
                chunk.setData(r, numCols - 1, null);
            }
        }
        this.m_DataExtents.shrinkTo(this.m_DataExtents.getRowStart(), this.m_DataExtents.getColStart(), this.m_DataExtents.getRowStop(), this.m_DataExtents.getColStop() - 1);
    }

    public void setDataMatrix(double[][] theData) {
        this.setDataMatrix(0, 0, theData);
    }

    public void setDataMatrix(Object[][] theData) {
        this.setDataMatrix(0, 0, theData);
    }

    public void setDataMatrix(int rowStart, int colStart, double[][] theData) {
        int nrows = theData.length;
        int ncols = theData[0].length;
        for (int ir = 0; ir < nrows; ++ir) {
            for (int ic = 0; ic < ncols; ++ic) {
                this.setData(rowStart + ir, colStart + ic, (Object)theData[ir][ic]);
            }
        }
    }

    public void setDataMatrix(int rowStart, int colStart, Object[][] theData) {
        int nrows = theData.length;
        int ncols = theData[0].length;
        for (int ir = 0; ir < nrows; ++ir) {
            for (int ic = 0; ic < ncols; ++ic) {
                this.setData(rowStart + ir, colStart + ic, theData[ir][ic]);
            }
        }
    }

    public void setDataRow(int rowStart, double[] theData) {
        this.setDataRow(rowStart, 0, theData);
    }

    public void setDataRow(int rowStart, Object[] theData) {
        this.setDataRow(rowStart, 0, theData);
    }

    public void setDataRow(int rowStart, int colStart, double[] theData) {
        int ncols = theData.length;
        for (int ic = 0; ic < ncols; ++ic) {
            this.setData(rowStart, colStart + ic, (Object)theData[ic]);
        }
    }

    public void setDataRow(int rowStart, int colStart, Object[] theData) {
        int ncols = theData.length;
        for (int ic = 0; ic < ncols; ++ic) {
            this.setData(rowStart, colStart + ic, theData[ic]);
        }
    }

    public void setFillMissingData(int nRow, int nCol, boolean bFillMissingData) {
        Boolean boolObj = bFillMissingData ? Boolean.TRUE : Boolean.FALSE;
        DataChunk missingDataChunk = this.findChunk(1, nRow, nCol);
        if (missingDataChunk == null) {
            missingDataChunk = new DataChunk(1, nRow, nCol);
            this.m_chunks.addElement(missingDataChunk);
        }
        missingDataChunk.setData(nRow, nCol, boolObj);
    }

    public boolean isMissingDataFilledIn(int nRow, int nCol) {
        Boolean boolObj;
        PfjAssert.pfjAssert(nRow >= 0 && nCol >= 0);
        if (this.m_dataGrid != null) {
            return false;
        }
        DataChunk missingDataChunk = this.findChunk(1, nRow, nCol);
        if (missingDataChunk == null) {
            PfjAssert.pfjAssert(missingDataChunk, "Cell Not In Chunk for row = " + nRow + ", col = " + nCol);
        }
        if ((boolObj = (Boolean)missingDataChunk.getData(nRow, nCol)) == null) {
            throw new AssertionException("Empty Missing Data Cell for row = " + nRow + ", col = " + nCol);
        }
        return boolObj;
    }

    public void setGridSize(int rows, int columns) {
        this.m_dataGrid = new Object[rows][columns];
        this.m_DataExtents.extendTo(rows - 1, columns - 1);
    }
}

