/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import oracle.dss.graph.pfj.Access;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.AxisTemplate;
import oracle.dss.graph.pfj.CircularFrameObj;
import oracle.dss.graph.pfj.DataRange;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_2D;
import oracle.dss.graph.pfj.JChart_2D_Standard;
import oracle.dss.graph.pfj.MinMaxObj;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.RelativeAxisObj;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetLine;
import oracle.dss.graph.pfj.draw.DetOval;
import oracle.dss.graph.pfj.draw.DetPolyline;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;

public class CircularAxisObj
extends RelativeAxisObj {
    private static final long serialVersionUID = 1L;
    private static final int TICKSIZE = 250;
    private static final double TICK_RADIUS_LENGTH = 0.05;
    protected static final double RELATIVE_Y1AXIS_BODY_ANGLE = 0.0;
    protected static final double RELATIVE_Y2AXIS_BODY_ANGLE = 0.0;
    protected static final double MAJOR_GRID_ANCOR = 0.0;
    protected static final double MINOR_GRID_ANCOR = 0.66;
    protected static final int Y_AXIS_TICK_LABEL_MARGIN = 3;
    protected boolean m_radarGraphType = false;
    protected boolean m_bRadiusAxis;
    protected Dimension m_frameDimVC;
    protected Point m_centerFramePosVC;
    protected boolean m_bVertScale;
    protected boolean m_polygonSides = true;
    protected int m_numLabels = 0;
    protected List m_o1PosRel = null;

    public CircularAxisObj(Perspective perspective, Access access, AxisTemplate id, MinMaxObj minMax, boolean bAscending, boolean bVertical, int nAxisOffset, int nAxisSize, boolean bRadius) {
        super(perspective, access, id, minMax, bAscending, nAxisOffset, nAxisSize);
        this.m_bRadiusAxis = bRadius;
        this.m_bVertScale = bVertical;
        this.initVariables();
    }

    public CircularAxisObj(Perspective perspective, Access access, AxisTemplate id, boolean bAscending, int nAxisOffset, int nAxisSize, boolean bRadius) {
        super(perspective, access, id, 9, bAscending);
        this.m_bRadiusAxis = bRadius;
        this.m_bVertScale = false;
        this.initVariables();
    }

    @Override
    protected void adjustTitlePosPass1(int nSide, List rLabels, Rectangle rTitle) {
        if (rTitle != null) {
            Rectangle r = rLabels.size() == 1 ? (Rectangle)rLabels.get(0) : (Rectangle)rLabels.get(1);
            if (this.m_bVertScale) {
                if (nSide == 0) {
                    rTitle.width = r.x - rTitle.x;
                    rTitle.x = r.x - rTitle.width - 50;
                } else {
                    rTitle.width = rTitle.width + rTitle.x - (r.x + r.width);
                    rTitle.x = r.x + r.width + 50;
                }
            } else {
                rTitle.y = nSide == 0 ? r.y - rTitle.height : r.y + r.height;
            }
        }
    }

    @Override
    protected void adjustTitlePosPass2(IdentObj id, int nSide, Rectangle rTitle, Dimension labelDim) {
        if (this.m_bVertScale) {
            if (nSide == 0) {
                int nRight = rTitle.x + rTitle.width;
                rTitle.width = Math.min(rTitle.width, labelDim.width);
                rTitle.x = nRight - rTitle.width;
            } else {
                rTitle.width = Math.min(rTitle.width, labelDim.width);
            }
        } else if (nSide == 0) {
            int nTop = rTitle.y + rTitle.height;
            rTitle.height = Math.min(rTitle.height, labelDim.height);
            rTitle.y = nTop - rTitle.height;
        } else {
            rTitle.height = Math.min(rTitle.height, labelDim.height);
        }
    }

    @Override
    public void calc() {
        this.initAxis();
        super.calc();
        if (this.m_bNumericAxis && this.m_Perspective.getDisplay(this.m_template.getZeroLine()) && this.isZeroInRange()) {
            this.calcZeroLine();
        }
    }

    @Override
    public void calcAxisBody() {
        if (!this.m_Perspective.getDisplay(this.m_template.getBody())) {
            return;
        }
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, this.m_template.getBody());
        if (this.m_bRadiusAxis) {
            Point pt1 = new Point(0, 0);
            Point pt2 = new Point(0, 0);
            double relAxisBodyAngle = this.m_template.getAxis().getObjectID() == this.m_Perspective.getY1Axis().getObjectID() ? 0.0 : 0.0;
            CircularAxisObj.polarToCartesian(pt1, CircularAxisObj.getAngleFromRelAngle(relAxisBodyAngle, this.m_Perspective), 0.0, this.m_frameDimVC, this.m_centerFramePosVC, this.m_Perspective.m_VC);
            CircularAxisObj.polarToCartesian(pt2, CircularAxisObj.getAngleFromRelAngle(relAxisBodyAngle, this.m_Perspective), 1.0, this.m_frameDimVC, this.m_centerFramePosVC, this.m_Perspective.m_VC);
            new DetLine(this.m_Perspective.getDetectiv(), this.m_template.getZeroLine(), pt1.x, pt1.y, pt2.x, pt2.y, (BlackBoxIF)blackBox, null, this.m_Perspective.getLineWidth(this.m_template.getBody()), this.m_Perspective.getLineStyle(this.m_template.getBody()));
        } else if (!this.m_polygonSides) {
            new DetOval(this.m_Perspective.getDetectiv(), this.m_template.getZeroLine(), this.m_centerFramePosVC.x - this.m_frameDimVC.width / 2, this.m_centerFramePosVC.y - this.m_frameDimVC.height / 2, this.m_frameDimVC.width, this.m_frameDimVC.height, blackBox, false, true, true);
        }
    }

    @Override
    protected void calcMajorGridLine(IdentObj id, double fRelPos, BlackBoxIF blackBox) {
        this.calcLineOnFrame(this.m_Perspective.getGridStyle(this.m_template.getMajor()), fRelPos, id, blackBox, this.m_Perspective.getLineWidth(this.m_template.getMajor()), this.m_Perspective.getLineStyle(this.m_template.getMajor()), 0.0);
    }

    @Override
    protected void calcMinorGridLine(IdentObj id, double fRelPos, BlackBoxIF blackBox) {
        this.calcLineOnFrame(this.m_Perspective.getGridStyle(this.m_template.getMinor()), fRelPos, id, blackBox, this.m_Perspective.getLineWidth(this.m_template.getMinor()), this.m_Perspective.getLineStyle(this.m_template.getMajor()), 0.66);
    }

    protected void calcZeroLine() {
        if (this.m_bNumericAxis) {
            BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, this.m_template.getZeroLine());
            if (this.m_bRadiusAxis) {
                Rectangle rOval = this.getValueOval(this.getValueRelCoord(0.0));
                new DetOval(this.m_Perspective.getDetectiv(), this.m_template.getZeroLine(), rOval.x, rOval.y, rOval.width, rOval.height, blackBox, false, true, true);
            } else {
                Point pt2 = new Point(0, 0);
                double angle = this.getValueCoord(0.0);
                CircularAxisObj.polarToCartesian(pt2, angle, 1.0, this.m_frameDimVC, this.m_centerFramePosVC, this.m_Perspective.m_VC);
                new DetLine(this.m_Perspective.getDetectiv(), this.m_template.getZeroLine(), this.m_centerFramePosVC.x, this.m_centerFramePosVC.y, pt2.x, pt2.y, (BlackBoxIF)blackBox, null, this.m_Perspective.getLineWidth(this.m_template.getZeroLine()), this.m_Perspective.getLineStyle(this.m_template.getBody()));
            }
        } else {
            throw new AssertionException("Numerical method called by ordinal axis");
        }
    }

    public static void cartesianToPolar(Point pt, Double angle, Double relRadius) {
    }

    @Override
    protected boolean doDisplayOnCalc() {
        return true;
    }

    @Override
    protected boolean isVertical() {
        return this.m_bVertScale;
    }

    public static double getAngleFromRelAngle(double fRelAngle, Perspective pfj) {
        double angle = fRelAngle * 360.0 + 270.0 + (double)pfj.getPieRotate();
        if (angle > 360.0) {
            angle -= 360.0;
        }
        return angle;
    }

    @Override
    protected int getAxisSide() {
        return this.m_Perspective.getAxisSide(this.m_template.getAxis());
    }

    @Override
    protected boolean isAxisLabelVisible(int nSide) {
        return true;
    }

    @Override
    public double getBaseCoord() {
        if (this.m_bNumericAxis) {
            if (this.m_bRadiusAxis) {
                return this.getBaseRelCoord();
            }
            return CircularAxisObj.getAngleFromRelAngle(this.getBaseRelCoord(), this.m_Perspective);
        }
        throw new AssertionException("Numerical method called by ordinal axis");
    }

    @Override
    public double getCenterCoord(int g) {
        if (!this.m_bNumericAxis) {
            if (this.m_bRadiusAxis) {
                return this.getCenterRelCoord(g);
            }
            if (this.m_numGroups > 1) {
                return CircularAxisObj.getAngleFromRelAngle(this.getCenterRelCoord(g), this.m_Perspective);
            }
            return CircularAxisObj.getAngleFromRelAngle(0.0, this.m_Perspective);
        }
        throw new AssertionException("Ordinal method called by numerical axis");
    }

    @Override
    public int getGroupAboveCoord(int nCoord) {
        if (!this.m_bNumericAxis) {
            return 0;
        }
        throw new AssertionException("Ordinal Axis method call on numerical axis");
    }

    @Override
    public int getGroupBelowCoord(int nCoord) {
        if (!this.m_bNumericAxis) {
            return 0;
        }
        throw new AssertionException("Ordinal Axis method call on numerical axis");
    }

    @Override
    public int getGroupAboveCoordForZoom(int nCoord) {
        if (!this.m_bNumericAxis) {
            return 0;
        }
        throw new AssertionException("Ordinal Axis method call on numerical axis");
    }

    @Override
    public int getGroupBelowCoordForZoom(int nCoord) {
        if (!this.m_bNumericAxis) {
            return 0;
        }
        throw new AssertionException("Ordinal Axis method call on numerical axis");
    }

    @Override
    public double getHighCoord(int s, int g) {
        if (!this.m_bNumericAxis) {
            if (this.m_bRadiusAxis) {
                return this.getHighRelCoord(s, g);
            }
            if (this.m_numGroups > 1) {
                return CircularAxisObj.getAngleFromRelAngle((double)g / (double)this.m_numGroups, this.m_Perspective);
            }
            return CircularAxisObj.getAngleFromRelAngle(0.0, this.m_Perspective);
        }
        throw new AssertionException("Ordinal method called by numerical axis");
    }

    @Override
    protected void alignTop(Rectangle rLabel, Dimension dimLargestLabelVC) {
        rLabel.y += rLabel.height;
    }

    @Override
    protected void alignBottom(Rectangle rLabel, Dimension dimLargestLabelVC) {
        rLabel.y -= dimLargestLabelVC.height;
    }

    @Override
    protected void getLabelAndTitlePos(int nSide, int nLabels, List rLabels, List fRelPos, List align, Rectangle rTitle, boolean bRotate, int nAutoSkip, int nLabelBegin, int nSkipFactor, TextStyleObj textStyleLabel) {
        int nMaxDim;
        Integer nAlign = null;
        Rectangle rSpace = this.getSpaceAvailable(nSide, this.m_Perspective.m_VC);
        int[] nPos = new int[nLabels];
        int titleHeight = 0;
        if (this.m_bRadiusAxis) {
            titleHeight = rTitle != null ? (this.m_bVertScale ? Math.min(rSpace.width / 3, 2300) : Math.min(rSpace.height / 3, 2300)) : 0;
        } else {
            rTitle = null;
        }
        if (this.m_bRadiusAxis) {
            int i;
            for (int i2 = 0; i2 < nLabels; ++i2) {
                Point pt = new Point(0, 0);
                double radius = (Double)fRelPos.get(i2);
                if (this.m_bVertScale) {
                    CircularAxisObj.polarToCartesian(pt, 270.0, radius, this.m_frameDimVC, this.m_centerFramePosVC, this.m_Perspective.m_VC);
                    nPos[i2] = pt.y;
                    continue;
                }
                CircularAxisObj.polarToCartesian(pt, 0.0, radius, this.m_frameDimVC, this.m_centerFramePosVC, this.m_Perspective.m_VC);
                nPos[i2] = pt.x;
            }
            nMaxDim = Math.abs(nPos[1] - nPos[0]);
            nAlign = nSide == 0 ? (this.m_bVertScale ? Integer.valueOf(5) : Integer.valueOf(3)) : (this.m_bVertScale ? Integer.valueOf(1) : Integer.valueOf(7));
            for (i = 0; i < nLabels; ++i) {
                align.add(i, nAlign);
            }
            for (i = 0; i < nLabels; ++i) {
                Rectangle r = this.m_bVertScale ? new Rectangle(rSpace.x - this.m_Perspective.getVC().destToVirtWidth(3), nPos[i] - nMaxDim / 2, rSpace.width, nMaxDim) : new Rectangle(nPos[i] - nMaxDim / 2, rSpace.y, nMaxDim, rSpace.height);
                rLabels.add(i, r);
            }
        } else {
            Dimension dim = this.m_Perspective.m_VC.getVirtDimension();
            Point pt = new Point(0, 0);
            ArrayList<Point> points = new ArrayList<Point>();
            for (int i = 0; i < nLabels; ++i) {
                Rectangle r;
                double relPos = (Double)fRelPos.get(i);
                double angle = CircularAxisObj.getAngleFromRelAngle(relPos, this.m_Perspective);
                CircularAxisObj.polarToCartesian(pt, angle, 1.0, this.m_frameDimVC, this.m_centerFramePosVC, this.m_Perspective.m_VC);
                points.add(new Point(pt.x, pt.y));
                if (angle > 345.0 || angle < 15.0) {
                    int maxHalfHeight = Math.min(dim.height / 2 - pt.y, pt.y + dim.height / 2);
                    r = new Rectangle(pt.x + this.m_Perspective.m_VC.destToVirtWidth(3), pt.y - maxHalfHeight, dim.width / 2 - pt.x, 2 * maxHalfHeight);
                    nAlign = 1;
                } else if (angle < 80.0) {
                    r = new Rectangle(pt.x + this.m_Perspective.m_VC.destToVirtWidth(2), pt.y + this.m_Perspective.m_VC.destToVirtWidth(3), dim.width / 2 - pt.x, dim.height / 2 - pt.y);
                    nAlign = 8;
                } else if (angle < 100.0) {
                    int maxHalfWidth = Math.min(dim.width / 2 - pt.x, pt.x + dim.width / 2);
                    r = new Rectangle(pt.x - maxHalfWidth, pt.y - this.m_Perspective.m_VC.destToVirtHeight(3), maxHalfWidth * 2, dim.height / 2 - pt.y);
                    nAlign = 7;
                } else if (angle < 165.0) {
                    r = new Rectangle(-dim.width / 2 - this.m_Perspective.m_VC.destToVirtWidth(2), pt.y + this.m_Perspective.m_VC.destToVirtWidth(3), pt.x + dim.width / 2, dim.height / 2 - pt.y);
                    nAlign = 6;
                } else if (angle < 195.0) {
                    int maxHalfHeight = Math.min(dim.height / 2 - pt.y, pt.y + dim.height / 2);
                    r = new Rectangle(-dim.width / 2 - this.m_Perspective.m_VC.destToVirtWidth(3), pt.y - maxHalfHeight, pt.x + dim.width / 2, 2 * maxHalfHeight);
                    nAlign = 5;
                } else if (angle < 260.0) {
                    r = new Rectangle(-dim.width / 2 - this.m_Perspective.m_VC.destToVirtWidth(2), -dim.height / 2, pt.x + dim.width / 2, dim.height / 2 + pt.y);
                    nAlign = 4;
                } else if (angle < 280.0) {
                    IdentObj labelsID = this.m_Perspective.getY1Label();
                    FontMetrics fm = this.m_Perspective.getFontMetrics(labelsID);
                    int fontHeight = TextStyleObj.getFontHeight(fm, this.m_Perspective.getFontMetricsResolver());
                    int maxHalfWidth = Math.min(dim.width / 2 - pt.x, pt.x + dim.width / 2);
                    r = new Rectangle(pt.x - maxHalfWidth, -dim.height / 2, maxHalfWidth * 2, dim.height / 2 + pt.y);
                    r.height += this.m_Perspective.m_VC.destToVirtHeight(fontHeight) / 2;
                    nAlign = 3;
                } else {
                    r = new Rectangle(pt.x + this.m_Perspective.m_VC.destToVirtWidth(2), -dim.height / 2, dim.width / 2 - pt.x, pt.y + dim.height / 2);
                    nAlign = 2;
                }
                align.add(i, nAlign);
                rLabels.add(i, r);
            }
            if (this.m_radarGraphType && nLabels > 1 && points.size() < 13 && points.size() % 2 == 1) {
                Polygon p = new Polygon();
                for (int i = 0; i < points.size(); ++i) {
                    Point point = (Point)points.get(i);
                    p.addPoint(point.x, point.y);
                }
                Rectangle rect = p.getBounds();
                int rectCenterY = rect.y + rect.height / 2;
                int dist = rectCenterY - this.m_centerFramePosVC.y;
                this.m_centerFramePosVC.y -= dist;
                ((CircularFrameObj)((JChart_2D)this.m_Perspective.m_chart).m_Frame).recalc(dist);
                for (int i = 0; i < rLabels.size(); ++i) {
                    Rectangle rect2 = (Rectangle)rLabels.get(i);
                    rect2.y -= dist;
                }
            }
        }
        if (rTitle != null) {
            nMaxDim = Math.abs(nPos[1] - nPos[0]);
            if (this.m_bVertScale) {
                rTitle.y = Math.min(nPos[0], nPos[nLabels - 1]) - nMaxDim / 2;
                rTitle.height = nMaxDim * nLabels;
                rTitle.width = rSpace.width;
                rTitle.x = nSide == 0 ? rSpace.x : rSpace.x + rSpace.width - titleHeight;
            } else {
                rTitle.x = Math.min(nPos[0], nPos[nLabels - 1]) - nMaxDim / 2;
                rTitle.width = nMaxDim * nLabels;
                rTitle.height = rSpace.height;
                rTitle.y = nSide == 0 ? rSpace.y : rSpace.y + rSpace.height - titleHeight;
            }
        }
    }

    @Override
    protected List getLabels() {
        if (this.m_bNumericAxis) {
            return this.getNumericLabels();
        }
        int nLabels = this.getNumLabels();
        ArrayList<String> szLabels = new ArrayList<String>(nLabels);
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        while (gEnum.hasMoreElements()) {
            int g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_Access.getNumTotalGroups());
            String szLabel = this.m_Perspective.getGroupLabel(g);
            szLabels.add(szLabel);
        }
        return szLabels;
    }

    @Override
    protected List getLabelIdents() {
        if (this.m_bNumericAxis) {
            return null;
        }
        ArrayList<IdentObj> idents = new ArrayList<IdentObj>(this.getNumLabels());
        DataRange drViewSG = this.m_Perspective.getViewableDataRangeSG();
        int nViewGroupStart = drViewSG.getColStart();
        int nViewGroupStop = drViewSG.getColStop();
        for (int g = nViewGroupStart; g <= nViewGroupStop; ++g) {
            idents.add(new IdentObj(-3, -3, g));
        }
        return idents;
    }

    @Override
    public double getLowCoord(int s, int g) {
        if (!this.m_bNumericAxis) {
            if (this.m_bRadiusAxis) {
                return this.getLowRelCoord(s, g);
            }
            if (this.m_numGroups > 1) {
                return CircularAxisObj.getAngleFromRelAngle((double)g / (double)this.m_numGroups, this.m_Perspective);
            }
            return CircularAxisObj.getAngleFromRelAngle(0.0, this.m_Perspective);
        }
        throw new AssertionException("Ordinal method called by numerical axis");
    }

    @Override
    protected boolean getMajorGridDisplay(AxisTemplate axisID) {
        if (this.m_radarGraphType && axisID.getAxisObjID() == 5) {
            Object gridStyleObj = this.m_Perspective.getGridStyleObj(this.m_template.getMajor());
            if (gridStyleObj != null) {
                int gridStyle = (Integer)gridStyleObj;
                return gridStyle != 6;
            }
            return true;
        }
        int gridStyle = this.m_Perspective.getGridStyle(this.m_template.getMajor());
        return gridStyle != 6;
    }

    @Override
    protected boolean getMinorGridDisplay(AxisTemplate axisID) {
        int gridStyle = this.m_Perspective.getGridStyle(this.m_template.getMinor());
        return gridStyle != 6 && gridStyle != 5;
    }

    @Override
    protected Rectangle getSpaceAvailable(int nSide, VC vc) {
        Rectangle[] rect = new Rectangle[1];
        Dimension dim = vc.getVirtDimension();
        Rectangle rSpace = this.m_bRadiusAxis ? (nSide == 0 ? (this.m_bVertScale ? new Rectangle(this.m_centerFramePosVC.x - this.m_frameDimVC.width / 2, this.m_centerFramePosVC.y, this.m_frameDimVC.width / 2, this.m_frameDimVC.height / 2) : new Rectangle(this.m_centerFramePosVC.x, this.m_centerFramePosVC.y - this.m_frameDimVC.height / 2, this.m_frameDimVC.width / 2, this.m_frameDimVC.height / 2)) : (this.m_bVertScale ? new Rectangle(this.m_centerFramePosVC.x, this.m_centerFramePosVC.y, this.m_frameDimVC.width / 2, this.m_frameDimVC.height / 2) : new Rectangle(this.m_centerFramePosVC.x, this.m_centerFramePosVC.y, this.m_frameDimVC.width / 2, this.m_frameDimVC.height / 2))) : new Rectangle(0, 0, 0, 0);
        return rSpace;
    }

    @Override
    protected int getTitleRotation(AxisTemplate template, int nSide) {
        int nRotation = this.m_Perspective.getMoveAxisTitles() ? this.m_Perspective.getTextRotation(template.getTitle()) : (this.m_bRadiusAxis ? (nSide == 0 && this.m_bVertScale ? (this.m_Perspective.getTextRotation(template.getTitle()) == 270 ? 270 : 90) : (nSide == 1 && this.m_bVertScale ? (this.m_Perspective.getTextRotation(template.getTitle()) == 90 ? 90 : 270) : 0)) : 0);
        return nRotation;
    }

    @Override
    public double getValueCoord(double fValue) {
        if (this.m_bRadiusAxis) {
            return this.getValueRelCoord(fValue);
        }
        return CircularAxisObj.getAngleFromRelAngle(this.getValueRelCoord(fValue), this.m_Perspective);
    }

    @Override
    public double getValueCoordForZoom(double fValue) {
        if (this.m_bRadiusAxis) {
            return this.getValueRelCoordForZoom(fValue);
        }
        return CircularAxisObj.getAngleFromRelAngle(this.getValueRelCoordForZoom(fValue), this.m_Perspective);
    }

    @Override
    public double getValueFromCoord(int nCoord) {
        return 0.0;
    }

    public Rectangle getValueOval(double fRelValue) {
        if (this.m_bRadiusAxis) {
            return new Rectangle((int)((double)this.m_centerFramePosVC.x - (double)(this.m_frameDimVC.width / 2) * fRelValue), (int)((double)this.m_centerFramePosVC.y - (double)(this.m_frameDimVC.height / 2) * fRelValue), (int)((double)(2 * this.m_frameDimVC.width / 2) * fRelValue), (int)((double)(2 * this.m_frameDimVC.height / 2) * fRelValue));
        }
        throw new AssertionException("Radius method called by non Radius axis");
    }

    private void initAxis() {
        Rectangle rFrame = this.m_Perspective.getFrameRect(false);
        this.m_frameDimVC.width = rFrame.width;
        this.m_frameDimVC.height = rFrame.height;
        this.m_centerFramePosVC.x = rFrame.x + rFrame.width / 2;
        this.m_centerFramePosVC.y = rFrame.y + rFrame.height / 2;
        if ((this.m_template.getAxis().getObjectID() == this.m_Perspective.getY1Axis().getObjectID() || this.m_template.getAxis().getObjectID() == this.m_Perspective.getY2Axis().getObjectID()) && this.m_radarGraphType) {
            this.m_numLabels = ((JChart_2D_Standard)this.m_Perspective.m_chart).m_O1Axis.getNumLabels();
            this.m_o1PosRel = ((JChart_2D_Standard)this.m_Perspective.m_chart).m_O1Axis.getRelLabelPos(this.m_numLabels);
        }
    }

    private void initVariables() {
        this.m_frameDimVC = new Dimension(0, 0);
        this.m_centerFramePosVC = new Point(0, 0);
        int graphType = this.m_Perspective.getGraphType();
        this.m_radarGraphType = graphType == 67 || graphType == 68 || graphType == 69;
        this.m_polygonSides = this.m_radarGraphType;
    }

    @Override
    public boolean isO1WithNestedLabels() {
        return false;
    }

    @Override
    protected boolean isPolarAxis() {
        return !this.m_bRadiusAxis;
    }

    public static void polarToCartesian(Point pt, double fAngleInDeg, double relRadius, Dimension frameDim, Point origin, VC vc) {
        Dimension dcFrameDim = vc.virtToDest(frameDim);
        Point dcOrigin = vc.virtToDest(origin);
        double radius = (double)(dcFrameDim.width / 2) * relRadius;
        double fX = radius * Math.cos(fAngleInDeg * (Math.PI / 180));
        double fY = radius * Math.sin(fAngleInDeg * (Math.PI / 180));
        Point ptTemp = new Point(dcOrigin.x + (int)fX, dcOrigin.y + (int)fY);
        ptTemp = vc.destToVirt(ptTemp);
        pt.x = ptTemp.x;
        pt.y = ptTemp.y;
    }

    @Override
    protected void adjustLabelPos(int nSide, int nLabels, List rLabels) {
    }

    private void calcLineOnFrame(int nStyle, double fRelPos, IdentObj id, BlackBoxIF blackBox, int nLineWidth, int nLineStyle, double ancor) {
        Point pt1 = new Point(0, 0);
        Point pt2 = new Point(0, 0);
        if (nStyle == 5) {
            nStyle = 0;
        }
        if (this.m_bRadiusAxis) {
            if (nStyle == 0 || nStyle == 1) {
                if (!this.m_polygonSides) {
                    Rectangle rOval = this.getValueOval(fRelPos);
                    new DetOval(this.m_Perspective.getDetectiv(), id, rOval.x, rOval.y, rOval.width, rOval.height, blackBox, false, true, true);
                } else {
                    Point pt = new Point(0, 0);
                    ArrayList<Point> points = new ArrayList<Point>();
                    for (int i = 0; i < this.m_numLabels; ++i) {
                        double angle = CircularAxisObj.getAngleFromRelAngle((Double)this.m_o1PosRel.get(i), this.m_Perspective);
                        CircularAxisObj.polarToCartesian(pt, angle, fRelPos, this.m_frameDimVC, this.m_centerFramePosVC, this.m_Perspective.m_VC);
                        points.add(new Point(pt.x, pt.y));
                    }
                    points.add((Point)points.get(0));
                    new DetPolyline(this.m_Perspective.getDetectiv(), id, points, blackBox, null, nLineWidth);
                }
            } else {
                int nSide = this.getAxisSide();
                if (this.m_bVertScale) {
                    pt1.y = pt2.y = (int)((double)this.m_centerFramePosVC.y + (double)(this.m_frameDimVC.height / 2) * fRelPos + 0.5);
                    pt1.x = this.m_centerFramePosVC.x;
                    if (nSide == 0 && nStyle == 3 || nSide == 1 && nStyle == 2 || nSide == 2 || nStyle == 4) {
                        pt1.x -= 250;
                    }
                    pt2.x = this.m_centerFramePosVC.x;
                    if (nSide == 1 && nStyle == 3 || nSide == 0 && nStyle == 2 || nSide == 2 || nStyle == 4) {
                        pt2.x += 250;
                    }
                } else {
                    pt1.x = pt2.x = (int)((double)this.m_centerFramePosVC.x + (double)(this.m_frameDimVC.width / 2) * fRelPos + 0.5);
                    pt1.y = this.m_centerFramePosVC.y;
                    if (nSide == 0 && nStyle == 2 || nSide == 1 && nStyle == 3 || nSide == 2 || nStyle == 4) {
                        pt1.y += 250;
                    }
                    pt2.y = this.m_centerFramePosVC.y;
                    if (nSide == 1 && nStyle == 2 || nSide == 0 && nStyle == 3 || nSide == 2 || nStyle == 4) {
                        pt2.y -= 250;
                    }
                }
                new DetLine(this.m_Perspective.getDetectiv(), id, pt1.x, pt1.y, pt2.x, pt2.y, blackBox, null, nLineWidth, nLineStyle);
            }
        } else {
            double fPosIn;
            if (nStyle == 5) {
                nStyle = 0;
            }
            double fPosOut = switch (nStyle) {
                case 1 -> {
                    fPosIn = ancor;
                    yield 1.05;
                }
                case 2 -> {
                    fPosIn = 0.95;
                    yield 1.0;
                }
                case 3 -> {
                    fPosIn = 1.0;
                    yield 1.05;
                }
                case 4 -> {
                    fPosIn = 0.95;
                    yield 1.05;
                }
                default -> {
                    fPosIn = ancor;
                    yield 1.0;
                }
            };
            double angle = CircularAxisObj.getAngleFromRelAngle(fRelPos, this.m_Perspective);
            CircularAxisObj.polarToCartesian(pt1, angle, fPosIn, this.m_frameDimVC, this.m_centerFramePosVC, this.m_Perspective.m_VC);
            CircularAxisObj.polarToCartesian(pt2, angle, fPosOut, this.m_frameDimVC, this.m_centerFramePosVC, this.m_Perspective.m_VC);
            new DetLine(this.m_Perspective.getDetectiv(), this.m_template.getMajor(), pt1.x, pt1.y, pt2.x, pt2.y, blackBox, null, this.m_Perspective.getLineWidth(this.m_template.getMajor()), this.m_Perspective.getLineStyle(this.m_template.getMajor()));
        }
    }

    @Override
    protected int getTitleJustVert(IdentObj id, int nSide) {
        return this.m_Perspective.getTextJustVert(id);
    }

    @Override
    protected int getTitleJustHoriz(IdentObj id, int nSide) {
        return this.m_Perspective.getTextJustHoriz(id);
    }
}

