/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.dataView.HorizontalAlignment;
import oracle.dss.graph.BaseText;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.annotations.Concealed;

public class ZTickLabel
extends BaseText
implements HorizontalAlignment {
    @Concealed
    protected IdentObj m_identObj2;
    private static final String m_method_setTickLabelSkipCount = "void setTickLabelSkipCount( int count )";
    private static final String m_method_setTickLabelSkipFirst = "void setTickLabelSkipFirst( int first )";
    private static final String m_method_setTickLabelSkipMode = "void setTickLabelSkipMode( int mode )";

    @Concealed
    public ZTickLabel(CommonGraph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getO2Label();
        this.m_identObj2 = this.m_pfj.getO2DrillLabel();
    }

    @Concealed
    void setAutoHorizAlignment() {
        int rotation = this.m_pfj.getTextRotation(this.m_identObj);
        int alignment = this.m_pfj.getTextJustHoriz(this.m_identObj);
        switch (rotation) {
            case 0: 
            case 90: {
                alignment = 4;
                break;
            }
            case 270: {
                alignment = 2;
            }
        }
        if (alignment != this.m_pfj.getTextJustHoriz(this.m_identObj)) {
            this.m_pfj.setTextJustHoriz(this.m_identObj, alignment);
        }
    }

    @Override
    public boolean selectObject(int series, int group) {
        if (series >= 0) {
            IdentObj identObj = this.m_identObj;
            identObj.setSeriesID(series);
            this.m_pfj.setSelection(identObj);
            if (identObj.equals(this.m_pfj.getSelectionID())) {
                return true;
            }
        }
        return false;
    }

    public int getTextRotation() {
        return this.m_pfj.getTextRotation(this.m_identObj);
    }

    public void setTextRotation(int orient) {
        if (orient != 0 && orient != 90 && orient != 270) {
            this.m_commonGraph.getErrorHandler().log("invalid value for TextRotation", this.getClass().getName(), "setTextRotation(int orient)");
        } else {
            this.m_pfj.setTextRotation(this.m_identObj, orient);
            this.setAutoHorizAlignment();
        }
    }

    public int getTickLabelSkipCount() {
        return this.m_pfj.getSkipCount(this.m_identObj);
    }

    public void setTickLabelSkipCount(int count) {
        if (count < 0) {
            this.m_commonGraph.getErrorHandler().log("invalid Tick Label Skip count", this.getClass().getName(), m_method_setTickLabelSkipCount);
        } else {
            this.m_pfj.setSkipCount(this.m_identObj, count);
        }
    }

    public int getTickLabelSkipFirst() {
        return this.m_pfj.getSkipBegin(this.m_identObj);
    }

    public void setTickLabelSkipFirst(int first) {
        if (first < 0) {
            this.m_commonGraph.getErrorHandler().log("invalid first tick label", this.getClass().getName(), m_method_setTickLabelSkipFirst);
        } else {
            this.m_pfj.setSkipBegin(this.m_identObj, first);
        }
    }

    public int getTickLabelSkipMode() {
        return this.m_pfj.getAutoSkip(this.m_identObj);
    }

    public void setTickLabelSkipMode(int mode) {
        if (mode < 0 || mode > 2) {
            this.m_commonGraph.getErrorHandler().log("invalid TickLabelSkipMode", this.getClass().getName(), m_method_setTickLabelSkipMode);
        } else {
            this.m_pfj.setAutoSkip(this.m_identObj, mode);
        }
    }

    @Override
    public void setHorizontalAlignment(int a) {
        if (a == 2 || a == 0 || a == 4 || a == 10) {
            this.m_pfj.setTextJustHoriz(this.m_identObj, a);
            this.m_pfj.setTextJustHoriz(this.m_identObj2, a);
        } else {
            this.m_commonGraph.getErrorHandler().log("invalid horizontal aligment", this.getClass().getName(), "setHorizontalAlignment(a)");
        }
    }

    @Override
    public int getHorizontalAlignment() {
        return this.m_pfj.getTextJustHoriz(this.m_identObj);
    }

    @Concealed
    protected String convertTickLabelSkipModeToString(int value) {
        String skipMode = "TLS_NOSKIP";
        switch (value) {
            case 0: {
                skipMode = "TLS_NOSKIP";
                break;
            }
            case 1: {
                skipMode = "TLS_AUTOMATIC";
                break;
            }
            case 2: {
                skipMode = "TLS_MANUAL";
            }
        }
        return skipMode;
    }

    @Concealed
    protected int convertTickLabelSkipModeToInt(String string) {
        if (string.equals("TLS_NOSKIP")) {
            return 0;
        }
        if (string.equals("TLS_AUTOMATIC")) {
            return 1;
        }
        if (string.equals("TLS_MANUAL")) {
            return 2;
        }
        return -1;
    }

    @Override
    @Concealed
    protected String getComponentName() {
        return "ZTickLabel";
    }

    @Override
    @Concealed
    public boolean getStyleXML(boolean allProperties, ObjectNode node) {
        boolean nodeExists = super.getStyleXML(allProperties, node);
        Object val = this.m_pfj.getAutoSkipObj(this.m_identObj);
        if (val != null) {
            node.addProperty("tickLabelSkipMode", this.convertTickLabelSkipModeToString((Integer)val));
            nodeExists = true;
        }
        if ((val = this.m_pfj.getSkipCountObj(this.m_identObj)) != null) {
            node.addProperty("tickLabelSkipCount", ((Integer)val).intValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getSkipBeginObj(this.m_identObj)) != null) {
            node.addProperty("tickLabelSkipFirst", ((Integer)val).intValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getTextRotationObj(this.m_identObj)) != null) {
            int temp = (Integer)val;
            if (temp == 0) {
                node.addProperty("textRotation", "TR_HORIZ");
            } else if (temp == 90) {
                node.addProperty("textRotation", "TR_HORIZ_ROTATE_90");
            } else {
                node.addProperty("textRotation", "TR_HORIZ_ROTATE_270");
            }
            nodeExists = true;
        }
        if ((val = this.m_pfj.getTextJustHorizObj(this.m_identObj)) != null) {
            node.addProperty("horizontalAlignment", this.convertHorizontalAlignmentToString((Integer)val));
            nodeExists = true;
        }
        return nodeExists;
    }

    @Override
    @Concealed
    public void setStyleXML(ObjectNode node) {
        super.setStyleXML(node);
        PropertyNode pNode = node.getProperty("tickLabelSkipMode");
        if (pNode != null) {
            this.setTickLabelSkipMode(this.convertTickLabelSkipModeToInt(pNode.getValueAsString()));
        }
        if ((pNode = node.getProperty("tickLabelSkipCount")) != null) {
            this.setTickLabelSkipCount(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty("tickLabelSkipFirst")) != null) {
            this.setTickLabelSkipFirst(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty("textRotation")) != null) {
            String tmp = pNode.getValueAsString();
            if (tmp.equals("TR_HORIZ")) {
                this.setTextRotation(0);
            } else if (tmp.equals("TR_HORIZ_ROTATE_90")) {
                this.setTextRotation(90);
            } else if (tmp.equals("TR_HORIZ_ROTATE_270")) {
                this.setTextRotation(270);
            }
        }
        if ((pNode = node.getProperty("horizontalAlignment")) != null) {
            this.setHorizontalAlignment(ZTickLabel.convertHorizontalAlignmentToInt(pNode.getValueAsString()));
        }
    }

    @Override
    @Concealed
    public void resetStyle() {
        this.setTextRotation(0);
        this.setHorizontalAlignment(2);
        this.setTickLabelSkipMode(2);
        this.setTickLabelSkipCount(1);
        this.setTickLabelSkipFirst(1);
        super.resetStyle();
    }
}

