/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import java.util.Enumeration;
import java.util.HashMap;
import oracle.dss.dataView.ThresholdOutOfRangeException;
import oracle.dss.dataView.UIThresholdColor;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.BaseNode;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.annotations.Concealed;

public class Threshold
extends BaseGraphComponent
implements UIThresholdColor {
    @Concealed
    public Threshold(CommonGraph graph) {
        super(graph);
    }

    public void setColorValueRange(Color[] colors, double[][] values) throws ThresholdOutOfRangeException {
        if (colors.length != values.length && values[0].length != 2) {
            this.m_commonGraph.getErrorHandler().log(" color and value arrays invalid ", this.getClass().getName(), "setColorValueRange(Color[] colors, double[][] values)");
            return;
        }
        this.m_pfj.setThresholdCount(colors.length);
        for (int i = 0; i < colors.length; ++i) {
            this.setColor(colors[i], i);
            this.setMinValue(i, values[i][0]);
            this.setMaxValue(i, values[i][1]);
        }
    }

    @Override
    public Color getColor(int threshold) throws ThresholdOutOfRangeException {
        if (!this.isTransparent(threshold)) {
            return this.m_pfj.getFillColor(this._getID(threshold));
        }
        return null;
    }

    @Override
    public void setColor(Color newColor, int threshold) throws ThresholdOutOfRangeException {
        if (newColor == null) {
            this.setTransparent(true, threshold);
            return;
        }
        this.updateThresholdCount(threshold);
        this.m_pfj.setFillColor(this._getID(threshold), newColor);
    }

    public double getMinValue(int threshold) throws ThresholdOutOfRangeException {
        return this.m_pfj.getThresholdMinValue(this._getID(threshold));
    }

    public void setMinValue(int threshold, double minVal) throws ThresholdOutOfRangeException {
        this.updateThresholdCount(threshold);
        this.m_pfj.setThresholdMinValue(this._getID(threshold), minVal);
    }

    public double getMaxValue(int threshold) throws ThresholdOutOfRangeException {
        return this.m_pfj.getThresholdMaxValue(this._getID(threshold));
    }

    public void setMaxValue(int threshold, double maxVal) throws ThresholdOutOfRangeException {
        this.updateThresholdCount(threshold);
        this.m_pfj.setThresholdMaxValue(this._getID(threshold), maxVal);
    }

    public boolean isTransparent(int threshold) throws ThresholdOutOfRangeException {
        return this.m_pfj.getTransparentFillColor(this._getID(threshold));
    }

    public void setTransparent(boolean yesNo, int threshold) throws ThresholdOutOfRangeException {
        this.updateThresholdCount(threshold);
        this.m_pfj.setTransparentFillColor(this._getID(threshold), yesNo);
    }

    @Override
    public int getThresholdId(int group) {
        int thresholdId = -1;
        if (group < 0) {
            this.m_commonGraph.getErrorHandler().log(" group index invalid ", this.getClass().getName(), "getThresholdId(int group)");
        } else {
            thresholdId = this.m_pfj.getThresholdId(group);
        }
        return thresholdId;
    }

    public void setDefaultColor(Color color) {
        this.m_pfj.setObjProp(color, Attr.ThresholdDefaultColor);
    }

    @Override
    public boolean isXMLBeingSet() {
        return this.m_commonGraph.m_settingXML;
    }

    @Override
    @Concealed
    protected String getComponentName() {
        return "ThresholdItems";
    }

    @Concealed
    protected ContainerNode getXML(boolean allProperties, boolean allOverriddenProperties) {
        boolean nodeExists = false;
        ContainerNode node = new ContainerNode(this.getComponentName());
        nodeExists = this.getThresholdItemsXML(allProperties, allOverriddenProperties, node);
        for (int i = 0; i < this.m_pfj.getThresholdCount(); ++i) {
            ObjectNode thresholdNode = new ObjectNode("Threshold");
            thresholdNode.addProperty("id", i);
            if (!this.getThresholdXML(allProperties, allOverriddenProperties, thresholdNode, i)) continue;
            node.addContainedObject((BaseNode)thresholdNode);
            nodeExists = true;
        }
        return nodeExists ? node : null;
    }

    @Concealed
    protected boolean getThresholdItemsXML(boolean allProperties, boolean allOverriddenProperties, ContainerNode node) {
        boolean styleOverridden = false;
        Object val = this.m_pfj.getObjProp(Attr.ThresholdDefaultBorderColor);
        if (val != null) {
            node.addProperty("defaultBorderColor", Threshold.toHexString(((Color)val).getRGB()));
            styleOverridden = true;
        }
        return styleOverridden;
    }

    @Concealed
    protected boolean getThresholdXML(boolean allProperties, boolean allOverriddenProperties, ObjectNode thresholdNode, int i) {
        boolean styleOverridden = false;
        try {
            Object val = this.m_pfj.getFillColor(this._getID(i));
            if (val != null) {
                thresholdNode.addProperty("color", Threshold.toHexString(((Color)val).getRGB()));
                styleOverridden = true;
            }
            if ((val = this.m_pfj.getTransparentFillColorObj(this._getID(i))) != null) {
                thresholdNode.addProperty("transparent", ((Boolean)val).booleanValue());
                styleOverridden = true;
            }
            if ((val = this.m_pfj.getThresholdMinValue(this._getID(i), false)) != null) {
                thresholdNode.addProperty("thresholdMinValue", ((Double)val).doubleValue());
                styleOverridden = true;
            }
            if ((val = this.m_pfj.getThresholdMaxValue(this._getID(i), false)) != null) {
                thresholdNode.addProperty("thresholdMaxValue", ((Double)val).doubleValue());
                styleOverridden = true;
            }
        }
        catch (ThresholdOutOfRangeException tore) {
            String name = "getThresholdXML(boolean allProperties, boolean allOverriddenProperties, ObjectNode thresholdNode, int i)";
            this.m_commonGraph.getErrorHandler().log(" threshold is out of range ", this.getClass().getName(), name);
        }
        return styleOverridden;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Concealed
    protected void setXML(ContainerNode node, boolean allProperties, HashMap map) {
        this.m_jsfHashMap = map;
        try {
            this.setXML(node, allProperties);
        }
        finally {
            this.m_jsfHashMap = null;
        }
    }

    @Concealed
    protected void setXML(ContainerNode node, boolean allProperties) {
        this.setThresholdItemsXML(node);
        Enumeration e = node.getContainedObject();
        while (e.hasMoreElements()) {
            ObjectNode thresholdNode = (ObjectNode)e.nextElement();
            PropertyNode pNode = thresholdNode.getProperty("id");
            if (pNode == null) continue;
            int threshold = pNode.getValueAsInteger();
            HashMap map = new HashMap();
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put(threshold, map);
            }
            this.setThresholdXML(thresholdNode, threshold, allProperties, map);
        }
    }

    @Concealed
    protected void setThresholdItemsXML(ContainerNode node) {
        PropertyNode pNode = node.getProperty("defaultColor");
        if (pNode != null) {
            this.setDefaultColor(new Color(Threshold.hexStringToInt(pNode.getValueAsString()), true));
        }
    }

    @Concealed
    protected void setThresholdXML(ObjectNode thresholdNode, int threshold, boolean allProperties, HashMap map) {
        try {
            PropertyNode pNode = thresholdNode.getProperty("color");
            if (pNode != null) {
                if (this.m_jsfHashMap != null) {
                    map.put("color", new Color(Threshold.hexStringToInt(pNode.getValueAsString()), true));
                } else {
                    this.setColor(new Color(Threshold.hexStringToInt(pNode.getValueAsString()), true), threshold);
                }
            }
            if ((pNode = thresholdNode.getProperty("transparent")) != null) {
                this.setTransparent(pNode.getValueAsBoolean(), threshold);
            }
            if ((pNode = thresholdNode.getProperty("thresholdMinValue")) != null) {
                if (this.m_jsfHashMap != null) {
                    map.put("thresholdMinValue", pNode.getValueAsDouble());
                } else {
                    this.setMinValue(threshold, pNode.getValueAsDouble());
                }
            }
            if ((pNode = thresholdNode.getProperty("thresholdMaxValue")) != null) {
                if (this.m_jsfHashMap != null) {
                    map.put("thresholdMaxValue", pNode.getValueAsDouble());
                } else {
                    this.setMaxValue(threshold, pNode.getValueAsDouble());
                }
            }
        }
        catch (ThresholdOutOfRangeException tore) {
            String name = "setThresholdXML(ObjectNode thresholdNode, int threshold, boolean allProperties, HashMap map)";
            this.m_commonGraph.getErrorHandler().log(" threshold is out of range ", this.getClass().getName(), name);
        }
    }

    @Concealed
    protected void resetStyle() {
        try {
            for (int i = 0; i < this.m_pfj.getThresholdCount(); ++i) {
                this.setTransparent(false, i);
            }
        }
        catch (ThresholdOutOfRangeException tore) {
            this.m_commonGraph.getErrorHandler().log(" threshold is out of range ", this.getClass().getName(), "resetStyle()");
        }
    }

    private IdentObj _getID(int threshold) throws ThresholdOutOfRangeException {
        int bound = this.m_pfj.getThresholdCount();
        if (threshold < 0 || threshold >= bound) {
            throw new ThresholdOutOfRangeException(threshold, bound);
        }
        return this.m_pfj.getThreshold(threshold);
    }

    private void updateThresholdCount(int index) {
        Integer thresholdCount = (Integer)this.m_pfj.getFromLook2(IdentObj.GLOBAL, Attr.ThresholdCount);
        if (thresholdCount == null || index >= thresholdCount) {
            this.m_pfj.setThresholdCount(index + 1);
        }
    }
}

