/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.dataView.BaseComponentXML;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.PFJ;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.annotations.Concealed;

public class ThreeDViewMatrix
extends BaseComponentXML {
    @Concealed
    protected PFJ m_pfj;
    private CommonGraph m_commonGraph;

    @Concealed
    public ThreeDViewMatrix(CommonGraph graph, PFJ pfj) {
        this.m_pfj = pfj;
        this.m_commonGraph = graph;
    }

    public double getFocusFactor() {
        return this.m_pfj.getCubeFocusFactor();
    }

    public void setFocusFactor(double newValue) {
        if (newValue < 0.0 || newValue > 100.0) {
            this.m_commonGraph.getErrorHandler().log("invalid focus factor", this.getClass().getName(), "setFocusFactor(double newValue)");
        } else {
            this.m_pfj.setCubeFocusFactor(newValue);
        }
    }

    public boolean isIsometricProjection() {
        return this.m_pfj.getCubeIsometricProjection();
    }

    public void setIsometricProjection(boolean yesNo) {
        this.m_pfj.setCubeIsometricProjection(yesNo);
    }

    public double getLightSourceX() {
        return this.m_pfj.getCubeLightSourceX();
    }

    public void setLightSourceX(double newValue) {
        if (newValue < 0.0 || newValue > 100.0) {
            this.m_commonGraph.getErrorHandler().log("invalid Light SourceX", this.getClass().getName(), "setLightSourceX(double newValue)");
        } else {
            this.m_pfj.setCubeLightSourceX(newValue);
        }
    }

    public double getLightSourceY() {
        return this.m_pfj.getCubeLightSourceY();
    }

    public void setLightSourceY(double newValue) {
        if (newValue < 0.0 || newValue > 100.0) {
            this.m_commonGraph.getErrorHandler().log("invalid light Source Y", this.getClass().getName(), "setLightSourceY(double newValue)");
        } else {
            this.m_pfj.setCubeLightSourceY(newValue);
        }
    }

    public double getLightSourceZ() {
        return this.m_pfj.getCubeLightSourceZ();
    }

    public void setLightSourceZ(double newValue) {
        if (newValue < 0.0 || newValue > 100.0) {
            this.m_commonGraph.getErrorHandler().log("invalid light Source", this.getClass().getName(), "setLightSourceZ(double newValue)");
        } else {
            this.m_pfj.setCubeLightSourceZ(newValue);
        }
    }

    public double getPanX() {
        return this.m_pfj.getCubePanX();
    }

    public void setPanX(double newValue) {
        if (newValue < 0.0 || newValue > 100.0) {
            this.m_commonGraph.getErrorHandler().log("invalid pan value", this.getClass().getName(), "setPanX(double newValue)");
        } else {
            this.m_pfj.setCubePanX(newValue);
        }
    }

    public double getPanY() {
        return this.m_pfj.getCubePanY();
    }

    public void setPanY(double newValue) {
        if (newValue < 0.0 || newValue > 100.0) {
            this.m_commonGraph.getErrorHandler().log("invalid pan value", this.getClass().getName(), "setPanY(double newValue)");
        } else {
            this.m_pfj.setCubePanY(newValue);
        }
    }

    public double getSizeX() {
        return this.m_pfj.getCubeSizeX();
    }

    public void setSizeX(double newValue) {
        if (newValue < 0.0 || newValue > 100.0) {
            this.m_commonGraph.getErrorHandler().log("invalid size", this.getClass().getName(), "setSizeX(double newValue)");
        } else {
            this.m_pfj.setCubeSizeX(newValue);
        }
    }

    public double getSizeY() {
        return this.m_pfj.getCubeSizeY();
    }

    public void setSizeY(double newValue) {
        if (newValue < 0.0 || newValue > 100.0) {
            this.m_commonGraph.getErrorHandler().log("invalid size", this.getClass().getName(), "setSizeY(double newValue)");
        } else {
            this.m_pfj.setCubeSizeY(newValue);
        }
    }

    public double getSizeZ() {
        return this.m_pfj.getCubeSizeZ();
    }

    public void setSizeZ(double newValue) {
        if (newValue < 0.0 || newValue > 100.0) {
            this.m_commonGraph.getErrorHandler().log("invalid size", this.getClass().getName(), "setSizeZ(double newValue)");
        } else {
            this.m_pfj.setCubeSizeZ(newValue);
        }
    }

    public boolean isSquareRisers() {
        return this.m_pfj.getCubeSquareRisers();
    }

    public void setSquareRisers(boolean yesNo) {
        this.m_pfj.setCubeSquareRisers(yesNo);
    }

    public double getTranslationX() {
        return this.m_pfj.getCubeTranslationX();
    }

    public void setTranslationX(double newValue) {
        if (newValue < 0.0 || newValue > 100.0) {
            this.m_commonGraph.getErrorHandler().log("invalid translation", this.getClass().getName(), "setTranslationX(double newValue)");
        } else {
            this.m_pfj.setCubeTranslationX(newValue);
        }
    }

    public double getTranslationY() {
        return this.m_pfj.getCubeTranslationY();
    }

    public void setTranslationY(double newValue) {
        if (newValue < 0.0 || newValue > 100.0) {
            this.m_commonGraph.getErrorHandler().log("invalid translation", this.getClass().getName(), "setTranslationY(double newValue)");
        } else {
            this.m_pfj.setCubeTranslationY(newValue);
        }
    }

    public double getTranslationZ() {
        return this.m_pfj.getCubeTranslationZ();
    }

    public void setTranslationZ(double newValue) {
        if (newValue < 0.0 || newValue > 100.0) {
            this.m_commonGraph.getErrorHandler().log("invalid translation", this.getClass().getName(), "setTranslationZ(double newValue)");
        } else {
            this.m_pfj.setCubeTranslationZ(newValue);
        }
    }

    public double getViewerX() {
        return this.m_pfj.getCubeViewerX();
    }

    public void setViewerX(double newValue) {
        if (newValue < 0.0 || newValue > 100.0) {
            this.m_commonGraph.getErrorHandler().log("invalid ViewerX", this.getClass().getName(), "setViewerX(double newValue)");
        } else {
            this.m_pfj.setCubeViewerX(newValue);
        }
    }

    public double getViewerY() {
        return this.m_pfj.getCubeViewerY();
    }

    public void setViewerY(double newValue) {
        if (newValue < 0.0 || newValue > 100.0) {
            this.m_commonGraph.getErrorHandler().log("invalid ViewerY", this.getClass().getName(), "setViewerY(double newValue)");
        } else {
            this.m_pfj.setCubeViewerY(newValue);
        }
    }

    public double getViewerZ() {
        return this.m_pfj.getCubeViewerZ();
    }

    public void setViewerZ(double newValue) {
        if (newValue < 0.0 || newValue > 100.0) {
            this.m_commonGraph.getErrorHandler().log("invalid ViewerZ", this.getClass().getName(), "setViewerZ(double newValue)");
        } else {
            this.m_pfj.setCubeViewerZ(newValue);
        }
    }

    public double getWallThickX() {
        return this.m_pfj.getCubeWallThickX();
    }

    public void setWallThickX(double newValue) {
        if (newValue < 0.0 || newValue > 100.0) {
            this.m_commonGraph.getErrorHandler().log("invalid wall thickness", this.getClass().getName(), "setWallThickX(double newValue)");
        } else {
            this.m_pfj.setCubeWallThickX(newValue);
        }
    }

    public double getWallThickY() {
        return this.m_pfj.getCubeWallThickY();
    }

    public void setWallThickY(double newValue) {
        if (newValue < 0.0 || newValue > 100.0) {
            this.m_commonGraph.getErrorHandler().log("invalid wall thickness", this.getClass().getName(), "setWallThickY(double newValue)");
        } else {
            this.m_pfj.setCubeWallThickY(newValue);
        }
    }

    public double getWallThickZ() {
        return this.m_pfj.getCubeWallThickZ();
    }

    public void setWallThickZ(double newValue) {
        if (newValue < 0.0 || newValue > 100.0) {
            this.m_commonGraph.getErrorHandler().log("invalid wall thickness", this.getClass().getName(), "setWallThickZ(double newValue)");
        } else {
            this.m_pfj.setCubeWallThickZ(newValue);
        }
    }

    public double getZoomFactor() {
        return this.m_pfj.getCubeZoomFactor();
    }

    public void setZoomFactor(double newValue) {
        if (newValue < 0.0 || newValue > 100.0) {
            this.m_commonGraph.getErrorHandler().log("invalid zoom factor", this.getClass().getName(), "setZoomFactor(double newValue)");
        } else {
            this.m_pfj.setCubeZoomFactor(newValue);
        }
    }

    @Override
    @Concealed
    protected String getComponentName() {
        return "ThreeDViewMatrix";
    }

    @Override
    @Concealed
    public boolean getStyleXML(boolean allProperties, ObjectNode node) {
        boolean nodeExists = super.getStyleXML(allProperties, node);
        Object val = this.m_pfj.getObjProp(Attr.CubeFocusFactor);
        if (val != null) {
            node.addProperty("focusFactor", ((Double)val).doubleValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.CubeIsometricProjection)) != null) {
            node.addProperty("isometricProjection", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.CubeLightSourceX)) != null) {
            node.addProperty("lightSourceX", ((Double)val).doubleValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.CubeLightSourceY)) != null) {
            node.addProperty("lightSourceY", ((Double)val).doubleValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.CubeLightSourceZ)) != null) {
            node.addProperty("lightSourceZ", ((Double)val).doubleValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.CubePanX)) != null) {
            node.addProperty("panX", ((Double)val).doubleValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.CubePanY)) != null) {
            node.addProperty("panY", ((Double)val).doubleValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.CubeSizeX)) != null) {
            node.addProperty("sizeX", ((Double)val).doubleValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.CubeSizeY)) != null) {
            node.addProperty("sizeY", ((Double)val).doubleValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.CubeSizeZ)) != null) {
            node.addProperty("sizeZ", ((Double)val).doubleValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.CubeSquareRisers)) != null) {
            node.addProperty("squareRisers", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.CubeTranslationX)) != null) {
            node.addProperty("translationX", ((Double)val).doubleValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.CubeTranslationY)) != null) {
            node.addProperty("translationY", ((Double)val).doubleValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.CubeTranslationZ)) != null) {
            node.addProperty("translationZ", ((Double)val).doubleValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.CubeViewerX)) != null) {
            node.addProperty("viewerX", ((Double)val).doubleValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.CubeViewerY)) != null) {
            node.addProperty("viewerY", ((Double)val).doubleValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.CubeViewerZ)) != null) {
            node.addProperty("viewerZ", ((Double)val).doubleValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.CubeWallThickX)) != null) {
            node.addProperty("wallThickX", ((Double)val).doubleValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.CubeWallThickY)) != null) {
            node.addProperty("wallThickY", ((Double)val).doubleValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.CubeWallThickZ)) != null) {
            node.addProperty("wallThickZ", ((Double)val).doubleValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.CubeZoomFactor)) != null) {
            node.addProperty("zoomFactor", ((Double)val).doubleValue());
            nodeExists = true;
        }
        return nodeExists;
    }

    @Override
    @Concealed
    public void setStyleXML(ObjectNode node) {
        PropertyNode pNode = node.getProperty("focusFactor");
        if (pNode != null) {
            this.setFocusFactor(pNode.getValueAsDouble());
        }
        if ((pNode = node.getProperty("isometricProjection")) != null) {
            this.setIsometricProjection(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty("lightSourceX")) != null) {
            this.setLightSourceX(pNode.getValueAsDouble());
        }
        if ((pNode = node.getProperty("lightSourceY")) != null) {
            this.setLightSourceY(pNode.getValueAsDouble());
        }
        if ((pNode = node.getProperty("lightSourceZ")) != null) {
            this.setLightSourceZ(pNode.getValueAsDouble());
        }
        if ((pNode = node.getProperty("panX")) != null) {
            this.setPanX(pNode.getValueAsDouble());
        }
        if ((pNode = node.getProperty("panY")) != null) {
            this.setPanY(pNode.getValueAsDouble());
        }
        if ((pNode = node.getProperty("sizeX")) != null) {
            this.setSizeX(pNode.getValueAsDouble());
        }
        if ((pNode = node.getProperty("sizeY")) != null) {
            this.setSizeY(pNode.getValueAsDouble());
        }
        if ((pNode = node.getProperty("sizeZ")) != null) {
            this.setSizeZ(pNode.getValueAsDouble());
        }
        if ((pNode = node.getProperty("squareRisers")) != null) {
            this.setSquareRisers(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty("translationX")) != null) {
            this.setTranslationX(pNode.getValueAsDouble());
        }
        if ((pNode = node.getProperty("translationY")) != null) {
            this.setTranslationY(pNode.getValueAsDouble());
        }
        if ((pNode = node.getProperty("translationZ")) != null) {
            this.setTranslationZ(pNode.getValueAsDouble());
        }
        if ((pNode = node.getProperty("viewerX")) != null) {
            this.setViewerX(pNode.getValueAsDouble());
        }
        if ((pNode = node.getProperty("viewerY")) != null) {
            this.setViewerY(pNode.getValueAsDouble());
        }
        if ((pNode = node.getProperty("viewerZ")) != null) {
            this.setViewerZ(pNode.getValueAsDouble());
        }
        if ((pNode = node.getProperty("wallThickX")) != null) {
            this.setWallThickX(pNode.getValueAsDouble());
        }
        if ((pNode = node.getProperty("wallThickY")) != null) {
            this.setWallThickY(pNode.getValueAsDouble());
        }
        if ((pNode = node.getProperty("wallThickZ")) != null) {
            this.setWallThickZ(pNode.getValueAsDouble());
        }
        if ((pNode = node.getProperty("zoomFactor")) != null) {
            this.setZoomFactor(pNode.getValueAsDouble());
        }
    }

    @Concealed
    protected void resetStyle() {
        this.setFocusFactor(0.0);
        this.setIsometricProjection(false);
        this.setLightSourceX(0.0);
        this.setLightSourceY(0.0);
        this.setLightSourceZ(0.0);
        this.setPanX(0.0);
        this.setPanY(0.0);
        this.setSizeX(0.0);
        this.setSizeY(0.0);
        this.setSizeZ(0.0);
        this.setSquareRisers(false);
        this.setTranslationX(0.0);
        this.setTranslationY(0.0);
        this.setTranslationZ(0.0);
        this.setViewerX(0.0);
        this.setViewerY(0.0);
        this.setViewerZ(0.0);
        this.setWallThickX(0.0);
        this.setWallThickY(0.0);
        this.setWallThickZ(0.0);
        this.setZoomFactor(0.0);
    }
}

