/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import oracle.dss.dataView.UIParetoLine;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.Series;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.annotations.Concealed;

public class ParetoLine
extends BaseGraphComponent
implements UIParetoLine {
    @Concealed
    public ParetoLine(CommonGraph graph) {
        super(graph);
    }

    @Override
    public void setColor(Color color) {
        if (color == null) {
            this.m_commonGraph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setColor(Color color)");
            return;
        }
        this.m_pfj.setFillColor(this.m_pfj.getParetoLineRiser(), color);
    }

    @Override
    public Color getColor() {
        return this.m_pfj.getFillColor(this.m_pfj.getParetoLineRiser());
    }

    @Override
    public void setWidth(int width) {
        if (width < 0) {
            this.m_commonGraph.getErrorHandler().log("invalid width", this.getClass().getName(), "setWidth (int width)");
        } else {
            this.m_pfj.setLineWidth(this.m_pfj.getParetoLineRiser(), width);
        }
    }

    @Override
    public int getWidth() {
        return this.m_pfj.getLineWidth(this.m_pfj.getParetoLineRiser());
    }

    @Override
    public void setLineStyle(int style) {
        if (style < 0 || style > 3) {
            this.m_commonGraph.getErrorHandler().log("invalid line style", this.getClass().getName(), "setStyle (int style)");
        } else {
            this.m_pfj.setLineStyle(this.m_pfj.getParetoLineRiser(), style);
        }
    }

    @Override
    public int getLineStyle() {
        return this.m_pfj.getLineStyle(this.m_pfj.getParetoLineRiser());
    }

    @Override
    public void setMarkerShape(int shape) {
        this.m_commonGraph.getParetoMarker().setMarkerShape(shape);
    }

    @Override
    public int getMarkerShape() {
        return this.m_commonGraph.getParetoMarker().getMarkerShape();
    }

    @Override
    @Concealed
    protected String getComponentName() {
        return "ParetoLine";
    }

    @Override
    @Concealed
    public void setStyleXML(ObjectNode node) {
        PropertyNode pNode = node.getProperty("color");
        if (pNode != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("color", new Color(ParetoLine.hexStringToInt(pNode.getValueAsString()), true));
            } else {
                this.setColor(new Color(ParetoLine.hexStringToInt(pNode.getValueAsString()), true));
            }
        }
        if ((pNode = node.getProperty("width")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("width", pNode.getValueAsInteger());
            } else {
                this.setWidth(pNode.getValueAsInteger());
            }
        }
        if ((pNode = node.getProperty("lineStyle")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("lineStyle", ParetoLine.convertLineStyleToInt(pNode.getValueAsString()));
            } else {
                this.setLineStyle(ParetoLine.convertLineStyleToInt(pNode.getValueAsString()));
            }
        }
        if ((pNode = node.getProperty("markerShape")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_commonGraph.getSeries();
                this.m_jsfHashMap.put("markerShape", Series.convertMarkerShapeToInt(pNode.getValueAsString()));
            } else {
                this.m_commonGraph.getSeries();
                this.setMarkerShape(Series.convertMarkerShapeToInt(pNode.getValueAsString()));
            }
        }
    }

    @Override
    @Concealed
    public boolean getStyleXML(boolean allProperties, ObjectNode node) {
        boolean styleOverridden = false;
        Object val = this.getColor();
        if (val != null) {
            node.addProperty("color", ParetoLine.toHexString(((Color)val).getRGB()));
            styleOverridden = true;
        }
        if ((val = this.m_pfj.getLineWidthObj(this.m_pfj.getParetoLineRiser())) != null) {
            node.addProperty("width", ((Integer)val).intValue());
            styleOverridden = true;
        }
        if ((val = this.m_pfj.getLineStyleObj(this.m_pfj.getParetoLineRiser())) != null) {
            node.addProperty("lineStyle", ParetoLine.convertLineStyleToString((Integer)val));
            styleOverridden = true;
        }
        return styleOverridden;
    }

    @Concealed
    protected void resetStyle() {
        this.setColor(Color.black);
        this.setWidth(1);
        this.setLineStyle(0);
    }
}

