/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.dataView.TokenSubstitution;
import oracle.dss.graph.BaseText;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.annotations.Concealed;

public class LegendTitle
extends BaseText {
    @Concealed
    protected String m_text = "";

    @Concealed
    public LegendTitle(CommonGraph graph) {
        super(graph);
        this.m_identObj = new IdentObj(74);
    }

    public boolean isVisible() {
        IdentObj legendArea = new IdentObj(12);
        if (!this.m_pfj.getDisplay(legendArea)) {
            return false;
        }
        return this.m_pfj.getDisplay(this.m_identObj);
    }

    public void setVisible(boolean yesNo) {
        IdentObj legendArea = new IdentObj(12);
        if (!this.m_pfj.getDisplay(legendArea)) {
            this.m_pfj.setDisplay(this.m_identObj, false);
        } else {
            this.m_pfj.setDisplay(this.m_identObj, yesNo);
        }
    }

    public void setText(String str) {
        if (str == null) {
            this.m_commonGraph.getErrorHandler().log("invalid text", this.getClass().toString(), "setText");
            return;
        }
        TokenSubstitution vs = this.m_commonGraph.getTokenSubstitution();
        if (vs != null) {
            String[] tokenArray = null;
            tokenArray = vs.getListItems();
            for (int i = 0; i < tokenArray.length; ++i) {
                tokenArray[i] = vs.getToken(tokenArray[i]);
            }
            str = this.truncateText(str, tokenArray);
            this.m_pfj.setTextString(this.m_identObj, vs.getParsedString(str));
            this.m_text = str;
        } else {
            str = this.truncateText(str, null);
            this.m_pfj.setTextString(this.m_identObj, vs.getParsedString(str));
            this.m_text = str;
        }
    }

    public String getText() {
        TokenSubstitution vs = this.m_commonGraph.getTokenSubstitution();
        if (vs == null) {
            return this.m_text;
        }
        return vs.getParsedString(this.m_text);
    }

    public String getUnParseText() {
        return this.m_text;
    }

    public int getHorizontalAlignment() {
        return this.m_pfj.getTextJustHoriz(this.m_identObj);
    }

    public void setHorizontalAlignment(int a) {
        if (a == 2 || a == 0 || a == 4 || a == 10) {
            this.m_pfj.setTextJustHoriz(this.m_identObj, a);
        } else {
            this.m_commonGraph.getErrorHandler().log("invalid horizontal aligment", this.getClass().getName(), "setHorizontalAlignment(a)");
        }
    }

    @Override
    public void setStyleXML(ObjectNode node) {
        super.setStyleXML(node);
        PropertyNode pNode = node.getProperty("horizontalAlignment");
        if (pNode != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("horizontalAlignment", LegendTitle.convertHorizontalAlignmentToInt(pNode.getValueAsString()));
            } else {
                this.setHorizontalAlignment(LegendTitle.convertHorizontalAlignmentToInt(pNode.getValueAsString()));
            }
        }
    }

    @Override
    @Concealed
    public boolean getStyleXML(boolean allProperties, ObjectNode node) {
        boolean nodeExists = super.getStyleXML(allProperties, node);
        Object val = this.m_pfj.getTextJustHorizObj(this.m_identObj);
        if (val != null) {
            node.addProperty("horizontalAlignment", this.convertHorizontalAlignmentToString((Integer)val));
            nodeExists = true;
        }
        return nodeExists;
    }

    @Override
    @Concealed
    public boolean getNonstyleXML(boolean allProperties, ObjectNode node) {
        boolean nodeExists = super.getNonstyleXML(allProperties, node);
        Object val = this.m_pfj.getTextString(this.m_identObj);
        if (val != null) {
            node.addProperty("text", this.getUnParseText());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getDisplayObj(this.m_identObj)) != null) {
            node.addProperty("visible", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        return nodeExists;
    }

    @Override
    @Concealed
    public void setNonstyleXML(ObjectNode node) {
        super.setNonstyleXML(node);
        PropertyNode pNode = node.getProperty("text");
        if (pNode != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("text", pNode.getValueAsString());
            } else {
                this.setText(pNode.getValueAsString());
            }
        }
        if ((pNode = node.getProperty("visible")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("rendered", pNode.getValueAsBoolean());
            } else {
                this.setVisible(pNode.getValueAsBoolean());
            }
        }
        if ((pNode = node.getProperty("rendered")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("rendered", pNode.getValueAsBoolean());
            } else {
                this.setVisible(pNode.getValueAsBoolean());
            }
        }
    }

    @Override
    @Concealed
    protected String getComponentName() {
        return "LegendTitle";
    }
}

