/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.HashMap;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.GraphConstants;
import oracle.dss.graph.Rect;
import oracle.dss.graph.SFX;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.LegendLayout;
import oracle.dss.util.Utility;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.annotations.Concealed;

public class LegendArea
extends BaseGraphComponent
implements Rect {
    @Concealed
    protected SFX m_sfx;
    private LegendLayout m_legendLayout;
    private static final String a_threeDSurfacePosition = "threeDSurfacePosition";
    @Concealed
    public static final String a_alongGraphEdge = "alongGraphEdge";
    @Concealed
    public static final String a_automaticPlacement = "automaticPlacement";
    @Concealed
    public static final String a_itemSpacing = "itemSpacing";
    private static final String NAME_THREEDSURFACERECT = "ThreeDSurfaceRect";
    @Concealed
    protected static final int rect_Height = 2063;
    @Concealed
    protected static final int rect_Width = 25072;
    @Concealed
    protected static final int rect_X = -14180;
    @Concealed
    protected static final int rect_Y = -11537;

    @Concealed
    public LegendArea(CommonGraph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getLegendArea();
        this.m_legendLayout = this.m_pfj.getLegendLayout();
    }

    public SFX getSFX() {
        if (this.m_sfx == null) {
            this.m_sfx = new SFX(this.m_commonGraph, this.m_identObj);
        }
        return this.m_sfx;
    }

    @Override
    public boolean selectObject(int series, int group) {
        this.m_pfj.setSelection(this.m_identObj);
        return this.m_identObj.equals(this.m_pfj.getSelectionID());
    }

    public Color getBorderColor() {
        return this.m_pfj.getBorderColor(this.m_identObj);
    }

    public void setBorderColor(Color newColor) {
        if (newColor == null) {
            this.m_commonGraph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setBorderColor( Color newColor)");
            return;
        }
        this.m_pfj.setBorderColor(this.m_identObj, newColor);
    }

    public boolean isBorderTransparent() {
        return this.m_pfj.getTransparentBorderColor(this.m_identObj);
    }

    public void setBorderTransparent(boolean yesNo) {
        this.m_pfj.setTransparentBorderColor(this.m_identObj, yesNo);
    }

    public Color getFillColor() {
        return this.m_pfj.getFillColor(this.m_identObj);
    }

    public void setFillColor(Color newColor) {
        if (newColor == null) {
            this.setFillTransparent(true);
            return;
        }
        this.m_pfj.setFillColor(this.m_identObj, newColor);
    }

    public boolean isFillTransparent() {
        return this.m_pfj.getTransparentFillColor(this.m_identObj);
    }

    public void setFillTransparent(boolean yesNo) {
        this.m_pfj.setTransparentFillColor(this.m_identObj, yesNo);
    }

    public boolean isMarkersPerRowAutomatic() {
        return this.m_pfj.getLegendAutomatic();
    }

    public void setMarkersPerRowAutomatic(boolean yesNo) {
        this.m_pfj.setLegendAutomatic(yesNo);
    }

    public int getLegendMarkersPerRow() {
        return this.m_pfj.getLegendMarkersPerRow();
    }

    public void setLegendMarkersPerRow(int count) {
        if (count < 0 || count > 9999) {
            this.m_commonGraph.getErrorHandler().log("invalid number of legend markers", this.getClass().getName(), "setLegendMarkersPerRow(int count)");
        } else {
            this.m_pfj.setLegendMarkersPerRow(count);
        }
    }

    public int getLegendTextPosition() {
        return this.m_pfj.getLegendMarkerPosition();
    }

    public void setLegendTextPosition(int mode) {
        if (mode > 4 || mode < 0) {
            this.m_commonGraph.getErrorHandler().log("Invalid parameter", this.getClass().getName(), "setLegendTextPosition");
            return;
        }
        this.m_pfj.setLegendMarkerPosition(mode);
    }

    public int getLegendOrientation() {
        return this.m_pfj.getLegendOrient();
    }

    public void setLegendOrientation(int orient) {
        if (orient > 2 || orient < 0) {
            this.m_commonGraph.getErrorHandler().log("Invalid parameter", this.getClass().getName(), "setLegendOrientation");
            return;
        }
        this.m_pfj.setLegendOrient(orient);
    }

    public int getPosition() {
        return this.m_pfj.getIntegerProp(Attr.LegendPosition);
    }

    public void setPosition(int position) {
        switch (position) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.m_pfj.setIntegerProp(position, Attr.LegendPosition);
                this.m_legendLayout.setAutomaticPosition(position, true);
                this.setRectDefault(true);
                this.m_pfj.setIntegerProp(0, Attr.AutomaticPlacement);
                break;
            }
            default: {
                this.m_commonGraph.getErrorHandler().log("invalid position", this.getClass().getName(), "setPosition(int position)");
                return;
            }
        }
    }

    public GraphConstants.LegendAreaPositionHint getPositionHint() {
        return this.m_pfj.getLegendAreaPositionHint();
    }

    public void setPositionHint(GraphConstants.LegendAreaPositionHint positionHint) {
        this.m_pfj.setLegendAreaPositionHint(positionHint);
    }

    public GraphConstants.LegendItemSpacing getItemSpacing() {
        return this.m_pfj.getLegendItemSpacing();
    }

    public void setItemSpacing(GraphConstants.LegendItemSpacing itemSpacing) {
        this.m_pfj.setLegendItemSpacing(itemSpacing);
    }

    public String getMaxWidth() {
        return this.m_pfj.getLegendAreaMaxWidth();
    }

    public void setMaxWidth(String maxWidth) {
        this.m_pfj.setLegendAreaMaxWidth(maxWidth);
    }

    @Concealed
    public int getAutomaticPosition() {
        return this.m_legendLayout.getAutomaticPosition();
    }

    @Concealed
    protected void setRectDefault(boolean bDefault) {
        this.m_legendLayout.setRectDefault(bDefault);
    }

    public void setAlongGraphEdge(boolean alongEdge) {
        this.m_pfj.setBooleanProp(alongEdge, Attr.AlongGraphEdge);
        this.m_legendLayout.setAutomaticPosition(this.getAutomaticPosition(), true);
        this.setRectDefault(true);
        this.m_pfj.setObjProp(this.m_legendLayout.getDefaultPFJRect(this.m_pfj.getIntegerProp(Attr.LegendAlternatePosition), this.m_pfj.getBooleanProp(Attr.AlongGraphEdge)), Attr.LegendAlternateRect);
        this.m_legendLayout.setStandardRectDefault(true);
        this.m_legendLayout.setThreeDSurfaceRectDefault(true);
        if (!alongEdge) {
            this.m_legendLayout.adjustTitlesForLegendAlongEdge(this.getAutomaticPosition(), alongEdge);
        }
    }

    public boolean isAlongGraphEdge() {
        return this.m_pfj.getBooleanProp(Attr.AlongGraphEdge);
    }

    public void setAutomaticPlacement(int placement) {
        if (placement < 0 || placement > 1) {
            this.m_commonGraph.getErrorHandler().log("invalid value for AutomaticPlacement", this.getClass().getName(), "public void setAutomaticPlacement(int placement)");
            return;
        }
        this.m_pfj.setIntegerProp(placement, Attr.AutomaticPlacement);
        this.m_legendLayout.setLegendPositionProp(this.getPosition());
        this.m_pfj.needRecalc();
    }

    public int getAutomaticPlacement() {
        return this.m_pfj.getIntegerProp(Attr.AutomaticPlacement);
    }

    @Override
    public Rectangle getRect() {
        Rectangle pfjRect = this.m_pfj.getRect(this.m_identObj);
        if (pfjRect != null) {
            Rectangle rect = new Rectangle(pfjRect);
            rect.y += rect.height;
            return rect;
        }
        return null;
    }

    @Override
    public void setRect(Rectangle loc) {
        Rectangle rect = new Rectangle(loc);
        rect.y -= rect.height;
        this.m_pfj.setRect(this.m_identObj, rect);
        this.m_legendLayout.setPositionForRect();
        this.m_commonGraph.setFrameSizeAutomatic(false);
        this.setRectDefault(false);
    }

    public boolean isVisible() {
        return this.m_pfj.getDisplay(this.m_identObj);
    }

    public void setVisible(boolean yesNo) {
        this.m_pfj.setDisplay(this.m_identObj, yesNo);
    }

    @Concealed
    private void setRectXML(ObjectNode node, boolean bThreeDSurfaceRect) {
        Rectangle rect = null;
        rect = bThreeDSurfaceRect ? this.m_legendLayout.getThreeDSurfaceRect() : this.m_legendLayout.getStandardRect();
        PropertyNode pNode = node.getProperty("height");
        if (pNode != null) {
            rect.height = pNode.getValueAsInteger();
        }
        if ((pNode = node.getProperty("width")) != null) {
            rect.width = pNode.getValueAsInteger();
        }
        if ((pNode = node.getProperty("x")) != null) {
            rect.x = pNode.getValueAsInteger();
        }
        if ((pNode = node.getProperty("y")) != null) {
            rect.y = pNode.getValueAsInteger();
        }
        if (bThreeDSurfaceRect) {
            this.m_legendLayout.setThreeDSurfaceRect(rect);
        } else {
            this.m_legendLayout.setStandardRect(rect);
        }
    }

    @Concealed
    private ObjectNode getRectXML(boolean allProperties, boolean bThreeDSurfaceRect) {
        boolean nodeExists = false;
        Rectangle rect = null;
        boolean bRectDefault = true;
        ObjectNode node = new ObjectNode("Rect");
        if (bThreeDSurfaceRect) {
            rect = this.m_legendLayout.getThreeDSurfaceRect();
            bRectDefault = this.m_legendLayout.isThreeDSurfaceRectDefault();
        } else {
            rect = this.m_legendLayout.getStandardRect();
            bRectDefault = this.m_legendLayout.isStandardRectDefault();
        }
        if (rect != null && (allProperties || !bRectDefault)) {
            node.addProperty("height", rect.height);
            node.addProperty("width", rect.width);
            node.addProperty("x", rect.x);
            node.addProperty("y", rect.y);
            nodeExists = true;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }

    @Concealed
    private ObjectNode getThreeDSurfaceRectXML(boolean allProperties) {
        ObjectNode node = new ObjectNode(NAME_THREEDSURFACERECT);
        boolean nodeExists = false;
        ObjectNode rectNode = this.getRectXML(allProperties, true);
        if (allProperties || rectNode != null) {
            node.addProperty(rectNode);
            nodeExists = true;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }

    @Concealed
    protected String convertLegendAreaPositionToString(int value) {
        String lAPosition = "LAP_BOTTOM";
        switch (value) {
            case 0: {
                lAPosition = "LAP_TOP";
                break;
            }
            case 1: {
                lAPosition = "LAP_BOTTOM";
                break;
            }
            case 2: {
                lAPosition = "LAP_RIGHT";
                break;
            }
            case 3: {
                lAPosition = "LAP_LEFT";
            }
        }
        return lAPosition;
    }

    @Concealed
    public static int convertLegendAreaPositionToInt(String string) {
        if (string.equals("LAP_TOP")) {
            return 0;
        }
        if (string.equals("LAP_BOTTOM")) {
            return 1;
        }
        if (string.equals("LAP_RIGHT")) {
            return 2;
        }
        if (string.equals("LAP_LEFT")) {
            return 3;
        }
        return -1;
    }

    @Concealed
    private String _convertAutomaticPlacementToString(int placement) {
        switch (placement) {
            case 0: {
                return "AP_NEVER";
            }
        }
        return "AP_ALWAYS";
    }

    @Concealed
    public static int convertAutomaticPlacementToInt(String placement) {
        if (placement.equals("AP_NEVER")) {
            return 0;
        }
        if (placement.equals("AP_ALWAYS")) {
            return 1;
        }
        return -1;
    }

    @Concealed
    protected void resetToDefault() {
        this.m_legendLayout.resetToDefault();
    }

    @Concealed
    protected void graphTypeChanged(int oldType, int newType) {
        boolean bOldThreeD = this._isThreeDSurfaceGraph(oldType);
        boolean bNewThreeD = this._isThreeDSurfaceGraph(newType);
        if (bOldThreeD && !bNewThreeD || !bOldThreeD && bNewThreeD) {
            int tmpPos = this.m_pfj.getIntegerProp(Attr.LegendAlternatePosition);
            this.m_pfj.setIntegerProp(this.getPosition(), Attr.LegendAlternatePosition);
            this.m_legendLayout.setLegendPositionProp(tmpPos);
            Rectangle tempRect = new Rectangle(this.m_pfj.getRect(this.m_identObj));
            this.m_pfj.setRect(this.m_identObj, (Rectangle)this.m_pfj.getObjProp(Attr.LegendAlternateRect));
            this.m_pfj.setObjProp(tempRect, Attr.LegendAlternateRect);
        }
        this.m_legendLayout.setThreeDSurfaceGraph(bNewThreeD);
    }

    private boolean _isDualY(int graphType) {
        switch (graphType) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 62: 
            case 64: 
            case 71: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 88: 
            case 91: 
            case 92: 
            case 98: {
                return true;
            }
        }
        return false;
    }

    private boolean _isPie(int graphType) {
        switch (graphType) {
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 93: 
            case 94: {
                return true;
            }
        }
        return false;
    }

    private boolean _isThreeDSurfaceGraph(int type) {
        return type == 12 || type == 13 || type == 14;
    }

    @Concealed
    protected void resetStyle() {
        this.setBorderColor(Color.black);
        this.setBorderTransparent(false);
        this.setFillColor(Color.black);
        this.setFillTransparent(false);
        this.setMarkersPerRowAutomatic(true);
        this.setLegendMarkersPerRow(1);
        this.setLegendTextPosition(4);
        this.setLegendOrientation(1);
        this.setPosition(1);
        this.setPositionHint(GraphConstants.LegendAreaPositionHint.ALIGN_TO_EDGE);
        this.setAutomaticPlacement(1);
        this.setAlongGraphEdge(false);
        this.setMaxWidth(null);
        if (this.m_sfx != null) {
            this.getSFX().resetStyle();
        }
    }

    @Override
    @Concealed
    protected String getComponentName() {
        return "LegendArea";
    }

    @Concealed
    protected ObjectNode getXML(boolean allProperties, boolean allOverriddenProperties) {
        boolean nodeExists = false;
        ObjectNode node = this.getStyleXML(allProperties, allOverriddenProperties);
        if (node == null) {
            node = new ObjectNode(this.getComponentName());
        } else {
            nodeExists = true;
        }
        return (nodeExists |= this.getNonstyleXML(allProperties, node)) ? node : null;
    }

    @Override
    @Concealed
    public boolean getNonstyleXML(boolean allProperties, ObjectNode node) {
        boolean nodeExists = super.getNonstyleXML(allProperties, node);
        Object val = this.m_pfj.getDisplayObj(this.m_identObj);
        if (val != null) {
            node.addProperty("visible", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        return nodeExists;
    }

    @Concealed
    protected ObjectNode getStyleXML(boolean allProperties, boolean allOverriddenProperties) {
        ContainerNode sfxNode;
        ObjectNode threeDSurfaceRectXML;
        ObjectNode rectXML;
        int tmp;
        ObjectNode node = new ObjectNode(this.getComponentName());
        boolean nodeExists = false;
        Object val = this.m_pfj.getObjProp(Attr.AlongGraphEdge);
        if (val != null) {
            node.addProperty(a_alongGraphEdge, ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.AutomaticPlacement)) != null) {
            node.addProperty(a_automaticPlacement, this._convertAutomaticPlacementToString((Integer)val));
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.LegendItemSpacing)) != null) {
            node.addProperty(a_itemSpacing, ((GraphConstants.LegendItemSpacing)((Object)val)).toString());
            nodeExists = true;
        }
        if ((val = this.m_legendLayout.getStandardPosition()) != null) {
            node.addProperty("position", this.convertLegendAreaPositionToString((Integer)val));
            nodeExists = true;
        }
        if ((val = this.m_pfj.getLegendAreaPositionHint()) != null) {
            node.addProperty("positionHint", ((GraphConstants.LegendAreaPositionHint)((Object)val)).toString());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getLegendAreaMaxWidth()) != null) {
            node.addProperty("maxWidth", val.toString());
            nodeExists = true;
        }
        if ((val = this.m_legendLayout.getThreeDSurfacePosition()) != null) {
            node.addProperty(a_threeDSurfacePosition, this.convertLegendAreaPositionToString((Integer)val));
            nodeExists = true;
        }
        if ((val = this.getBorderColor()) != null) {
            node.addProperty("borderColor", LegendArea.toHexString(((Color)val).getRGB()));
            nodeExists = true;
        }
        if ((val = this.getFillColor()) != null) {
            node.addProperty("fillColor", LegendArea.toHexString(((Color)val).getRGB()));
            nodeExists = true;
        }
        if ((val = this.m_pfj.getTransparentBorderColorObj(this.m_identObj)) != null) {
            node.addProperty("borderTransparent", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getTransparentFillColorObj(this.m_identObj)) != null) {
            node.addProperty("fillTransparent", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.LegendAutomatic)) != null) {
            node.addProperty("markersPerRowAutomatic", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.LegendMarkersPerRow)) != null) {
            node.addProperty("legendMarkersPerRow", ((Integer)val).intValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.LegendMarkerPosition)) != null) {
            tmp = (Integer)val;
            if (tmp == 0) {
                node.addProperty("legendTextPosition", "LTP_ON_RIGHT");
            } else if (tmp == 1) {
                node.addProperty("legendTextPosition", "LTP_ON_LEFT");
            } else if (tmp == 2) {
                node.addProperty("legendTextPosition", "LTP_BELOW");
            } else if (tmp == 3) {
                node.addProperty("legendTextPosition", "LTP_ABOVE");
            } else if (tmp == 4) {
                node.addProperty("legendTextPosition", "LTP_ON_MWRKER");
            }
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.LegendOrient)) != null) {
            tmp = (Integer)val;
            if (tmp == 2) {
                node.addProperty("legendOrientation", "LO_AUTOMATIC");
            } else if (tmp == 1) {
                node.addProperty("legendOrientation", "LO_HORIZONTAL");
            } else if (tmp == 0) {
                node.addProperty("legendOrientation", "LO_VERTICAL");
            }
            nodeExists = true;
        }
        if ((rectXML = this.getRectXML(allProperties, false)) != null) {
            node.addProperty(rectXML);
            nodeExists = true;
        }
        if ((threeDSurfaceRectXML = this.getThreeDSurfaceRectXML(allProperties)) != null) {
            node.addProperty(threeDSurfaceRectXML);
            nodeExists = true;
        }
        if ((sfxNode = this.getSFX().getXML(allProperties, allOverriddenProperties)) != null) {
            node.addContainer(sfxNode);
            nodeExists = true;
        }
        return nodeExists ? node : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Concealed
    protected void setXML(ObjectNode node, boolean allProperties, HashMap map) {
        this.m_jsfHashMap = map;
        try {
            this.setXML(node, allProperties);
        }
        finally {
            this.m_jsfHashMap = null;
        }
    }

    @Concealed
    protected void setXML(ObjectNode node, boolean allProperties) {
        this.setNonStyleXML(node);
        this.setStyleXML(node, allProperties);
    }

    @Concealed
    protected void setNonStyleXML(ObjectNode node) {
        PropertyNode pNode = node.getProperty("visible");
        if (pNode != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("rendered", pNode.getValueAsBoolean());
            } else {
                this.setVisible(pNode.getValueAsBoolean());
            }
        }
        if ((pNode = node.getProperty("rendered")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("rendered", pNode.getValueAsBoolean());
            } else {
                this.setVisible(pNode.getValueAsBoolean());
            }
        }
    }

    @Concealed
    protected void setStyleXML(ObjectNode node, boolean allProperties) {
        String tmp;
        ContainerNode sfx;
        PropertyNode pNode = node.getProperty("position");
        if (pNode != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("position", LegendArea.convertLegendAreaPositionToInt(pNode.getValueAsString()));
            } else {
                this.m_legendLayout.setStandardPosition(LegendArea.convertLegendAreaPositionToInt(pNode.getValueAsString()));
            }
        }
        if ((pNode = node.getProperty("positionHint")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("positionHint", GraphConstants.LegendAreaPositionHint.convertStringToEnum(pNode.getValueAsString()));
            } else {
                this.setPositionHint(GraphConstants.LegendAreaPositionHint.convertStringToEnum(pNode.getValueAsString()));
            }
        }
        if ((pNode = node.getProperty("maxWidth")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("maxWidth", pNode.getValueAsString());
            } else {
                this.setMaxWidth(pNode.getValueAsString());
            }
        }
        if ((pNode = node.getProperty(a_threeDSurfacePosition)) != null) {
            this.m_legendLayout.setThreeDSurfacePosition(LegendArea.convertLegendAreaPositionToInt(pNode.getValueAsString()));
        }
        pNode = node.getProperty(a_alongGraphEdge);
        boolean alongGraphEdge = this.isAlongGraphEdge();
        if (pNode != null) {
            alongGraphEdge = pNode.getValueAsBoolean();
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put(a_alongGraphEdge, alongGraphEdge);
            } else {
                this.setAlongGraphEdge(alongGraphEdge);
            }
        }
        if (!alongGraphEdge) {
            ObjectNode rectNode;
            ObjectNode threeDSurfaceRectXML;
            ObjectNode rectXML = node.getPropertyValueAsObjectNode("Rect", true);
            if (rectXML != null) {
                this.setRectXML(rectXML, false);
            }
            if ((threeDSurfaceRectXML = node.getPropertyValueAsObjectNode(NAME_THREEDSURFACERECT, true)) != null && (rectNode = threeDSurfaceRectXML.getPropertyValueAsObjectNode("Rect", true)) != null) {
                this.setRectXML(rectNode, true);
            }
        }
        if ((pNode = node.getProperty(a_automaticPlacement)) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put(a_automaticPlacement, LegendArea.convertAutomaticPlacementToInt(pNode.getValueAsString()));
            } else {
                this.setAutomaticPlacement(LegendArea.convertAutomaticPlacementToInt(pNode.getValueAsString()));
            }
        }
        if ((pNode = node.getProperty(a_itemSpacing)) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put(a_itemSpacing, GraphConstants.LegendItemSpacing.convertStringToEnum(pNode.getValueAsString()));
            } else {
                this.setItemSpacing(GraphConstants.LegendItemSpacing.convertStringToEnum(pNode.getValueAsString()));
            }
        }
        if ((pNode = node.getProperty("borderColor")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("borderColor", new Color(LegendArea.hexStringToInt(pNode.getValueAsString()), true));
            } else {
                this.setBorderColor(new Color(LegendArea.hexStringToInt(pNode.getValueAsString()), true));
            }
        }
        pNode = node.getProperty("fillColor");
        boolean fillColorSet = false;
        if (pNode != null) {
            fillColorSet = true;
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("fillColor", new Color(LegendArea.hexStringToInt(pNode.getValueAsString()), true));
            } else {
                this.setFillColor(new Color(LegendArea.hexStringToInt(pNode.getValueAsString()), true));
            }
        }
        if ((sfx = node.getContainer("SFX")) != null) {
            this.getSFX().setXML(sfx, allProperties);
        }
        if ((pNode = node.getProperty("borderTransparent")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("borderTransparent", pNode.getValueAsBoolean());
            } else {
                this.setBorderTransparent(pNode.getValueAsBoolean());
            }
        }
        if ((pNode = node.getProperty("fillTransparent")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("fillTransparent", pNode.getValueAsBoolean());
            } else {
                this.setFillTransparent(pNode.getValueAsBoolean());
            }
        } else if (fillColorSet && Utility.compareXMLVersions((String)this.m_commonGraph.m_passedInXMLVersion, (String)this.m_commonGraph.getVersion()) < 0) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("fillTransparent", Boolean.FALSE);
            } else {
                this.setFillTransparent(false);
            }
        }
        pNode = node.getProperty("markersPerRowAutomatic");
        if (pNode != null) {
            this.setMarkersPerRowAutomatic(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty("legendMarkersPerRow")) != null) {
            this.setLegendMarkersPerRow(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty("legendTextPosition")) != null) {
            tmp = pNode.getValueAsString();
            if (tmp.equals("LTP_ON_RIGHT")) {
                this.setLegendTextPosition(0);
            } else if (tmp.equals("LTP_ON_LEFT")) {
                this.setLegendTextPosition(1);
            } else if (tmp.equals("LTP_ABOVE")) {
                this.setLegendTextPosition(3);
            } else if (tmp.equals("LTP_BELOW")) {
                this.setLegendTextPosition(2);
            } else if (tmp.equals("LTP_ON_MWRKER")) {
                this.setLegendTextPosition(4);
            }
        }
        if ((pNode = node.getProperty("legendOrientation")) != null) {
            tmp = pNode.getValueAsString();
            if (tmp.equals("LO_AUTOMATIC")) {
                this.setLegendOrientation(2);
            } else if (tmp.equals("LO_HORIZONTAL")) {
                this.setLegendOrientation(1);
            } else if (tmp.equals("LO_VERTICAL")) {
                this.setLegendOrientation(0);
            }
        }
    }
}

