/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.dataView.HorizontalAlignment;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.BaseText;
import oracle.dss.graph.CommonGraph;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.annotations.Concealed;

public abstract class BaseTickLabel
extends BaseText
implements HorizontalAlignment {
    @Concealed
    public BaseTickLabel(CommonGraph graph) {
        super(graph);
    }

    @Override
    public boolean selectObject(int series, int group) {
        this.m_pfj.setSelection(this.m_identObj);
        return this.m_identObj.equals(this.m_pfj.getSelectionID());
    }

    @Override
    public int getHorizontalAlignment() {
        return this.m_pfj.getTextJustHoriz(this.m_identObj);
    }

    @Override
    public void setHorizontalAlignment(int a) {
        if (a == 2 || a == 0 || a == 4 || a == 10) {
            this.m_pfj.setTextJustHoriz(this.m_identObj, a);
        } else {
            this.m_commonGraph.getErrorHandler().log("invalid horizontal aligment", this.getClass().getName(), "setHorizontalAlignment(a)");
        }
    }

    public int getTextRotation() {
        return this.m_pfj.getTextRotation(this.m_identObj);
    }

    public void setTextRotation(int orient) {
        if (this.m_pfj.isFunnel()) {
            this.m_pfj.setTextRotation(this.m_identObj, orient);
        }
        if (orient != 0 && orient != 90 && orient != 270) {
            this.m_commonGraph.getErrorHandler().log("invalid value for TextRotation", this.getClass().getName(), "setTextRotation(int orient)");
        } else {
            this.m_pfj.setTextRotation(this.m_identObj, orient);
        }
    }

    public abstract boolean isTickLabelStaggered();

    public abstract void setTickLabelStaggered(boolean var1);

    public boolean isTextFittingAutomatic() {
        return false;
    }

    public void setTextFittingAutomatic(boolean yesNo) {
    }

    public boolean isVisible() {
        return this.m_pfj.getDisplay(this.m_identObj);
    }

    public void setVisible(boolean yesNo) {
        this.m_pfj.setDisplay(this.m_identObj, yesNo);
    }

    @Override
    @Concealed
    public void setXML(ObjectNode node) {
        this.setStyleXML(node);
        this.setNonstyleXML(node);
    }

    @Override
    @Concealed
    public boolean getNonstyleXML(boolean allProperties, ObjectNode node) {
        boolean nodeExists = super.getNonstyleXML(allProperties, node);
        Object val = this.m_pfj.getAutofitObj(this.m_identObj);
        if (val != null) {
            node.addProperty("textFittingAutomatic", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getDisplayObj(this.m_identObj)) != null) {
            node.addProperty("visible", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        return nodeExists;
    }

    @Override
    @Concealed
    public boolean getStyleXML(boolean allProperties, ObjectNode node) {
        boolean nodeExists = super.getStyleXML(allProperties, node);
        Object val = this.m_pfj.getTextRotationObj(this.m_identObj);
        if (val != null) {
            int tmp = (Integer)val;
            if (tmp == 0) {
                node.addProperty("textRotation", "TR_HORIZ");
            } else if (tmp == 90) {
                node.addProperty("textRotation", "TR_HORIZ_ROTATE_90");
            } else if (tmp == 270) {
                node.addProperty("textRotation", "TR_HORIZ_ROTATE_270");
            } else {
                node.addProperty("textRotation", tmp);
            }
            nodeExists = true;
        }
        if ((val = this.m_pfj.getTextJustHorizObj(this.m_identObj)) != null) {
            node.addProperty("horizontalAlignment", this.convertHorizontalAlignmentToString((Integer)val));
            nodeExists = true;
        }
        if ((val = this.m_pfj.getLabelStaggerObj(this.m_identObj)) != null) {
            node.addProperty("tickLabelStaggered", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        return nodeExists;
    }

    @Override
    @Concealed
    public void setNonstyleXML(ObjectNode node) {
        super.setNonstyleXML(node);
        PropertyNode pNode = node.getProperty("textFittingAutomatic");
        if (pNode != null) {
            this.setTextFittingAutomatic(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty("visible")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("rendered", pNode.getValueAsBoolean());
            } else {
                this.setVisible(pNode.getValueAsBoolean());
            }
        }
        if ((pNode = node.getProperty("rendered")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("rendered", pNode.getValueAsBoolean());
            } else {
                this.setVisible(pNode.getValueAsBoolean());
            }
        }
    }

    @Override
    @Concealed
    public void setStyleXML(ObjectNode node) {
        super.setStyleXML(node);
        PropertyNode pNode = node.getProperty("textRotation");
        if (pNode != null) {
            String tmp = pNode.getValueAsString();
            int textRotation = 0;
            textRotation = BaseGraphComponent.convertTextRotationtToInt(tmp);
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("textRotation", textRotation);
            } else {
                this.setTextRotation(textRotation);
            }
        }
        if ((pNode = node.getProperty("horizontalAlignment")) != null) {
            this.setHorizontalAlignment(BaseTickLabel.convertHorizontalAlignmentToInt(pNode.getValueAsString()));
        }
        if ((pNode = node.getProperty("tickLabelStaggered")) != null) {
            this.setTickLabelStaggered(pNode.getValueAsBoolean());
        }
    }

    @Override
    @Concealed
    public void resetStyle() {
        this.setTextRotation(0);
        this.setHorizontalAlignment(2);
        this.setTickLabelStaggered(false);
        super.resetStyle();
    }
}

