/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.util.HashMap;
import oracle.dss.dataView.BaseComponentXML;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.PFJ;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.presutil.PresUtils;
import oracle.javatools.annotations.Concealed;
import oracle.javatools.mt.annotation.CodeSharingSafe;

@CodeSharingSafe(value="StaticInitializer")
public abstract class BaseGraphComponent
extends BaseComponentXML {
    public static final int DY2_TRUE = 1;
    public static final int DY2_FALSE = 0;
    public static final int DY2_AUTO_ASSIGN = 2;
    @Concealed
    protected static final String dy2_true = "DY2_TRUE";
    @Concealed
    protected static final String dy2_false = "DY2_FALSE";
    @Concealed
    protected static final String dy2_auto_assign = "DY2_AUTO_ASSIGN";
    @Concealed
    public static final int FP_SM_DIAG_UP_LT = 0;
    @Concealed
    public static final int FP_SM_CHECK = 1;
    @Concealed
    public static final int FP_SM_DIAG_UP_RT = 2;
    @Concealed
    public static final int FP_SM_TRIANGLE_CHECK = 3;
    @Concealed
    public static final int FP_SM_CROSSHATCH = 4;
    @Concealed
    public static final int FP_SM_DIAMOND_CHECK = 5;
    @Concealed
    public static final int FP_LG_DIAG_UP_LT = 6;
    @Concealed
    public static final int FP_LG_CHECK = 7;
    @Concealed
    public static final int FP_LG_DIAG_UP_RT = 8;
    @Concealed
    public static final int FP_LG_TRIANGLE_CHECK = 9;
    @Concealed
    public static final int FP_LG_CROSSHATCH = 10;
    @Concealed
    public static final int FP_LG_DIAMOND_CHECK = 11;
    @Concealed
    public static final int FP_MAX = 11;
    public static final int FS_PLAIN = 0;
    public static final int FS_ITALIC = 1;
    public static final int FS_BOLD = 2;
    public static final int FS_ITALIC_BOLD = 3;
    public static final int FS_UNDERLINE = 4;
    public static final int FS_ITALIC_UNDERLINE = 5;
    public static final int FS_BOLD_UNDERLINE = 6;
    public static final int FS_BOLD_ITALIC_UNDERLINE = 7;
    @Concealed
    protected static final String fs_plain = "FS_PLAIN";
    @Concealed
    protected static final String fs_italic = "FS_ITALIC";
    @Concealed
    protected static final String fs_bold = "FS_BOLD";
    @Concealed
    protected static final String fs_italic_bold = "FS_ITALIC_BOLD";
    @Concealed
    protected static final String fs_underline = "FS_UNDERLINE";
    @Concealed
    protected static final String fs_italic_underline = "FS_ITALIC_UNDERLINE";
    @Concealed
    protected static final String fs_bold_underline = "FS_BOLD_UNDERLINE";
    @Concealed
    protected static final String fs_bold_italic_underline = "FS_BOLD_ITALIC_UNDERLINE";
    public static final int FT_COLOR = 1;
    public static final int FT_GRADIENT = 2;
    public static final int FT_TEXTURE = 3;
    @Concealed
    public static final int FT_PATTERN = 4;
    @Concealed
    protected static final String ft_color = "FT_COLOR";
    @Concealed
    protected static final String ft_gradient = "FT_GRADIENT";
    @Concealed
    protected static final String ft_texture = "FT_TEXTURE";
    public static final int GD_RIGHT = 1;
    public static final int GD_LEFT = 2;
    public static final int GD_DOWN = 3;
    public static final int GD_UP = 4;
    public static final int GD_DOWN_LEFT = 5;
    public static final int GD_DIAGONAL_45 = 5;
    public static final int GD_UP_LEFT = 6;
    public static final int GD_DOWN_RIGHT = 7;
    public static final int GD_DIAGONAL_135 = 7;
    public static final int GD_UP_RIGHT = 8;
    public static final int GD_RADIAL = 9;
    public static final int GD_RADIAL_TOP_LEFT = 10;
    public static final int GD_RADIAL_TOP_RIGHT = 11;
    public static final int GD_RADIAL_BOTTOM_LEFT = 12;
    public static final int GD_RADIAL_BOTTOM_RIGHT = 13;
    @Concealed
    protected static final String gd_right = "GD_RIGHT";
    @Concealed
    protected static final String gd_left = "GD_LEFT";
    @Concealed
    protected static final String gd_down = "GD_DOWN";
    @Concealed
    protected static final String gd_up_left = "GD_UP_LEFT";
    @Concealed
    protected static final String gd_up = "GD_UP";
    @Concealed
    protected static final String gd_down_left = "GD_DOWN_LEFT";
    @Concealed
    protected static final String gd_radial = "GD_RADIAL";
    @Concealed
    protected static final String gd_down_right = "GD_DOWN_RIGHT";
    @Concealed
    protected static final String gd_up_right = "GD_UP_RIGHT";
    @Concealed
    protected static final String gd_radial_top_right = "GD_RADIAL_TOP_RIGHT";
    @Concealed
    protected static final String gd_radial_bottom_right = "GD_RADIAL_BOTTOM_RIGHT";
    @Concealed
    protected static final String gd_radial_top_left = "GD_RADIAL_TOP_LEFT";
    @Concealed
    protected static final String gd_radial_bottom_left = "GD_RADIAL_BOTTOM_RIGHT";
    @Concealed
    protected static final String gd_diagonal_45 = "GD_DIAGONAL_45";
    @Concealed
    protected static final String gd_diagonal_135 = "GD_DIAGONAL_135";
    public static final int GS_GRID = 0;
    public static final int GS_EXTENDED = 1;
    public static final int GS_IN = 2;
    public static final int GS_OUT = 3;
    public static final int GS_SPAN = 4;
    public static final int GS_AUTOMATIC = 5;
    public static final int GS_NONE = 6;
    @Concealed
    protected static final String gs_automatic = "GS_AUTOMATIC";
    @Concealed
    protected static final String gs_grid = "GS_GRID";
    @Concealed
    protected static final String gs_extended = "GS_EXTENDED";
    @Concealed
    protected static final String gs_in = "GS_IN";
    @Concealed
    protected static final String gs_out = "GS_OUT";
    @Concealed
    protected static final String gs_span = "GS_SPAN";
    @Concealed
    protected static final String gs_none = "GS_NONE";
    public static final int LD_VALUE = 0;
    public static final int LD_PERCENT = 1;
    public static final int LD_TEXT = 2;
    public static final int LD_TEXT_PERCENT = 3;
    public static final int LD_TEXT_VALUE = 4;
    @Concealed
    protected static final String ld_value = "LD_VALUE";
    @Concealed
    protected static final String ld_percent = "LD_PERCENT";
    @Concealed
    protected static final String ld_text = "LD_TEXT";
    @Concealed
    protected static final String ld_text_percent = "LD_TEXT_PERCENT";
    @Concealed
    protected static final String ld_text_value = "LD_TEXT_VALUE";
    public static final int LO_AUTOMATIC = 2;
    public static final int LO_HORIZONTAL = 1;
    public static final int LO_VERTICAL = 0;
    @Concealed
    protected static final String lo_automatic = "LO_AUTOMATIC";
    @Concealed
    protected static final String lo_horizontal = "LO_HORIZONTAL";
    @Concealed
    protected static final String lo_vertical = "LO_VERTICAL";
    public static final int LAP_TOP = 0;
    public static final int LAP_BOTTOM = 1;
    public static final int LAP_RIGHT = 2;
    public static final int LAP_LEFT = 3;
    @Concealed
    protected static final String lap_top = "LAP_TOP";
    @Concealed
    protected static final String lap_bottom = "LAP_BOTTOM";
    @Concealed
    protected static final String lap_right = "LAP_RIGHT";
    @Concealed
    protected static final String lap_left = "LAP_LEFT";
    public static final int AP_NEVER = 0;
    public static final int AP_ALWAYS = 1;
    @Concealed
    protected static final String ap_never = "AP_NEVER";
    @Concealed
    protected static final String ap_always = "AP_ALWAYS";
    public static final int LTP_ON_RIGHT = 0;
    public static final int LTP_ON_LEFT = 1;
    public static final int LTP_BELOW = 2;
    public static final int LTP_ABOVE = 3;
    public static final int LTP_ON_MARKER = 4;
    @Concealed
    protected static final String ltp_on_right = "LTP_ON_RIGHT";
    @Concealed
    protected static final String ltp_on_left = "LTP_ON_LEFT";
    @Concealed
    protected static final String ltp_below = "LTP_BELOW";
    @Concealed
    protected static final String ltp_above = "LTP_ABOVE";
    @Concealed
    protected static final String ltp_on_marker = "LTP_ON_MWRKER";
    public static final int MS_AUTOMATIC = -1;
    public static final int MS_NONE = 0;
    public static final int MS_SQUARE = 1;
    public static final int MS_CIRCLE = 2;
    public static final int MS_DIAMOND = 3;
    public static final int MS_PLUS = 4;
    public static final int MS_TRIANGLE_DOWN = 5;
    public static final int MS_TRIANGLE_UP = 6;
    public static final int MS_HUMAN = 7;
    public static final String SHAPE_AUTOMATIC = "automatic";
    public static final String SHAPE_NONE = "none";
    public static final String SHAPE_SQUARE = "square";
    public static final String SHAPE_CIRCLE = "circle";
    public static final String SHAPE_DIAMOND = "diamond";
    public static final String SHAPE_PLUS = "plus";
    public static final String SHAPE_TRIANGLE_DOWN = "triangle-down";
    public static final String SHAPE_TRIANGLE_UP = "triangle-up";
    public static final String SHAPE_HUMAN = "human";
    @Concealed
    protected static final String ms_automatic = "MS_AUTOMATIC";
    @Concealed
    protected static final String ms_none = "MS_NONE";
    @Concealed
    protected static final String ms_square = "MS_SQUARE";
    @Concealed
    protected static final String ms_circle = "MS_CIRCLE";
    @Concealed
    protected static final String ms_diamond = "MS_DIAMOND";
    @Concealed
    protected static final String ms_plus = "MS_PLUS";
    @Concealed
    protected static final String ms_triangle_down = "MS_TRIANGLE_DOWN";
    @Concealed
    protected static final String ms_triangle_up = "MS_TRIANGLE_UP";
    @Concealed
    protected static final String ms_human = "MS_HUMAN";
    public static final int MT_DEFAULT = 0;
    public static final int MT_BAR = 1;
    public static final int MT_MARKER = 2;
    public static final int MT_LINE = 2;
    public static final int MT_AREA = 3;
    public static final int MT_CURVE_LINE = 4;
    public static final int MT_STEPPED_LINE = 5;
    public static final int MT_CENTERED_STEPPED_LINE = 6;
    public static final int MT_CURVE_AREA = 7;
    @Concealed
    protected static final String mt_default = "MT_DEFAULT";
    @Concealed
    protected static final String mt_bar = "MT_BAR";
    @Concealed
    protected static final String mt_marker = "MT_MARKER";
    @Concealed
    protected static final String mt_line = "MT_LINE";
    @Concealed
    protected static final String mt_area = "MT_AREA";
    @Concealed
    protected static final String mt_curve_line = "MT_CURVE_LINE";
    @Concealed
    protected static final String mt_stepped_line = "MT_STEPPED_LINE";
    @Concealed
    protected static final String mt_centered_stepped_line = "MT_CENTERED_STEPPED_LINE";
    public static final int MTP_CUSTOM = 0;
    public static final int MTP_OUTSIDE_MAX = 1;
    public static final int MTP_ON_MAXEDGE = 2;
    public static final int MTP_INSIDE_MAX = 3;
    public static final int MTP_CENTER = 4;
    public static final int MTP_INSIDE_MIN = 5;
    public static final int MTP_UNDER_MARKER = 6;
    public static final int MTP_LEFT = 7;
    public static final int MTP_RIGHT = 8;
    @Concealed
    protected static final String mtp_custom = "MTP_CUSTOM";
    @Concealed
    protected static final String mtp_outside_max = "MTP_OUTSIDE_MAX";
    @Concealed
    protected static final String mtp_on_maxedge = "MTP_ON_MAXEDGE";
    @Concealed
    protected static final String mtp_inside_max = "MTP_INSIDE_MAX";
    @Concealed
    protected static final String mtp_center = "MTP_CENTER";
    @Concealed
    protected static final String mtp_inside_min = "MTP_INSIDE_MIN";
    @Concealed
    protected static final String mtp_under_marker = "MTP_UNDER_MARKER";
    @Concealed
    protected static final String mtp_left = "MTP_LEFT";
    @Concealed
    protected static final String mtp_right = "MTP_RIGHT";
    public static final int TDM_STRETCHED = 1;
    public static final int TDM_TILED = 0;
    @Concealed
    protected static final String tdm_stretched = "TDM_STRETCHED";
    @Concealed
    protected static final String tdm_tiled = "TDM_TILED";
    public static final int TLS_NOSKIP = 0;
    public static final int TLS_AUTOMATIC = 1;
    public static final int TLS_MANUAL = 2;
    @Concealed
    protected static final String tls_noskip = "TLS_NOSKIP";
    @Concealed
    protected static final String tls_automatic = "TLS_AUTOMATIC";
    @Concealed
    protected static final String tls_manual = "TLS_MANUAL";
    public static final int TR_HORIZ = 0;
    public static final int TR_HORIZ_ROTATE_90 = 90;
    public static final int TR_HORIZ_ROTATE_270 = 270;
    @Concealed
    protected static final String tr_horiz = "TR_HORIZ";
    @Concealed
    protected static final String tr_horiz_rotate_90 = "TR_HORIZ_ROTATE_90";
    @Concealed
    protected static final String tr_horiz_rotate_270 = "TR_HORIZ_ROTATE_270";
    public static final int AR_NO_ROTATE = 0;
    public static final int AR_HORIZ_ROTATE_90 = 1;
    public static final int AR_HORIZ_ROTATE_270 = 2;
    @Concealed
    protected static final String ar_no_rotate = "AR_NO_ROTATE";
    @Concealed
    protected static final String ar_horiz_rotate_90 = "AR_HORIZ_ROTATE_90";
    @Concealed
    protected static final String ar_horiz_rotate_270 = "AR_HORIZ_ROTATE_270";
    @Concealed
    protected static final String va_top = "TOP";
    @Concealed
    protected static final String va_center = "CENTER";
    @Concealed
    protected static final String va_bottom = "BOTTOM";
    public static final int VF_X1 = 0;
    public static final int VF_Y1 = 1;
    public static final int VF_Y2 = 2;
    public static final int VF_Z = 3;
    public static final int VF_STOCK_VOLUME = 4;
    public static final int VF_PIE_SLICE_LABEL = 5;
    public static final int AL_LEFT = 0;
    public static final int AL_RIGHT = 1;
    public static final int AL_BOTH = 2;
    @Concealed
    protected static final String al_left = "AL_LEFT";
    @Concealed
    protected static final String al_right = "AL_RIGHT";
    @Concealed
    protected static final String al_both = "AL_BOTH";
    public static final int FT_NONE = 0;
    public static final int FT_LINEAR = 1;
    public static final int FT_LOGARITHMIC = 5;
    public static final int FT_EXPONENTIAL = 8;
    @Concealed
    protected static final String ft_none = "FT_NONE";
    @Concealed
    protected static final String ft_linear = "FT_LINEAR";
    @Concealed
    protected static final String ft_logarithmic = "FT_LOGARITHMIC";
    @Concealed
    protected static final String ft_exponential = "FT_EXPONENTIAL";
    public static final int LP_NO_LABELS = 0;
    public static final int LP_OUTSIDE_WITH_FEELER = 1;
    public static final int LP_OUTSIDE_WITHOUT_FEELER = 2;
    public static final int LP_INSIDE = 3;
    public static final int LP_OUTSIDE_FEELER_IF_NEEDED = 4;
    @Concealed
    protected static final String lp_no_labels = "LP_NO_LABELS";
    @Concealed
    protected static final String lp_outside_with_feeler = "LP_OUTSIDE_WITH_FEELER";
    @Concealed
    protected static final String lp_outside_without_feeler = "LP_OUTSIDE_WITHOUT_FEELER";
    @Concealed
    protected static final String lp_inside = "LP_INSIDE";
    @Concealed
    protected static final String lp_outside_feeler_if_needed = "LP_OUTSIDE_FEELER_IF_NEEDED";
    public static final int LS_SOLID = 0;
    public static final int LS_DASH = 1;
    public static final int LS_DOTTED = 2;
    public static final int LS_DASH_DOT = 3;
    @Concealed
    protected static final String ls_solid = "LS_SOLID";
    @Concealed
    protected static final String ls_dash = "LS_DASH";
    @Concealed
    protected static final String ls_dotted = "LS_DOTTED";
    @Concealed
    protected static final String ls_dash_dot = "LS_DASH_DOT";
    public static final int RO_LINE = 0;
    public static final int RO_AREA = 1;
    @Concealed
    public static final String ro_line = "RO_LINE";
    @Concealed
    public static final String ro_area = "RO_AREA";
    public static final int RO_FRONT = 0;
    public static final int RO_BACK = 1;
    @Concealed
    public static final String ro_front = "RO_FRONT";
    @Concealed
    public static final String ro_back = "RO_BACK";
    public static final int LEGENDMARKERSLIMIT = 9999;
    public static final int QUADRANTLINEVALUELIMIT = 10;
    public static final int TSM_OFF = 0;
    public static final int TSM_EXPLICIT = 1;
    @Concealed
    public static final String tsm_off = "TSM_OFF";
    @Concealed
    public static final String tsm_explicit = "TSM_EXPLICIT";
    public static final int SV_VISIBLE = 0;
    public static final int SV_HIDDEN = 1;
    @Concealed
    public static final String sv_visible = "SV_VISIBLE";
    @Concealed
    public static final String sv_hidden = "SV_HIDDEN";
    @Concealed
    public static final String a_assignedToY2 = "assignedToY2";
    @Concealed
    public static final String a_axisMaxAutoScaled = "axisMaxAutoScaled";
    @Concealed
    public static final String a_axisMaxValue = "axisMaxValue";
    @Concealed
    public static final String a_axisZoomMaxValue = "axisZoomMaxValue";
    @Concealed
    public static final String a_axisMinAutoScaled = "axisMinAutoScaled";
    @Concealed
    public static final String a_axisMinValue = "axisMinValue";
    @Concealed
    public static final String a_axisZoomMinValue = "axisZoomMinValue";
    @Concealed
    public static final String a_color = "color";
    @Concealed
    public static final String a_markerColor = "markerColor";
    @Concealed
    public static final String a_shapePath = "shapePath";
    @Concealed
    public static final String a_effect = "effect";
    @Concealed
    public static final String a_explicitEnd = "explicitEnd";
    @Concealed
    public static final String a_explicitStart = "explicitStart";
    @Concealed
    public static final String a_horizontalAlignment = "horizontalAlignment";
    @Concealed
    public static final String a_verticalAlignment = "verticalAlignment";
    @Concealed
    public static final String a_labelPosition = "labelPosition";
    @Concealed
    public static final String a_lineColor = "lineColor";
    @Concealed
    public static final String a_lineWidth = "lineWidth";
    @Concealed
    public static final String a_logarithmicBase = "logarithmicBase";
    @Concealed
    public static final String a_majorTickStep = "majorTickStep";
    @Concealed
    public static final String a_majorIncrement = "majorIncrement";
    @Concealed
    public static final String a_minorTickStep = "minorTickStep";
    @Concealed
    public static final String a_minorIncrement = "minorIncrement";
    @Concealed
    public static final String a_majorTickCount = "majorTickCount";
    @Concealed
    public static final String a_minorTickCount = "minorTickCount";
    @Concealed
    public static final String a_majorTickStepAutomatic = "majorTickStepAutomatic";
    @Concealed
    public static final String a_minorTickStepType = "minorTickStepType";
    @Concealed
    public static final String a_markerShape = "markerShape";
    @Concealed
    public static final String a_markerTextPlace = "markerTextPlace";
    @Concealed
    public static final String a_markerType = "markerType";
    @Concealed
    public static final String a_mode = "mode";
    @Concealed
    public static final String a_scaledLogarithmic = "scaledLogarithmic";
    @Concealed
    public static final String a_text = "text";
    @Concealed
    public static final String a_textRotation = "textRotation";
    @Concealed
    public static final String a_automaticRotation = "automaticRotation";
    @Concealed
    public static final String a_tickLabelSkipCount = "tickLabelSkipCount";
    @Concealed
    public static final String a_tickLabelSkipFirst = "tickLabelSkipFirst";
    @Concealed
    public static final String a_tickLabelSkipMode = "tickLabelSkipMode";
    @Concealed
    public static final String a_visible = "visible";
    @Concealed
    public static final String a_rendered = "rendered";
    @Concealed
    protected static final String a_skippedWithLabels = "skippedWithLabels";
    @Concealed
    protected static final String a_textFittingAutomatic = "textFittingAutomatic";
    @Concealed
    protected static final String a_tickLabelStaggered = "tickLabelStaggered";
    @Concealed
    protected static final String a_tickLabelWrapped = "tickLabelWrapped";
    @Concealed
    protected static final String a_wordWrapEnabled = "wordWrapEnabled";
    @Concealed
    protected static final String a_axisAutoScaledFromZero = "axisAutoScaledFromZero";
    @Concealed
    public static final String a_tickStyle = "tickStyle";
    @Concealed
    public static final String a_borderTransparent = "borderTransparent";
    @Concealed
    protected static final String a_markersPerRowAutomatic = "markersPerRowAutomatic";
    @Concealed
    protected static final String a_legendMarkersPerRow = "legendMarkersPerRow";
    @Concealed
    public static final String a_thresholdMinValue = "thresholdMinValue";
    @Concealed
    public static final String a_thresholdMaxValue = "thresholdMaxValue";
    @Concealed
    protected static final String a_legendTextPosition = "legendTextPosition";
    @Concealed
    protected static final String a_legendOrientation = "legendOrientation";
    @Concealed
    protected static final String a_backGround = "backGround";
    @Concealed
    protected static final String a_markerTextAngleDefault = "markerTextAngleDefault";
    @Concealed
    protected static final String a_markerTextRadiusDefault = "markerTextRadiusDefault";
    @Concealed
    public static final String a_textType = "textType";
    @Concealed
    protected static final String a_height = "height";
    @Concealed
    public static final String a_width = "width";
    @Concealed
    protected static final String a_x = "x";
    @Concealed
    protected static final String a_y = "y";
    @Concealed
    protected static final String a_markerSize = "markerSize";
    @Concealed
    protected static final String a_quadrantLineCountX = "quadrantLineCountX";
    @Concealed
    protected static final String a_quadrantLineCountY = "quadrantLineCountY";
    @Concealed
    protected static final String a_quadrantLineValueX = "QuadrantLineValueX";
    @Concealed
    protected static final String a_quadrantLineValueY = "QuadrantLineValueY";
    @Concealed
    protected static final String a_lineIndex = "lineIndex";
    @Concealed
    protected static final String a_sharePanelProperties = "sharePanelProperties";
    @Concealed
    public static final String a_fitlineType = "fitlineType";
    @Concealed
    public static final String a_pieSliceExplode = "pieSliceExplode";
    @Concealed
    protected static final String a_transparent = "transparent";
    @Concealed
    public static final String a_visibility = "visibility";
    @Concealed
    protected static final String a_borderUsingDefaults = "borderUsingDefaults";
    @Concealed
    protected static final String a_defaultBorderColor = "defaultBorderColor";
    @Concealed
    protected static final String a_defaultBorderTransparent = "defaultBorderTransparent";
    @Concealed
    public static final String a_defaultColor = "defaultColor";
    @Concealed
    public static final String a_defaultMarkerColor = "defaultMarkerColor";
    @Concealed
    public static final String a_defaultMarkers = "defaultMarkers";
    @Concealed
    public static final String a_defaultFirstMarkerColor = "defaultFirstMarkerColor";
    @Concealed
    public static final String a_defaultLastMarkerColor = "defaultLastMarkerColor";
    @Concealed
    public static final String a_defaultHighMarkerColor = "defaultHighMarkerColor";
    @Concealed
    public static final String a_defaultLowMarkerColor = "defaultLowMarkerColor";
    @Concealed
    public static final String a_defaultMarkerType = "defaultMarkerType";
    @Concealed
    public static final String a_defaultMarkerShape = "defaultMarkerShape";
    @Concealed
    public static final String a_defaultLineWidth = "defaultLineWidth";
    @Concealed
    public static final String a_defaultAssignedToY2 = "defaultAssignedToY2";
    @Concealed
    public static final String a_defaultFitlineType = "defaultFitlineType";
    @Concealed
    public static final String a_displayedInLegend = "displayedInLegend";
    @Concealed
    public static final String a_seriesDisplayInLegend = "displayInLegend";
    @Concealed
    public static final String a_shortDesc = "shortDesc";
    @Concealed
    protected static final String a_focusFactor = "focusFactor";
    @Concealed
    protected static final String a_isometricProjection = "isometricProjection";
    @Concealed
    protected static final String a_lightSourceX = "lightSourceX";
    @Concealed
    protected static final String a_lightSourceY = "lightSourceY";
    @Concealed
    protected static final String a_lightSourceZ = "lightSourceZ";
    @Concealed
    protected static final String a_panX = "panX";
    @Concealed
    protected static final String a_panY = "panY";
    @Concealed
    protected static final String a_sizeX = "sizeX";
    @Concealed
    protected static final String a_sizeY = "sizeY";
    @Concealed
    protected static final String a_sizeZ = "sizeZ";
    @Concealed
    protected static final String a_squareRisers = "squareRisers";
    @Concealed
    protected static final String a_translationX = "translationX";
    @Concealed
    protected static final String a_translationY = "translationY";
    @Concealed
    protected static final String a_translationZ = "translationZ";
    @Concealed
    protected static final String a_viewerX = "viewerX";
    @Concealed
    protected static final String a_viewerY = "viewerY";
    @Concealed
    protected static final String a_viewerZ = "viewerZ";
    @Concealed
    protected static final String a_wallThickX = "wallThickX";
    @Concealed
    protected static final String a_wallThickY = "wallThickY";
    @Concealed
    protected static final String a_wallThickZ = "wallThickZ";
    @Concealed
    protected static final String a_zoomFactor = "zoomFactor";
    @Concealed
    public static final String a_lineStyle = "lineStyle";
    @Concealed
    public static final String a_type = "type";
    @Concealed
    public static final String a_location = "location";
    @Concealed
    public static final String a_association = "association";
    @Concealed
    public static final String a_high_value = "high";
    @Concealed
    public static final String a_low_value = "low";
    @Concealed
    public static final String a_group = "group";
    @Concealed
    public static final String a_series = "series";
    @Concealed
    public static final String a_line_value = "lineValue";
    @Concealed
    public static final String a_rollover_behavior = "rolloverBehavior";
    @Concealed
    public static final String a_borderWidth = "borderWidth";
    @Concealed
    public static final String a_borderStyle = "borderStyle";
    @Concealed
    public static final String a_xValue = "xValue";
    @Concealed
    public static final String a_yValue = "yValue";
    @Concealed
    public static final String a_imageSource = "imageSource";
    @Concealed
    public static final String a_yValueAssignment = "yValueAssignment";
    @Concealed
    protected CommonGraph m_commonGraph;
    @Concealed
    protected PFJ m_pfj;
    @Concealed
    protected IdentObj m_identObj;
    @CodeSharingSafe(value="StaticField")
    public static HashMap<String, Integer> CONV_MAP;
    @CodeSharingSafe(value="StaticField")
    public static HashMap<Integer, String> REV_CONV_MAP;

    @Concealed
    public BaseGraphComponent(CommonGraph graph) {
        this.m_commonGraph = graph;
        this.m_pfj = this.m_commonGraph.getPFJ();
    }

    public boolean selectObject(int series, int group) {
        return false;
    }

    @Concealed
    protected static String toHexString(int value) {
        return PresUtils.toHexStringWithAlpha(value);
    }

    @Concealed
    public static int hexStringToInt(String str) {
        return PresUtils.hexStringWithAlphaToInt(str);
    }

    @Concealed
    public static int convertTypeToInt(String type) {
        if (type.equals(ro_line)) {
            return 0;
        }
        return 1;
    }

    @Concealed
    public static int convertLocationToInt(String location) {
        if (location.equals(ro_front)) {
            return 0;
        }
        return 1;
    }

    @Concealed
    public static int convertAssociationToInt(String association) {
        if (association.equals("X1AXIS")) {
            return 41;
        }
        if (association.equals("Y1AXIS")) {
            return 46;
        }
        if (association.equals("Y2AXIS")) {
            return 51;
        }
        if (association.equals("SERIES")) {
            return 31;
        }
        return 46;
    }

    @Concealed
    public static int convertTextRotationtToInt(String str) {
        Integer val = null;
        try {
            val = Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (val == null) {
            val = str.equals(tr_horiz_rotate_90) ? Integer.valueOf(90) : (str.equals(tr_horiz_rotate_270) ? Integer.valueOf(270) : Integer.valueOf(0));
        }
        return val;
    }

    @Concealed
    public static int convertTickStyleToInt(String str) {
        if (str.equals(gs_grid)) {
            return 0;
        }
        if (str.equals(gs_extended)) {
            return 1;
        }
        if (str.equals(gs_in)) {
            return 2;
        }
        if (str.equals(gs_out)) {
            return 3;
        }
        if (str.equals(gs_span)) {
            return 4;
        }
        if (str.equals(gs_none)) {
            return 6;
        }
        return 5;
    }

    @Concealed
    public static int convertHorizontalAlignmentToInt(String str) {
        return PresUtils.convertHorizontalAlignmentToInt(str);
    }

    @Concealed
    protected String convertHorizontalAlignmentToString(int alignment) {
        return PresUtils.convertHorizontalAlignmentToString(alignment);
    }

    @Concealed
    public static int convertVerticalAlignmentToInt(String str) {
        int alignment = 3;
        if (str.equals(va_top)) {
            alignment = 1;
        } else if (str.equals(va_center)) {
            alignment = 0;
        } else if (str.equals(va_bottom)) {
            alignment = 3;
        }
        return alignment;
    }

    @Concealed
    public static String convertVerticalAlignmentToString(int alignment) {
        String str = va_bottom;
        switch (alignment) {
            case 1: {
                str = va_top;
                break;
            }
            case 0: {
                str = va_center;
                break;
            }
            case 3: {
                str = va_bottom;
            }
        }
        return str;
    }

    @Concealed
    public static String convertFillPatternToString(int pattern) {
        switch (pattern) {
            case 0: {
                return "FP_SM_DIAG_UP_LT";
            }
            case 1: {
                return "FP_SM_CHECK";
            }
            case 2: {
                return "FP_SM_DIAG_UP_RT";
            }
            case 3: {
                return "FP_SM_TRIANGLE_CHECK";
            }
            case 4: {
                return "FP_SM_CROSSHATCH";
            }
            case 5: {
                return "FP_SM_DIAMOND_CHECK";
            }
            case 6: {
                return "FP_LG_DIAG_UP_LT";
            }
            case 7: {
                return "FP_LG_CHECK";
            }
            case 8: {
                return "FP_LG_DIAG_UP_RT";
            }
            case 9: {
                return "FP_LG_TRIANGLE_CHECK";
            }
            case 10: {
                return "FP_LG_CROSSHATCH";
            }
            case 11: {
                return "FP_LG_DIAMOND_CHECK";
            }
        }
        return null;
    }

    @Concealed
    public static String convertGradientDirectionToString(int direction) {
        switch (direction) {
            case 1: {
                return gd_right;
            }
            case 3: {
                return gd_down;
            }
            case 5: {
                return gd_diagonal_45;
            }
            case 7: {
                return gd_diagonal_135;
            }
            case 9: {
                return gd_radial;
            }
        }
        return null;
    }

    @Concealed
    public static String convertLineStyleToString(int value) {
        String lstyle = ls_solid;
        switch (value) {
            case 0: {
                lstyle = ls_solid;
                break;
            }
            case 1: {
                lstyle = ls_dash;
                break;
            }
            case 2: {
                lstyle = ls_dotted;
                break;
            }
            case 3: {
                lstyle = ls_dash_dot;
            }
        }
        return lstyle;
    }

    @Concealed
    public static int convertLineStyleToInt(String lstyle) {
        if (lstyle.equals(ls_solid)) {
            return 0;
        }
        if (lstyle.equals(ls_dash)) {
            return 1;
        }
        if (lstyle.equals(ls_dotted)) {
            return 2;
        }
        if (lstyle.equals(ls_dash_dot)) {
            return 3;
        }
        return -1;
    }

    static {
        if (CONV_MAP == null) {
            CONV_MAP = new HashMap();
        }
        CONV_MAP.put(SHAPE_AUTOMATIC, -1);
        CONV_MAP.put(SHAPE_NONE, 0);
        CONV_MAP.put(SHAPE_CIRCLE, 2);
        CONV_MAP.put(SHAPE_DIAMOND, 3);
        CONV_MAP.put(SHAPE_HUMAN, 7);
        CONV_MAP.put(SHAPE_PLUS, 4);
        CONV_MAP.put(SHAPE_SQUARE, 1);
        CONV_MAP.put(SHAPE_TRIANGLE_DOWN, 5);
        CONV_MAP.put(SHAPE_TRIANGLE_UP, 6);
        if (REV_CONV_MAP == null) {
            REV_CONV_MAP = new HashMap();
        }
        REV_CONV_MAP.put(-1, SHAPE_AUTOMATIC);
        REV_CONV_MAP.put(0, SHAPE_NONE);
        REV_CONV_MAP.put(2, SHAPE_CIRCLE);
        REV_CONV_MAP.put(3, SHAPE_DIAMOND);
        REV_CONV_MAP.put(7, SHAPE_HUMAN);
        REV_CONV_MAP.put(4, SHAPE_PLUS);
        REV_CONV_MAP.put(1, SHAPE_SQUARE);
        REV_CONV_MAP.put(5, SHAPE_TRIANGLE_DOWN);
        REV_CONV_MAP.put(6, SHAPE_TRIANGLE_UP);
    }
}

