/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.awt.Color;
import java.awt.Font;
import java.util.BitSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.event.EventListenerList;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.ControllerListener;
import oracle.dss.dataView.Dataview;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.DataviewDefaultValues;
import oracle.dss.dataView.DataviewTitles;
import oracle.dss.dataView.FontList;
import oracle.dss.dataView.Footnote;
import oracle.dss.dataView.Model;
import oracle.dss.dataView.SelectEvent;
import oracle.dss.dataView.Subtitle;
import oracle.dss.dataView.Title;
import oracle.dss.dataView.TokenSubstitution;
import oracle.dss.dataView.TokenSubstitutionAdapter;
import oracle.dss.dataView.UIDataview;
import oracle.dss.util.DataSource;
import oracle.dss.util.DefaultErrorHandler;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.PagingControlAttributes;
import oracle.dss.util.PagingControlAttributesAdapter;
import oracle.dss.util.WaitData;

public abstract class UIDataviewAdapter
extends PagingControlAttributesAdapter
implements UIDataview,
DataviewCommon {
    private boolean _userOverrideMode = false;
    private boolean _styleOverrideMode = false;
    protected DataviewTitles m_dataViewTitle;
    protected DataviewTitles m_dataViewSubtitle;
    protected DataviewTitles m_dataViewFootnote;
    protected Locale m_locale = null;
    protected ComponentHandle m_selectedObject = null;
    protected EventListenerList m_listenerList = null;
    protected TokenSubstitution m_token = null;
    protected ErrorHandler m_errorHandler = new DefaultErrorHandler();
    protected boolean m_customColorsEnabled = false;

    public UIDataviewAdapter() {
        this.m_dataViewTitle = new TitleAdapter(DataviewDefaultValues.getBaseTitleText(), null);
        this.m_dataViewSubtitle = new SubtitleAdapter(DataviewDefaultValues.getBaseTitleText(), null);
        this.m_dataViewFootnote = new FootnoteAdapter(DataviewDefaultValues.getBaseTitleText(), null);
    }

    public UIDataviewAdapter(UIDataview view) {
        this();
        this.initFromDataview(view);
    }

    public void initFromDataview(UIDataview view) {
        super.initFromPagingControlAttributes((PagingControlAttributes)view);
        this.m_locale = view.getLocale();
        this.setCustomColorsEnabled(view.isCustomColorsEnabled());
        this.m_selectedObject = view.getSelectedObject();
        this.initTitleAttributes(view);
    }

    public void applyToDataview(UIDataview view) {
        super.applyToPagingControlAttributes((PagingControlAttributes)view);
        this.applyTitleAttributes(view);
        view.setCustomColorsEnabled(this.isCustomColorsEnabled());
    }

    @Override
    public Locale getLocale() {
        if (this.m_locale == null) {
            this.m_locale = Locale.getDefault();
        }
        return this.m_locale;
    }

    public void setLocale(Locale loc) {
        this.m_locale = loc;
    }

    @Override
    public ComponentHandle getSelectedObject() {
        return this.m_selectedObject;
    }

    @Override
    public DataviewTitles getDataviewTitle() {
        return this.m_dataViewTitle;
    }

    @Override
    public DataviewTitles getDataviewSubtitle() {
        return this.m_dataViewSubtitle;
    }

    @Override
    public DataviewTitles getDataviewFootnote() {
        return this.m_dataViewFootnote;
    }

    public boolean selectObject(ComponentHandle handle) {
        boolean bSuccess = false;
        if (this.fireComponentSelecting(this, handle)) {
            this.m_selectedObject = handle;
            this.fireComponentSelected(this, handle);
            bSuccess = true;
        }
        return bSuccess;
    }

    @Override
    public void addControllerListener(ControllerListener l) {
        if (this.m_listenerList == null) {
            this.m_listenerList = new EventListenerList();
        }
        this.m_listenerList.add(ControllerListener.class, l);
    }

    @Override
    public void removeControllerListener(ControllerListener l) {
        if (this.m_listenerList != null) {
            this.m_listenerList.remove(ControllerListener.class, l);
        }
    }

    @Override
    public abstract int getViewType();

    @Override
    public void setTokenSubstitution(TokenSubstitution token) {
        this.m_token = token;
    }

    @Override
    public TokenSubstitution getTokenSubstitution() {
        if (this.m_token == null) {
            this.m_token = new TokenSubstitutionAdapter(this);
        }
        return this.m_token;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.m_errorHandler;
    }

    @Override
    public FontList getFontList() {
        return null;
    }

    @Override
    public int getZoomFactor() {
        return 0;
    }

    @Override
    public Font scaleFont(Font f, int zoomFactor) {
        return null;
    }

    @Override
    public String getIntlString(String key) {
        return null;
    }

    @Override
    public String getIntlString(String key, ResourceBundle rBundle) {
        String strTemp;
        if (rBundle == null) {
            return key;
        }
        try {
            strTemp = rBundle.getString(key);
        }
        catch (MissingResourceException e) {
            this.getErrorHandler().log("missing resource \"" + key + "\" in " + rBundle.getClass().getName(), this.getClass().getName(), "getIntlString(String key, ResourceBundle rBundle)");
            return key;
        }
        return strTemp;
    }

    @Override
    public boolean isLayerMetaShortLabelSupported() {
        return true;
    }

    @Override
    public boolean isLayerMetaViewStyleSupported() {
        return true;
    }

    @Override
    public boolean isMetadataViewStyleSupported() {
        return true;
    }

    @Override
    public boolean isMetadataShortLabelSupported() {
        return true;
    }

    @Override
    public boolean isDataUnformattedSupported() {
        return true;
    }

    @Override
    public boolean isDataViewFormatSupported() {
        return true;
    }

    @Override
    public boolean isMemberMetadataLabelTypeSupported(String type) {
        return true;
    }

    @Override
    public boolean isLayerMetadataLabelTypeSupported(String type) {
        return true;
    }

    @Override
    public String getLayerMetadataLabelType(int edge) {
        return DataviewDefaultValues.getLayerMetadataLabelType(edge);
    }

    @Override
    public String getMemberMetadataLabelType(int edge) {
        return DataviewDefaultValues.getMemberMetadataLabelType(edge);
    }

    @Override
    public void repaint() {
    }

    @Override
    public void metadataStyleChanged() {
    }

    @Override
    public void dataStyleChanged() {
    }

    @Override
    public void dataFormatChanged() {
    }

    @Override
    public WaitData getWaitDataForRow(int row) {
        return null;
    }

    @Override
    public void setWaitDataForRow(int row, WaitData waitData) {
    }

    @Override
    public Model getModel() {
        return null;
    }

    public int convertComponentTypeToInteger(String type) {
        return 0;
    }

    public String convertComponentTypeToString(int type) {
        return null;
    }

    @Override
    public void setHTMLPagingControlAutosubmit(boolean autosubmit) {
    }

    @Override
    public boolean isHTMLPagingControlAutosubmit() {
        return true;
    }

    @Override
    public void setHTMLPagingControlWidth(int width) {
    }

    @Override
    public int getHTMLPagingControlWidth() {
        return -1;
    }

    protected void applyTitleAttributes(UIDataview toView) {
        toView.getDataviewTitle().setText(this.getDataviewTitle().getUnParseText());
        toView.getDataviewSubtitle().setText(this.getDataviewSubtitle().getUnParseText());
        toView.getDataviewFootnote().setText(this.getDataviewFootnote().getUnParseText());
        if (((TitleAdapter)this.getDataviewTitle()).isVisibleChanged()) {
            toView.getDataviewTitle().setVisible(this.getDataviewTitle().isVisible());
        }
        if (((SubtitleAdapter)this.getDataviewSubtitle()).isVisibleChanged()) {
            toView.getDataviewSubtitle().setVisible(this.getDataviewSubtitle().isVisible());
        }
        if (((FootnoteAdapter)this.getDataviewFootnote()).isVisibleChanged()) {
            toView.getDataviewFootnote().setVisible(this.getDataviewFootnote().isVisible());
        }
        if (((TitleAdapter)this.getDataviewTitle()).isForegroundChanged()) {
            toView.getDataviewTitle().setForeground(this.getDataviewTitle().getForeground());
        }
        if (((SubtitleAdapter)this.getDataviewSubtitle()).isForegroundChanged()) {
            toView.getDataviewSubtitle().setForeground(this.getDataviewSubtitle().getForeground());
        }
        if (((FootnoteAdapter)this.getDataviewFootnote()).isForegroundChanged()) {
            toView.getDataviewFootnote().setForeground(this.getDataviewFootnote().getForeground());
        }
        if (((TitleAdapter)this.getDataviewTitle()).isBackgroundChanged()) {
            toView.getDataviewTitle().setBackground(this.getDataviewTitle().getBackground());
        }
        if (((SubtitleAdapter)this.getDataviewSubtitle()).isBackgroundChanged()) {
            toView.getDataviewSubtitle().setBackground(this.getDataviewSubtitle().getBackground());
        }
        if (((FootnoteAdapter)this.getDataviewFootnote()).isBackgroundChanged()) {
            toView.getDataviewFootnote().setBackground(this.getDataviewFootnote().getBackground());
        }
        if (((TitleAdapter)this.getDataviewTitle()).isHorizontalAlignmentChanged()) {
            toView.getDataviewTitle().setHorizontalAlignment(this.getDataviewTitle().getHorizontalAlignment());
        }
        if (((SubtitleAdapter)this.getDataviewSubtitle()).isHorizontalAlignmentChanged()) {
            toView.getDataviewSubtitle().setHorizontalAlignment(this.getDataviewSubtitle().getHorizontalAlignment());
        }
        if (((FootnoteAdapter)this.getDataviewFootnote()).isHorizontalAlignmentChanged()) {
            toView.getDataviewFootnote().setHorizontalAlignment(this.getDataviewFootnote().getHorizontalAlignment());
        }
        if (((TitleAdapter)this.getDataviewTitle()).isFontChanged()) {
            toView.getDataviewTitle().setFont(this.getDataviewTitle().getFont());
        }
        if (((SubtitleAdapter)this.getDataviewSubtitle()).isFontChanged()) {
            toView.getDataviewSubtitle().setFont(this.getDataviewSubtitle().getFont());
        }
        if (((FootnoteAdapter)this.getDataviewFootnote()).isFontChanged()) {
            toView.getDataviewFootnote().setFont(this.getDataviewFootnote().getFont());
        }
        if (((TitleAdapter)this.getDataviewTitle()).isUnderlineChanged()) {
            toView.getDataviewTitle().setUnderline(this.getDataviewTitle().isUnderline());
        }
        if (((SubtitleAdapter)this.getDataviewSubtitle()).isUnderlineChanged()) {
            toView.getDataviewSubtitle().setUnderline(this.getDataviewSubtitle().isUnderline());
        }
        if (((FootnoteAdapter)this.getDataviewFootnote()).isUnderlineChanged()) {
            toView.getDataviewFootnote().setUnderline(this.getDataviewFootnote().isUnderline());
        }
    }

    protected void initTitleAttributes(UIDataview fromView) {
        this.getDataviewTitle().setText(fromView.getDataviewTitle().getUnParseText());
        this.getDataviewSubtitle().setText(fromView.getDataviewSubtitle().getUnParseText());
        this.getDataviewFootnote().setText(fromView.getDataviewFootnote().getUnParseText());
        this.getDataviewTitle().setVisible(fromView.getDataviewTitle().isVisible());
        ((TitleAdapter)this.getDataviewTitle()).setVisibleChanged(false);
        this.getDataviewSubtitle().setVisible(fromView.getDataviewSubtitle().isVisible());
        ((SubtitleAdapter)this.getDataviewSubtitle()).setVisibleChanged(false);
        this.getDataviewFootnote().setVisible(fromView.getDataviewFootnote().isVisible());
        ((FootnoteAdapter)this.getDataviewFootnote()).setVisibleChanged(false);
        this.getDataviewTitle().setForeground(fromView.getDataviewTitle().getForeground());
        ((TitleAdapter)this.getDataviewTitle()).setForegroundChanged(false);
        this.getDataviewSubtitle().setForeground(fromView.getDataviewSubtitle().getForeground());
        ((SubtitleAdapter)this.getDataviewSubtitle()).setForegroundChanged(false);
        this.getDataviewFootnote().setForeground(fromView.getDataviewFootnote().getForeground());
        ((FootnoteAdapter)this.getDataviewFootnote()).setForegroundChanged(false);
        this.getDataviewTitle().setBackground(fromView.getDataviewTitle().getBackground());
        ((TitleAdapter)this.getDataviewTitle()).setBackgroundChanged(false);
        this.getDataviewSubtitle().setBackground(fromView.getDataviewSubtitle().getBackground());
        ((SubtitleAdapter)this.getDataviewSubtitle()).setBackgroundChanged(false);
        this.getDataviewFootnote().setBackground(fromView.getDataviewFootnote().getBackground());
        ((FootnoteAdapter)this.getDataviewFootnote()).setBackgroundChanged(false);
        this.getDataviewTitle().setHorizontalAlignment(fromView.getDataviewTitle().getHorizontalAlignment());
        ((TitleAdapter)this.getDataviewTitle()).setHorizontalAlignmentChanged(false);
        this.getDataviewSubtitle().setHorizontalAlignment(fromView.getDataviewSubtitle().getHorizontalAlignment());
        ((SubtitleAdapter)this.getDataviewSubtitle()).setHorizontalAlignmentChanged(false);
        this.getDataviewFootnote().setHorizontalAlignment(fromView.getDataviewFootnote().getHorizontalAlignment());
        ((FootnoteAdapter)this.getDataviewFootnote()).setHorizontalAlignmentChanged(false);
        this.getDataviewTitle().setFont(fromView.getDataviewTitle().getFont());
        ((TitleAdapter)this.getDataviewTitle()).setFontChanged(false);
        this.getDataviewSubtitle().setFont(fromView.getDataviewSubtitle().getFont());
        ((SubtitleAdapter)this.getDataviewSubtitle()).setFontChanged(false);
        this.getDataviewFootnote().setFont(fromView.getDataviewFootnote().getFont());
        ((FootnoteAdapter)this.getDataviewFootnote()).setFontChanged(false);
        this.getDataviewTitle().setUnderline(fromView.getDataviewTitle().isUnderline());
        ((TitleAdapter)this.getDataviewTitle()).setUnderlineChanged(false);
        this.getDataviewSubtitle().setUnderline(fromView.getDataviewSubtitle().isUnderline());
        ((SubtitleAdapter)this.getDataviewSubtitle()).setUnderlineChanged(false);
        this.getDataviewFootnote().setUnderline(fromView.getDataviewFootnote().isUnderline());
        ((FootnoteAdapter)this.getDataviewFootnote()).setUnderlineChanged(false);
    }

    protected boolean fireComponentSelecting(Object source, ComponentHandle id) {
        boolean bNotConsumed = true;
        if (this.m_listenerList != null) {
            SelectEvent e = new SelectEvent(source, 0, id);
            Object[] listeners = this.m_listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ControllerListener.class) continue;
                ((ControllerListener)listeners[i + 1]).componentSelecting(e);
                if (!e.isConsumed()) continue;
                bNotConsumed = false;
            }
        }
        return bNotConsumed;
    }

    protected void fireComponentSelected(Object source, ComponentHandle id) {
        if (this.m_listenerList != null) {
            SelectEvent e = new SelectEvent(source, 1, id);
            Object[] listeners = this.m_listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ControllerListener.class) continue;
                ((ControllerListener)listeners[i + 1]).componentSelected(e);
            }
        }
    }

    @Override
    public void setDataSource(DataSource ds) {
    }

    @Override
    public DataSource getDataSource() {
        return null;
    }

    protected void cleanUp() {
        this.m_dataViewTitle = null;
        this.m_dataViewSubtitle = null;
        this.m_dataViewFootnote = null;
        this.m_locale = null;
        this.m_selectedObject = null;
        this.m_token = null;
        this.m_errorHandler = null;
        if (this.m_listenerList != null) {
            Object[] listeners = this.m_listenerList.getListenerList();
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i] = null;
            }
        }
        this.m_listenerList = null;
    }

    @Override
    public BitSet createPropertyOverrideFlags(int maxID) {
        return new BitSet(maxID);
    }

    @Override
    public void setPropertyOverrideFlags(int attrID, BitSet userFlags, BitSet styleFlags) {
        if (userFlags != null && attrID >= 0 && attrID < userFlags.size()) {
            if (this.isUserOverrideMode()) {
                userFlags.set(attrID);
            }
            if (this.isStyleOverrideMode()) {
                styleFlags.set(attrID);
            }
        }
    }

    @Override
    public boolean isPropertyOverrideFlag(int attrID, BitSet overrideFlags) {
        if (attrID >= 0 && attrID < overrideFlags.size()) {
            return overrideFlags.get(attrID);
        }
        return false;
    }

    public static void clearPropertyOverrideFlag(int attrID, BitSet overrideFlags) {
        if (attrID >= 0 && attrID < overrideFlags.size()) {
            overrideFlags.clear(attrID);
        }
    }

    @Override
    public void setCustomColorsEnabled(boolean enabled) {
        this.m_customColorsEnabled = enabled;
    }

    @Override
    public boolean isCustomColorsEnabled() {
        return this.m_customColorsEnabled;
    }

    protected void setStyleOverrideMode(boolean flag) {
        this._styleOverrideMode = flag;
    }

    protected boolean isStyleOverrideMode() {
        return this._styleOverrideMode;
    }

    protected void setUserOverrideMode(boolean flag) {
        this._userOverrideMode = flag;
    }

    protected boolean isUserOverrideMode() {
        return this._userOverrideMode;
    }

    private class TitleAdapter
    extends Title {
        private static final long serialVersionUID = 1L;
        private boolean m_bBackgroundChanged;
        private boolean m_bForegroundChanged;
        private boolean m_bVisibleChanged;
        private boolean m_bUnderlineChanged;
        private boolean m_bFontChanged;
        private boolean m_bHorizontalAlignmentChanged;

        public TitleAdapter(String t, Dataview dataview) {
            super(t, dataview);
        }

        @Override
        public int getID() {
            return 6;
        }

        @Override
        public String getComponentName() {
            return "DataviewTitle";
        }

        @Override
        public void setVisible(boolean visible) {
            super.setVisible(visible);
            this.setVisibleChanged(true);
        }

        public void setVisibleChanged(boolean b) {
            this.m_bVisibleChanged = b;
        }

        public boolean isVisibleChanged() {
            return this.m_bVisibleChanged;
        }

        @Override
        public void setBackground(Color color) {
            super.setBackground(color);
            this.setBackgroundChanged(true);
        }

        public void setBackgroundChanged(boolean b) {
            this.m_bBackgroundChanged = b;
        }

        public boolean isBackgroundChanged() {
            return this.m_bBackgroundChanged;
        }

        @Override
        public void setForeground(Color color) {
            super.setForeground(color);
            this.setForegroundChanged(true);
        }

        public void setForegroundChanged(boolean b) {
            this.m_bForegroundChanged = b;
        }

        public boolean isForegroundChanged() {
            return this.m_bForegroundChanged;
        }

        @Override
        public void setFont(Font f) {
            super.setFont(f);
            this.setFontChanged(true);
        }

        public void setFontChanged(boolean b) {
            this.m_bFontChanged = b;
        }

        public boolean isFontChanged() {
            return this.m_bFontChanged;
        }

        @Override
        public void setHorizontalAlignment(int align) {
            super.setHorizontalAlignment(align);
            this.setHorizontalAlignmentChanged(true);
        }

        public void setHorizontalAlignmentChanged(boolean b) {
            this.m_bHorizontalAlignmentChanged = b;
        }

        public boolean isHorizontalAlignmentChanged() {
            return this.m_bHorizontalAlignmentChanged;
        }

        @Override
        public void setUnderline(boolean underline) {
            super.setUnderline(underline);
            this.setUnderlineChanged(true);
        }

        public void setUnderlineChanged(boolean b) {
            this.m_bUnderlineChanged = b;
        }

        public boolean isUnderlineChanged() {
            return this.m_bUnderlineChanged;
        }
    }

    private class SubtitleAdapter
    extends Subtitle {
        private static final long serialVersionUID = 1L;
        private boolean m_bBackgroundChanged;
        private boolean m_bForegroundChanged;
        private boolean m_bVisibleChanged;
        private boolean m_bUnderlineChanged;
        private boolean m_bFontChanged;
        private boolean m_bHorizontalAlignmentChanged;

        public SubtitleAdapter(String t, Dataview dataview) {
            super(t, dataview);
        }

        @Override
        public int getID() {
            return 7;
        }

        @Override
        public String getComponentName() {
            return "DataviewSubtitle";
        }

        @Override
        public void setVisible(boolean visible) {
            super.setVisible(visible);
            this.setVisibleChanged(true);
        }

        public void setVisibleChanged(boolean b) {
            this.m_bVisibleChanged = b;
        }

        public boolean isVisibleChanged() {
            return this.m_bVisibleChanged;
        }

        @Override
        public void setBackground(Color color) {
            super.setBackground(color);
            this.setBackgroundChanged(true);
        }

        public void setBackgroundChanged(boolean b) {
            this.m_bBackgroundChanged = b;
        }

        public boolean isBackgroundChanged() {
            return this.m_bBackgroundChanged;
        }

        @Override
        public void setForeground(Color color) {
            super.setForeground(color);
            this.setForegroundChanged(true);
        }

        public void setForegroundChanged(boolean b) {
            this.m_bForegroundChanged = b;
        }

        public boolean isForegroundChanged() {
            return this.m_bForegroundChanged;
        }

        @Override
        public void setFont(Font f) {
            super.setFont(f);
            this.setFontChanged(true);
        }

        public void setFontChanged(boolean b) {
            this.m_bFontChanged = b;
        }

        public boolean isFontChanged() {
            return this.m_bFontChanged;
        }

        @Override
        public void setHorizontalAlignment(int align) {
            super.setHorizontalAlignment(align);
            this.setHorizontalAlignmentChanged(true);
        }

        public void setHorizontalAlignmentChanged(boolean b) {
            this.m_bHorizontalAlignmentChanged = b;
        }

        public boolean isHorizontalAlignmentChanged() {
            return this.m_bHorizontalAlignmentChanged;
        }

        @Override
        public void setUnderline(boolean underline) {
            super.setUnderline(underline);
            this.setUnderlineChanged(true);
        }

        public void setUnderlineChanged(boolean b) {
            this.m_bUnderlineChanged = b;
        }

        public boolean isUnderlineChanged() {
            return this.m_bUnderlineChanged;
        }
    }

    private class FootnoteAdapter
    extends Footnote {
        private static final long serialVersionUID = 1L;
        private boolean m_bBackgroundChanged;
        private boolean m_bForegroundChanged;
        private boolean m_bVisibleChanged;
        private boolean m_bUnderlineChanged;
        private boolean m_bFontChanged;
        private boolean m_bHorizontalAlignmentChanged;

        public FootnoteAdapter(String t, Dataview dataview) {
            super(t, dataview);
        }

        @Override
        public int getID() {
            return 8;
        }

        @Override
        public String getComponentName() {
            return "DataviewFootnote";
        }

        @Override
        public void setVisible(boolean visible) {
            super.setVisible(visible);
            this.setVisibleChanged(true);
        }

        public void setVisibleChanged(boolean b) {
            this.m_bVisibleChanged = b;
        }

        public boolean isVisibleChanged() {
            return this.m_bVisibleChanged;
        }

        @Override
        public void setBackground(Color color) {
            super.setBackground(color);
            this.setBackgroundChanged(true);
        }

        public void setBackgroundChanged(boolean b) {
            this.m_bBackgroundChanged = b;
        }

        public boolean isBackgroundChanged() {
            return this.m_bBackgroundChanged;
        }

        @Override
        public void setForeground(Color color) {
            super.setForeground(color);
            this.setForegroundChanged(true);
        }

        public void setForegroundChanged(boolean b) {
            this.m_bForegroundChanged = b;
        }

        public boolean isForegroundChanged() {
            return this.m_bForegroundChanged;
        }

        @Override
        public void setFont(Font f) {
            super.setFont(f);
            this.setFontChanged(true);
        }

        public void setFontChanged(boolean b) {
            this.m_bFontChanged = b;
        }

        public boolean isFontChanged() {
            return this.m_bFontChanged;
        }

        @Override
        public void setHorizontalAlignment(int align) {
            super.setHorizontalAlignment(align);
            this.setHorizontalAlignmentChanged(true);
        }

        public void setHorizontalAlignmentChanged(boolean b) {
            this.m_bHorizontalAlignmentChanged = b;
        }

        public boolean isHorizontalAlignmentChanged() {
            return this.m_bHorizontalAlignmentChanged;
        }

        @Override
        public void setUnderline(boolean underline) {
            super.setUnderline(underline);
            this.setUnderlineChanged(true);
        }

        public void setUnderlineChanged(boolean b) {
            this.m_bUnderlineChanged = b;
        }

        public boolean isUnderlineChanged() {
            return this.m_bUnderlineChanged;
        }
    }
}

