/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import oracle.dss.dataView.Attributes;
import oracle.dss.dataView.DataComponentHandle;

public class ScatterDataComponentHandle
extends DataComponentHandle {
    private static final long serialVersionUID = 1L;

    public ScatterDataComponentHandle(int id, String name, Object comp, int r, int c, int group, int series) {
        super(id, name, comp, r, c, group, series);
    }

    public Object getXValue(String attrName) {
        if (this.m_dataAccess != null) {
            try {
                return this.m_dataAccess.getValue(this.getRow(), this.getColumn(), attrName);
            }
            catch (Exception exp) {
                return null;
            }
        }
        return null;
    }

    public Object getYValue(String attrName) {
        if (this.m_dataAccess != null) {
            try {
                if (this.m_seriesAreRows) {
                    return this.m_dataAccess.getValue(this.getRow(), this.getColumn() + 1, attrName);
                }
                return this.m_dataAccess.getValue(this.getRow() + 1, this.getColumn(), attrName);
            }
            catch (Exception exp) {
                return null;
            }
        }
        return null;
    }

    public Attributes[] getXAttributes() {
        int edge = 1;
        int slice = this.getRow();
        if (this.m_seriesAreRows) {
            edge = 0;
            slice = this.getColumn();
        }
        try {
            int layers = this.m_dataAccess.getLayerCount(edge);
            Attributes[] attrs = new Attributes[layers];
            for (int i = 0; i < layers; ++i) {
                attrs[i] = new Attributes(this.m_dataAccess, i, slice, edge);
            }
            return attrs;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Attributes[] getYAttributes() {
        int edge = 1;
        int slice = this.getRow() + 1;
        if (this.m_seriesAreRows) {
            edge = 0;
            slice = this.getColumn() + 1;
        }
        try {
            int layers = this.m_dataAccess.getLayerCount(edge);
            Attributes[] attrs = new Attributes[layers];
            for (int i = 0; i < layers; ++i) {
                attrs[i] = new Attributes(this.m_dataAccess, i, slice, edge);
            }
            return attrs;
        }
        catch (Exception e) {
            return null;
        }
    }
}

