/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.util.ArrayList;
import java.util.List;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.DataAccess;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerMetadataMap;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.MemberContext;
import oracle.dss.util.QDR;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.Utility;

public class DimensionMetadata
implements MemberContext {
    protected static final int MAX_MEMBER_COUNT = 100;
    protected static final String dimNameType = "layerName";
    public static final int ID_INDEX = 0;
    public static final int LABEL_INDEX = 1;
    public static final int DATATYPE_INDEX = 2;
    protected List m_memberList = null;
    protected List m_memberLabels = null;
    protected int m_edge = -1;
    protected int m_layer = -1;
    protected int m_dimIndex = -1;
    protected String m_dimID;
    protected String m_dimLabel;
    protected String m_dimPluralLabel;
    protected boolean m_isMeasure = false;
    protected DataviewCommon m_dataView = null;
    protected DataAccess m_dataAccess = null;

    public static List createDimensionMemberList(DataviewCommon dataView) {
        ArrayList<DimensionMetadata> dimensionList = new ArrayList<DimensionMetadata>();
        DataAccess dataAccess = dataView.getModel().getDataAccess();
        try {
            String measureDim = null;
            QDR qdr = dataAccess.getValueQDR(0, 0, 1);
            if (qdr != null) {
                measureDim = qdr.getMeasureDim();
            }
            if (measureDim != null && measureDim.length() == 0) {
                measureDim = null;
            }
            int dimIndex = 0;
            for (int edge = 0; edge < dataAccess.getEdgeCount(); ++edge) {
                int layerCount = dataAccess.getLayerCount(edge);
                for (int layer = 0; layer < layerCount; ++layer) {
                    Object dimObj = dataAccess.getLayerMetadata(edge, layer, dimNameType);
                    String dimID = null;
                    if (dimObj != null) {
                        dimID = dimObj.toString();
                    }
                    DimensionMetadata dimData = new DimensionMetadata(dataView, dimID, dimIndex++, edge, layer);
                    if (measureDim != null && measureDim.equals(dimID)) {
                        dimData.setMeasure(true);
                    }
                    dimensionList.add(dimData);
                }
            }
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
        }
        catch (LayerOutOfRangeException layerOutOfRangeException) {
        }
        catch (ColumnOutOfRangeException columnOutOfRangeException) {
        }
        catch (RowOutOfRangeException rowOutOfRangeException) {
            // empty catch block
        }
        return dimensionList;
    }

    public static String getLayerLabel(DataAccess dataAccess, int edge, int layer, String dimLabelType) {
        String label = null;
        try {
            Object dimVal = dataAccess.getLayerMetadata(edge, layer, dimLabelType);
            if (dimVal != null) {
                label = dimVal.toString();
            }
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
        }
        catch (LayerOutOfRangeException layerOutOfRangeException) {
            // empty catch block
        }
        return label;
    }

    public static List getDimensionMemberList(DataviewCommon dataView, String dimID, int edge, int layer) {
        if (dimID == null) {
            return new ArrayList();
        }
        List<Object[]> members = null;
        DataAccess dataAccess = dataView.getModel().getDataAccess();
        String[] types = new String[]{"value", dataView.getMemberMetadataLabelType(edge), "dataType"};
        try {
            members = dataAccess.getUniqueMemberMetadata(dimID, types, 0, 100);
            if (members == null) {
                if (edge == 1 && dataView.getModel().getDataDirector().isOutline()) {
                    members = DimensionMetadata.getOutlineMemberList(dataAccess, edge, layer, types);
                } else {
                    members = new ArrayList();
                    int maxMemberCount = 0;
                    int endslice = dataAccess.getEdgeExtent(edge);
                    for (int startslice = 0; startslice != endslice; startslice += dataAccess.getMemberExtent(edge, layer, startslice)) {
                        if (dataAccess.getMemberStartLayer(edge, layer, startslice) != layer) continue;
                        Object nameValue = dataAccess.getMemberMetadata(edge, layer, startslice, types[0]);
                        Object labelValue = dataAccess.getMemberMetadata(edge, layer, startslice, types[1]);
                        Object datatype = dataAccess.getMemberMetadata(edge, layer, startslice, types[2]);
                        if (nameValue == null || labelValue == null || DimensionMetadata.containsMember(members, nameValue, 0)) continue;
                        if (maxMemberCount >= 100) {
                            return members;
                        }
                        members.add(new Object[]{nameValue, labelValue, datatype});
                        ++maxMemberCount;
                    }
                }
            }
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
        }
        catch (LayerOutOfRangeException layerOutOfRangeException) {
        }
        catch (SliceOutOfRangeException sliceOutOfRangeException) {
            // empty catch block
        }
        return members;
    }

    protected static List getOutlineMemberList(DataAccess dataAccess, int edge, int logicalLayer, String[] types) {
        ArrayList<Object[]> members = new ArrayList<Object[]>();
        try {
            int extent = dataAccess.getEdgeExtent(edge);
            int maxMemberCount = 0;
            for (int slice = 0; slice < extent; ++slice) {
                int span;
                int layer = dataAccess.getSliceOutlineLayer(edge, slice);
                if (layer != logicalLayer || (span = dataAccess.getMemberExtent(edge, layer, slice)) > 1 && dataAccess.getMemberStartSlice(edge, layer, slice) != slice) continue;
                Object nameValue = dataAccess.getMemberMetadata(edge, layer, slice, types[0]);
                Object labelValue = dataAccess.getMemberMetadata(edge, layer, slice, types[1]);
                Object datatype = dataAccess.getMemberMetadata(edge, layer, slice, types[2]);
                if (nameValue == null || labelValue == null || DimensionMetadata.containsMember(members, nameValue, 0)) continue;
                if (maxMemberCount >= 100) {
                    return members;
                }
                members.add(new Object[]{nameValue, labelValue, datatype});
                ++maxMemberCount;
            }
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
        }
        catch (LayerOutOfRangeException layerOutOfRangeException) {
        }
        catch (SliceOutOfRangeException sliceOutOfRangeException) {
            // empty catch block
        }
        return members;
    }

    private static boolean containsMember(List list, Object id, int index) {
        if (list == null) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object[] member = (Object[])list.get(i);
            if (!id.equals(member[index])) continue;
            return true;
        }
        return false;
    }

    public DimensionMetadata(DataviewCommon dataView, String dimID, int dimIndex, int edge, int layer) {
        this.m_dataView = dataView;
        this.m_dimID = dimID;
        this.m_edge = edge;
        this.m_layer = layer;
        this.m_dimIndex = dimIndex;
        this.m_dataAccess = dataView.getModel().getDataAccess();
    }

    public int getEdge() {
        return this.m_edge;
    }

    public String getDimID() {
        return this.m_dimID;
    }

    public String getDimLabel() {
        if (this.m_dimLabel == null) {
            String dimLabelType = this.m_dataView.getLayerMetadataLabelType(this.m_edge);
            this.m_dimLabel = DimensionMetadata.getLayerLabel(this.m_dataAccess, this.m_edge, this.m_layer, dimLabelType);
        }
        if (this.m_dimLabel == null || this.m_dimLabel.length() == 0) {
            return this.m_dimID;
        }
        return this.m_dimLabel;
    }

    public String getDimPluralLabel() {
        if (this.m_dimPluralLabel == null) {
            String dimLabelType = this.m_dataView.getLayerMetadataLabelType(this.m_edge);
            String plural = null;
            plural = dimLabelType.equals("dimShortName") ? "dimShortPluralName" : "dimLongPluralName";
            LayerMetadataMap map = this.m_dataView.getModel().getDataDirector().getSupportedLayerMetadataMap();
            if (map != null && plural != null && map.containsType(plural) != -1) {
                this.m_dimPluralLabel = DimensionMetadata.getLayerLabel(this.m_dataAccess, this.m_edge, this.m_layer, plural);
            }
            if (this.m_dimPluralLabel == null || this.m_dimPluralLabel.length() == 0) {
                this.m_dimPluralLabel = DimensionMetadata.getLayerLabel(this.m_dataAccess, this.m_edge, this.m_layer, dimLabelType);
            }
            if (this.m_dimPluralLabel == null || this.m_dimPluralLabel.length() == 0) {
                this.m_dimPluralLabel = this.m_dimID;
            }
        }
        return this.m_dimPluralLabel;
    }

    public int getDimIndex() {
        return this.m_dimIndex;
    }

    public List getMemberLabels() {
        if (this.m_memberLabels == null) {
            this.m_memberLabels = new ArrayList();
            List list = this.getMemberList();
            for (int i = 0; i < list.size(); ++i) {
                Object[] member = (Object[])list.get(i);
                if (member == null || member[1] == null) continue;
                this.m_memberLabels.add(member[1].toString());
            }
        }
        return this.m_memberLabels;
    }

    public List getMemberList() {
        if (this.m_memberList == null) {
            this.m_memberList = DimensionMetadata.getDimensionMemberList(this.m_dataView, this.m_dimID, this.m_edge, this.m_layer);
        }
        return this.m_memberList;
    }

    public String getMemberID(String label) {
        if (label == null) {
            return null;
        }
        int size = this.getMemberList().size();
        for (int i = 0; i < size; ++i) {
            String iLabel;
            Object[] member = (Object[])this.m_memberList.get(i);
            if (member == null || member[1] == null || !label.equals(iLabel = member[1].toString())) continue;
            return member[0].toString();
        }
        return null;
    }

    public int getMemberLabelIndex(String memberLabel) {
        int size = this.getMemberList().size();
        for (int i = 0; i < size; ++i) {
            String iLabel;
            Object[] member = (Object[])this.m_memberList.get(i);
            if (member == null || member[1] == null || !memberLabel.equals(iLabel = member[1].toString())) continue;
            return i;
        }
        return -1;
    }

    public int getMemberIndex(String memberID) {
        int size = this.getMemberList().size();
        for (int i = 0; i < size; ++i) {
            Object[] member = (Object[])this.m_memberList.get(i);
            String iLabel = member[0].toString();
            if (!memberID.equals(iLabel)) continue;
            return i;
        }
        this.m_memberList.add(new Object[]{memberID, memberID, null});
        return this.m_memberList.size() - 1;
    }

    public String getMemberID(int index) {
        Object[] member;
        if (index >= 0 && index < this.getMemberList().size() && (member = (Object[])this.m_memberList.get(index))[0] != null) {
            return member[0].toString();
        }
        return null;
    }

    public int getMemberCount() {
        return this.getMemberList().size();
    }

    public String getMemberLabel(int index) {
        Object[] member = (Object[])this.getMemberList().get(index);
        if (member != null && member[1] != null) {
            return member[1].toString();
        }
        return null;
    }

    public String getMemberLabel(String memberID) {
        if (memberID == null) {
            return null;
        }
        int size = this.getMemberList().size();
        for (int i = 0; i < size; ++i) {
            String memID;
            Object[] member = (Object[])this.m_memberList.get(i);
            if (member == null || member[0] == null || !memberID.equals(memID = member[0].toString())) continue;
            if (member[1] != null) {
                return member[1].toString();
            }
            return null;
        }
        return null;
    }

    public String getMemberDatatype(String memberID) {
        if (memberID == null) {
            return null;
        }
        int size = this.getMemberList().size();
        for (int i = 0; i < size; ++i) {
            String memID;
            Object[] member = (Object[])this.m_memberList.get(i);
            if (member == null || member[0] == null || !memberID.equals(memID = member[0].toString())) continue;
            if (member[2] == null) {
                return null;
            }
            return this.toSimpleDatatype(member[2].toString());
        }
        return null;
    }

    public String getMemberDatatype(int index) {
        Object[] member;
        if (index >= 0 && index < this.getMemberList().size() && (member = (Object[])this.m_memberList.get(index)) != null && member[2] != null) {
            return this.toSimpleDatatype(member[2].toString());
        }
        return null;
    }

    public String toSimpleDatatype(String datatype) {
        if (datatype == null) {
            return null;
        }
        if (datatype.equals("Short") || datatype.equals("Integer") || datatype.equals("Long") || datatype.equals("Float")) {
            return "Double";
        }
        return datatype;
    }

    public boolean equals(MemberContext member) {
        return Utility.compareObj((Object)member.getDimID(), (Object)this.getDimID());
    }

    public void setMeasure(boolean isMeasure) {
        this.m_isMeasure = isMeasure;
    }

    public boolean isMeasure() {
        return this.m_isMeasure;
    }
}

