/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import oracle.bali.ewt.button.ButtonBar;
import oracle.ide.IdeUIManager;
import oracle.ide.net.URLFactory;
import oracle.ide.util.ResourceUtils;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.ideimpl.webupdate.CheckForUpdatesPreferences;
import oracle.ideimpl.webupdate.CheckUpdatesRunnable;
import oracle.ideimpl.webupdate.LocalUpdateBundle;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateCenter;
import oracle.ideimpl.webupdate.UpdateCenterMessage;
import oracle.ideimpl.webupdate.UpdateCenterMonitor;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.WebUpdateAddin;
import oracle.ideimpl.webupdate.wizard.UpdateInfoPanel;
import oracle.ideimpl.webupdate.wizard.UpdateWizardModel;
import oracle.ideimpl.webupdate.wizard.UpdateWizardPage;
import oracle.javatools.controls.HyperlinkButton;
import oracle.javatools.controls.SimpleListModel;
import oracle.javatools.controls.nicelist.NiceList;
import oracle.javatools.controls.nicelist.NiceListActionEvent;
import oracle.javatools.controls.nicelist.NiceListActionListener;
import oracle.javatools.controls.nicelist.NiceListRenderer;
import oracle.javatools.data.ListStructure;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.util.ListUtil;
import org.xml.sax.SAXParseException;

public class UpdatesPanel
extends JPanel {
    private final GridBagLayout _layout = new GridBagLayout();
    private final JLabel _updatesLabel = new JLabel();
    private final JCheckBox _onlyUpgrades = new JCheckBox();
    private final NiceList _updatesList = new NiceList();
    private final SimpleListModel<UpdateItem> _allListModel = new SimpleListModel();
    private final Map _itemsByUpdateInfo = new HashMap();
    private final JPanel _progressPanel = new JPanel();
    private final JButton _progressStop = new JButton();
    private final JProgressBar _progressBar = new JProgressBar();
    private final JLabel _progressBarStatus = new JLabel();
    private final HyperlinkButton _statusLink = new HyperlinkButton();
    private final ButtonBar _selectButtonBar = new ButtonBar();
    private final JButton _selectAllButton = new JButton();
    private final JButton _deselectAllButton = new JButton();
    private final SearchField _searchField = new SearchField();
    private transient CheckUpdatesRunnable _checkRunnable;
    private transient Thread _checkRunnableThread;
    private ActionListener _statusLinkListener;
    private boolean _stoppedCheck = false;
    private boolean _checkedForUpdates = false;
    private final transient ListDataListener _listDataListener = new ListDataListener(){

        @Override
        public void intervalAdded(ListDataEvent e) {
            UpdatesPanel.this.updateSelectAllButtons();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            UpdatesPanel.this.updateSelectAllButtons();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            UpdatesPanel.this.updateSelectAllButtons();
        }
    };

    public UpdatesPanel() {
        this.resControls();
        this.layoutControls();
        this.installListeners();
        NiceListRenderer renderer = new NiceListRenderer(){

            public String getTitle(Object update) {
                UpdateItem updateItem = (UpdateItem)update;
                if (updateItem.getUpdate().getType() == UpdateInfo.Type.EXTENSION) {
                    return updateItem.getUpdate().getName() + " " + updateItem.getUpdate().getVersion().toString();
                }
                return updateItem.getUpdate().getName();
            }

            public String getDescription(Object update) {
                if (update == null) {
                    return "";
                }
                UpdateInfo updateInfo = ((UpdateItem)update).getUpdate();
                if (updateInfo == null) {
                    return "";
                }
                String desc = updateInfo.getDescription();
                if (desc == null) {
                    return "";
                }
                return desc.trim();
            }

            public String getSecondDescription(Object update) {
                UpdateInfo info = ((UpdateItem)update).getUpdate();
                if (info != null) {
                    if (info.getType() == UpdateInfo.Type.MESSAGE) {
                        return " ";
                    }
                    if (info.getSourceCenter() != null) {
                        return UpdateArb.format(184, info.getSourceCenter().getName());
                    }
                    return "Local Update";
                }
                return " ";
            }

            public boolean isItemSelected(Object update) {
                return ((UpdateItem)update).isSelected();
            }

            public String getHyperLinkText(Object update) {
                UpdateItem item = (UpdateItem)update;
                if (item.getUpdate().getType() == UpdateInfo.Type.MESSAGE) {
                    return ((UpdateCenterMessage)item.getUpdate()).getLinkText();
                }
                return UpdateArb.getString(127);
            }

            public String getSecondaryHyperLinkText(Object update) {
                UpdateItem item = (UpdateItem)update;
                if (item.getUpdate().getType() == UpdateInfo.Type.MESSAGE) {
                    return "Hide";
                }
                return "";
            }

            public Icon getIndicator(Object update) {
                UpdateItem updateItem = (UpdateItem)update;
                if (updateItem.getUpdate().getType() == UpdateInfo.Type.PATCH) {
                    return UpdateArb.getIcon(196);
                }
                if (updateItem.getUpdate().getType() == UpdateInfo.Type.MESSAGE) {
                    return OracleIcons.getIcon((String)"info.png");
                }
                if (updateItem.getUpdate().isNew()) {
                    return UpdateArb.getIcon(140);
                }
                return OracleIcons.getIcon((String)"update2.png");
            }

            public boolean isCheckable(Object update) {
                return ((UpdateItem)update).getUpdate().getType() != UpdateInfo.Type.MESSAGE;
            }
        };
        renderer.setGradientColor(IdeUIManager.getActiveTitleGradientLightColor(), IdeUIManager.getActiveTitleGradientDarkColor());
        renderer.setTwoLineDescription(true);
        this._updatesList.setCellRenderer((ListCellRenderer)renderer);
        this._updatesList.setModel(this._allListModel);
        this._updatesList.setSelectionMode(0);
        this._updatesList.setFireCheckboxActionOnDoubleClick(true);
        this._onlyUpgrades.setSelected(false);
        this._progressBar.setStringPainted(false);
    }

    boolean isCheckedForUpdates() {
        return this._checkedForUpdates;
    }

    boolean hasUpdates() {
        return this._allListModel.getSize() != 0;
    }

    private synchronized void setStopped(boolean stopped) {
        this._stoppedCheck = stopped;
        this._progressStop.setEnabled(!stopped);
    }

    private synchronized boolean isStopped() {
        return this._stoppedCheck;
    }

    private SimpleListModel getListModel() {
        return (SimpleListModel)this._updatesList.getModel();
    }

    private void installListeners() {
        Listener l = new Listener();
        this._updatesList.addListActionListener((NiceListActionListener)l);
        this._onlyUpgrades.addActionListener(l);
        this._selectAllButton.addActionListener(l);
        this._deselectAllButton.addActionListener(l);
        this._progressStop.addActionListener(l);
        this._allListModel.addListDataListener(this._listDataListener);
        this._searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent se) {
                UpdatesPanel.this.filterList(se.getSearchText().toLowerCase());
            }

            public void searchCategoryChanged(SearchEvent se) {
            }
        });
    }

    private void resControls() {
        this._statusLink.setText(UpdateArb.getString(127));
        ResourceUtils.resLabel((JLabel)this._updatesLabel, (Component)this._updatesList, (String)UpdateArb.getString(12));
        ResourceUtils.resButton((AbstractButton)this._onlyUpgrades, (String)UpdateArb.getString(13));
        ResourceUtils.resButton((AbstractButton)this._progressStop, (String)UpdateArb.getString(14));
        ResourceUtils.resButton((AbstractButton)this._selectAllButton, (String)UpdateArb.getString(19));
        ResourceUtils.resButton((AbstractButton)this._deselectAllButton, (String)UpdateArb.getString(20));
    }

    private void layoutControls() {
        this.setLayout(this._layout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = UpdateWizardPage.INSETS_GAP_BELOW;
        gbc.anchor = 17;
        JPanel north = new JPanel();
        north.setLayout(new BorderLayout(30, 0));
        north.add((Component)this._updatesLabel, "West");
        north.add((Component)this._searchField, "Center");
        this.add((Component)north, gbc);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 18;
        JScrollPane scrollPane = new JScrollPane((Component)this._updatesList);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(22);
        this.add((Component)scrollPane, gbc);
        JPanel checkBoxAndButtons = new JPanel();
        checkBoxAndButtons.setLayout(new BorderLayout());
        checkBoxAndButtons.add((Component)this._onlyUpgrades, "West");
        checkBoxAndButtons.add((Component)this._selectButtonBar, "East");
        this._selectButtonBar.setAlignment(4);
        this._selectButtonBar.add((Component)this._selectAllButton);
        this._selectButtonBar.add((Component)this._deselectAllButton);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weighty = 0.0;
        this.add((Component)checkBoxAndButtons, gbc);
        ++gbc.gridy;
        gbc.fill = 2;
        this.add((Component)this._progressPanel, gbc);
        this._progressPanel.setLayout(new GridBagLayout());
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 5);
        gbc.anchor = 17;
        this._progressPanel.add((Component)this._progressBar, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        this._progressPanel.add((Component)this._progressStop, gbc);
        ++gbc.gridx;
        this._progressPanel.add((Component)this._statusLink, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 5);
        gbc.anchor = 18;
        this._progressPanel.add((Component)this._progressBarStatus, gbc);
    }

    private void showUpdateInformation(UpdateItem item) {
        if (item.getUpdate().getType() == UpdateInfo.Type.MESSAGE) {
            BrowserRunner.getBrowserRunner().runBrowserOnURL(URLFactory.newURL((String)item.getUpdate().getURL()), null, null);
        } else {
            new UpdateInfoPanel().runDialog(this, item.getUpdate());
        }
    }

    public Component getInitialFocus() {
        return this._updatesList;
    }

    private void populateUpdates(Collection updates) {
        this._onlyUpgrades.setEnabled(!updates.isEmpty());
        this._searchField.setEnabled(!updates.isEmpty());
        if (updates.isEmpty()) {
            this.showStatusMessage(OracleIcons.getIcon((String)"warning.png"), UpdateArb.getString(18), null);
            return;
        }
        ArrayList sortedUpdates = new ArrayList(updates);
        Collections.sort(sortedUpdates);
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (!(o1 instanceof UpdateInfo) || !(o2 instanceof UpdateInfo)) {
                    return -1;
                }
                UpdateInfo update1 = (UpdateInfo)o1;
                UpdateInfo update2 = (UpdateInfo)o2;
                UpdateInfo.Type type1 = update1.getType();
                UpdateInfo.Type type2 = update2.getType();
                return type1.compareTo(type2);
            }
        };
        Collections.sort(sortedUpdates, c);
        updates = sortedUpdates;
        for (UpdateInfo update : updates) {
            UpdateItem item = new UpdateItem(update);
            item.setSelected(update.getType() == UpdateInfo.Type.PATCH);
            this._itemsByUpdateInfo.put(update, item);
            this._allListModel.addElement((Object)item);
        }
    }

    protected void completeValueChanged() {
    }

    private void updateSelectAllButtons() {
        boolean isEmpty = this.getListModel().getSize() == 0;
        this._selectAllButton.setEnabled(!isEmpty);
        this._deselectAllButton.setEnabled(!isEmpty);
    }

    public void populate(UpdateWizardModel model) {
        this._checkedForUpdates = false;
        this.completeValueChanged();
        this.setStopped(false);
        this._allListModel.removeAll();
        this._itemsByUpdateInfo.clear();
        this._onlyUpgrades.setEnabled(false);
        this._updatesList.setModel(this._allListModel);
        this._selectAllButton.setEnabled(false);
        this._deselectAllButton.setEnabled(false);
        if (model.getLocalBundle() == null) {
            this._checkRunnable = new CheckUpdatesRunnable(model.getSelectedCenters()){

                protected void finished(final Collection updates) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                UpdatesPanel.this.populateUpdates(updates);
                            }
                            finally {
                                UpdatesPanel.this._checkedForUpdates = true;
                                UpdatesPanel.this.completeValueChanged();
                                UpdatesPanel.this.updateSelectAllButtons();
                                UpdatesPanel.this.resetFilter();
                            }
                        }
                    });
                }

                @Override
                protected void stopped() {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UpdatesPanel.this._checkedForUpdates = true;
                            UpdatesPanel.this.showStatusMessage(OracleIcons.getIcon((String)"warning.png"), "Check for updates was stopped.");
                            UpdatesPanel.this.completeValueChanged();
                        }
                    });
                }

                @Override
                protected void updateCenterError(final UpdateCenter center, final Throwable t) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UpdatesPanel.this.showStatusMessage(OracleIcons.getIcon((String)"error.png"), UpdateArb.format(151, center.getName()), t);
                        }
                    });
                }
            };
            UpdateCenterMonitor monitor = new UpdateCenterMonitor(){

                @Override
                public void setMessage(final String message) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UpdatesPanel.this._progressBarStatus.setText(message);
                        }
                    });
                }

                @Override
                public void setProgress(final int progress) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UpdatesPanel.this._progressBar.setValue(progress);
                        }
                    });
                }

                @Override
                public void setMaximum(final int max) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UpdatesPanel.this._progressBar.setIndeterminate(max == 2);
                            UpdatesPanel.this._progressBar.setMaximum(max);
                        }
                    });
                }

                @Override
                public void start() {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UpdatesPanel.this._progressBar.setValue(0);
                            UpdatesPanel.this._progressBar.setVisible(true);
                            UpdatesPanel.this._progressStop.setVisible(true);
                            UpdatesPanel.this._progressBarStatus.setVisible(true);
                            UpdatesPanel.this._progressStop.setEnabled(true);
                            UpdatesPanel.this._statusLink.setVisible(false);
                            UpdatesPanel.this._progressPanel.setVisible(true);
                            UpdatesPanel.this._progressPanel.invalidate();
                            UpdatesPanel.this._progressPanel.validate();
                        }
                    });
                }

                @Override
                public void finish() {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (UpdatesPanel.this._allListModel.getSize() > 0) {
                                UpdatesPanel.this._progressPanel.setVisible(false);
                            }
                        }
                    });
                }

                @Override
                public boolean isStopped() {
                    return UpdatesPanel.this.isStopped();
                }
            };
            this._checkRunnable.setMonitor(monitor);
            Thread t = new Thread((Runnable)this._checkRunnable, "Check for updates");
            t.start();
        } else {
            this._progressPanel.setVisible(false);
            LocalUpdateBundle localBundle = model.getLocalBundle();
            for (UpdateInfo update : localBundle.getBundle().getUpdates()) {
                UpdateItem item = new UpdateItem(update);
                item.setSelected(true);
                this._allListModel.addElement((Object)item);
                this._itemsByUpdateInfo.put(update, item);
            }
            this._onlyUpgrades.setEnabled(false);
            this._onlyUpgrades.setSelected(false);
            this._updatesList.setModel(this._allListModel);
            this.completeValueChanged();
        }
    }

    private void resetFilter() {
        String currentFilter = this._searchField.getText();
        if (currentFilter.length() == 0) {
            return;
        }
        this.filterList("");
        this.filterList(currentFilter);
    }

    private void showStatusMessage(Icon icon, String message) {
        this.showStatusMessage(icon, message, null);
    }

    private void showStatusMessage(Icon icon, String message, Throwable t) {
        this._progressBar.setVisible(false);
        this._progressStop.setVisible(false);
        this._statusLink.setVisible(t != null);
        this._progressBarStatus.setVisible(false);
        this._progressPanel.setVisible(true);
        if (t != null) {
            if (this._statusLinkListener != null) {
                this._statusLink.removeActionListener(this._statusLinkListener);
            }
            this._statusLinkListener = this.createStatusLinkListener(t, message);
            this._statusLink.addActionListener(this._statusLinkListener);
        }
    }

    private ActionListener createStatusLinkListener(Throwable t, String message) {
        if (t instanceof SAXParseException) {
            return new KnownExceptionAction(t, message, UpdateArb.getString(187));
        }
        if (t instanceof FileNotFoundException) {
            return new KnownExceptionAction(t, message, UpdateArb.getString(188));
        }
        if (t instanceof IOException) {
            return new KnownExceptionAction(t, message, UpdateArb.getString(189));
        }
        return new UnknownExceptionAction(t, message);
    }

    protected void cleanUp() {
        if (this._checkRunnableThread != null) {
            try {
                this.setStopped(true);
                this._checkRunnableThread.join();
                this._checkRunnableThread = null;
                this._checkRunnable = null;
            }
            catch (InterruptedException ie) {
                return;
            }
        }
    }

    public boolean isComplete() {
        if (!this._checkedForUpdates) {
            return false;
        }
        if (this.getListModel().getSize() == 0) {
            return false;
        }
        for (int i = 0; i < this.getListModel().getSize(); ++i) {
            UpdateItem item = (UpdateItem)this.getListModel().getElementAt(i);
            if (!item.isSelected()) continue;
            return true;
        }
        return false;
    }

    List getSelectedUpdates() {
        ArrayList<UpdateInfo> selectedUpdates = new ArrayList<UpdateInfo>();
        for (int i = 0; i < this._allListModel.getSize(); ++i) {
            UpdateItem item = (UpdateItem)this._allListModel.getElementAt(i);
            if (!item.isSelected()) continue;
            selectedUpdates.add(item.getUpdate());
        }
        return selectedUpdates;
    }

    protected void save(UpdateWizardModel model) {
        model.setSelectedUpdates(this.getSelectedUpdates());
    }

    public boolean canFinish() {
        return this._checkedForUpdates && this._allListModel.getSize() == 0;
    }

    boolean isLicenseRequired() {
        List updates = this.getSelectedUpdates();
        for (UpdateInfo info : updates) {
            if (info.getClickThroughURL() == null) continue;
            return true;
        }
        return false;
    }

    private void updateDependencies(UpdateItem item) {
        UpdateInfo updateInfo = item.getUpdate();
        if (item.isSelected() && !updateInfo.getRequiredUpdates().isEmpty()) {
            for (UpdateInfo requiredInfo : updateInfo.getRequiredUpdates()) {
                UpdateItem requiredItem = (UpdateItem)this._itemsByUpdateInfo.get(requiredInfo);
                requiredItem.setSelected(true);
                this.updateDependencies(requiredItem);
            }
        } else if (!item.isSelected()) {
            boolean ok;
            ArrayList<String> deps = new ArrayList<String>();
            for (int i = 0; i < this._allListModel.getSize(); ++i) {
                UpdateItem otherItem = (UpdateItem)this._allListModel.getElementAt(i);
                if (!otherItem.isSelected() || !otherItem.getUpdate().getRequiredUpdates().contains(updateInfo)) continue;
                deps.add(otherItem.getUpdate().getName());
            }
            if (deps.size() > 0 && !(ok = MessageDialog.confirm((Component)this, (Object)UpdateArb.format(53, updateInfo.getName(), ListUtil.join(deps, (String)"\n")), (String)UpdateArb.getString(52), null))) {
                item.setSelected(true);
            }
        }
        UpdateBundle bundle = item.getUpdate().getBundle();
        for (UpdateInfo update : bundle.getUpdates()) {
            if (update == item.getUpdate()) continue;
            UpdateItem bundleItem = (UpdateItem)this._itemsByUpdateInfo.get(update);
            bundleItem.setSelected(item.isSelected());
        }
        this.getListModel().changed();
    }

    private void setAllSelected(boolean allSelected) {
        SimpleListModel model = this.getListModel();
        for (UpdateItem item : model) {
            item.setSelected(allSelected);
        }
        model.changed();
    }

    private void filterList(String search) {
        Object selected = this._updatesList.getSelectedValue();
        SimpleListModel<UpdateItem> newModel = null;
        if (search.length() == 0 && !this._onlyUpgrades.isSelected()) {
            if (this.getListModel() == this._allListModel) {
                return;
            }
            newModel = this._allListModel;
        } else {
            newModel = new SimpleListModel<UpdateItem>();
            for (UpdateItem update : this._allListModel) {
                if (this._onlyUpgrades.isSelected() && update.getUpdate().isNew() && update.getUpdate().getType() != UpdateInfo.Type.PATCH && update.getUpdate().getType() != UpdateInfo.Type.MESSAGE || search.length() != 0 && !update.getUpdate().getName().toLowerCase().contains(search)) continue;
                newModel.addElement((Object)update);
            }
        }
        this.getListModel().removeListDataListener(this._listDataListener);
        this._updatesList.setModel(newModel);
        this.getListModel().addListDataListener(this._listDataListener);
        if (selected != null) {
            this._updatesList.setSelectedValue(selected, true);
        }
        this.updateSelectAllButtons();
        this.completeValueChanged();
    }

    private class Listener
    implements NiceListActionListener,
    ActionListener {
        private Listener() {
        }

        public void listActionPerformed(NiceListActionEvent ae) {
            if (ae.getRow() >= 0) {
                UpdateItem item = (UpdateItem)UpdatesPanel.this.getListModel().getElementAt(ae.getRow());
                if (ae.getType() == NiceListActionEvent.Type.CHECKBOX) {
                    item.setSelected(!item.isSelected());
                    UpdatesPanel.this.updateDependencies(item);
                    UpdatesPanel.this.getListModel().changed(ae.getRow());
                    UpdatesPanel.this.completeValueChanged();
                } else if (ae.getType() == NiceListActionEvent.Type.HYPERLINK) {
                    UpdatesPanel.this.showUpdateInformation(item);
                } else if (ae.getType() == NiceListActionEvent.Type.SECONDARY_HYPERLINK) {
                    UpdatesPanel.this.getListModel().removeElement((Object)item);
                    CheckForUpdatesPreferences prefs = WebUpdateAddin.getPreferences();
                    ListStructure hiddenMessages = prefs.getHiddenMessages();
                    if (hiddenMessages == null) {
                        hiddenMessages = ListStructure.newInstance();
                        prefs.setHiddenMessages(hiddenMessages);
                    }
                    hiddenMessages.add(item.getUpdate().getID());
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (ae.getSource() == UpdatesPanel.this._onlyUpgrades) {
                UpdatesPanel.this.filterList(UpdatesPanel.this._searchField.getText());
            } else if (ae.getSource() == UpdatesPanel.this._progressStop) {
                UpdatesPanel.this.setStopped(true);
            } else if (ae.getSource() == UpdatesPanel.this._selectAllButton) {
                UpdatesPanel.this.setAllSelected(true);
                UpdatesPanel.this.completeValueChanged();
            } else if (ae.getSource() == UpdatesPanel.this._deselectAllButton) {
                UpdatesPanel.this.setAllSelected(false);
                UpdatesPanel.this.completeValueChanged();
            }
        }
    }

    private static class UpdateItem {
        private boolean _isSelected = false;
        private final UpdateInfo _update;

        UpdateItem(UpdateInfo info) {
            this._update = info;
        }

        public UpdateInfo getUpdate() {
            return this._update;
        }

        public boolean isSelected() {
            return this._isSelected;
        }

        public void setSelected(boolean selected) {
            this._isSelected = selected;
        }

        public String toString() {
            return this.getUpdate().getName();
        }
    }

    private class KnownExceptionAction
    implements ActionListener {
        private final String _baseMessage;
        private final String _detailMessage;

        public KnownExceptionAction(Throwable exception, String baseMessage, String detailMessage) {
            this._baseMessage = baseMessage;
            this._detailMessage = detailMessage;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            MessageDialog.error((Component)UpdatesPanel.this, (Object)(this._baseMessage + "\n" + this._detailMessage), (String)UpdateArb.getString(1), null);
        }
    }

    private class UnknownExceptionAction
    implements ActionListener {
        private final Throwable _exception;
        private final String _message;

        public UnknownExceptionAction(Throwable exception, String message) {
            this._exception = exception;
            this._message = message;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ExceptionDialog.showExceptionDialog((Component)UpdatesPanel.this, (Throwable)this._exception, (String)this._message, (String)UpdateArb.getString(1), null);
        }
    }
}

