/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.uninstall;

import javax.ide.util.Version;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateCategory;
import oracle.ideimpl.webupdate.UpdateInfo;

public class CFUBundlesExtraInfo {
    public static UpdateInfo createFromLineInExtras(String line) {
        UpdateInfo update = null;
        UpdateBundle bundle = null;
        String[] tokens = line.split(",");
        if (tokens.length >= 11) {
            update = new UpdateInfo();
            String id = tokens[0];
            update.setID(id);
            update.setType(UpdateInfo.Type.valueOf(tokens[1].toUpperCase()));
            if (update.getType().equals((Object)UpdateInfo.Type.CUSTOM)) {
                update.setCustomType(tokens[2]);
            }
            update.setVersion(new Version(tokens[3]));
            update.setName(tokens[4]);
            UpdateCategory cat = new UpdateCategory(tokens[5]);
            cat.setCategory(tokens[6]);
            update.setCategory(cat);
            update.setDescription(tokens[7].replaceAll("&newline&", "\n").replaceAll("&comma&", ","));
            update.setAuthor(tokens[8]);
            update.setAuthorURL(tokens[9]);
            bundle = new UpdateBundle();
            bundle.setName(tokens[10]);
            update.setBundle(bundle);
            if (tokens.length > 11) {
                for (int i = 11; i < tokens.length; ++i) {
                    update.addRequiredUpdate(tokens[i], null, null);
                }
            }
        }
        return update;
    }

    public static String extrasToString(UpdateInfo update) {
        StringBuilder buf = new StringBuilder();
        buf.append("UpdateExtraInfo=");
        buf.append(update.getID());
        buf.append(',');
        buf.append((Object)update.getType());
        buf.append(',');
        if (update.getType().equals((Object)UpdateInfo.Type.CUSTOM)) {
            buf.append(update.getCustomType());
        }
        buf.append(',');
        buf.append(update.getVersion());
        buf.append(',');
        buf.append(update.getName());
        buf.append(',');
        CFUBundlesExtraInfo.addCategoryInfo(buf, update);
        buf.append(update.getDescription().replaceAll(",", "&comma&").replaceAll("\n", "&newline&"));
        buf.append(',');
        buf.append(update.getAuthor());
        buf.append(',');
        buf.append(update.getAuthorURL());
        buf.append(',');
        if (update.getBundle() != null) {
            buf.append(update.getBundle().getName());
        } else {
            buf.append(update.getName());
        }
        for (String reqUpdateId : update.getRequiredIds()) {
            buf.append(",");
            buf.append(reqUpdateId);
        }
        return buf.toString();
    }

    private static void addCategoryInfo(StringBuilder buf, UpdateInfo update) {
        UpdateCategory category = update.getCategory();
        String categoryID = "";
        String categoryName = "";
        if (category != null) {
            categoryID = category.getCategoryId();
            categoryName = category.getCategoryName();
        }
        buf.append(categoryID == null ? "" : categoryID);
        buf.append(',');
        buf.append(categoryName == null ? "Other" : categoryName);
        buf.append(',');
    }
}

