/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.task;

import java.io.File;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.task.AtomicTask;
import oracle.ideimpl.webupdate.task.CreateDirectory;
import oracle.ideimpl.webupdate.task.DeleteFile;
import oracle.ideimpl.webupdate.task.TaskContext;
import oracle.ideimpl.webupdate.task.TaskFailedException;
import oracle.ideimpl.webupdate.task.TaskStack;
import oracle.ideimpl.webupdate.task.UnzipTask;

public class InstallExtensionTask
extends AtomicTask {
    private static final String KEY_ZIP = "extensionZip";
    private static final String KEY_DESTINATION = "destinationDir";
    private static final String KEY_DELETE_ZIP = "deleteZip";
    private static final String META_INF_PATTERN = "^meta-inf.*";
    private TaskStack _tasks;

    public InstallExtensionTask() {
    }

    public InstallExtensionTask(String zipFile, String destinationDir, boolean deleteZip) {
        this.getProperties().putString(KEY_ZIP, zipFile);
        this.getProperties().putString(KEY_DESTINATION, destinationDir);
        this.getProperties().putBoolean(KEY_DELETE_ZIP, deleteZip);
    }

    @Override
    public void perform(TaskContext tc) throws TaskFailedException {
        String zip = this.getProperties().getString(KEY_ZIP);
        if (zip != null && zip.contains(oracle.ideimpl.deferredupdate.task.InstallExtensionTask.JAVAFX_ZIP_NAME_PREFIX_VALUE)) {
            return;
        }
        this._tasks = new TaskStack();
        String destination = this.getProperties().getString(KEY_DESTINATION);
        boolean deleteZip = this.getProperties().getBoolean(KEY_DELETE_ZIP);
        File zipFile = new File(zip);
        if (!zipFile.exists() || !zipFile.canRead()) {
            throw new TaskFailedException(UpdateArb.format(166, zipFile.getPath()));
        }
        File destinationFile = new File(destination);
        this._tasks.performTask(new CreateDirectory(destinationFile), tc);
        UnzipTask unzipTask = new UnzipTask(zipFile, destinationFile);
        unzipTask.addSkipPattern(META_INF_PATTERN);
        this._tasks.performTask(unzipTask, tc);
        if (deleteZip) {
            this._tasks.performTask(new DeleteFile(zipFile), tc);
        }
    }

    @Override
    public void rollback(TaskContext tc) throws TaskFailedException {
        if (this._tasks == null) {
            throw new IllegalStateException("Cannot rollback");
        }
        this._tasks.rollbackTasks(tc);
    }

    @Override
    public void commit(TaskContext tc) throws TaskFailedException {
        this._tasks.commitTasks(tc);
    }
}

