/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Enumeration;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.ideimpl.deferredupdate.task.InstallExtensionTask;
import oracle.ideimpl.webupdate.InvalidLocalBundleException;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.parser.LocalBundleParser;
import oracle.ideimpl.webupdate.parser.UpdateBundleValidator;
import oracle.ideimpl.webupdate.uninstall.ManageInstalledUpdates;
import oracle.ideimpl.webupdate.util.UpdateUtil;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class LocalUpdateBundle {
    private static final Logger LOGGER = Logger.getLogger(LocalUpdateBundle.class.getName());
    private static final String BUNDLE_MANIFEST = "META-INF/bundle.xml";
    private static final String INCLUDE_JAVAFX_CONF_FILE = "IncludeConfFile javafx.conf";
    private UpdateBundle _bundle;
    private File _bundleFile;

    public LocalUpdateBundle(UpdateBundle bundle) {
        this._bundle = bundle;
    }

    public UpdateBundle getBundle() {
        return this._bundle;
    }

    public void setBundleFile(File file) {
        this._bundleFile = file;
    }

    public File getBundleFile() {
        return this._bundleFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContent(String entryPath) throws IOException {
        ZipFile zipFile = new ZipFile(this.getBundleFile());
        ZipEntry entry = zipFile.getEntry(entryPath);
        BufferedReader br = null;
        StringBuffer sb = new StringBuffer();
        try {
            br = new BufferedReader(new InputStreamReader(zipFile.getInputStream(entry)));
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                line = br.readLine();
            }
        }
        catch (Throwable throwable) {
            LocalUpdateBundle.close(br);
            LocalUpdateBundle.close(zipFile);
            throw throwable;
        }
        LocalUpdateBundle.close(br);
        LocalUpdateBundle.close(zipFile);
        return sb.toString();
    }

    public static LocalUpdateBundle createInstance(File localFile) throws InvalidLocalBundleException {
        return LocalUpdateBundle.createInstance(localFile, true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LocalUpdateBundle createInstance(File localFile, boolean resolveExt) throws InvalidLocalBundleException {
        if (!localFile.exists()) {
            throw new InvalidLocalBundleException(UpdateArb.format(136, localFile.getName()));
        }
        if (localFile.isDirectory()) {
            throw new InvalidLocalBundleException(UpdateArb.format(137, localFile.getName()));
        }
        if (!localFile.canRead()) {
            throw new InvalidLocalBundleException(UpdateArb.format(138, localFile.getName()));
        }
        zipFile = null;
        inStream = null;
        try {
            if (!localFile.getName().contains(InstallExtensionTask.JAVAFX_ZIP_NAME_PREFIX_VALUE)) ** GOTO lbl-1000
            productHome = System.getProperty("user.dir") + "/../../";
            if (localFile.getName().endsWith(".tar.gz")) {
                fin = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream(localFile)));
                try {
                    while ((entry = fin.getNextTarEntry()) != null) {
                        if (entry.isDirectory()) continue;
                        curfile = new File(new File(productHome), entry.getName());
                        parent = curfile.getParentFile();
                        if (!parent.exists()) {
                            parent.mkdirs();
                        }
                        IOUtils.copy((InputStream)fin, (OutputStream)new FileOutputStream(curfile));
                    }
                }
                finally {
                    fin.close();
                }
            }
            if (localFile.getName().endsWith(".zip")) {
                zipFile1 = new ZipFile(localFile);
                try {
                    entries = zipFile1.entries();
                    while (entries.hasMoreElements()) {
                        entry = entries.nextElement();
                        entryDestination = new File(productHome, entry.getName());
                        if (entry.isDirectory()) {
                            entryDestination.mkdirs();
                            continue;
                        }
                        entryDestination.getParentFile().mkdirs();
                        in = zipFile1.getInputStream(entry);
                        try {
                            out = new FileOutputStream(entryDestination);
                            try {
                                IOUtils.copy((InputStream)in, (OutputStream)out);
                            }
                            finally {
                                out.close();
                            }
                        }
                        finally {
                            if (in == null) continue;
                            in.close();
                        }
                    }
                }
                finally {
                    zipFile1.close();
                }
            }
            info = new UpdateInfo();
            info.setID("jdk.java.net.javafx");
            info.setName("JavaFX Extension");
            info.setNew(true);
            bundle = new UpdateBundle();
            bundle.add(info);
            lb = new LocalUpdateBundle(bundle);
            lb.setBundleFile(localFile);
            lines = Files.readAllLines(Paths.get("jdev.conf", new String[0]));
            exists = false;
            for (String line : lines) {
                if (!"IncludeConfFile javafx.conf".equals(line.strip())) continue;
                exists = true;
                break;
            }
            if (!exists) {
                Files.writeString(Paths.get("jdev.conf", new String[0]), (CharSequence)"\nIncludeConfFile javafx.conf", new OpenOption[]{StandardOpenOption.APPEND});
            }
            localFile.delete();
            System.setProperty("IDE_NEED_TO_RESTART_MANUALLY", "true");
            var10_23 = lb;
        }
        catch (IOException ioe) {
            try {
                throw new InvalidLocalBundleException(UpdateArb.format(139, localFile.getName()), ioe);
                catch (ParserConfigurationException pce) {
                    throw new InvalidLocalBundleException(UpdateArb.getString(153), pce);
                }
                catch (SAXException saxe) {
                    throw new InvalidLocalBundleException(UpdateArb.getString(153), saxe);
                }
            }
            catch (Throwable var13_29) {
                LocalUpdateBundle.close(inStream);
                LocalUpdateBundle.close(zipFile);
                throw var13_29;
            }
        }
        LocalUpdateBundle.close(inStream);
        LocalUpdateBundle.close(zipFile);
        return var10_23;
lbl-1000:
        // 1 sources

        {
            zipFile = new ZipFile(localFile);
            entry = zipFile.getEntry("META-INF/bundle.xml");
            if (entry == null) {
                throw new InvalidLocalBundleException(UpdateArb.format(152, localFile.getName(), "META-INF/bundle.xml"));
            }
            inStream = zipFile.getInputStream(entry);
            result = new LocalBundleParser().parse(inStream);
            if (result.problems().hasProblems()) {
                throw new InvalidLocalBundleException(UpdateArb.getString(205), result.problems());
            }
            LocalUpdateBundle.setCategoryFromExtension(zipFile, result.bundle());
            lub = new LocalUpdateBundle(result.bundle());
            lub.setBundleFile(localFile);
            if (resolveExt) {
                for (UpdateInfo info : result.bundle().getUpdates()) {
                    info.setNew(ManageInstalledUpdates.isUpdateInstalled(info) == false);
                }
            }
            LocalUpdateBundle.validateLocalUpdateBundle(lub);
            var7_18 = lub;
        }
        LocalUpdateBundle.close(inStream);
        LocalUpdateBundle.close(zipFile);
        return var7_18;
    }

    private static void close(final ZipFile zipFile) {
        LocalUpdateBundle.close(new Closeable(){

            @Override
            public void close() throws IOException {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
        });
    }

    private static void close(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException exception) {
                Logger.getLogger(LocalUpdateBundle.class.getName()).log(Level.SEVERE, null, exception);
            }
        }
    }

    private static void validateLocalUpdateBundle(LocalUpdateBundle lub) {
        UpdateBundleValidator bundleValidator;
        UpdateBundleValidator.Result validationResult;
        boolean isValidationEnabled = false;
        if (!$assertionsDisabled) {
            isValidationEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (isValidationEnabled && lub != null && !(validationResult = (bundleValidator = UpdateBundleValidator.createInstance(lub)).validate()).isValid()) {
            LOGGER.warning(validationResult.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setCategoryFromExtension(ZipFile zipFile, UpdateBundle bundle) throws SAXException, IOException, ParserConfigurationException {
        Set<UpdateInfo> set = bundle.getUpdates();
        for (UpdateInfo update : set) {
            StringReader reader;
            ZipInputStream zis;
            InputStream inputStream;
            block10: {
                if (update.getCategory().isCategorySet()) continue;
                String id = update.getID();
                String jarFileName = id + ".jar";
                ZipEntry jar = zipFile.getEntry(jarFileName);
                if (jar == null) {
                    Enumeration<? extends ZipEntry> list = zipFile.entries();
                    while (list.hasMoreElements()) {
                        ZipEntry e = list.nextElement();
                        if (!e.getName().endsWith(jarFileName)) continue;
                        jar = e;
                    }
                }
                if (jar == null) continue;
                inputStream = null;
                zis = null;
                reader = null;
                try {
                    inputStream = zipFile.getInputStream(jar);
                    zis = new ZipInputStream(inputStream);
                    String extensionXML = UpdateUtil.readExtensionXML(zis);
                    if (extensionXML == null) break block10;
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    SAXParser parser = factory.newSAXParser();
                    reader = new StringReader(extensionXML);
                    InputSource source = new InputSource(reader);
                    ReadCategoryHandler categoryHandler = new ReadCategoryHandler();
                    try {
                        parser.parse(source, (DefaultHandler)categoryHandler);
                        if (categoryHandler.getCategoryID() != null) {
                            update.getCategory().setCategoryId(categoryHandler.getCategoryID());
                        } else if (categoryHandler.getCategory() != null) {
                            update.getCategory().setCategory(categoryHandler.getCategory());
                        }
                    }
                    catch (Exception e) {
                        LOGGER.warning("Exception during parsing of " + zipFile.getName() + ":. " + jarFileName);
                    }
                }
                catch (Throwable throwable) {
                    LocalUpdateBundle.doClose(reader);
                    LocalUpdateBundle.doClose(inputStream);
                    LocalUpdateBundle.doClose(zis);
                    throw throwable;
                }
            }
            LocalUpdateBundle.doClose(reader);
            LocalUpdateBundle.doClose(inputStream);
            LocalUpdateBundle.doClose(zis);
        }
    }

    private static void doClose(Closeable s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private static class ReadCategoryHandler
    extends DefaultHandler {
        private String categoryID;
        private boolean inCategoryID;
        private String category;
        private boolean inCategory;

        private ReadCategoryHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equalsIgnoreCase("category-id")) {
                this.inCategoryID = true;
            } else if (qName.equalsIgnoreCase("category")) {
                this.inCategory = true;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equalsIgnoreCase("category-id")) {
                this.inCategoryID = false;
            } else if (qName.equalsIgnoreCase("category")) {
                this.inCategory = false;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String s = new String(ch, start, length).trim();
            if (!s.isEmpty() && this.inCategoryID) {
                this.categoryID = s;
            } else if (!s.isEmpty() && this.inCategory) {
                this.category = s;
            }
        }

        public String getCategory() {
            return this.category;
        }

        public String getCategoryID() {
            return this.categoryID;
        }
    }
}

