/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.io.File;
import java.io.IOException;
import java.util.List;
import oracle.ide.net.URLFactory;
import oracle.ideimpl.webupdate.AbstractProgressMonitor;
import oracle.ideimpl.webupdate.Directories;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.UpdateManager;
import oracle.ideimpl.webupdate.task.TaskContext;
import oracle.ideimpl.webupdate.task.TaskList;

public final class DeferredUpdater {
    public static void install() {
        try {
            System.out.println(UpdateArb.getString(159));
            UpdateManager updateManager = UpdateManager.getInstance();
            updateManager.setDirectories(new StandaloneDirectories());
            try {
                TaskList updateTasks = new TaskList();
                updateTasks.load(URLFactory.newFileURL((File)UpdateManager.getInstance().getDeferredUpdatesFile()));
                if (updateTasks.size() > 0) {
                    updateTasks.executeAll(new TaskContext(){

                        @Override
                        public Directories getDirectories() {
                            return UpdateManager.getInstance().getDirectories();
                        }

                        @Override
                        public boolean confirmOverwrite(File file) {
                            return true;
                        }
                    }, new AbstractProgressMonitor());
                }
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            File deferredUpdateFile = UpdateManager.getInstance().getDeferredUpdatesFile();
            deferredUpdateFile.delete();
        }
    }

    private static class StandaloneDirectories
    implements Directories {
        private String m_temp = null;
        private String m_ideHome = null;
        private String m_ideLib = null;
        private String m_userHome = null;

        private StandaloneDirectories() {
        }

        @Override
        public void save(List<String> list) {
            list.add("temp=" + this.getTemp());
            list.add("globalExtensionsHome=" + this.getGlobalExtensionsHome());
            list.add("patchesHome=" + this.getPatchesHome());
            list.add("userExtensionsHome=" + this.getUserExtensionsHome());
            list.add("globalSettingsHome=" + this.getGlobalSettingsHome());
            list.add("userSettingsHome=" + this.getUserSettingsHome());
            list.add("oracleHome=" + this.getOracleHome());
            list.add("bundlesInfoHome=" + this.getBundlesInfoHome());
        }

        private String cannonicalize(String dir) {
            if (dir == null || dir.trim().length() == 0) {
                return dir;
            }
            File f = new File(dir);
            try {
                f = f.getCanonicalFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return f.toString();
        }

        private String getIdeLibDirectory() {
            if (this.m_ideLib == null) {
                this.m_ideLib = this.cannonicalize(System.getProperty("ide.home", null));
                if (this.m_ideLib == null) {
                    this.m_ideLib = new File(System.getProperty("user.dir")).getParent();
                }
                this.m_ideHome = this.m_ideLib;
                File f = new File(this.m_ideLib, "lib");
                this.m_ideLib = f.getPath();
                if (!this.m_ideLib.endsWith(File.separator)) {
                    this.m_ideLib = this.m_ideLib + File.separator;
                }
            }
            return this.m_ideLib;
        }

        private String getIdeDirectory() {
            File ideLibDirectory = new File(this.getIdeLibDirectory());
            Object dir = ideLibDirectory.getParentFile().getAbsolutePath();
            if (!((String)dir).endsWith(File.separator)) {
                dir = (String)dir + File.separator;
            }
            return dir;
        }

        private String getUserHomeDirectory() {
            if (this.m_userHome == null) {
                this.m_userHome = this.cannonicalize(System.getProperty("ide.user.dir", null));
                if (this.m_userHome == null || "".equals(this.m_userHome)) {
                    this.getIdeLibDirectory();
                    this.m_userHome = this.m_ideHome;
                } else if (!this.m_userHome.endsWith(File.separator)) {
                    this.m_userHome = this.m_userHome + File.separator;
                }
                if (!this.m_userHome.endsWith(File.separator)) {
                    this.m_userHome = this.m_userHome + File.separator;
                }
            }
            return this.m_userHome;
        }

        @Override
        public String getTemp() {
            if (this.m_temp == null) {
                String userhome = this.getUserHomeDirectory();
                this.m_temp = new File(userhome + File.separator + "tmp", "update").getPath();
            }
            return this.m_temp;
        }

        @Override
        public String getGlobalExtensionsHome() {
            return this.getIdeDirectory() + "extensions";
        }

        @Override
        public String getPatchesHome() {
            return this.getIdeLibDirectory() + "patches";
        }

        @Override
        public String getUserExtensionsHome() {
            return this.getUserHomeDirectory() + "extensions";
        }

        @Override
        public String getGlobalSettingsHome() {
            return this.getIdeLibDirectory();
        }

        @Override
        public String getUserSettingsHome() {
            return this.getUserHomeDirectory() + "lib";
        }

        @Override
        public String getOracleHome() {
            File file = new File(this.getIdeDirectory());
            String parent = file.getParent();
            if (parent != null) {
                return parent;
            }
            return file.getPath();
        }

        @Override
        public String getBundlesInfoHome() {
            return null;
        }
    }
}

