/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import oracle.mapviewer.share.Sequence;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.ui.ErrorDialog;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.spatial.edit.layer.GeometrySetLayer;
import oracle.spatial.edit.model.AbstractDataAccessObject;
import oracle.spatial.edit.model.MDSException;

public class GeometryLayerPropertyPanel
extends JPanel {
    private GeometrySetLayer sessionLayer = null;
    private JLabel nameLabel = new JLabel();
    private JLabel nameTxt = new JLabel();
    private JLabel basetableLabel = new JLabel();
    private JLabel basetableTxt = new JLabel();
    private JLabel serverLabel = new JLabel();
    private JTextField serverTxt = new JTextField();
    private JLabel keyColumnLabel = new JLabel();
    private JComboBox keyColumnComboBox = new JComboBox();
    private JCheckBox keySequenceCheckBox = new JCheckBox();
    private JComboBox keySequenceComboBox = new JComboBox();
    private JButton keySequenceCreate = new JButton();
    private JLabel geomColumnLabel = new JLabel();
    private JComboBox geomColumnComboBox = new JComboBox();
    private JCheckBox labelCheckBox = new JCheckBox();
    private JComboBox labelComboBox = new JComboBox();
    private JLabel conditionLabel = new JLabel();
    private JTextField conditionTxt = new JTextField();
    private JLabel livescaleLabel = new JLabel();
    private JTextField livescaleTxt = new JTextField();
    private JCheckBox shareBoundaryBox = new JCheckBox();
    private JButton applyButton = new JButton(MessagesBundle.getMessage("Apply"));
    private NumberFormat scaleFormat = NumberFormat.getInstance();
    private JFormattedTextField scaleMVRenderTF = new JFormattedTextField(this.scaleFormat);
    private boolean allowLabelChanges = true;
    private String[] spatialColumns = null;
    private String[] tableAttrs = null;
    protected String[] seqNames = null;
    static ImageIcon editableIcon = Icons.getIcon("edit16.png");

    public GeometryLayerPropertyPanel(GeometrySetLayer layer) {
        this.scaleFormat.setMinimumFractionDigits(2);
        this.scaleFormat.setMaximumFractionDigits(4);
        this.sessionLayer = layer;
        String[] stringArray = new String[1];
        stringArray[0] = layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn");
        this.spatialColumns = stringArray;
        this.tableAttrs = layer.getNonComplexAttributes();
        this.seqNames = this.getSequences();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String[] getSequences() {
        String[] res = null;
        Vector<Sequence> sequences = null;
        try {
            AbstractDataAccessObject da = this.sessionLayer.getDataSource().getDataAccessObject();
            da.openConnection();
            sequences = da.getSequences();
            if (sequences != null && sequences.size() > 0) {
                res = new String[sequences.size()];
                for (int i = 0; i < sequences.size(); ++i) {
                    res[i] = sequences.get(i).getName();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        catch (MDSException ex) {
            ex.printStackTrace();
        }
        return res;
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.nameLabel.setText(MessagesBundle.getMessage("Label_name"));
        this.shareBoundaryBox.setText(MessagesBundle.getMessage("Shared_boundary"));
        this.labelCheckBox.setText(MessagesBundle.getMessage("Label_label_column"));
        this.geomColumnLabel.setText(MessagesBundle.getMessage("Label_geometry_column"));
        this.keyColumnLabel.setText(MessagesBundle.getMessage("Label_key_column"));
        this.basetableLabel.setText(MessagesBundle.getMessage("Label_base_table"));
        this.serverLabel.setText(MessagesBundle.getMessage("Label_mapviewer_server"));
        this.livescaleLabel.setText(MessagesBundle.getMessage("Label_live_scale"));
        this.livescaleTxt.setToolTipText(MessagesBundle.getMessage("Tooltip_live_scale"));
        this.conditionLabel.setText(MessagesBundle.getMessage("Label_query_condition"));
        this.keySequenceCheckBox.setText(MessagesBundle.getMessage("Label_key_sequence"));
        this.keySequenceCreate.setText(MessagesBundle.getMessage("Create_sequence"));
        this.livescaleTxt.setEnabled(false);
        this.keySequenceCreate.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDataAccessObject da = GeometryLayerPropertyPanel.this.sessionLayer.getDataSource().getDataAccessObject();
                GeometrySetLayer geometrySetLayer = GeometryLayerPropertyPanel.this.sessionLayer;
                GeometryLayerPropertyPanel.this.sessionLayer;
                String table = geometrySetLayer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable");
                GeometrySetLayer geometrySetLayer2 = GeometryLayerPropertyPanel.this.sessionLayer;
                GeometryLayerPropertyPanel.this.sessionLayer;
                String key = geometrySetLayer2.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keyColumn");
                String seqName = (table + "_" + key + "_SEQ").toUpperCase();
                boolean success = false;
                Throwable exception = null;
                try {
                    da.openConnection();
                    success = da.createSequence(seqName, 1L);
                }
                catch (MDSException ex) {
                    exception = ex;
                }
                catch (Exception ex) {
                    exception = ex;
                    System.out.println("Warning: " + MessagesBundle.getFormattedMessage("Unable_tocreate_sequence_name", seqName) + "\n" + ex.getMessage());
                }
                finally {
                    try {
                        da.closeConnection();
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
                if (exception != null || !success) {
                    ErrorDialog.showErrorDialog(exception, GeometryLayerPropertyPanel.this.sessionLayer.getCanvas().getFrameForDialog(), MessagesBundle.getFormattedMessage("Unable_tocreate_sequence_name", seqName), MessagesBundle.getMessage("Error"), 0);
                    return;
                }
                GeometrySetLayer geometrySetLayer3 = GeometryLayerPropertyPanel.this.sessionLayer;
                GeometryLayerPropertyPanel.this.sessionLayer;
                geometrySetLayer3.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keySequence", seqName);
                String[] newSeq = null;
                if (GeometryLayerPropertyPanel.this.seqNames != null) {
                    newSeq = new String[GeometryLayerPropertyPanel.this.seqNames.length + 1];
                    System.arraycopy(GeometryLayerPropertyPanel.this.seqNames, 0, newSeq, 0, GeometryLayerPropertyPanel.this.seqNames.length);
                } else {
                    newSeq = new String[1];
                }
                newSeq[newSeq.length - 1] = seqName;
                GeometryLayerPropertyPanel.this.setKeySequences(newSeq);
                GeometryLayerPropertyPanel.this.setKeySequence(seqName);
                GeometryLayerPropertyPanel.this.setKeySequenceSelected(true);
            }
        });
        this.applyButton.setMnemonic(65);
        this.applyButton.addActionListener(new ActionListener(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                block11: {
                    block10: {
                        geomCol = GeometryLayerPropertyPanel.this.getGeometryColumn();
                        keyCol = GeometryLayerPropertyPanel.this.getKeyColumn();
                        queryCon = GeometryLayerPropertyPanel.this.getQueryCondition();
                        serverURL = GeometryLayerPropertyPanel.this.getMapViewerServer();
                        v0 = GeometryLayerPropertyPanel.access$000(GeometryLayerPropertyPanel.this);
                        GeometryLayerPropertyPanel.access$000(GeometryLayerPropertyPanel.this);
                        v0.setProperty("oracle.lbs.mapviewer.serverURL", serverURL);
                        if (geomCol == null) break block10;
                        v1 = GeometryLayerPropertyPanel.access$000(GeometryLayerPropertyPanel.this);
                        GeometryLayerPropertyPanel.access$000(GeometryLayerPropertyPanel.this);
                        if (!geomCol.equals(v1.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn"))) ** GOTO lbl-1000
                    }
                    if (keyCol == null) break block11;
                    v2 = GeometryLayerPropertyPanel.access$000(GeometryLayerPropertyPanel.this);
                    GeometryLayerPropertyPanel.access$000(GeometryLayerPropertyPanel.this);
                    if (!keyCol.equals(v2.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keyColumn"))) ** GOTO lbl-1000
                }
                if (queryCon != null) {
                    v3 = GeometryLayerPropertyPanel.access$000(GeometryLayerPropertyPanel.this);
                    GeometryLayerPropertyPanel.access$000(GeometryLayerPropertyPanel.this);
                    ** if (queryCon.equals((Object)v3.getProperty((String)"oracle.spatial.edit.layer.AbstractDataSetLayer.queryCondition"))) goto lbl-1000
                }
                ** GOTO lbl-1000
lbl-1000:
                // 3 sources

                {
                    v4 = true;
                    ** GOTO lbl31
                }
lbl-1000:
                // 2 sources

                {
                    v4 = change = false;
                }
lbl31:
                // 2 sources

                if (change && GeometryLayerPropertyPanel.access$000(GeometryLayerPropertyPanel.this).isModified()) {
                    saveOpt = JOptionPane.showConfirmDialog(GeometryLayerPropertyPanel.access$000(GeometryLayerPropertyPanel.this).getCanvas().getFrameForDialog(), "Save before?", "Changes found", 1);
                    if (saveOpt == 0) {
                        GeometryLayerPropertyPanel.access$000(GeometryLayerPropertyPanel.this).save();
                    } else if (saveOpt == 2) {
                        return;
                    }
                }
                labelCol = null;
                if (GeometryLayerPropertyPanel.this.isLabelSelected()) {
                    labelCol = GeometryLayerPropertyPanel.this.getLabelColumn();
                }
                v5 = GeometryLayerPropertyPanel.access$000(GeometryLayerPropertyPanel.this);
                GeometryLayerPropertyPanel.access$000(GeometryLayerPropertyPanel.this);
                v5.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.labelColumn", labelCol);
                keySeq = null;
                if (GeometryLayerPropertyPanel.this.isKeySequenceSelected()) {
                    keySeq = GeometryLayerPropertyPanel.this.getKeySequence();
                }
                v6 = GeometryLayerPropertyPanel.access$000(GeometryLayerPropertyPanel.this);
                GeometryLayerPropertyPanel.access$000(GeometryLayerPropertyPanel.this);
                v6.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keySequence", keySeq);
                v7 = GeometryLayerPropertyPanel.access$000(GeometryLayerPropertyPanel.this);
                GeometryLayerPropertyPanel.access$000(GeometryLayerPropertyPanel.this);
                v7.setProperty("oracle.spatial.edit.layer.GeometrySetLayer.shareboundary", Boolean.toString(GeometryLayerPropertyPanel.this.isShareBoundary()));
                if (change) {
                    v8 = GeometryLayerPropertyPanel.access$000(GeometryLayerPropertyPanel.this);
                    GeometryLayerPropertyPanel.access$000(GeometryLayerPropertyPanel.this);
                    v8.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn", GeometryLayerPropertyPanel.this.getGeometryColumn());
                    v9 = GeometryLayerPropertyPanel.access$000(GeometryLayerPropertyPanel.this);
                    GeometryLayerPropertyPanel.access$000(GeometryLayerPropertyPanel.this);
                    v9.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keyColumn", GeometryLayerPropertyPanel.this.getKeyColumn());
                    v10 = GeometryLayerPropertyPanel.access$000(GeometryLayerPropertyPanel.this);
                    GeometryLayerPropertyPanel.access$000(GeometryLayerPropertyPanel.this);
                    v10.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.queryCondition", GeometryLayerPropertyPanel.this.getQueryCondition());
                    GeometryLayerPropertyPanel.access$000(GeometryLayerPropertyPanel.this).buildDataSet();
                }
            }
        });
        JPanel tab1 = new JPanel();
        tab1.setLayout(new GridBagLayout());
        int y = 0;
        tab1.add((Component)this.nameLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        tab1.add((Component)this.nameTxt, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        tab1.add((Component)this.basetableLabel, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        tab1.add((Component)this.basetableTxt, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        tab1.add((Component)this.serverLabel, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        tab1.add((Component)this.serverTxt, new GridBagConstraints(1, y, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        tab1.add((Component)this.keyColumnLabel, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        tab1.add((Component)this.keyColumnComboBox, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        tab1.add((Component)this.geomColumnLabel, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        tab1.add((Component)this.geomColumnComboBox, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        tab1.add((Component)this.conditionLabel, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        tab1.add((Component)this.conditionTxt, new GridBagConstraints(1, y, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        tab1.add((Component)this.livescaleLabel, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        tab1.add((Component)this.livescaleTxt, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        tab1.add((Component)this.labelCheckBox, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        tab1.add((Component)this.labelComboBox, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        tab1.add((Component)this.keySequenceCheckBox, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        tab1.add((Component)this.keySequenceComboBox, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        tab1.add((Component)this.shareBoundaryBox, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        tab1.add((Component)this.keySequenceCreate, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        tab1.add((Component)this.applyButton, new GridBagConstraints(0, ++y, 2, 1, 1.0, 0.0, 10, 0, new Insets(5, 0, 0, 5), 0, 0));
        JPanel tab2 = new JPanel();
        tab2.setLayout(new GridBagLayout());
        JLabel mvRenderLabel = new JLabel("Render on Mapviewer when");
        boolean renderOnMV = Boolean.parseBoolean(this.sessionLayer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.renderOnMapviewer"));
        JCheckBox noneditMVRenderCB = new JCheckBox("Not editable", renderOnMV);
        noneditMVRenderCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox cb = (JCheckBox)e.getSource();
                GeometrySetLayer geometrySetLayer = GeometryLayerPropertyPanel.this.sessionLayer;
                GeometryLayerPropertyPanel.this.sessionLayer;
                geometrySetLayer.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.renderOnMapviewer", Boolean.toString(cb.isSelected()));
            }
        });
        double liveScale = Double.NaN;
        if (this.sessionLayer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.liveScale") != null) {
            try {
                liveScale = Double.parseDouble(this.sessionLayer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.liveScale"));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        JCheckBox scaleMVRenderCB = new JCheckBox("Scale is greater than:", !Double.isNaN(liveScale));
        scaleMVRenderCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox cb = (JCheckBox)e.getSource();
                String newVal = Double.toString(Double.NaN);
                if (cb.isSelected()) {
                    try {
                        newVal = GeometryLayerPropertyPanel.this.scaleMVRenderTF.getValue().toString();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                GeometryLayerPropertyPanel.this.scaleMVRenderTF.setEnabled(cb.isSelected());
                GeometrySetLayer geometrySetLayer = GeometryLayerPropertyPanel.this.sessionLayer;
                GeometryLayerPropertyPanel.this.sessionLayer;
                geometrySetLayer.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.liveScale", newVal);
            }
        });
        this.scaleMVRenderTF.setValue(Double.isNaN(liveScale) ? null : Double.valueOf(liveScale));
        this.scaleMVRenderTF.setEnabled(!Double.isNaN(liveScale));
        this.scaleMVRenderTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFormattedTextField tf = (JFormattedTextField)e.getSource();
                try {
                    tf.commitEdit();
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.scaleMVRenderTF.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("value")) {
                    JFormattedTextField tf = (JFormattedTextField)e.getSource();
                    try {
                        GeometrySetLayer geometrySetLayer = GeometryLayerPropertyPanel.this.sessionLayer;
                        GeometryLayerPropertyPanel.this.sessionLayer;
                        geometrySetLayer.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.liveScale", e.getNewValue().toString());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        y = 0;
        tab2.add((Component)mvRenderLabel, new GridBagConstraints(0, y, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        tab2.add((Component)noneditMVRenderCB, new GridBagConstraints(0, ++y, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        JTabbedPane tabPane = new JTabbedPane();
        tabPane.addTab("Data Set", tab1);
        tabPane.addTab("Rendering", tab2);
        this.add((Component)tabPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.fillUIparameters();
        this.updateLabelFieldsStatus();
    }

    public void allowLabelChanges(boolean allow) {
        this.allowLabelChanges = allow;
        this.updateLabelFieldsStatus();
    }

    private void updateLabelFieldsStatus() {
        this.labelCheckBox.setEnabled(this.allowLabelChanges);
        this.labelComboBox.setEnabled(this.allowLabelChanges);
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            this.nameTxt.setText("");
        } else {
            this.nameTxt.setText(name);
        }
    }

    public String getGeometryColumn() {
        if (this.geomColumnComboBox.getItemCount() < 1) {
            return null;
        }
        return this.geomColumnComboBox.getSelectedItem().toString();
    }

    public String getLabelColumn() {
        if (this.labelComboBox.getItemCount() < 1) {
            return null;
        }
        return this.labelComboBox.getSelectedItem().toString();
    }

    public boolean isLabelSelected() {
        return this.labelCheckBox.isSelected();
    }

    public void setLabelSelected(boolean select) {
        this.labelCheckBox.setSelected(select);
    }

    public void setGeometryColumns(String[] columns) {
        this.geomColumnComboBox.removeAllItems();
        if (columns == null || columns.length == 0) {
            return;
        }
        for (int i = 0; i < columns.length; ++i) {
            this.geomColumnComboBox.addItem(columns[i].toUpperCase());
        }
    }

    public void setGeometryColumn(String geomCol) {
        if (geomCol == null) {
            return;
        }
        this.geomColumnComboBox.setSelectedItem(geomCol.toUpperCase());
    }

    public void setLabelColumns(String[] columns) {
        this.labelComboBox.removeAllItems();
        if (this.addROWIDtolist()) {
            this.labelComboBox.addItem("ROWID");
        }
        if (columns == null) {
            return;
        }
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].equalsIgnoreCase("ROWID")) continue;
            this.labelComboBox.addItem(columns[i].toUpperCase());
        }
    }

    public void setLabelColumn(String labelCol) {
        if (labelCol == null) {
            return;
        }
        this.labelComboBox.setSelectedItem(labelCol.toUpperCase());
    }

    private void fillUIparameters() {
        if (this.sessionLayer == null) {
            return;
        }
        this.setName(this.sessionLayer.getName());
        String serverURL = this.sessionLayer.getProperty("oracle.lbs.mapviewer.serverURL");
        this.serverTxt.setText(serverURL);
        String basetable = this.sessionLayer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable");
        this.basetableTxt.setText(basetable);
        String geomColumn = this.sessionLayer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn");
        String[] geomAttrs = this.spatialColumns;
        this.setGeometryColumns(geomAttrs);
        this.setGeometryColumn(geomColumn);
        String[] seqs = this.seqNames;
        this.setKeySequences(seqs);
        String seqName = this.sessionLayer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keySequence");
        this.setKeySequence(seqName);
        if (seqName != null) {
            this.setKeySequenceSelected(true);
        } else {
            this.setKeySequenceSelected(false);
            this.setKeySequence(basetable + "_" + this.sessionLayer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keyColumn") + "_SEQ");
        }
        String[] attrs = this.tableAttrs;
        this.setKeyColumns(attrs);
        this.setKeyColumn(this.sessionLayer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keyColumn"));
        this.setLabelColumns(attrs);
        this.setLabelSelected(false);
        String labelCol = this.sessionLayer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.labelColumn");
        if (labelCol != null && !labelCol.equalsIgnoreCase("null")) {
            this.setLabelColumn(labelCol);
            if (((String)this.labelComboBox.getSelectedItem()).equalsIgnoreCase(labelCol)) {
                this.setLabelSelected(true);
            }
        } else {
            this.setLabelSelected(false);
        }
        this.setQueryCondition(this.sessionLayer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.queryCondition"));
        String sharedBoundary = this.sessionLayer.getProperty("oracle.spatial.edit.layer.GeometrySetLayer.shareboundary");
        if (sharedBoundary != null && sharedBoundary.equalsIgnoreCase("true")) {
            this.setShareBoundary(true);
        } else {
            this.setShareBoundary(false);
        }
    }

    public void setKeyColumns(String[] colnames) {
        this.keyColumnComboBox.removeAllItems();
        if (this.addROWIDtolist()) {
            this.keyColumnComboBox.addItem("ROWID");
        }
        if (colnames == null) {
            return;
        }
        for (int i = 0; i < colnames.length; ++i) {
            if (colnames[i].equalsIgnoreCase("ROWID")) continue;
            this.keyColumnComboBox.addItem(colnames[i].toUpperCase());
        }
    }

    public void setKeyColumn(String colname) {
        if (colname == null) {
            return;
        }
        this.keyColumnComboBox.setSelectedItem(colname.toUpperCase());
    }

    public String getKeyColumn() {
        if (this.keyColumnComboBox.getItemCount() == 0) {
            return null;
        }
        return this.keyColumnComboBox.getSelectedItem().toString();
    }

    public void setKeySequences(String[] seqs) {
        this.keySequenceComboBox.removeAllItems();
        this.keySequenceComboBox.setEnabled(false);
        this.keySequenceCheckBox.setEnabled(false);
        if (seqs == null || seqs.length == 0) {
            return;
        }
        for (int i = 0; i < seqs.length; ++i) {
            if (seqs[i].toUpperCase().startsWith("MDRS_") && seqs[i].toUpperCase().endsWith("$")) continue;
            this.keySequenceComboBox.addItem(seqs[i].toUpperCase());
            this.keySequenceComboBox.setEnabled(true);
            this.keySequenceCheckBox.setEnabled(true);
        }
    }

    public void setKeySequence(String seqname) {
        if (seqname == null) {
            return;
        }
        this.keySequenceComboBox.setSelectedItem(seqname.toUpperCase());
    }

    public void setKeySequenceSelected(boolean selected) {
        this.keySequenceCheckBox.setSelected(selected);
    }

    public boolean isKeySequenceSelected() {
        return this.keySequenceCheckBox.isSelected();
    }

    public String getKeySequence() {
        if (this.keySequenceComboBox.getItemCount() == 0) {
            return null;
        }
        return this.keySequenceComboBox.getSelectedItem().toString();
    }

    public void isEditingMode(boolean mode) {
        if (mode) {
            this.keyColumnComboBox.setEnabled(false);
            this.geomColumnComboBox.setEnabled(false);
            this.conditionTxt.setEnabled(false);
        } else {
            this.keyColumnComboBox.setEnabled(true);
            this.geomColumnComboBox.setEnabled(true);
            this.conditionTxt.setEnabled(true);
        }
    }

    public boolean isShareBoundary() {
        return this.shareBoundaryBox.isSelected();
    }

    public void setShareBoundary(boolean share) {
        this.shareBoundaryBox.setSelected(share);
    }

    public double getLiveScale() {
        String text = this.livescaleTxt.getText();
        if (text == null || text.length() == 0) {
            return 0.0;
        }
        NumberFormat nf = NumberFormat.getInstance();
        try {
            double scale = nf.parse(text).doubleValue();
            if (scale <= 0.0) {
                return Double.NaN;
            }
            return scale;
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public void setLiveScale(double scale) {
        if (Double.isNaN(scale)) {
            this.livescaleTxt.setText("");
        } else {
            NumberFormat nf = NumberFormat.getInstance();
            this.livescaleTxt.setText(nf.format(scale));
        }
    }

    public void setQueryCondition(String filter) {
        if (filter == null) {
            this.conditionTxt.setText("");
        } else {
            this.conditionTxt.setText(filter);
        }
    }

    public String getQueryCondition() {
        if (this.conditionTxt.getText() == null) {
            return null;
        }
        String filter = this.conditionTxt.getText().trim();
        if (filter.length() == 0) {
            return null;
        }
        return filter;
    }

    public void setMapViewerServer(String serverURL) {
        if (serverURL == null) {
            this.serverTxt.setText("");
        } else {
            this.serverTxt.setText(serverURL);
        }
    }

    public String getMapViewerServer() {
        String url = this.serverTxt.getText();
        if (url != null && url.trim().isEmpty()) {
            url = null;
        }
        return url;
    }

    private boolean addROWIDtolist() {
        if (this.sessionLayer == null || this.sessionLayer.getDataSet() == null) {
            return false;
        }
        String[] attrList = this.sessionLayer.getDataSet().getAttributeNames();
        if (attrList == null || attrList.length == 0) {
            return false;
        }
        for (int i = 0; i < attrList.length; ++i) {
            if (!"rowid".equalsIgnoreCase(attrList[i])) continue;
            return true;
        }
        return false;
    }
}

