/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.model.topology;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.undo.UndoManager;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.TopoChildFeatureDescriptor;
import oracle.mapviewer.share.TopoPrimitiveDescriptor;
import oracle.mapviewer.share.TopologyEdge;
import oracle.mapviewer.share.TopologyFace;
import oracle.mapviewer.share.TopologyMetadata;
import oracle.mapviewer.share.TopologyNode;
import oracle.mapviewer.share.TopologyPrimitives;
import oracle.mapviewer.share.TopologyRelation;
import oracle.sdovis.edit.util.GeometryUtil;
import oracle.spatial.edit.index.AbstractSpatialIndex;
import oracle.spatial.edit.index.topology.IndexedTopologyModel;
import oracle.spatial.edit.model.AbstractDataAccessObject;
import oracle.spatial.edit.model.AbstractDataModel;
import oracle.spatial.edit.model.MDSException;
import oracle.spatial.edit.model.topology.TopologyFeature;
import oracle.spatial.edit.model.topology.TopologyGeometry;
import oracle.spatial.edit.model.topology.TopologySet;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.topo.Edge;
import oracle.spatial.topo.Face;
import oracle.spatial.topo.InvalidTopoOperationException;
import oracle.spatial.topo.Node;
import oracle.spatial.topo.Point2DD;
import oracle.spatial.topo.TopoEntityNotFoundException;
import oracle.spatial.topo.TopoPrimitives;

public class TopologyModel
extends AbstractDataModel {
    private UndoManager um = null;
    protected TopologyMetadata metadata = null;
    protected TopologyMetadata[] layersMetadata = null;
    protected TopoPrimitives topoData = null;
    private Hashtable<String, TopologySet> topologySets = new Hashtable();
    private IndexedTopologyModel indexedModel = null;

    public TopologyModel(String name, UndoManager um) {
        this.modelName = name;
        this.type = AbstractDataModel.TOPOLOGY_MODEL;
        this.um = um;
    }

    @Override
    public String getName() {
        return this.modelName;
    }

    public TopologyMetadata getTopologyMetadata() {
        return this.metadata;
    }

    public TopologyMetadata getLayerMetadata(int layerId) {
        if (this.layersMetadata == null) {
            return null;
        }
        for (int i = 0; i < this.layersMetadata.length; ++i) {
            if (this.layersMetadata[i].getTopoLayerId() != layerId) continue;
            return this.layersMetadata[i];
        }
        return null;
    }

    public void setIndexedModel(IndexedTopologyModel idxModel) {
        this.indexedModel = idxModel;
    }

    public IndexedTopologyModel getIndexedModel() {
        return this.indexedModel;
    }

    @Override
    public boolean load(AbstractDataAccessObject dataAccess, Rectangle2D mbr, String workspace, int mode) throws Exception, MDSException {
        TopologyPrimitives univface;
        if (this.modelName == null) {
            throw new Exception("Topology model name is null.");
        }
        this.clearModel();
        if (dataAccess == null) {
            throw new Exception("Unable to get data access object.");
        }
        if (!dataAccess.openConnection()) {
            throw new Exception("Unable to open data access connection.");
        }
        if (this.metadata == null) {
            this.metadata = dataAccess.loadTopologyMetadata(this.modelName, null, null);
        }
        if (this.metadata == null) {
            this.clearModel();
            dataAccess.closeConnection();
            throw new Exception("Unable to load topology metadata.");
        }
        if (this.layersMetadata == null) {
            this.layersMetadata = dataAccess.loadTopologyLayersMetadata(this.modelName);
        }
        TopologyPrimitives primitives = dataAccess.loadTopologyPrimitives(this.modelName, mbr, this.layer.getWorkspace());
        int decimalDigitsPrecision = 16;
        if (this.metadata != null) {
            decimalDigitsPrecision = this.metadata.getDigitsRightOfDecimal();
        }
        if (this.topoData == null) {
            this.topoData = new TopoPrimitives(100, 100, 100, decimalDigitsPrecision, this.um);
        }
        this.topoData.setTopologyModel(this);
        this.topoData.setSrid((int)this.metadata.getSrid());
        if (primitives != null) {
            TopologyFace[] faces;
            TopologyEdge[] edges;
            TopologyNode[] nodes = primitives.getNodes();
            if (nodes != null && nodes.length > 0) {
                for (int i = 0; i < nodes.length; ++i) {
                    this.insertNode(nodes[i]);
                }
            }
            if ((edges = primitives.getEdges()) != null && edges.length > 0) {
                for (int i = 0; i < edges.length; ++i) {
                    this.insertEdge(edges[i]);
                }
            }
            if ((faces = primitives.getFaces()) != null && faces.length > 0) {
                for (int i = 0; i < faces.length; ++i) {
                    this.insertFace(faces[i]);
                }
            }
        }
        if (this.topoData.getFace(-1) == null && (univface = dataAccess.loadTopologyPrimitives(this.modelName, new int[]{-1}, null, null, this.layer.getWorkspace())) != null) {
            TopologyFace face = univface.getFace(0);
            this.topoData.insertFace(face.getId(), face.getBoundaryEdge(), face.getIslandEdges(), face.getIslandNodes(), null, false);
        }
        this.topoData.createEdgeIndex();
        this.topoData.createFaceIndex();
        this.mode = mode;
        dataAccess.closeConnection();
        return true;
    }

    @Override
    public boolean save() throws Exception, MDSException {
        AbstractDataAccessObject dataAccess = this.layer.getDataSource().getDataAccessObject();
        if (this.mode != READ_WRITE_SET || dataAccess == null) {
            return false;
        }
        if (!this.isModified()) {
            return false;
        }
        boolean save = dataAccess.saveDataModel(this);
        if (!save) {
            return false;
        }
        Enumeration<TopologySet> enumer = this.topologySets.elements();
        while (enumer.hasMoreElements()) {
            TopologySet set = enumer.nextElement();
            set.clearChanges();
        }
        this.clearChanges();
        return true;
    }

    @Override
    public void clearModel() {
        this.topoData = null;
        this.metadata = null;
        this.layersMetadata = null;
    }

    @Override
    public boolean isModified() {
        if (this.topoData == null) {
            return false;
        }
        if (this.hasNodeChanges()) {
            return true;
        }
        if (this.hasEdgeChanges()) {
            return true;
        }
        return this.hasFaceChanges();
    }

    public boolean hasNodeChanges() {
        if (this.topoData == null) {
            return false;
        }
        ArrayList nodeAdditions = this.topoData.getNodeAdditions();
        if (nodeAdditions != null && nodeAdditions.size() > 0) {
            return true;
        }
        ArrayList nodeDeletions = this.topoData.getNodeDeletions();
        if (nodeDeletions != null && nodeDeletions.size() > 0) {
            return true;
        }
        ArrayList nodeChanges = this.topoData.getNodeChanges();
        return nodeChanges != null && nodeChanges.size() > 0;
    }

    public boolean hasEdgeChanges() {
        if (this.topoData == null) {
            return false;
        }
        ArrayList edgeAdditions = this.topoData.getEdgeAdditions();
        if (edgeAdditions != null && edgeAdditions.size() > 0) {
            return true;
        }
        ArrayList edgeDeletions = this.topoData.getEdgeDeletions();
        if (edgeDeletions != null && edgeDeletions.size() > 0) {
            return true;
        }
        ArrayList edgeChanges = this.topoData.getEdgeChanges();
        return edgeChanges != null && edgeChanges.size() > 0;
    }

    public boolean hasFaceChanges() {
        if (this.topoData == null) {
            return false;
        }
        ArrayList faceAdditions = this.topoData.getFaceAdditions();
        if (faceAdditions != null && faceAdditions.size() > 0) {
            return true;
        }
        ArrayList faceDeletions = this.topoData.getFaceDeletions();
        if (faceDeletions != null && faceDeletions.size() > 0) {
            return true;
        }
        ArrayList faceChanges = this.topoData.getFaceChanges();
        return faceChanges != null && faceChanges.size() > 0;
    }

    @Override
    public void startChangeBlock() {
    }

    @Override
    public void endChangeBlock() {
    }

    @Override
    public void undo() throws Exception {
    }

    @Override
    public void clearChanges() {
        if (this.topoData == null) {
            return;
        }
        this.topoData.clearChanges();
    }

    private int getIntAbsValue(String value) {
        if (value == null) {
            return 0;
        }
        int v = 0;
        try {
            v = (int)Double.parseDouble(value);
            return Math.abs(v);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public Node getNode(int node) {
        if (this.topoData == null) {
            return null;
        }
        try {
            Node nd = this.topoData.getNode(node);
            return nd;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Edge getEdge(int edge) {
        if (this.topoData == null) {
            return null;
        }
        try {
            Edge ed = this.topoData.getEdge(edge);
            return ed;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Face getFace(int face) {
        if (this.topoData == null) {
            return null;
        }
        try {
            Face fc = this.topoData.getFace(face);
            return fc;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Rectangle2D getNodeMBR(int node) {
        if (this.topoData == null) {
            return null;
        }
        return this.topoData.getNodeMBR(node);
    }

    public Rectangle2D getEdgeMBR(int edge) {
        if (this.topoData == null) {
            return null;
        }
        return this.topoData.getEdgeMBR(edge);
    }

    public Rectangle2D getFaceMBR(int face) {
        if (this.topoData == null) {
            return null;
        }
        return this.topoData.getFaceMBR(face);
    }

    public JGeometry getFaceMBRGeometry(int face) {
        Rectangle2D mbr = this.getFaceMBR(face);
        if (mbr == null) {
            return null;
        }
        return new JGeometry(mbr.getMinX(), mbr.getMinY(), mbr.getMaxX(), mbr.getMaxY(), (int)this.metadata.getSrid());
    }

    public JGeometry getFaceGeometry(int face) {
        JGeometry geom = null;
        Face fc = this.getFace(face);
        if (fc == null) {
            return null;
        }
        int bdedge = fc.getBoundaryEdge();
        Edge e = this.getEdge(Math.abs(bdedge));
        int startEdge = e.getId();
        int nextEdge = -1;
        nextEdge = e.getBoundedFaceL() == fc.getID() ? e.getNextEdgeL() : e.getNextEdgeR();
        double[] oords = this.getEdgeOords(e);
        if (bdedge < 0) {
            oords = GeometryUtil.reverseCoordinates((double[])oords, (int)2);
        }
        if (e.getOriginNode() == e.getEndNode()) {
            if (GeometryUtil.isClockwise((double[])oords)) {
                oords = GeometryUtil.reverseCoordinates((double[])oords, (int)2);
            }
        } else {
            Vector<Point2DD> points = new Vector<Point2DD>();
            for (int i = 0; i < oords.length / 2; ++i) {
                points.add(new Point2DD(oords[2 * i], oords[2 * i + 1]));
            }
            while (Math.abs(nextEdge) != Math.abs(startEdge)) {
                int j;
                Edge ne = this.getEdge(Math.abs(nextEdge));
                double[] neoords = this.getEdgeOords(ne);
                if (nextEdge > 0) {
                    for (j = 1; j < neoords.length / 2; ++j) {
                        points.add(new Point2DD(neoords[2 * j], neoords[2 * j + 1]));
                    }
                } else {
                    for (j = neoords.length / 2 - 2; j >= 0; --j) {
                        points.add(new Point2DD(neoords[2 * j], neoords[2 * j + 1]));
                    }
                }
                if (ne.getBoundedFaceL() == fc.getID()) {
                    nextEdge = ne.getNextEdgeL();
                    continue;
                }
                nextEdge = ne.getNextEdgeR();
            }
            Point2DD[] p2ds = points.toArray(new Point2DD[points.size()]);
            oords = new double[p2ds.length * 2];
            for (int i = 0; i < p2ds.length; ++i) {
                oords[i * 2] = p2ds[i].getX();
                oords[i * 2 + 1] = p2ds[i].getY();
            }
        }
        int[] elemInfo = new int[]{1, 1003, 1};
        geom = new JGeometry(2003, (int)this.metadata.getSrid(), elemInfo, oords);
        return geom;
    }

    private double[] getEdgeOords(Edge e) {
        if (e == null) {
            return null;
        }
        Point2DD[] pts = e.getCoords();
        double[] oords = new double[pts.length * 2];
        for (int i = 0; i < pts.length; ++i) {
            oords[i * 2] = pts[i].getX();
            oords[i * 2 + 1] = pts[i].getY();
        }
        return oords;
    }

    public JGeometry getEdgeGeometry(int edge) {
        try {
            Edge e = this.getEdge(Math.abs(edge));
            double[] oords = this.getEdgeOords(e);
            if (oords == null) {
                return null;
            }
            int[] elemInfo = new int[]{1, 2, 1};
            return new JGeometry(2002, (int)this.metadata.getSrid(), elemInfo, oords);
        }
        catch (Exception e) {
            return null;
        }
    }

    public JGeometry getNodeGeometry(int node) {
        try {
            Node n = this.getNode(node);
            Point2DD coord = n.getCoord();
            return new JGeometry(coord.getX(), coord.getY(), (int)this.metadata.getSrid());
        }
        catch (Exception e) {
            return null;
        }
    }

    public int[] getNodeStar(int node) {
        if (this.topoData == null) {
            return null;
        }
        try {
            int[] ns = this.topoData.getNodeStar(node);
            return ns;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Edge[] searchEdges(Rectangle2D rect) {
        if (rect == null || this.topoData == null) {
            return null;
        }
        double[][] mbr = new double[2][2];
        mbr[0][0] = rect.getMinX();
        mbr[0][1] = rect.getMaxX();
        mbr[1][0] = rect.getMinY();
        mbr[1][1] = rect.getMaxY();
        ArrayList edges = new ArrayList();
        this.topoData.searchEdgeRTree(mbr, edges);
        if (edges != null && edges.size() > 0) {
            return edges.toArray(new Edge[edges.size()]);
        }
        return null;
    }

    public Face[] searchFaces(Rectangle2D rect) {
        if (rect == null || this.topoData == null) {
            return null;
        }
        double[][] mbr = new double[2][2];
        mbr[0][0] = rect.getMinX();
        mbr[0][1] = rect.getMaxX();
        mbr[1][0] = rect.getMinY();
        mbr[1][1] = rect.getMaxY();
        ArrayList faces = new ArrayList();
        this.topoData.searchFaceRTree(mbr, faces);
        if (faces != null && faces.size() > 0) {
            return faces.toArray(new Face[faces.size()]);
        }
        return null;
    }

    public Hashtable<String, Integer> getDeletedNodes() {
        if (this.topoData == null) {
            return null;
        }
        ArrayList list = this.topoData.getNodeDeletions();
        if (list == null || list.size() == 0) {
            return null;
        }
        Hashtable<String, Integer> delNodes = new Hashtable<String, Integer>();
        for (int i = 0; i < list.size(); ++i) {
            Integer node = (Integer)list.get(i);
            delNodes.put(String.valueOf(node), node);
        }
        return delNodes;
    }

    public Hashtable<String, Integer> getDeletedEdges() {
        if (this.topoData == null) {
            return null;
        }
        ArrayList list = this.topoData.getEdgeDeletions();
        if (list == null || list.size() == 0) {
            return null;
        }
        Hashtable<String, Integer> delEdges = new Hashtable<String, Integer>();
        for (int i = 0; i < list.size(); ++i) {
            Integer edge = (Integer)list.get(i);
            delEdges.put(String.valueOf(edge), edge);
        }
        return delEdges;
    }

    public Hashtable<String, Integer> getDeletedFaces() {
        if (this.topoData == null) {
            return null;
        }
        ArrayList list = this.topoData.getFaceDeletions();
        if (list == null || list.size() == 0) {
            return null;
        }
        Hashtable<String, Integer> delFaces = new Hashtable<String, Integer>();
        for (int i = 0; i < list.size(); ++i) {
            Integer face = (Integer)list.get(i);
            delFaces.put(String.valueOf(face), face);
        }
        return delFaces;
    }

    public Hashtable<String, Node> getAddedNodes() {
        if (this.topoData == null) {
            return null;
        }
        ArrayList list = this.topoData.getNodeAdditions();
        if (list == null || list.size() == 0) {
            return null;
        }
        Hashtable<String, Node> addNodes = new Hashtable<String, Node>();
        for (int i = 0; i < list.size(); ++i) {
            Integer node = (Integer)list.get(i);
            addNodes.put(String.valueOf(node), this.getNode(node));
        }
        return addNodes;
    }

    public Hashtable<String, Edge> getAddedEdges() {
        if (this.topoData == null) {
            return null;
        }
        ArrayList list = this.topoData.getEdgeAdditions();
        if (list == null || list.size() == 0) {
            return null;
        }
        Hashtable<String, Edge> addEdges = new Hashtable<String, Edge>();
        for (int i = 0; i < list.size(); ++i) {
            Integer edge = (Integer)list.get(i);
            addEdges.put(String.valueOf(edge), this.getEdge(edge));
        }
        return addEdges;
    }

    public Hashtable<String, Face> getAddedFaces() {
        if (this.topoData == null) {
            return null;
        }
        ArrayList list = this.topoData.getFaceAdditions();
        if (list == null || list.size() == 0) {
            return null;
        }
        Hashtable<String, Face> addFaces = new Hashtable<String, Face>();
        for (int i = 0; i < list.size(); ++i) {
            Integer face = (Integer)list.get(i);
            addFaces.put(String.valueOf(face), this.getFace(face));
        }
        return addFaces;
    }

    public Hashtable<String, Node> getChangedNodes() {
        if (this.topoData == null) {
            return null;
        }
        ArrayList list = this.topoData.getNodeChanges();
        if (list == null || list.size() == 0) {
            return null;
        }
        Hashtable<String, Node> changeNodes = new Hashtable<String, Node>();
        for (int i = 0; i < list.size(); ++i) {
            Integer node = (Integer)list.get(i);
            changeNodes.put(String.valueOf(node), this.getNode(node));
        }
        return changeNodes;
    }

    public Hashtable<String, Edge> getChangedEdges() {
        if (this.topoData == null) {
            return null;
        }
        ArrayList list = this.topoData.getEdgeChanges();
        if (list == null || list.size() == 0) {
            return null;
        }
        Hashtable<String, Edge> changeEdges = new Hashtable<String, Edge>();
        for (int i = 0; i < list.size(); ++i) {
            Integer edge = (Integer)list.get(i);
            changeEdges.put(String.valueOf(edge), this.getEdge(edge));
        }
        return changeEdges;
    }

    public Hashtable<String, Face> getChangedFaces() {
        if (this.topoData == null) {
            return null;
        }
        ArrayList list = this.topoData.getFaceChanges();
        if (list == null || list.size() == 0) {
            return null;
        }
        Hashtable<String, Face> changeFaces = new Hashtable<String, Face>();
        for (int i = 0; i < list.size(); ++i) {
            Integer face = (Integer)list.get(i);
            changeFaces.put(String.valueOf(face), this.getFace(face));
        }
        return changeFaces;
    }

    public boolean insertNode(TopologyNode node) {
        Point2D pt;
        if (node == null) {
            return false;
        }
        Point2DD coord = null;
        if (node.getGeometry() != null && (pt = node.getGeometry().getJavaPoint()) != null) {
            coord = new Point2DD(pt.getX(), pt.getY());
        }
        try {
            this.topoData.insertNode(node.getId(), node.getStartEdge(), node.getContainFace(), coord);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public boolean insertEdge(TopologyEdge edge) {
        double[] oords;
        if (edge == null) {
            return false;
        }
        Point2DD[] coords = null;
        if (edge.getGeometry() != null && (oords = edge.getGeometry().getOrdinatesArray()) != null && oords.length > 0) {
            int dim = edge.getGeometry().getDimensions();
            int npts = oords.length / dim;
            coords = new Point2DD[npts];
            for (int j = 0; j < npts; ++j) {
                coords[j] = new Point2DD(oords[j * dim], oords[j * dim + 1]);
            }
        }
        try {
            this.topoData.insertEdge(edge.getId(), edge.getOriginNode(), edge.getEndNode(), edge.getBoundedFaceL(), edge.getBoundedFaceR(), edge.getNextEdgeL(), edge.getPrevEdgeL(), edge.getNextEdgeR(), edge.getPrevEdgeR(), coords, false);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public boolean insertFace(TopologyFace face) {
        Rectangle2D mbrface;
        if (face == null) {
            return false;
        }
        Point2DD[] facembr = null;
        if (face.getMBRgeometry() != null && (mbrface = face.getMBR()) != null) {
            facembr = new Point2DD[]{new Point2DD(mbrface.getMinX(), mbrface.getMinY()), new Point2DD(mbrface.getMaxX(), mbrface.getMaxY())};
        }
        try {
            this.topoData.insertFace(face.getId(), face.getBoundaryEdge(), face.getIslandEdges(), face.getIslandNodes(), facembr, false);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public int getNextNodeID() throws Exception {
        AbstractDataAccessObject dataAccess = this.layer.getDataSource().getDataAccessObject();
        if (dataAccess == null) {
            throw new Exception("Data access is null.");
        }
        if (this.metadata == null) {
            throw new Exception("Metadata is null.");
        }
        try {
            int nextId;
            dataAccess.openConnection();
            int n = nextId = (int)dataAccess.getSequenceNextValue(this.metadata.getNodeSequence());
            return n;
        }
        catch (Exception ex) {
            throw ex;
        }
        catch (MDSException me) {
            throw new Exception(me.getMessage());
        }
        finally {
            try {
                dataAccess.closeConnection();
            }
            catch (Exception e) {}
        }
    }

    public int getNextEdgeID() throws Exception {
        AbstractDataAccessObject dataAccess = this.layer.getDataSource().getDataAccessObject();
        if (dataAccess == null) {
            throw new Exception("Data access is null.");
        }
        if (this.metadata == null) {
            throw new Exception("Metadata is null.");
        }
        try {
            int nextId;
            dataAccess.openConnection();
            int n = nextId = (int)dataAccess.getSequenceNextValue(this.metadata.getEdgeSequence());
            return n;
        }
        catch (Exception ex) {
            throw ex;
        }
        catch (MDSException me) {
            throw new Exception(me.getMessage());
        }
        finally {
            try {
                dataAccess.closeConnection();
            }
            catch (Exception e) {}
        }
    }

    public int getNextFaceID() throws Exception {
        AbstractDataAccessObject dataAccess = this.layer.getDataSource().getDataAccessObject();
        if (dataAccess == null) {
            throw new Exception("Data access is null.");
        }
        if (this.metadata == null) {
            throw new Exception("Metadata is null.");
        }
        try {
            int nextId;
            dataAccess.openConnection();
            int n = nextId = (int)dataAccess.getSequenceNextValue(this.metadata.getFaceSequence());
            return n;
        }
        catch (Exception ex) {
            throw ex;
        }
        catch (MDSException me) {
            throw new Exception(me.getMessage());
        }
        finally {
            try {
                dataAccess.closeConnection();
            }
            catch (Exception e) {}
        }
    }

    public boolean hasRelationsForTopologyPrimitive(int topoId, int topoType) throws Exception {
        AbstractDataAccessObject dataAccess = this.layer.getDataSource().getDataAccessObject();
        if (dataAccess == null) {
            throw new Exception("Topology model has no data access defined.");
        }
        try {
            dataAccess.openConnection();
            TopologyRelation[] relations = dataAccess.getRelationsForTopologyPrimitive(this.modelName, topoId, topoType, this.layer.getWorkspace());
            if (relations != null && relations.length > 0) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        catch (MDSException me) {
            throw new Exception(me.getMessage());
        }
        finally {
            try {
                dataAccess.closeConnection();
            }
            catch (Exception e) {}
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean edgesHaveMismatchOfFeatures(int edgeId, int nextedgeId) throws Exception {
        AbstractDataAccessObject dataAccess = this.layer.getDataSource().getDataAccessObject();
        if (dataAccess == null) {
            throw new Exception("Topology model has no data access defined.");
        }
        try {
            dataAccess.openConnection();
            TopologyRelation[] relations1 = dataAccess.getRelationsForTopologyPrimitive(this.modelName, edgeId, 2, this.layer.getWorkspace());
            TopologyRelation[] relations2 = dataAccess.getRelationsForTopologyPrimitive(this.modelName, nextedgeId, 2, this.layer.getWorkspace());
            if (relations1 == null) {
                if (relations2 == null) {
                    boolean bl = false;
                    return bl;
                }
                if (relations2.length > 0) {
                    boolean bl = true;
                    return bl;
                }
            }
            boolean edgeMismatch = false;
            for (int i = 0; i < relations1.length; ++i) {
                if (relations2 == null || i >= relations2.length) {
                    edgeMismatch = true;
                    break;
                }
                if (relations1[i].getLayerId() == relations2[i].getLayerId() && relations1[i].getFeatureId() == relations2[i].getFeatureId()) continue;
                edgeMismatch = true;
                break;
            }
            if (!edgeMismatch) {
                if (relations2.length <= relations1.length) return false;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            throw ex;
        }
        catch (MDSException me) {
            throw new Exception(me.getMessage());
        }
        finally {
            try {
                dataAccess.closeConnection();
            }
            catch (Exception e) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean facesHaveMismatchOfFeatures(int faceLeft, int faceRight) throws Exception {
        AbstractDataAccessObject dataAccess = this.layer.getDataSource().getDataAccessObject();
        if (dataAccess == null) {
            throw new Exception("Topology model has no data access defined.");
        }
        try {
            dataAccess.openConnection();
            TopologyRelation[] relations1 = dataAccess.getRelationsForTopologyPrimitive(this.modelName, faceLeft, 3, this.layer.getWorkspace());
            TopologyRelation[] relations2 = dataAccess.getRelationsForTopologyPrimitive(this.modelName, faceRight, 3, this.layer.getWorkspace());
            if (relations1 == null) {
                if (relations2 == null) {
                    boolean bl = false;
                    return bl;
                }
                if (relations2.length > 0) {
                    boolean bl = true;
                    return bl;
                }
            }
            boolean edgeMismatch = false;
            for (int i = 0; i < relations1.length; ++i) {
                if (relations2 == null || i >= relations2.length) {
                    edgeMismatch = true;
                    break;
                }
                if (relations1[i].getLayerId() == relations2[i].getLayerId() && relations1[i].getFeatureId() == relations2[i].getFeatureId()) continue;
                edgeMismatch = true;
                break;
            }
            if (!edgeMismatch) {
                if (relations2.length <= relations1.length) return false;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            throw ex;
        }
        catch (MDSException me) {
            throw new Exception(me.getMessage());
        }
        finally {
            try {
                dataAccess.closeConnection();
            }
            catch (Exception e) {}
        }
    }

    public void getTopologyPrimitives(Rectangle2D mbr, ArrayList nodes, ArrayList edges, ArrayList faces) {
        int i;
        if (this.topoData == null) {
            return;
        }
        if (nodes == null && edges == null && faces == null) {
            return;
        }
        double[][] searchMbr = new double[2][2];
        searchMbr[0][0] = mbr.getMinX();
        searchMbr[0][1] = mbr.getMaxX();
        searchMbr[1][0] = mbr.getMinY();
        searchMbr[1][1] = mbr.getMaxY();
        Hashtable<String, String> usedNodes = new Hashtable<String, String>();
        if (nodes != null || edges != null) {
            ArrayList edgeList = edges;
            if (edgeList == null) {
                edgeList = new ArrayList();
            }
            this.topoData.searchEdgeRTree(searchMbr, edgeList);
            if (edgeList != null && nodes != null) {
                for (i = 0; i < edgeList.size(); ++i) {
                    Node endNode;
                    int endNodeId;
                    Node startNode;
                    Edge e = (Edge)edgeList.get(i);
                    int startNodeId = e.getOriginNode();
                    if (usedNodes.get("" + startNodeId) == null && (startNode = this.getNode(startNodeId)) != null) {
                        if (mbr.contains(startNode.getCoord().getX(), startNode.getCoord().getY())) {
                            nodes.add(startNode);
                        }
                        usedNodes.put("" + startNodeId, "" + startNodeId);
                    }
                    if ((endNodeId = e.getEndNode()) == startNodeId || usedNodes.get("" + endNodeId) != null || (endNode = this.getNode(endNodeId)) == null) continue;
                    if (mbr.contains(endNode.getCoord().getX(), endNode.getCoord().getY())) {
                        nodes.add(endNode);
                    }
                    usedNodes.put("" + endNodeId, "" + endNodeId);
                }
            }
        }
        if (nodes != null || faces != null) {
            int[] islandNodes;
            Face uf;
            ArrayList faceList = faces;
            if (faceList == null) {
                faceList = new ArrayList();
            }
            this.topoData.searchFaceRTree(searchMbr, faceList);
            if (faceList != null && nodes != null) {
                for (i = 0; i < faceList.size(); ++i) {
                    Face f = (Face)faceList.get(i);
                    int[] islandNodes2 = f.getIslandNodes();
                    if (islandNodes2 == null || islandNodes2.length <= 0) continue;
                    for (int j = 0; j < islandNodes2.length; ++j) {
                        Node nd = this.getNode(islandNodes2[j]);
                        if (mbr.contains(nd.getCoord().getX(), nd.getCoord().getY()) && usedNodes.get("" + islandNodes2[j]) == null) {
                            nodes.add(nd);
                        }
                        usedNodes.put("" + islandNodes2[j], "" + islandNodes2[j]);
                    }
                }
            }
            if (nodes != null && (uf = this.getFace(-1)) != null && (islandNodes = uf.getIslandNodes()) != null && islandNodes.length > 0) {
                for (int j = 0; j < islandNodes.length; ++j) {
                    Node nd = this.getNode(islandNodes[j]);
                    if (mbr.contains(nd.getCoord().getX(), nd.getCoord().getY()) && usedNodes.get("" + islandNodes[j]) == null) {
                        nodes.add(nd);
                    }
                    usedNodes.put("" + islandNodes[j], "" + islandNodes[j]);
                }
            }
        }
    }

    public boolean addPrimitiveGeometry(JGeometry primitive) throws Exception {
        if (primitive == null || primitive.getType() != 1 && primitive.getType() != 2 && primitive.getType() != 3) {
            throw new Exception("Invalid geometry: null or not a geometry type (point, line, or polygon).");
        }
        int decimalDigitsPrecision = 16;
        if (this.metadata != null) {
            decimalDigitsPrecision = this.metadata.getDigitsRightOfDecimal();
        }
        if (this.topoData == null) {
            this.topoData = new TopoPrimitives(100, 100, 100, decimalDigitsPrecision, this.um);
            this.topoData.setTopologyModel(this);
            this.topoData.setSrid(primitive.getSRID());
        }
        try {
            if (primitive.getType() == 1) {
                int nodeid = this.topoData.addPointGeometry(primitive);
            } else if (primitive.getType() == 2) {
                int[] edgeIds = this.topoData.addLinearGeometry(primitive);
            } else if (primitive.getType() == 3) {
                int[] faceIds = this.topoData.addPolygonGeometry(primitive);
            }
        }
        catch (InvalidTopoOperationException ivex) {
            throw new Exception(ivex.getMessage());
        }
        catch (TopoEntityNotFoundException tex) {
            throw new Exception(tex.getMessage());
        }
        catch (Exception ex) {
            throw ex;
        }
        return true;
    }

    public boolean removeNode(int nodeId) throws Exception {
        if (this.topoData == null) {
            throw new Exception("Base topology data is null");
        }
        try {
            this.topoData.removeNode(nodeId);
        }
        catch (InvalidTopoOperationException ivex) {
            throw new Exception(ivex.getMessage());
        }
        catch (TopoEntityNotFoundException tex) {
            throw new Exception(tex.getMessage());
        }
        return true;
    }

    public int[] moveNode(int nodeId, Point2D newLocation) throws Exception {
        if (this.topoData == null) {
            throw new Exception("Base topology data is null");
        }
        Node nd = this.getNode(nodeId);
        if (nd == null) {
            throw new Exception("Unable to get node.");
        }
        int[] edgeIds = this.getNodeStar(nodeId);
        if (edgeIds == null || edgeIds.length == 0) {
            throw new Exception("Unable to get node connected edges.");
        }
        double ndLocX = nd.getCoord().getX();
        double ndLocY = nd.getCoord().getY();
        Point2DD[][] coords = new Point2DD[edgeIds.length][];
        for (int i = 0; i < edgeIds.length; ++i) {
            JGeometry geom = this.getEdgeGeometry(Math.abs(edgeIds[i]));
            double[] oords = geom.getOrdinatesArray();
            int dim = geom.getDimensions();
            int npts = oords.length / dim;
            Point2DD[] ed_oords = new Point2DD[npts];
            for (int j = 0; j < npts; ++j) {
                if (j == 0 || j == npts - 1) {
                    if (oords[j * dim] == ndLocX && oords[j * dim + 1] == ndLocY) {
                        ed_oords[j] = new Point2DD(newLocation.getX(), newLocation.getY());
                        continue;
                    }
                    ed_oords[j] = new Point2DD(oords[j * dim], oords[j * dim + 1]);
                    continue;
                }
                ed_oords[j] = new Point2DD(oords[j * dim], oords[j * dim + 1]);
            }
            coords[i] = ed_oords;
        }
        try {
            this.topoData.moveNode(nodeId, coords);
        }
        catch (InvalidTopoOperationException ivex) {
            throw new Exception(ivex.getMessage());
        }
        catch (TopoEntityNotFoundException tex) {
            throw new Exception(tex.getMessage());
        }
        catch (Exception ex) {
            throw ex;
        }
        return edgeIds;
    }

    public boolean removeEdge(int edgeId) throws Exception {
        if (this.topoData == null) {
            throw new Exception("Base topology data is null");
        }
        try {
            this.topoData.removeEdge(edgeId);
        }
        catch (InvalidTopoOperationException ivex) {
            throw new Exception(ivex.getMessage());
        }
        catch (TopoEntityNotFoundException tex) {
            throw new Exception(tex.getMessage());
        }
        return true;
    }

    public boolean changeEdgeGeometry(int edgeId, JGeometry newGeometry) throws Exception {
        if (this.topoData == null) {
            throw new Exception("Base topology data is null");
        }
        if (newGeometry == null) {
            throw new Exception("New edge geometry is null.");
        }
        if (newGeometry.getType() != 2) {
            throw new Exception("invalide geometry type for edge change");
        }
        Point2DD[] coords = null;
        double[] oords = newGeometry.getOrdinatesArray();
        if (oords != null && oords.length > 0) {
            int dim = newGeometry.getDimensions();
            int npts = oords.length / dim;
            coords = new Point2DD[npts];
            for (int j = 0; j < npts; ++j) {
                coords[j] = new Point2DD(oords[j * dim], oords[j * dim + 1]);
            }
        }
        if (coords == null) {
            throw new Exception("Input new geometry has not points");
        }
        try {
            this.topoData.changeEdgeCoords(edgeId, coords);
        }
        catch (InvalidTopoOperationException ivex) {
            throw new Exception(ivex.getMessage());
        }
        catch (TopoEntityNotFoundException tex) {
            throw new Exception(tex.getMessage());
        }
        return true;
    }

    public void registerTopologySet(TopologySet set) {
        if (set == null || set.getName() == null) {
            return;
        }
        this.topologySets.put(set.getName().toUpperCase(), set);
    }

    public void unregisterTopologySet(String setName) {
        if (setName == null) {
            return;
        }
        this.topologySets.remove(setName.toUpperCase());
    }

    public void updateTopologySetChildHierarchy(TopologySet set) {
        if (set == null || set.getMetadata() == null) {
            return;
        }
        set.setTopologyChildSet(null);
        if (this.topologySets.size() > 0) {
            int layerId = set.getMetadata().getTopoLayerId();
            int layerLevel = set.getMetadata().getTopoLayerLevel();
            int childLayer = set.getMetadata().getChildLayerId();
            Enumeration<TopologySet> el = this.topologySets.elements();
            while (el.hasMoreElements()) {
                TopologySet tpset = el.nextElement();
                if (tpset.getMetadata() == null || tpset.getMetadata().getTopoLayerId() == layerId) continue;
                if (layerLevel > 0 && childLayer == tpset.getMetadata().getTopoLayerId()) {
                    set.setTopologyChildSet(tpset);
                }
                if (tpset.getMetadata().getTopoLayerLevel() <= 0 || tpset.getMetadata().getChildLayerId() != layerId) continue;
                tpset.setTopologyChildSet(set);
            }
        }
    }

    public TopologySet[] getRegisteredSets() {
        if (this.topologySets.size() == 0) {
            return null;
        }
        ArrayList<TopologySet> sets = new ArrayList<TopologySet>();
        Enumeration<TopologySet> enumer = this.topologySets.elements();
        while (enumer.hasMoreElements()) {
            TopologySet set = enumer.nextElement();
            sets.add(set);
        }
        return sets.toArray(new TopologySet[sets.size()]);
    }

    public void updateTopoRelation(int topoId, int topoType, String operation, int baseTopoId) {
        if (this.topologySets.size() == 0) {
            return;
        }
        if (operation == null || !operation.equals("I") && !operation.equals("D") && !operation.equals("C")) {
            return;
        }
        if (operation.equals("I") || operation.equals("D")) {
            Enumeration<TopologySet> el = this.topologySets.elements();
            while (el.hasMoreElements()) {
                TopologySet set = el.nextElement();
                TopologyFeature[] features = set.getFeaturesWithTopoPrimitiveRelation(baseTopoId, topoType);
                if (features == null || features.length <= 0) continue;
                for (int i = 0; i < features.length; ++i) {
                    int j;
                    TopoPrimitiveDescriptor[] tpds;
                    TopologyGeometry tpgeom;
                    Field key = features[i].getAttribute(set.getKeyColumn());
                    if (key == null || key.getValue() == null || (tpgeom = features[i].getSpatialAttribute()) == null || (tpds = tpgeom.getTopoPrimitives()) == null || tpds.length == 0) continue;
                    TopologyGeometry change = new TopologyGeometry();
                    change.setId(tpgeom.getId());
                    change.setLayerId(tpgeom.getLayerId());
                    change.setTopoType(tpgeom.getTopoType());
                    if (operation.equals("I")) {
                        for (j = 0; j < tpds.length; ++j) {
                            change.addTopoPrimitive(tpds[j].getTopoId(), tpds[j].getTopoType());
                        }
                        change.addTopoPrimitive(topoId, topoType);
                    } else {
                        for (j = 0; j < tpds.length; ++j) {
                            if (tpds[j].getTopoId() == topoId && tpds[j].getTopoType() == topoType) continue;
                            change.addTopoPrimitive(tpds[j].getTopoId(), tpds[j].getTopoType());
                        }
                    }
                    try {
                        if (set.getIndexedSet() != null) {
                            set.getIndexedSet().updateSpatialAttribute(key.getValue().toString(), change);
                            continue;
                        }
                        set.updateFeatureGeometry(key.getValue().toString(), change);
                        continue;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
        } else {
            Enumeration<TopologySet> el = this.topologySets.elements();
            while (el.hasMoreElements()) {
                int leftFace;
                Edge ed;
                TopologySet set = el.nextElement();
                AbstractSpatialIndex sptIndex = null;
                if (set.getIndexedSet() != null) {
                    sptIndex = set.getIndexedSet().getSpatialindex();
                }
                if (sptIndex == null) continue;
                this.updateFeatureSetSpatialIndex(set, baseTopoId, topoType);
                if (topoType == 1) {
                    int[] edgeIds = this.getNodeStar(baseTopoId);
                    if (edgeIds == null || edgeIds.length <= 0) continue;
                    for (int i = 0; i < edgeIds.length; ++i) {
                        int leftFace2;
                        Edge ed2 = this.getEdge(Math.abs(edgeIds[i]));
                        if (ed2 == null) continue;
                        this.updateFeatureSetSpatialIndex(set, ed2.getId(), 2);
                        int rightFace = ed2.getBoundedFaceR();
                        if (rightFace != -1) {
                            this.updateFeatureSetSpatialIndex(set, rightFace, 3);
                        }
                        if ((leftFace2 = ed2.getBoundedFaceL()) == -1) continue;
                        this.updateFeatureSetSpatialIndex(set, leftFace2, 3);
                    }
                    continue;
                }
                if (topoType != 2 || (ed = this.getEdge(Math.abs(baseTopoId))) == null) continue;
                int rightFace = ed.getBoundedFaceR();
                if (rightFace != -1) {
                    this.updateFeatureSetSpatialIndex(set, rightFace, 3);
                }
                if ((leftFace = ed.getBoundedFaceL()) == -1) continue;
                this.updateFeatureSetSpatialIndex(set, leftFace, 3);
            }
        }
    }

    private void updateFeatureSetSpatialIndex(TopologySet set, int topoId, int topoType) {
        if (set == null || set.getIndexedSet() == null) {
            return;
        }
        AbstractSpatialIndex sptIndex = set.getIndexedSet().getSpatialindex();
        if (sptIndex == null) {
            return;
        }
        TopologyFeature[] features = set.getFeaturesWithTopoPrimitiveRelation(topoId, topoType);
        if (features != null && features.length > 0) {
            for (int i = 0; i < features.length; ++i) {
                TopologyGeometry tpgeom;
                Field key = features[i].getAttribute(set.getKeyColumn());
                if (key == null || key.getValue() == null || (tpgeom = features[i].getSpatialAttribute()) == null) continue;
                try {
                    TopologyGeometry change = (TopologyGeometry)tpgeom.clone();
                    change.clearGeometries();
                    change.clearMBR();
                    change.updateMBR(this);
                    set.getIndexedSet().updateSpatialAttribute(key.getValue().toString(), change);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    public ArrayList<TopoPrimitiveDescriptor> getTopoPrimitives(int layerId, TopoChildFeatureDescriptor[] childFeatures) {
        ArrayList<TopoPrimitiveDescriptor> primitives = new ArrayList<TopoPrimitiveDescriptor>();
        if (childFeatures == null) {
            return null;
        }
        if (this.topologySets.size() > 0) {
            Enumeration<TopologySet> el = this.topologySets.elements();
            while (el.hasMoreElements()) {
                TopologyGeometry tpgeom;
                TopologyFeature tpfeat;
                int featureId;
                int i;
                TopologySet childSet;
                TopologySet tpset = el.nextElement();
                if (layerId != tpset.getMetadata().getTopoLayerId() || (childSet = tpset.getTopologyChildSet()) == null) continue;
                if (childSet.getMetadata().getTopoLayerLevel() == 0) {
                    for (i = 0; i < childFeatures.length; ++i) {
                        TopoPrimitiveDescriptor[] tpds;
                        featureId = childFeatures[i].getFeatureId();
                        tpfeat = childSet.getFeatureFromTopoRelation(featureId);
                        if (tpfeat == null || (tpgeom = tpfeat.getSpatialAttribute()) == null || (tpds = tpgeom.getTopoPrimitives()) == null) continue;
                        for (int j = 0; j < tpds.length; ++j) {
                            primitives.add(tpds[j]);
                        }
                    }
                    continue;
                }
                for (i = 0; i < childFeatures.length; ++i) {
                    ArrayList<TopoPrimitiveDescriptor> prims;
                    TopoChildFeatureDescriptor[] tpcds;
                    featureId = childFeatures[i].getFeatureId();
                    tpfeat = childSet.getFeatureFromTopoRelation(featureId);
                    if (tpfeat == null || (tpgeom = tpfeat.getSpatialAttribute()) == null || (tpcds = tpgeom.getChildFeatures()) == null || (prims = this.getTopoPrimitives(childSet.getMetadata().getTopoLayerId(), tpcds)) == null) continue;
                    int j = 0;
                    while (j < prims.size()) {
                        primitives.add(prims.get(j));
                        ++i;
                    }
                }
            }
        }
        if (primitives.size() == 0) {
            return null;
        }
        return primitives;
    }

    public Rectangle2D getPrimitivesMBR() {
        if (this.topoData == null) {
            return null;
        }
        try {
            Point2DD[] bounds = this.topoData.getCacheBounds();
            if (bounds == null) {
                return null;
            }
            return new Rectangle2D.Double(bounds[0].getX(), bounds[0].getY(), bounds[1].getX() - bounds[0].getX(), bounds[1].getY() - bounds[0].getY());
        }
        catch (InvalidTopoOperationException ex) {
            return null;
        }
    }
}

